export declare class CheckFailed extends Error {
    readonly exitCode: number;
    constructor(message: string, exitCode?: number);
}
export declare class ApplicationError extends Error {
    readonly exitCode: number;
    readonly cause?: Error | undefined;
    constructor(message: string, exitCode?: number, cause?: Error | undefined);
}
export declare class IOError extends ApplicationError {
    readonly cause: NodeError;
    constructor(message: string, cause: NodeError);
    get code(): string | undefined;
    isNotFound(): boolean;
}
export declare function toError(e: unknown): NodeError;
export declare function isError(e: unknown): e is NodeError;
export declare function toApplicationError(e: unknown, message?: string): ApplicationError;
export interface NodeError extends Error {
    code?: string;
    toString?: () => string;
}
//# sourceMappingURL=errors.d.ts.map