import type { CSpellReporter, Issue, ProgressItem, RunResult } from '@cspell/cspell-types';
export interface InMemoryResult {
    log: string[];
    issues: Issue[];
    runResult: RunResult | undefined;
}
/**
 * Simple reporter for test purposes
 */
export declare class InMemoryReporter implements CSpellReporter, InMemoryResult {
    log: string[];
    errors: Error[];
    issueCount: number;
    errorCount: number;
    debugCount: number;
    infoCount: number;
    progressCount: number;
    issues: Issue[];
    runResult: RunResult | undefined;
    issue: (issue: Issue) => void;
    error: (message: string, error: Error) => void;
    info: (message: string) => void;
    debug: (message: string) => void;
    progress: (p: ProgressItem) => void;
    result: (r: RunResult) => void;
    dump: () => InMemoryResult;
}
//# sourceMappingURL=InMemoryReporter.d.ts.map