"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.addPathsToGlobalImportsResultToTable = exports.listGlobalImportsResultToTable = exports.removePathsFromGlobalImports = exports.addPathsToGlobalImports = exports.listGlobalImports = void 0;
const cspell_lib_1 = require("cspell-lib");
const chalk_1 = __importDefault(require("chalk"));
exports.listGlobalImports = cspell_lib_1.Link.listGlobalImports;
exports.addPathsToGlobalImports = cspell_lib_1.Link.addPathsToGlobalImports;
exports.removePathsFromGlobalImports = cspell_lib_1.Link.removePathsFromGlobalImports;
function listGlobalImportsResultToTable(results) {
    const header = ['id', 'package', 'name', 'filename', 'dictionaries', 'errors'];
    const decorate = (isError) => (isError ? (s) => chalk_1.default.red(s) : (s) => s);
    function toColumns(r) {
        var _a, _b;
        return [
            r.id,
            (_a = r.package) === null || _a === void 0 ? void 0 : _a.name,
            r.name,
            r.filename,
            (_b = r.dictionaryDefinitions) === null || _b === void 0 ? void 0 : _b.map((def) => def.name).join(', '),
            r.error ? 'Failed to read file.' : '',
        ]
            .map((c) => c || '')
            .map(decorate(!!r.error));
    }
    return {
        header,
        rows: results.map(toColumns),
    };
}
exports.listGlobalImportsResultToTable = listGlobalImportsResultToTable;
function addPathsToGlobalImportsResultToTable(results) {
    const header = ['filename', 'errors'];
    const decorate = (isError) => (isError ? (s) => chalk_1.default.red(s) : (s) => s);
    function toColumns(r) {
        return [r.resolvedToFilename || r.filename, r.error ? 'Failed to read file.' : '']
            .map((c) => c || '')
            .map(decorate(!!r.error));
    }
    return {
        header,
        rows: results.resolvedSettings.map(toColumns),
    };
}
exports.addPathsToGlobalImportsResultToTable = addPathsToGlobalImportsResultToTable;
//# sourceMappingURL=link.js.map