"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.commandSuggestion = void 0;
const commander_1 = require("commander");
const App = __importStar(require("./application"));
const suggestionsEmitter_1 = require("./emitters/suggestionsEmitter");
const errors_1 = require("./util/errors");
function collect(value, previous) {
    value = value.replace(/^=/, '');
    if (!previous) {
        return [value];
    }
    return previous.concat([value]);
}
function count(_, previous) {
    return (previous || 0) + 1;
}
function asNumber(value, prev) {
    var _a;
    return (_a = parseInt(value, 10)) !== null && _a !== void 0 ? _a : prev;
}
function commandSuggestion(prog) {
    const suggestionCommand = prog.command('suggestions');
    suggestionCommand
        .aliases(['sug', 'suggest'])
        .description('Spelling Suggestions for words.')
        .option('-c, --config <cspell.json>', 'Configuration file to use.  By default cspell looks for cspell.json in the current directory.')
        .option('--locale <locale>', 'Set language locales. i.e. "en,fr" for English and French, or "en-GB" for British English.')
        .option('--language-id <language>', 'Use programming language. i.e. "php" or "scala".')
        .addOption(new commander_1.Option('--languageId <language>', 'Use programming language. i.e. "php" or "scala".').hideHelp())
        .option('-s, --no-strict', 'Ignore case and accents when searching for words.')
        .option('--ignore-case', 'Alias of --no-strict.')
        .option('--num-changes <number>', 'Number of changes allowed to a word', asNumber, 4)
        .option('--num-suggestions <number>', 'Number of suggestions', asNumber, 8)
        .option('--no-include-ties', 'Force the number of suggested to be limited, by not including suggestions that have the same edit cost.')
        .option('--stdin', 'Use stdin for input.')
        .addOption(new commander_1.Option('--repl', 'REPL interface for looking up suggestions.').hideHelp())
        .option('-v, --verbose', 'Show detailed output.', count, 0)
        .option('-d, --dictionary <dictionary name>', 'Use the dictionary specified. Only dictionaries specified will be used.', collect)
        .option('--dictionaries <dictionary names...>', 'Use the dictionaries specified. Only dictionaries specified will be used.')
        .option('--no-color', 'Turn off color.')
        .option('--color', 'Force color')
        .arguments('[words...]')
        .action(async (words, options) => {
        options.useStdin = options.stdin;
        options.dictionaries = mergeArrays(options.dictionaries, options.dictionary);
        if (!words.length && !options.useStdin && !options.repl) {
            suggestionCommand.outputHelp();
            throw new errors_1.CheckFailed('outputHelp', 1);
        }
        for await (const r of App.suggestions(words, options)) {
            (0, suggestionsEmitter_1.emitSuggestionResult)(r, options);
        }
    });
    return suggestionCommand;
}
exports.commandSuggestion = commandSuggestion;
function mergeArrays(a, b) {
    if (a === undefined)
        return b;
    if (b === undefined)
        return a;
    return a.concat(b);
}
//# sourceMappingURL=commandSuggestion.js.map