"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.commandCheck = void 0;
const commander_1 = require("commander");
const App = __importStar(require("./application"));
const application_1 = require("./application");
const errors_1 = require("./util/errors");
const chalk = require("chalk");
function commandCheck(prog) {
    return prog
        .command('check <files...>')
        .description('Spell check file(s) and display the result. The full file is displayed in color.')
        .option('-c, --config <cspell.json>', 'Configuration file to use.  By default cspell looks for cspell.json in the current directory.')
        .option('--no-color', 'Turn off color.')
        .option('--color', 'Force color')
        .addOption(new commander_1.Option('--default-configuration', 'Load the default configuration and dictionaries.').hideHelp())
        .addOption(new commander_1.Option('--no-default-configuration', 'Do not load the default configuration and dictionaries.'))
        .action(async (files, options) => {
        let issueCount = 0;
        for (const filename of files) {
            console.log(chalk.yellowBright(`Check file: ${filename}`));
            console.log();
            try {
                const result = await (0, application_1.checkText)(filename, options);
                for (const item of result.items) {
                    const fn = item.flagIE === App.IncludeExcludeFlag.EXCLUDE
                        ? chalk.gray
                        : item.isError
                            ? chalk.red
                            : chalk.whiteBright;
                    const t = fn(item.text);
                    process.stdout.write(t);
                    issueCount += item.isError ? 1 : 0;
                }
                console.log();
            }
            catch (e) {
                console.error(`File not found "${filename}"`);
                throw new errors_1.CheckFailed('File not found', 1);
            }
            console.log();
        }
        if (issueCount) {
            throw new errors_1.CheckFailed('Issues found', 1);
        }
    });
}
exports.commandCheck = commandCheck;
//# sourceMappingURL=commandCheck.js.map