"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.run = exports.CheckFailed = void 0;
const commander_1 = require("commander");
const semver_1 = require("semver");
const commandCheck_1 = require("./commandCheck");
const commandLink_1 = require("./commandLink");
const commandLint_1 = require("./commandLint");
const commandSuggestion_1 = require("./commandSuggestion");
const commandTrace_1 = require("./commandTrace");
const errors_1 = require("./util/errors");
// eslint-disable-next-line @typescript-eslint/no-var-requires
const npmPackage = require('../package.json');
var errors_2 = require("./util/errors");
Object.defineProperty(exports, "CheckFailed", { enumerable: true, get: function () { return errors_2.CheckFailed; } });
async function run(command, argv) {
    const prog = command || commander_1.program;
    const args = argv || process.argv;
    prog.exitOverride();
    prog.version(npmPackage.version).description('Spelling Checker for Code').name('cspell');
    if (!(0, semver_1.satisfies)(process.versions.node, npmPackage.engines.node)) {
        throw new errors_1.ApplicationError(`Unsupported NodeJS version (${process.versions.node}); ${npmPackage.engines.node} is required`);
    }
    (0, commandLint_1.commandLint)(prog);
    (0, commandTrace_1.commandTrace)(prog);
    (0, commandCheck_1.commandCheck)(prog);
    (0, commandLink_1.commandLink)(prog);
    (0, commandSuggestion_1.commandSuggestion)(prog);
    /*
        program
            .command('init')
            .description('(Alpha) Initialize a cspell.json file.')
            .option('-o, --output <cspell.json>', 'define where to write file.')
            .option('--extends <cspell.json>', 'extend an existing cspell.json file.')
            .action((options: InitOptions) => {
                showHelp = false;
                CSpellApplication.createInit(options).then(
                    () => process.exit(0),
                    () => process.exit(1)
                );
                console.log('Init');
            });
    */
    prog.exitOverride();
    await prog.parseAsync(args);
}
exports.run = run;
//# sourceMappingURL=app.js.map