import { Attribute } from '@ts-graphviz/common';
import { AttributeKey } from '@ts-graphviz/common';
import { AttributeListKind } from '@ts-graphviz/common';
import { AttributeListModel } from '@ts-graphviz/common';
import { Attributes } from '@ts-graphviz/common';
import { AttributesEntities } from '@ts-graphviz/common';
import { AttributesGroupModel } from '@ts-graphviz/common';
import { AttributesObject } from '@ts-graphviz/common';
import { ClusterSubgraphAttributeKey } from '@ts-graphviz/common';
import { EdgeAttributeKey } from '@ts-graphviz/common';
import { EdgeAttributesObject } from '@ts-graphviz/common';
import { EdgeModel } from '@ts-graphviz/common';
import { EdgeTargetLikeTuple } from '@ts-graphviz/common';
import { EdgeTargetTuple } from '@ts-graphviz/common';
import { ForwardRefNode } from '@ts-graphviz/common';
import { GraphAttributeKey } from '@ts-graphviz/common';
import { GraphAttributesObject } from '@ts-graphviz/common';
import { GraphBaseModel } from '@ts-graphviz/common';
import { GraphCommonAttributes } from '@ts-graphviz/common';
import { ModelsContext } from '@ts-graphviz/common';
import { NodeAttributeKey } from '@ts-graphviz/common';
import { NodeAttributesObject } from '@ts-graphviz/common';
import { NodeModel } from '@ts-graphviz/common';
import { Port } from '@ts-graphviz/common';
import { RootGraphModel } from '@ts-graphviz/common';
import { SubgraphAttributeKey } from '@ts-graphviz/common';
import { SubgraphAttributesObject } from '@ts-graphviz/common';
import { SubgraphModel } from '@ts-graphviz/common';

/**
 * A set of attribute values for any object.
 * @group Models
 */
export declare class AttributeList<K extends AttributeListKind, T extends AttributeKey = AttributeKey> extends AttributesBase_2<T> implements AttributeListModel<K, T> {
    readonly $$kind: K;
    get $$type(): 'AttributeList';
    comment?: string;
    constructor($$kind: K, attributes?: AttributesObject<T>);
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
export declare abstract class AttributesBase<T extends AttributeKey> extends DotObject_3 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
declare abstract class AttributesBase_2<T extends AttributeKey> extends DotObject_2 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
declare abstract class AttributesBase_3<T extends AttributeKey> extends DotObject_4 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
declare abstract class AttributesBase_4<T extends AttributeKey> extends DotObject_5 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
declare abstract class AttributesBase_5<T extends AttributeKey> extends DotObject_7 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
declare abstract class AttributesBase_6<T extends AttributeKey> extends DotObject_8 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
declare abstract class AttributesBase_7<T extends AttributeKey> extends DotObject_2_2 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
declare abstract class AttributesBase_8<T extends AttributeKey> extends DotObject_10 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * Base class for DOT objects with attributes.
 * @group Models
 */
declare abstract class AttributesBase_9<T extends AttributeKey> extends DotObject_11 implements Attributes<T> {
    #private;
    constructor(attributes?: AttributesObject<T>);
    get values(): ReadonlyArray<[T, Attribute<T>]>;
    get size(): number;
    get<K extends T>(key: K): Attribute<K> | undefined;
    set<K extends T>(key: K, value: Attribute<K>): void;
    delete(key: T): void;
    apply(attributes: AttributesObject<T> | AttributesEntities<T>): void;
    clear(): void;
}

/**
 * A set of attribute values for any object.
 * @group Models
 */
export declare class AttributesGroup<T extends AttributeKey = AttributeKey> extends AttributesBase_3<T> implements AttributesGroupModel<T> {
    comment?: string;
}

/**
 * A set of attribute values for any object.
 * @group Models
 */
declare class AttributesGroup_2<T extends AttributeKey = AttributeKey> extends AttributesBase_7<T> implements AttributesGroupModel<T> {
    comment?: string;
}

/**
 * DOT object class representing a digraph.
 * @group Models
 */
export declare class Digraph extends RootGraph_2 {
    get directed(): boolean;
}

/**
 * Base class for DOT objects.
 * @group Models
 */
export declare abstract class DotObject {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_10 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_11 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_2 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_2_2 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_3 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_4 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_5 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_6 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_7 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_8 {
}

/**
 * Base class for DOT objects.
 * @group Models
 */
declare abstract class DotObject_9 {
}

/**
 * DOT object class representing a edge.
 * @group Models
 */
export declare class Edge extends DotObject_6 implements EdgeModel {
    readonly targets: EdgeTargetTuple;
    get $$type(): 'Edge';
    comment?: string;
    readonly attributes: AttributesGroupModel<EdgeAttributeKey>;
    constructor(targets: EdgeTargetTuple, attributes?: EdgeAttributesObject);
}

/**
 * DOT object class representing a graph.
 * @group Models
 */
export declare class Graph extends RootGraph_3 {
    get directed(): boolean;
}

/**
 * Base class for Graph objects.
 * @group Models
 */
export declare abstract class GraphBase<T extends AttributeKey> extends AttributesBase_6<T> implements GraphBaseModel<T> {
    #private;
    readonly id?: string;
    comment?: string;
    readonly attributes: Readonly<GraphCommonAttributes>;
    get nodes(): ReadonlyArray<NodeModel>;
    get edges(): ReadonlyArray<EdgeModel>;
    get subgraphs(): ReadonlyArray<SubgraphModel>;
    with(models: Partial<ModelsContext>): void;
    addNode(node: NodeModel): void;
    addEdge(edge: EdgeModel): void;
    addSubgraph(subgraph: SubgraphModel): void;
    existNode(nodeId: string): boolean;
    existEdge(edge: EdgeModel): boolean;
    existSubgraph(subgraph: SubgraphModel): boolean;
    createSubgraph(id?: string, attributes?: SubgraphAttributesObject): SubgraphModel;
    createSubgraph(attributes?: SubgraphAttributesObject): SubgraphModel;
    removeNode(node: NodeModel | string): void;
    removeEdge(edge: EdgeModel): void;
    removeSubgraph(subgraph: SubgraphModel): void;
    createNode(id: string, attributes?: NodeAttributesObject): NodeModel;
    getSubgraph(id: string): SubgraphModel | undefined;
    getNode(id: string): NodeModel | undefined;
    createEdge(targets: EdgeTargetLikeTuple, attributes?: EdgeAttributesObject): EdgeModel;
    subgraph(id: string, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(id: string, attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    node(id: string, callback?: (node: NodeModel) => void): NodeModel;
    node(id: string, attributes: NodeAttributesObject, callback?: (node: NodeModel) => void): NodeModel;
    node(attributes: NodeAttributesObject): void;
    edge(targets: EdgeTargetLikeTuple, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(targets: EdgeTargetLikeTuple, attributes: EdgeAttributesObject, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(attributes: EdgeAttributesObject): void;
    graph(attributes: SubgraphAttributesObject): void;
}

/**
 * Base class for Graph objects.
 * @group Models
 */
declare abstract class GraphBase_2<T extends AttributeKey> extends AttributesBase_4<T> implements GraphBaseModel<T> {
    #private;
    readonly id?: string;
    comment?: string;
    readonly attributes: Readonly<GraphCommonAttributes>;
    get nodes(): ReadonlyArray<NodeModel>;
    get edges(): ReadonlyArray<EdgeModel>;
    get subgraphs(): ReadonlyArray<SubgraphModel>;
    with(models: Partial<ModelsContext>): void;
    addNode(node: NodeModel): void;
    addEdge(edge: EdgeModel): void;
    addSubgraph(subgraph: SubgraphModel): void;
    existNode(nodeId: string): boolean;
    existEdge(edge: EdgeModel): boolean;
    existSubgraph(subgraph: SubgraphModel): boolean;
    createSubgraph(id?: string, attributes?: SubgraphAttributesObject): SubgraphModel;
    createSubgraph(attributes?: SubgraphAttributesObject): SubgraphModel;
    removeNode(node: NodeModel | string): void;
    removeEdge(edge: EdgeModel): void;
    removeSubgraph(subgraph: SubgraphModel): void;
    createNode(id: string, attributes?: NodeAttributesObject): NodeModel;
    getSubgraph(id: string): SubgraphModel | undefined;
    getNode(id: string): NodeModel | undefined;
    createEdge(targets: EdgeTargetLikeTuple, attributes?: EdgeAttributesObject): EdgeModel;
    subgraph(id: string, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(id: string, attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    node(id: string, callback?: (node: NodeModel) => void): NodeModel;
    node(id: string, attributes: NodeAttributesObject, callback?: (node: NodeModel) => void): NodeModel;
    node(attributes: NodeAttributesObject): void;
    edge(targets: EdgeTargetLikeTuple, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(targets: EdgeTargetLikeTuple, attributes: EdgeAttributesObject, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(attributes: EdgeAttributesObject): void;
    graph(attributes: SubgraphAttributesObject): void;
}

/**
 * Base class for Graph objects.
 * @group Models
 */
declare abstract class GraphBase_3<T extends AttributeKey> extends AttributesBase_5<T> implements GraphBaseModel<T> {
    #private;
    readonly id?: string;
    comment?: string;
    readonly attributes: Readonly<GraphCommonAttributes>;
    get nodes(): ReadonlyArray<NodeModel>;
    get edges(): ReadonlyArray<EdgeModel>;
    get subgraphs(): ReadonlyArray<SubgraphModel>;
    with(models: Partial<ModelsContext>): void;
    addNode(node: NodeModel): void;
    addEdge(edge: EdgeModel): void;
    addSubgraph(subgraph: SubgraphModel): void;
    existNode(nodeId: string): boolean;
    existEdge(edge: EdgeModel): boolean;
    existSubgraph(subgraph: SubgraphModel): boolean;
    createSubgraph(id?: string, attributes?: SubgraphAttributesObject): SubgraphModel;
    createSubgraph(attributes?: SubgraphAttributesObject): SubgraphModel;
    removeNode(node: NodeModel | string): void;
    removeEdge(edge: EdgeModel): void;
    removeSubgraph(subgraph: SubgraphModel): void;
    createNode(id: string, attributes?: NodeAttributesObject): NodeModel;
    getSubgraph(id: string): SubgraphModel | undefined;
    getNode(id: string): NodeModel | undefined;
    createEdge(targets: EdgeTargetLikeTuple, attributes?: EdgeAttributesObject): EdgeModel;
    subgraph(id: string, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(id: string, attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    node(id: string, callback?: (node: NodeModel) => void): NodeModel;
    node(id: string, attributes: NodeAttributesObject, callback?: (node: NodeModel) => void): NodeModel;
    node(attributes: NodeAttributesObject): void;
    edge(targets: EdgeTargetLikeTuple, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(targets: EdgeTargetLikeTuple, attributes: EdgeAttributesObject, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(attributes: EdgeAttributesObject): void;
    graph(attributes: SubgraphAttributesObject): void;
}

/**
 * Base class for Graph objects.
 * @group Models
 */
declare abstract class GraphBase_4<T extends AttributeKey> extends AttributesBase_8<T> implements GraphBaseModel<T> {
    #private;
    readonly id?: string;
    comment?: string;
    readonly attributes: Readonly<GraphCommonAttributes>;
    get nodes(): ReadonlyArray<NodeModel>;
    get edges(): ReadonlyArray<EdgeModel>;
    get subgraphs(): ReadonlyArray<SubgraphModel>;
    with(models: Partial<ModelsContext>): void;
    addNode(node: NodeModel): void;
    addEdge(edge: EdgeModel): void;
    addSubgraph(subgraph: SubgraphModel): void;
    existNode(nodeId: string): boolean;
    existEdge(edge: EdgeModel): boolean;
    existSubgraph(subgraph: SubgraphModel): boolean;
    createSubgraph(id?: string, attributes?: SubgraphAttributesObject): SubgraphModel;
    createSubgraph(attributes?: SubgraphAttributesObject): SubgraphModel;
    removeNode(node: NodeModel | string): void;
    removeEdge(edge: EdgeModel): void;
    removeSubgraph(subgraph: SubgraphModel): void;
    createNode(id: string, attributes?: NodeAttributesObject): NodeModel;
    getSubgraph(id: string): SubgraphModel | undefined;
    getNode(id: string): NodeModel | undefined;
    createEdge(targets: EdgeTargetLikeTuple, attributes?: EdgeAttributesObject): EdgeModel;
    subgraph(id: string, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(id: string, attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    node(id: string, callback?: (node: NodeModel) => void): NodeModel;
    node(id: string, attributes: NodeAttributesObject, callback?: (node: NodeModel) => void): NodeModel;
    node(attributes: NodeAttributesObject): void;
    edge(targets: EdgeTargetLikeTuple, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(targets: EdgeTargetLikeTuple, attributes: EdgeAttributesObject, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(attributes: EdgeAttributesObject): void;
    graph(attributes: SubgraphAttributesObject): void;
}

/**
 * Base class for Graph objects.
 * @group Models
 */
declare abstract class GraphBase_5<T extends AttributeKey> extends AttributesBase_9<T> implements GraphBaseModel<T> {
    #private;
    readonly id?: string;
    comment?: string;
    readonly attributes: Readonly<GraphCommonAttributes>;
    get nodes(): ReadonlyArray<NodeModel>;
    get edges(): ReadonlyArray<EdgeModel>;
    get subgraphs(): ReadonlyArray<SubgraphModel>;
    with(models: Partial<ModelsContext>): void;
    addNode(node: NodeModel): void;
    addEdge(edge: EdgeModel): void;
    addSubgraph(subgraph: SubgraphModel): void;
    existNode(nodeId: string): boolean;
    existEdge(edge: EdgeModel): boolean;
    existSubgraph(subgraph: SubgraphModel): boolean;
    createSubgraph(id?: string, attributes?: SubgraphAttributesObject): SubgraphModel;
    createSubgraph(attributes?: SubgraphAttributesObject): SubgraphModel;
    removeNode(node: NodeModel | string): void;
    removeEdge(edge: EdgeModel): void;
    removeSubgraph(subgraph: SubgraphModel): void;
    createNode(id: string, attributes?: NodeAttributesObject): NodeModel;
    getSubgraph(id: string): SubgraphModel | undefined;
    getNode(id: string): NodeModel | undefined;
    createEdge(targets: EdgeTargetLikeTuple, attributes?: EdgeAttributesObject): EdgeModel;
    subgraph(id: string, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(id: string, attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(attributes: SubgraphAttributesObject, callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    subgraph(callback?: (subgraph: SubgraphModel) => void): SubgraphModel;
    node(id: string, callback?: (node: NodeModel) => void): NodeModel;
    node(id: string, attributes: NodeAttributesObject, callback?: (node: NodeModel) => void): NodeModel;
    node(attributes: NodeAttributesObject): void;
    edge(targets: EdgeTargetLikeTuple, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(targets: EdgeTargetLikeTuple, attributes: EdgeAttributesObject, callback?: (edge: EdgeModel) => void): EdgeModel;
    edge(attributes: EdgeAttributesObject): void;
    graph(attributes: SubgraphAttributesObject): void;
}

/**
 * DOT object class representing a node.
 * @group Models
 */
export declare class Node extends DotObject_9 implements NodeModel {
    readonly id: string;
    get $$type(): 'Node';
    comment?: string;
    readonly attributes: AttributesGroup_2<NodeAttributeKey>;
    constructor(id: string, attributes?: NodeAttributesObject);
    port(port: string | Partial<Port>): ForwardRefNode;
}

export declare function registerDefault(): void;

/**
 * Base class representing a root graph(digraph, graph).
 * @group Models
 */
export declare abstract class RootGraph extends GraphBase_4<GraphAttributeKey> implements RootGraphModel {
    get $$type(): 'Graph';
    readonly id?: string;
    abstract readonly directed: boolean;
    strict: boolean;
    constructor(id?: string, attributes?: GraphAttributesObject);
    constructor(id?: string, strict?: boolean, attributes?: GraphAttributesObject);
    constructor(strict?: boolean, attributes?: GraphAttributesObject);
    constructor(attributes?: GraphAttributesObject);
}

/**
 * Base class representing a root graph(digraph, graph).
 * @group Models
 */
declare abstract class RootGraph_2 extends GraphBase_2<GraphAttributeKey> implements RootGraphModel {
    get $$type(): 'Graph';
    readonly id?: string;
    abstract readonly directed: boolean;
    strict: boolean;
    constructor(id?: string, attributes?: GraphAttributesObject);
    constructor(id?: string, strict?: boolean, attributes?: GraphAttributesObject);
    constructor(strict?: boolean, attributes?: GraphAttributesObject);
    constructor(attributes?: GraphAttributesObject);
}

/**
 * Base class representing a root graph(digraph, graph).
 * @group Models
 */
declare abstract class RootGraph_3 extends GraphBase_3<GraphAttributeKey> implements RootGraphModel {
    get $$type(): 'Graph';
    readonly id?: string;
    abstract readonly directed: boolean;
    strict: boolean;
    constructor(id?: string, attributes?: GraphAttributesObject);
    constructor(id?: string, strict?: boolean, attributes?: GraphAttributesObject);
    constructor(strict?: boolean, attributes?: GraphAttributesObject);
    constructor(attributes?: GraphAttributesObject);
}

/**
 * DOT object class representing a subgraph.
 * @group Models
 */
export declare class Subgraph extends GraphBase_5<SubgraphAttributeKey | ClusterSubgraphAttributeKey> implements SubgraphModel {
    get $$type(): 'Subgraph';
    readonly id?: string;
    constructor(id?: string, attributes?: SubgraphAttributesObject);
    constructor(attributes?: SubgraphAttributesObject);
    isSubgraphCluster(): boolean;
}

export { }
