package net.cacheux.nvplib.utils

import org.junit.Assert.assertEquals
import org.junit.Test

class ByteArrayStoreTest {

    companion object {
        const val TEST_DATA = """
0x00000000 90 00                                           ..

0x00000000 90 00                                           ..

0x00000000 00 0F 20 01 0C 01 0C 04 06 E1 04 01 0C 00 00 90 ................
0x00000010 00                                              .

0x00000000 90 00                                           ..

0x00000000 00 3D 90 00                                     .=..

0x00000000 D1 03 37 50 48 44 00 E2 00 00 32 80 00 00 00 00 ..7PHD....2.....
0x00000010 01 00 2A 50 79 00 26 80 00 00 00 80 00 80 00 00 ..*Py.&.........
0x00000020 00 00 00 00 00 00 80 00 00 00 08 00 14 65 00 40 .............e.@
0x00000030 12 1C 2D 40 0A 00 01 01 00 00 00 00 00 90 00    ..-@...........

0x00000000 90 00                                           ..

0x00000000 90 00                                           ..

0x00000000 00 CF 90 00                                     ....

0x00000000 D1 03 C9 50 48 44 82 E7 00 00 C4 00 C2 00 00 01 ...PHD..........
0x00000010 01 00 BC 00 00 00 00 00 00 0D 1C 00 B2 40 0A 00 .............@..
0x00000020 04 00 AC 00 3D 01 00 00 08 00 38 0A 4D 00 02 08 ....=.....8.M...
0x00000030 00 09 43 00 02 00 00 09 41 00 04 00 00 03 20 09 ..C.....A.......
0x00000040 53 00 02 00 00 0A 57 00 04 00 02 50 4D 09 51 00 S.....W....PM.Q.
0x00000050 02 00 01 0A 63 00 04 00 00 00 00 09 44 00 04 00 ....c.......D...
0x00000060 00 03 20 00 06 00 02 00 04 00 20 09 2F 00 04 00 ............/...
0x00000070 82 34 01 0A 46 00 02 F0 40 09 96 00 02 15 60 0A .4..F...@.....`.
0x00000080 55 00 08 00 01 00 04 0A 56 00 04 00 05 00 03 00 U.......V.......
0x00000090 03 00 1A 09 2F 00 04 00 82 34 02 0A 46 00 02 F0 ..../....4..F...
0x000000A0 40 0A 55 00 08 00 01 00 04 0A 66 00 02 00 06 00 @.U.......f.....
0x000000B0 04 00 03 00 1A 09 2F 00 04 00 82 F0 00 0A 46 00 ....../.......F.
0x000000C0 02 F0 40 0A 55 00 08 00 01 00 04 0A 66 00 02 90 ..@.U.......f...
0x000000D0 00                                              .

0x00000000 90 00                                           ..

0x00000000 90 00                                           ..

0x00000000 00 07 90 00                                     ....
        """
    }

    @Test
    fun testLoadFromInputStream() {
        val store = ByteArrayStore.fromInputStream(TEST_DATA.byteInputStream())
        assertEquals(13, store.content.size)
        assertEquals(2, store.content[0].size)
        assertEquals(17, store.content[2].size)
    }
}