/*
 * Copyright (c) 2020-2022 Martin Denham, Tuomas Airaksinen and the AndBible contributors.
 *
 * This file is part of AndBible: Bible Study (http://github.com/AndBible/and-bible).
 *
 * AndBible is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation,
 * either version 3 of the License, or (at your option) any later version.
 *
 * AndBible is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with AndBible.
 * If not, see http://www.gnu.org/licenses/.
 */
package net.bible.android.view.util

import android.app.ProgressDialog
import android.content.Context
import android.util.Log
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import net.bible.android.BibleApplication.Companion.application
import net.bible.android.activity.R
import net.bible.android.view.activity.base.CurrentActivityHolder

/** Helper class to show HourGlass
 *
 * @author Martin Denham [mjdenham at gmail dot com]
 */
class Hourglass(val context: Context) {
    private var hourglass: ProgressDialog? = null

    suspend fun show(messageId: Int = R.string.please_wait) {
        withContext(Dispatchers.Main) {
            val hourglass = ProgressDialog(context)
            this@Hourglass.hourglass = hourglass

            hourglass.setMessage(application.getText(messageId))
            hourglass.isIndeterminate = true
            hourglass.setCancelable(false)
            Log.e(TAG, "Show")
            hourglass.show()
        }
    }

    suspend fun dismiss() {
        withContext(Dispatchers.Main) {
            if (hourglass == null) {
                Log.e(TAG, "Hourglass already dismissed!")
            } else {
                Log.e(TAG, "Dismiss")
            }
            hourglass?.dismiss()
            hourglass = null
        }
    }
    companion object {
        private val TAG = "Hourglass"
    }
}
