/*!
 * 
 * Planck.js v0.3.29
 * @license The MIT license
 * @copyright Copyright (c) 2021 Erin Catto, Ali Shakiba
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
!function(t,i){"object"==typeof exports&&"object"==typeof module?module.exports=i():"function"==typeof define&&define.amd?define([],i):"object"==typeof exports?exports.planck=i():t.planck=i()}(window,(function(){return function(t){var i={};function e(s){if(i[s])return i[s].exports;var o=i[s]={i:s,l:!1,exports:{}};return t[s].call(o.exports,o,o.exports,e),o.l=!0,o.exports}return e.m=t,e.c=i,e.d=function(t,i,s){e.o(t,i)||Object.defineProperty(t,i,{enumerable:!0,get:s})},e.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},e.t=function(t,i){if(1&i&&(t=e(t)),8&i)return t;if(4&i&&"object"==typeof t&&t&&t.__esModule)return t;var s=Object.create(null);if(e.r(s),Object.defineProperty(s,"default",{enumerable:!0,value:t}),2&i&&"string"!=typeof t)for(var o in t)e.d(s,o,function(i){return t[i]}.bind(null,o));return s},e.n=function(t){var i=t&&t.__esModule?function(){return t.default}:function(){return t};return e.d(i,"a",i),i},e.o=function(t,i){return Object.prototype.hasOwnProperty.call(t,i)},e.p="",e(e.s=62)}([function(t,i,e){t.exports=o;e(2);var s=e(1);function o(t,i){if(!(this instanceof o))return new o(t,i);void 0===t?(this.x=0,this.y=0):"object"==typeof t?(this.x=t.x,this.y=t.y):(this.x=t,this.y=i)}o.prototype._serialize=function(){return{x:this.x,y:this.y}},o._deserialize=function(t){var i=Object.create(o.prototype);return i.x=t.x,i.y=t.y,i},o.zero=function(){var t=Object.create(o.prototype);return t.x=0,t.y=0,t},o.neo=function(t,i){var e=Object.create(o.prototype);return e.x=t,e.y=i,e},o.clone=function(t){return o.neo(t.x,t.y)},o.prototype.toString=function(){return JSON.stringify(this)},o.isValid=function(t){return t&&s.isFinite(t.x)&&s.isFinite(t.y)},o.assert=function(t){},o.prototype.clone=function(){return o.clone(this)},o.prototype.setZero=function(){return this.x=0,this.y=0,this},o.prototype.set=function(t,i){return"object"==typeof t?(this.x=t.x,this.y=t.y):(this.x=t,this.y=i),this},o.prototype.wSet=function(t,i,e,s){return void 0!==e||void 0!==s?this.setCombine(t,i,e,s):this.setMul(t,i)},o.prototype.setCombine=function(t,i,e,s){var o=t*i.x+e*s.x,n=t*i.y+e*s.y;return this.x=o,this.y=n,this},o.prototype.setMul=function(t,i){var e=t*i.x,s=t*i.y;return this.x=e,this.y=s,this},o.prototype.add=function(t){return this.x+=t.x,this.y+=t.y,this},o.prototype.wAdd=function(t,i,e,s){return void 0!==e||void 0!==s?this.addCombine(t,i,e,s):this.addMul(t,i)},o.prototype.addCombine=function(t,i,e,s){var o=t*i.x+e*s.x,n=t*i.y+e*s.y;return this.x+=o,this.y+=n,this},o.prototype.addMul=function(t,i){var e=t*i.x,s=t*i.y;return this.x+=e,this.y+=s,this},o.prototype.wSub=function(t,i,e,s){return void 0!==e||void 0!==s?this.subCombine(t,i,e,s):this.subMul(t,i)},o.prototype.subCombine=function(t,i,e,s){var o=t*i.x+e*s.x,n=t*i.y+e*s.y;return this.x-=o,this.y-=n,this},o.prototype.subMul=function(t,i){var e=t*i.x,s=t*i.y;return this.x-=e,this.y-=s,this},o.prototype.sub=function(t){return this.x-=t.x,this.y-=t.y,this},o.prototype.mul=function(t){return this.x*=t,this.y*=t,this},o.prototype.length=function(){return o.lengthOf(this)},o.prototype.lengthSquared=function(){return o.lengthSquared(this)},o.prototype.normalize=function(){var t=this.length();if(t<s.EPSILON)return 0;var i=1/t;return this.x*=i,this.y*=i,t},o.lengthOf=function(t){return s.sqrt(t.x*t.x+t.y*t.y)},o.lengthSquared=function(t){return t.x*t.x+t.y*t.y},o.distance=function(t,i){var e=t.x-i.x,o=t.y-i.y;return s.sqrt(e*e+o*o)},o.distanceSquared=function(t,i){var e=t.x-i.x,s=t.y-i.y;return e*e+s*s},o.areEqual=function(t,i){return t==i||"object"==typeof i&&null!==i&&t.x===i.x&&t.y===i.y},o.skew=function(t){return o.neo(-t.y,t.x)},o.dot=function(t,i){return t.x*i.x+t.y*i.y},o.cross=function(t,i){return"number"==typeof i?o.neo(i*t.y,-i*t.x):"number"==typeof t?o.neo(-t*i.y,t*i.x):t.x*i.y-t.y*i.x},o.addCross=function(t,i,e){return"number"==typeof e?o.neo(e*i.y+t.x,-e*i.x+t.y):"number"==typeof i?o.neo(-i*e.y+t.x,i*e.x+t.y):void 0},o.add=function(t,i){return o.neo(t.x+i.x,t.y+i.y)},o.wAdd=function(t,i,e,s){return void 0!==e||void 0!==s?o.combine(t,i,e,s):o.mul(t,i)},o.combine=function(t,i,e,s){return o.zero().setCombine(t,i,e,s)},o.sub=function(t,i){return o.neo(t.x-i.x,t.y-i.y)},o.mul=function(t,i){return"object"==typeof t?o.neo(t.x*i,t.y*i):"object"==typeof i?o.neo(t*i.x,t*i.y):void 0},o.prototype.neg=function(){return this.x=-this.x,this.y=-this.y,this},o.neg=function(t){return o.neo(-t.x,-t.y)},o.abs=function(t){return o.neo(s.abs(t.x),s.abs(t.y))},o.mid=function(t,i){return o.neo(.5*(t.x+i.x),.5*(t.y+i.y))},o.upper=function(t,i){return o.neo(s.max(t.x,i.x),s.max(t.y,i.y))},o.lower=function(t,i){return o.neo(s.min(t.x,i.x),s.min(t.y,i.y))},o.prototype.clamp=function(t){var i=this.x*this.x+this.y*this.y;if(i>t*t){var e=s.invSqrt(i);this.x*=e*t,this.y*=e*t}return this},o.clamp=function(t,i){return(t=o.neo(t.x,t.y)).clamp(i),t},o.scaleFn=function(t,i){return function(e){return o.neo(e.x*t,e.y*i)}},o.translateFn=function(t,i){return function(e){return o.neo(e.x+t,e.y+i)}}},function(t,i,e){e(2);var s=Math,o=t.exports=Object.create(s);o.EPSILON=1e-9,o.isFinite=function(t){return"number"==typeof t&&isFinite(t)&&!isNaN(t)},o.assert=function(t){},o.invSqrt=function(t){return 1/s.sqrt(t)},o.nextPowerOfTwo=function(t){return t|=t>>1,t|=t>>2,t|=t>>4,t|=t>>8,(t|=t>>16)+1},o.isPowerOfTwo=function(t){return t>0&&0==(t&t-1)},o.mod=function(t,i,e){return void 0===i?(e=1,i=0):void 0===e&&(e=i,i=0),e>i?(t=(t-i)%(e-i))+(t<0?e:i):(t=(t-e)%(i-e))+(t<=0?i:e)},o.clamp=function(t,i,e){return t<i?i:t>e?e:t},o.random=function(t,i){return void 0===t?(i=1,t=0):void 0===i&&(i=t,t=0),t==i?t:s.random()*(i-t)+t}},function(t,i,e){i.debug=function(){},i.assert=function(t,i,e){}},function(t,i,e){t.exports=n;e(2);var s=e(0),o=e(1);function n(t){if(!(this instanceof n))return new n(t);"number"==typeof t?this.setAngle(t):"object"==typeof t?this.set(t):this.setIdentity()}n.neo=function(t){var i=Object.create(n.prototype);return i.setAngle(t),i},n.clone=function(t){var i=Object.create(n.prototype);return i.s=t.s,i.c=t.c,i},n.identity=function(){var t=Object.create(n.prototype);return t.s=0,t.c=1,t},n.isValid=function(t){return t&&o.isFinite(t.s)&&o.isFinite(t.c)},n.assert=function(t){},n.prototype.setIdentity=function(){this.s=0,this.c=1},n.prototype.set=function(t){"object"==typeof t?(this.s=t.s,this.c=t.c):(this.s=o.sin(t),this.c=o.cos(t))},n.prototype.setAngle=function(t){this.s=o.sin(t),this.c=o.cos(t)},n.prototype.getAngle=function(){return o.atan2(this.s,this.c)},n.prototype.getXAxis=function(){return s.neo(this.c,this.s)},n.prototype.getYAxis=function(){return s.neo(-this.s,this.c)},n.mul=function(t,i){if("c"in i&&"s"in i){var e=n.identity();return e.s=t.s*i.c+t.c*i.s,e.c=t.c*i.c-t.s*i.s,e}if("x"in i&&"y"in i)return s.neo(t.c*i.x-t.s*i.y,t.s*i.x+t.c*i.y)},n.mulRot=function(t,i){var e=n.identity();return e.s=t.s*i.c+t.c*i.s,e.c=t.c*i.c-t.s*i.s,e},n.mulVec2=function(t,i){return s.neo(t.c*i.x-t.s*i.y,t.s*i.x+t.c*i.y)},n.mulSub=function(t,i,e){var o=t.c*(i.x-e.x)-t.s*(i.y-e.y),n=t.s*(i.x-e.x)+t.c*(i.y-e.y);return s.neo(o,n)},n.mulT=function(t,i){if("c"in i&&"s"in i){var e=n.identity();return e.s=t.c*i.s-t.s*i.c,e.c=t.c*i.c+t.s*i.s,e}if("x"in i&&"y"in i)return s.neo(t.c*i.x+t.s*i.y,-t.s*i.x+t.c*i.y)},n.mulTRot=function(t,i){var e=n.identity();return e.s=t.c*i.s-t.s*i.c,e.c=t.c*i.c+t.s*i.s,e},n.mulTVec2=function(t,i){return s.neo(t.c*i.x+t.s*i.y,-t.s*i.x+t.c*i.y)}},function(t,i,e){var s=i;s.maxManifoldPoints=2,s.maxPolygonVertices=12,s.aabbExtension=.1,s.aabbMultiplier=2,s.linearSlop=.005,s.linearSlopSquared=s.linearSlop*s.linearSlop,s.angularSlop=2/180*Math.PI,s.polygonRadius=2*s.linearSlop,s.maxSubSteps=8,s.maxTOIContacts=32,s.maxTOIIterations=20,s.maxDistnceIterations=20,s.velocityThreshold=1,s.maxLinearCorrection=.2,s.maxAngularCorrection=8/180*Math.PI,s.maxTranslation=2,s.maxTranslationSquared=s.maxTranslation*s.maxTranslation,s.maxRotation=.5*Math.PI,s.maxRotationSquared=s.maxRotation*s.maxRotation,s.baumgarte=.2,s.toiBaugarte=.75,s.timeToSleep=.5,s.linearSleepTolerance=.01,s.linearSleepToleranceSqr=Math.pow(s.linearSleepTolerance,2),s.angularSleepTolerance=2/180*Math.PI,s.angularSleepToleranceSqr=Math.pow(s.angularSleepTolerance,2)},function(t,i,e){t.exports=n;e(2);var s=e(0),o=e(3);function n(t,i){if(!(this instanceof n))return new n(t,i);this.p=s.zero(),this.q=o.identity(),void 0!==t&&this.p.set(t),void 0!==i&&this.q.set(i)}n.clone=function(t){var i=Object.create(n.prototype);return i.p=s.clone(t.p),i.q=o.clone(t.q),i},n.neo=function(t,i){var e=Object.create(n.prototype);return e.p=s.clone(t),e.q=o.clone(i),e},n.identity=function(){var t=Object.create(n.prototype);return t.p=s.zero(),t.q=o.identity(),t},n.prototype.setIdentity=function(){this.p.setZero(),this.q.setIdentity()},n.prototype.set=function(t,i){void 0===i?(this.p.set(t.p),this.q.set(t.q)):(this.p.set(t),this.q.set(i))},n.isValid=function(t){return t&&s.isValid(t.p)&&o.isValid(t.q)},n.assert=function(t){},n.mul=function(t,i){if(Array.isArray(i)){for(var e=[],r=0;r<i.length;r++)e[r]=n.mul(t,i[r]);return e}if("x"in i&&"y"in i){var h=t.q.c*i.x-t.q.s*i.y+t.p.x,a=t.q.s*i.x+t.q.c*i.y+t.p.y;return s.neo(h,a)}if("p"in i&&"q"in i){var m=n.identity();return m.q=o.mulRot(t.q,i.q),m.p=s.add(o.mulVec2(t.q,i.p),t.p),m}},n.mulAll=function(t,i){for(var e=[],s=0;s<i.length;s++)e[s]=n.mul(t,i[s]);return e},n.mulFn=function(t){return function(i){return n.mul(t,i)}},n.mulVec2=function(t,i){var e=t.q.c*i.x-t.q.s*i.y+t.p.x,o=t.q.s*i.x+t.q.c*i.y+t.p.y;return s.neo(e,o)},n.mulXf=function(t,i){var e=n.identity();return e.q=o.mulRot(t.q,i.q),e.p=s.add(o.mulVec2(t.q,i.p),t.p),e},n.mulT=function(t,i){if("x"in i&&"y"in i){var e=i.x-t.p.x,r=i.y-t.p.y,h=t.q.c*e+t.q.s*r,a=-t.q.s*e+t.q.c*r;return s.neo(h,a)}if("p"in i&&"q"in i){var m=n.identity();return m.q.set(o.mulTRot(t.q,i.q)),m.p.set(o.mulTVec2(t.q,s.sub(i.p,t.p))),m}},n.mulTVec2=function(t,i){var e=i.x-t.p.x,o=i.y-t.p.y,n=t.q.c*e+t.q.s*o,r=-t.q.s*e+t.q.c*o;return s.neo(n,r)},n.mulTXf=function(t,i){var e=n.identity();return e.q.set(o.mulTRot(t.q,i.q)),e.p.set(o.mulTVec2(t.q,s.sub(i.p,t.p))),e}},function(t,i,e){Object.prototype.propertyIsEnumerable;t.exports=function(t,i){null==t&&(t={});var e=Object.assign({},t);for(var s in i)i.hasOwnProperty(s)&&void 0===t[s]&&(e[s]=i[s]);if("function"==typeof Object.getOwnPropertySymbols)for(var o=Object.getOwnPropertySymbols(i),n=0;n<o.length;n++){var r=o[n];i.propertyIsEnumerable(r)&&void 0===t[s]&&(e[r]=i[r])}return e}},function(t,i,e){t.exports=o;e(2);var s=e(1);function o(t,i,e){if(!(this instanceof o))return new o(t,i,e);void 0===t?(this.x=0,this.y=0,this.z=0):"object"==typeof t?(this.x=t.x,this.y=t.y,this.z=t.z):(this.x=t,this.y=i,this.z=e)}o.prototype._serialize=function(){return{x:this.x,y:this.y,z:this.z}},o._deserialize=function(t){var i=Object.create(o.prototype);return i.x=t.x,i.y=t.y,i.z=t.z,i},o.neo=function(t,i,e){var s=Object.create(o.prototype);return s.x=t,s.y=i,s.z=e,s},o.clone=function(t){return o.neo(t.x,t.y,t.z)},o.prototype.toString=function(){return JSON.stringify(this)},o.isValid=function(t){return t&&s.isFinite(t.x)&&s.isFinite(t.y)&&s.isFinite(t.z)},o.assert=function(t){},o.prototype.setZero=function(){return this.x=0,this.y=0,this.z=0,this},o.prototype.set=function(t,i,e){return this.x=t,this.y=i,this.z=e,this},o.prototype.add=function(t){return this.x+=t.x,this.y+=t.y,this.z+=t.z,this},o.prototype.sub=function(t){return this.x-=t.x,this.y-=t.y,this.z-=t.z,this},o.prototype.mul=function(t){return this.x*=t,this.y*=t,this.z*=t,this},o.areEqual=function(t,i){return t==i||"object"==typeof t&&null!==t&&"object"==typeof i&&null!==i&&t.x===i.x&&t.y===i.y&&t.z===i.z},o.dot=function(t,i){return t.x*i.x+t.y*i.y+t.z*i.z},o.cross=function(t,i){return new o(t.y*i.z-t.z*i.y,t.z*i.x-t.x*i.z,t.x*i.y-t.y*i.x)},o.add=function(t,i){return new o(t.x+i.x,t.y+i.y,t.z+i.z)},o.sub=function(t,i){return new o(t.x-i.x,t.y-i.y,t.z-i.z)},o.mul=function(t,i){return new o(i*t.x,i*t.y,i*t.z)},o.prototype.neg=function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this},o.neg=function(t){return new o(-t.x,-t.y,-t.z)}},function(t,i,e){t.exports=y;e(2);var s=e(6),o=e(0),n=e(3),r=(e(1),e(9)),h=e(5),a=e(12),m=e(13),c=e(26),_=(e(15),y.STATIC="static"),l=y.KINEMATIC="kinematic",u=y.DYNAMIC="dynamic",p={type:_,position:o.zero(),angle:0,linearVelocity:o.zero(),angularVelocity:0,linearDamping:0,angularDamping:0,fixedRotation:!1,bullet:!1,gravityScale:1,allowSleep:!0,awake:!0,active:!0,userData:null};function y(t,i){i=s(i,p),this.m_world=t,this.m_awakeFlag=i.awake,this.m_autoSleepFlag=i.allowSleep,this.m_bulletFlag=i.bullet,this.m_fixedRotationFlag=i.fixedRotation,this.m_activeFlag=i.active,this.m_islandFlag=!1,this.m_toiFlag=!1,this.m_userData=i.userData,this.m_type=i.type,this.m_type==u?(this.m_mass=1,this.m_invMass=1):(this.m_mass=0,this.m_invMass=0),this.m_I=0,this.m_invI=0,this.m_xf=h.identity(),this.m_xf.p=o.clone(i.position),this.m_xf.q.setAngle(i.angle),this.m_sweep=new r,this.m_sweep.setTransform(this.m_xf),this.c_velocity=new a,this.c_position=new m,this.m_force=o.zero(),this.m_torque=0,this.m_linearVelocity=o.clone(i.linearVelocity),this.m_angularVelocity=i.angularVelocity,this.m_linearDamping=i.linearDamping,this.m_angularDamping=i.angularDamping,this.m_gravityScale=i.gravityScale,this.m_sleepTime=0,this.m_jointList=null,this.m_contactList=null,this.m_fixtureList=null,this.m_prev=null,this.m_next=null,this.m_destroyed=!1}function d(){this.mass=0,this.center=o.zero(),this.I=0}y.prototype._serialize=function(){for(var t=[],i=this.m_fixtureList;i;i=i.m_next)t.push(i);return{type:this.m_type,bullet:this.m_bulletFlag,position:this.m_xf.p,angle:this.m_xf.q.getAngle(),linearVelocity:this.m_linearVelocity,angularVelocity:this.m_angularVelocity,fixtures:t}},y._deserialize=function(t,i,e){var s=new y(i,t);if(t.fixtures)for(var o=t.fixtures.length-1;o>=0;o--){var n=e(c,t.fixtures[o],s);s._addFixture(n)}return s},y.prototype.isWorldLocked=function(){return!(!this.m_world||!this.m_world.isLocked())},y.prototype.getWorld=function(){return this.m_world},y.prototype.getNext=function(){return this.m_next},y.prototype.setUserData=function(t){this.m_userData=t},y.prototype.getUserData=function(){return this.m_userData},y.prototype.getFixtureList=function(){return this.m_fixtureList},y.prototype.getJointList=function(){return this.m_jointList},y.prototype.getContactList=function(){return this.m_contactList},y.prototype.isStatic=function(){return this.m_type==_},y.prototype.isDynamic=function(){return this.m_type==u},y.prototype.isKinematic=function(){return this.m_type==l},y.prototype.setStatic=function(){return this.setType(_),this},y.prototype.setDynamic=function(){return this.setType(u),this},y.prototype.setKinematic=function(){return this.setType(l),this},y.prototype.getType=function(){return this.m_type},y.prototype.setType=function(t){if(1!=this.isWorldLocked()&&this.m_type!=t){this.m_type=t,this.resetMassData(),this.m_type==_&&(this.m_linearVelocity.setZero(),this.m_angularVelocity=0,this.m_sweep.forward(),this.synchronizeFixtures()),this.setAwake(!0),this.m_force.setZero(),this.m_torque=0;for(var i=this.m_contactList;i;){var e=i;i=i.next,this.m_world.destroyContact(e.contact)}this.m_contactList=null;for(var s=this.m_world.m_broadPhase,o=this.m_fixtureList;o;o=o.m_next)for(var n=o.m_proxyCount,r=0;r<n;++r)s.touchProxy(o.m_proxies[r].proxyId)}},y.prototype.isBullet=function(){return this.m_bulletFlag},y.prototype.setBullet=function(t){this.m_bulletFlag=!!t},y.prototype.isSleepingAllowed=function(){return this.m_autoSleepFlag},y.prototype.setSleepingAllowed=function(t){this.m_autoSleepFlag=!!t,0==this.m_autoSleepFlag&&this.setAwake(!0)},y.prototype.isAwake=function(){return this.m_awakeFlag},y.prototype.setAwake=function(t){t?0==this.m_awakeFlag&&(this.m_awakeFlag=!0,this.m_sleepTime=0):(this.m_awakeFlag=!1,this.m_sleepTime=0,this.m_linearVelocity.setZero(),this.m_angularVelocity=0,this.m_force.setZero(),this.m_torque=0)},y.prototype.isActive=function(){return this.m_activeFlag},y.prototype.setActive=function(t){if(t!=this.m_activeFlag)if(this.m_activeFlag=!!t,this.m_activeFlag)for(var i=this.m_world.m_broadPhase,e=this.m_fixtureList;e;e=e.m_next)e.createProxies(i,this.m_xf);else{for(i=this.m_world.m_broadPhase,e=this.m_fixtureList;e;e=e.m_next)e.destroyProxies(i);for(var s=this.m_contactList;s;){var o=s;s=s.next,this.m_world.destroyContact(o.contact)}this.m_contactList=null}},y.prototype.isFixedRotation=function(){return this.m_fixedRotationFlag},y.prototype.setFixedRotation=function(t){this.m_fixedRotationFlag!=t&&(this.m_fixedRotationFlag=!!t,this.m_angularVelocity=0,this.resetMassData())},y.prototype.getTransform=function(){return this.m_xf},y.prototype.setTransform=function(t,i){if(1!=this.isWorldLocked()){this.m_xf.set(t,i),this.m_sweep.setTransform(this.m_xf);for(var e=this.m_world.m_broadPhase,s=this.m_fixtureList;s;s=s.m_next)s.synchronize(e,this.m_xf,this.m_xf)}},y.prototype.synchronizeTransform=function(){this.m_sweep.getTransform(this.m_xf,1)},y.prototype.synchronizeFixtures=function(){var t=h.identity();this.m_sweep.getTransform(t,0);for(var i=this.m_world.m_broadPhase,e=this.m_fixtureList;e;e=e.m_next)e.synchronize(i,t,this.m_xf)},y.prototype.advance=function(t){this.m_sweep.advance(t),this.m_sweep.c.set(this.m_sweep.c0),this.m_sweep.a=this.m_sweep.a0,this.m_sweep.getTransform(this.m_xf,1)},y.prototype.getPosition=function(){return this.m_xf.p},y.prototype.setPosition=function(t){this.setTransform(t,this.m_sweep.a)},y.prototype.getAngle=function(){return this.m_sweep.a},y.prototype.setAngle=function(t){this.setTransform(this.m_xf.p,t)},y.prototype.getWorldCenter=function(){return this.m_sweep.c},y.prototype.getLocalCenter=function(){return this.m_sweep.localCenter},y.prototype.getLinearVelocity=function(){return this.m_linearVelocity},y.prototype.getLinearVelocityFromWorldPoint=function(t){var i=o.sub(t,this.m_sweep.c);return o.add(this.m_linearVelocity,o.cross(this.m_angularVelocity,i))},y.prototype.getLinearVelocityFromLocalPoint=function(t){return this.getLinearVelocityFromWorldPoint(this.getWorldPoint(t))},y.prototype.setLinearVelocity=function(t){this.m_type!=_&&(o.dot(t,t)>0&&this.setAwake(!0),this.m_linearVelocity.set(t))},y.prototype.getAngularVelocity=function(){return this.m_angularVelocity},y.prototype.setAngularVelocity=function(t){this.m_type!=_&&(t*t>0&&this.setAwake(!0),this.m_angularVelocity=t)},y.prototype.getLinearDamping=function(){return this.m_linearDamping},y.prototype.setLinearDamping=function(t){this.m_linearDamping=t},y.prototype.getAngularDamping=function(){return this.m_angularDamping},y.prototype.setAngularDamping=function(t){this.m_angularDamping=t},y.prototype.getGravityScale=function(){return this.m_gravityScale},y.prototype.setGravityScale=function(t){this.m_gravityScale=t},y.prototype.getMass=function(){return this.m_mass},y.prototype.getInertia=function(){return this.m_I+this.m_mass*o.dot(this.m_sweep.localCenter,this.m_sweep.localCenter)},y.prototype.getMassData=function(t){t.mass=this.m_mass,t.I=this.getInertia(),t.center.set(this.m_sweep.localCenter)},y.prototype.resetMassData=function(){if(this.m_mass=0,this.m_invMass=0,this.m_I=0,this.m_invI=0,this.m_sweep.localCenter.setZero(),this.isStatic()||this.isKinematic())return this.m_sweep.c0.set(this.m_xf.p),this.m_sweep.c.set(this.m_xf.p),void(this.m_sweep.a0=this.m_sweep.a);for(var t=o.zero(),i=this.m_fixtureList;i;i=i.m_next)if(0!=i.m_density){var e=new d;i.getMassData(e),this.m_mass+=e.mass,t.addMul(e.mass,e.center),this.m_I+=e.I}this.m_mass>0?(this.m_invMass=1/this.m_mass,t.mul(this.m_invMass)):(this.m_mass=1,this.m_invMass=1),this.m_I>0&&0==this.m_fixedRotationFlag?(this.m_I-=this.m_mass*o.dot(t,t),this.m_invI=1/this.m_I):(this.m_I=0,this.m_invI=0);var s=o.clone(this.m_sweep.c);this.m_sweep.setLocalCenter(t,this.m_xf),this.m_linearVelocity.add(o.cross(this.m_angularVelocity,o.sub(this.m_sweep.c,s)))},y.prototype.setMassData=function(t){if(1!=this.isWorldLocked()&&this.m_type==u){this.m_invMass=0,this.m_I=0,this.m_invI=0,this.m_mass=t.mass,this.m_mass<=0&&(this.m_mass=1),this.m_invMass=1/this.m_mass,t.I>0&&0==this.m_fixedRotationFlag&&(this.m_I=t.I-this.m_mass*o.dot(t.center,t.center),this.m_invI=1/this.m_I);var i=o.clone(this.m_sweep.c);this.m_sweep.setLocalCenter(t.center,this.m_xf),this.m_linearVelocity.add(o.cross(this.m_angularVelocity,o.sub(this.m_sweep.c,i)))}},y.prototype.applyForce=function(t,i,e){this.m_type==u&&(e&&0==this.m_awakeFlag&&this.setAwake(!0),this.m_awakeFlag&&(this.m_force.add(t),this.m_torque+=o.cross(o.sub(i,this.m_sweep.c),t)))},y.prototype.applyForceToCenter=function(t,i){this.m_type==u&&(i&&0==this.m_awakeFlag&&this.setAwake(!0),this.m_awakeFlag&&this.m_force.add(t))},y.prototype.applyTorque=function(t,i){this.m_type==u&&(i&&0==this.m_awakeFlag&&this.setAwake(!0),this.m_awakeFlag&&(this.m_torque+=t))},y.prototype.applyLinearImpulse=function(t,i,e){this.m_type==u&&(e&&0==this.m_awakeFlag&&this.setAwake(!0),this.m_awakeFlag&&(this.m_linearVelocity.addMul(this.m_invMass,t),this.m_angularVelocity+=this.m_invI*o.cross(o.sub(i,this.m_sweep.c),t)))},y.prototype.applyAngularImpulse=function(t,i){this.m_type==u&&(i&&0==this.m_awakeFlag&&this.setAwake(!0),this.m_awakeFlag&&(this.m_angularVelocity+=this.m_invI*t))},y.prototype.shouldCollide=function(t){if(this.m_type!=u&&t.m_type!=u)return!1;for(var i=this.m_jointList;i;i=i.next)if(i.other==t&&0==i.joint.m_collideConnected)return!1;return!0},y.prototype._addFixture=function(t){if(1==this.isWorldLocked())return null;if(this.m_activeFlag){var i=this.m_world.m_broadPhase;t.createProxies(i,this.m_xf)}return t.m_next=this.m_fixtureList,this.m_fixtureList=t,t.m_density>0&&this.resetMassData(),this.m_world.m_newFixture=!0,t},y.prototype.createFixture=function(t,i){if(1==this.isWorldLocked())return null;var e=new c(this,t,i);return this._addFixture(e),e},y.prototype.destroyFixture=function(t){if(1!=this.isWorldLocked()){if(this.m_fixtureList===t)this.m_fixtureList=t.m_next,!0;else for(var i=this.m_fixtureList;null!=i;){if(i.m_next===t){i.m_next=t.m_next,!0;break}i=i.m_next}for(var e=this.m_contactList;e;){var s=e.contact;e=e.next;var o=s.getFixtureA(),n=s.getFixtureB();t!=o&&t!=n||this.m_world.destroyContact(s)}if(this.m_activeFlag){var r=this.m_world.m_broadPhase;t.destroyProxies(r)}t.m_body=null,t.m_next=null,this.m_world.publish("remove-fixture",t),this.resetMassData()}},y.prototype.getWorldPoint=function(t){return h.mulVec2(this.m_xf,t)},y.prototype.getWorldVector=function(t){return n.mulVec2(this.m_xf.q,t)},y.prototype.getLocalPoint=function(t){return h.mulTVec2(this.m_xf,t)},y.prototype.getLocalVector=function(t){return n.mulTVec2(this.m_xf.q,t)}},function(t,i,e){t.exports=h;e(2);var s=e(1),o=e(0),n=e(3),r=e(5);function h(t,i){this.localCenter=o.zero(),this.c=o.zero(),this.a=0,this.alpha0=0,this.c0=o.zero(),this.a0=0}h.prototype.setTransform=function(t){var i=r.mulVec2(t,this.localCenter);this.c.set(i),this.c0.set(i),this.a=t.q.getAngle(),this.a0=t.q.getAngle()},h.prototype.setLocalCenter=function(t,i){this.localCenter.set(t);var e=r.mulVec2(i,this.localCenter);this.c.set(e),this.c0.set(e)},h.prototype.getTransform=function(t,i){i=void 0===i?0:i,t.q.setAngle((1-i)*this.a0+i*this.a),t.p.setCombine(1-i,this.c0,i,this.c),t.p.sub(n.mulVec2(t.q,this.localCenter))},h.prototype.advance=function(t){var i=(t-this.alpha0)/(1-this.alpha0);this.c0.setCombine(i,this.c,1-i,this.c0),this.a0=i*this.a+(1-i)*this.a0,this.alpha0=t},h.prototype.forward=function(){this.a0=this.a,this.c0.set(this.c)},h.prototype.normalize=function(){var t=s.mod(this.a0,-s.PI,+s.PI);this.a-=this.a0-t,this.a0=t},h.prototype.clone=function(){var t=new h;return t.localCenter.set(this.localCenter),t.alpha0=this.alpha0,t.a0=this.a0,t.a=this.a,t.c0.set(this.c0),t.c.set(this.c),t},h.prototype.set=function(t){this.localCenter.set(t.localCenter),this.alpha0=t.alpha0,this.a0=t.a0,this.a=t.a,this.c0.set(t.c0),this.c.set(t.c)}},function(t,i,e){t.exports=o;e(2),e(1);var s=e(0);function o(t,i,e,o){"object"==typeof t&&null!==t?(this.ex=s.clone(t),this.ey=s.clone(i)):"number"==typeof t?(this.ex=s.neo(t,e),this.ey=s.neo(i,o)):(this.ex=s.zero(),this.ey=s.zero())}o.prototype.toString=function(){return JSON.stringify(this)},o.isValid=function(t){return t&&s.isValid(t.ex)&&s.isValid(t.ey)},o.assert=function(t){},o.prototype.set=function(t,i,e,s){"number"==typeof t&&"number"==typeof i&&"number"==typeof e&&"number"==typeof s?(this.ex.set(t,e),this.ey.set(i,s)):"object"==typeof t&&"object"==typeof i?(this.ex.set(t),this.ey.set(i)):"object"==typeof t&&(this.ex.set(t.ex),this.ey.set(t.ey))},o.prototype.setIdentity=function(){this.ex.x=1,this.ey.x=0,this.ex.y=0,this.ey.y=1},o.prototype.setZero=function(){this.ex.x=0,this.ey.x=0,this.ex.y=0,this.ey.y=0},o.prototype.getInverse=function(){var t=this.ex.x,i=this.ey.x,e=this.ex.y,s=this.ey.y,n=t*s-i*e;0!=n&&(n=1/n);var r=new o;return r.ex.x=n*s,r.ey.x=-n*i,r.ex.y=-n*e,r.ey.y=n*t,r},o.prototype.solve=function(t){var i=this.ex.x,e=this.ey.x,o=this.ex.y,n=this.ey.y,r=i*n-e*o;0!=r&&(r=1/r);var h=s.zero();return h.x=r*(n*t.x-e*t.y),h.y=r*(i*t.y-o*t.x),h},o.mul=function(t,i){if(i&&"x"in i&&"y"in i){var e=t.ex.x*i.x+t.ey.x*i.y,n=t.ex.y*i.x+t.ey.y*i.y;return s.neo(e,n)}if(i&&"ex"in i&&"ey"in i)return new o(t.ex.x*i.ex.x+t.ey.x*i.ex.y,t.ex.x*i.ey.x+t.ey.x*i.ey.y,t.ex.y*i.ex.x+t.ey.y*i.ex.y,t.ex.y*i.ey.x+t.ey.y*i.ey.y)},o.mulVec2=function(t,i){var e=t.ex.x*i.x+t.ey.x*i.y,o=t.ex.y*i.x+t.ey.y*i.y;return s.neo(e,o)},o.mulMat22=function(t,i){return new o(t.ex.x*i.ex.x+t.ey.x*i.ex.y,t.ex.x*i.ey.x+t.ey.x*i.ey.y,t.ex.y*i.ex.x+t.ey.y*i.ex.y,t.ex.y*i.ey.x+t.ey.y*i.ey.y)},o.mulT=function(t,i){return i&&"x"in i&&"y"in i?s.neo(s.dot(i,t.ex),s.dot(i,t.ey)):i&&"ex"in i&&"ey"in i?new o(s.neo(s.dot(t.ex,i.ex),s.dot(t.ey,i.ex)),s.neo(s.dot(t.ex,i.ey),s.dot(t.ey,i.ey))):void 0},o.mulTVec2=function(t,i){return s.neo(s.dot(i,t.ex),s.dot(i,t.ey))},o.mulTMat22=function(t,i){return new o(s.neo(s.dot(t.ex,i.ex),s.dot(t.ey,i.ex)),s.neo(s.dot(t.ex,i.ey),s.dot(t.ey,i.ey)))},o.abs=function(t){return new o(s.abs(t.ex),s.abs(t.ey))},o.add=function(t,i){return new o(s.add(t.ex,i.ex),s.add(t.ey,i.ey))}},function(t,i,e){t.exports=o;e(2);function s(){this.other=null,this.joint=null,this.prev=null,this.next=null}function o(t,i,e){i=t.bodyA||i,e=t.bodyB||e,this.m_type="unknown-joint",this.m_bodyA=i,this.m_bodyB=e,this.m_index=0,this.m_collideConnected=!!t.collideConnected,this.m_prev=null,this.m_next=null,this.m_edgeA=new s,this.m_edgeB=new s,this.m_islandFlag=!1,this.m_userData=t.userData}o.TYPES={},o._deserialize=function(t,i,e){var s=o.TYPES[t.type];return s&&e(s,t)},o.prototype.isActive=function(){return this.m_bodyA.isActive()&&this.m_bodyB.isActive()},o.prototype.getType=function(){return this.m_type},o.prototype.getBodyA=function(){return this.m_bodyA},o.prototype.getBodyB=function(){return this.m_bodyB},o.prototype.getNext=function(){return this.m_next},o.prototype.getUserData=function(){return this.m_userData},o.prototype.setUserData=function(t){this.m_userData=t},o.prototype.getCollideConnected=function(){return this.m_collideConnected},o.prototype.getAnchorA=function(){},o.prototype.getAnchorB=function(){},o.prototype.getReactionForce=function(t){},o.prototype.getReactionTorque=function(t){},o.prototype.shiftOrigin=function(t){},o.prototype.initVelocityConstraints=function(t){},o.prototype.solveVelocityConstraints=function(t){},o.prototype.solvePositionConstraints=function(t){}},function(t,i,e){t.exports=function(){this.v=s.zero(),this.w=0};var s=e(0)},function(t,i,e){t.exports=n;var s=e(0),o=e(3);function n(){this.c=s.zero(),this.a=0}n.prototype.getTransform=function(t,i){return t.q.set(this.a),t.p.set(s.sub(this.c,o.mulVec2(t.q,i))),t}},function(t,i,e){t.exports=n;e(2),e(1);var s=e(0),o=e(7);function n(t,i,e){"object"==typeof t&&null!==t?(this.ex=o.clone(t),this.ey=o.clone(i),this.ez=o.clone(e)):(this.ex=o(),this.ey=o(),this.ez=o())}n.prototype.toString=function(){return JSON.stringify(this)},n.isValid=function(t){return t&&o.isValid(t.ex)&&o.isValid(t.ey)&&o.isValid(t.ez)},n.assert=function(t){},n.prototype.setZero=function(){return this.ex.setZero(),this.ey.setZero(),this.ez.setZero(),this},n.prototype.solve33=function(t){var i=o.dot(this.ex,o.cross(this.ey,this.ez));0!=i&&(i=1/i);var e=new o;return e.x=i*o.dot(t,o.cross(this.ey,this.ez)),e.y=i*o.dot(this.ex,o.cross(t,this.ez)),e.z=i*o.dot(this.ex,o.cross(this.ey,t)),e},n.prototype.solve22=function(t){var i=this.ex.x,e=this.ey.x,o=this.ex.y,n=this.ey.y,r=i*n-e*o;0!=r&&(r=1/r);var h=s.zero();return h.x=r*(n*t.x-e*t.y),h.y=r*(i*t.y-o*t.x),h},n.prototype.getInverse22=function(t){var i=this.ex.x,e=this.ey.x,s=this.ex.y,o=this.ey.y,n=i*o-e*s;0!=n&&(n=1/n),t.ex.x=n*o,t.ey.x=-n*e,t.ex.z=0,t.ex.y=-n*s,t.ey.y=n*i,t.ey.z=0,t.ez.x=0,t.ez.y=0,t.ez.z=0},n.prototype.getSymInverse33=function(t){var i=o.dot(this.ex,o.cross(this.ey,this.ez));0!=i&&(i=1/i);var e=this.ex.x,s=this.ey.x,n=this.ez.x,r=this.ey.y,h=this.ez.y,a=this.ez.z;t.ex.x=i*(r*a-h*h),t.ex.y=i*(n*h-s*a),t.ex.z=i*(s*h-n*r),t.ey.x=t.ex.y,t.ey.y=i*(e*a-n*n),t.ey.z=i*(n*s-e*h),t.ez.x=t.ex.z,t.ez.y=t.ey.z,t.ez.z=i*(e*r-s*s)},n.mul=function(t,i){if(i&&"z"in i&&"y"in i&&"x"in i){var e=t.ex.x*i.x+t.ey.x*i.y+t.ez.x*i.z,n=t.ex.y*i.x+t.ey.y*i.y+t.ez.y*i.z,r=t.ex.z*i.x+t.ey.z*i.y+t.ez.z*i.z;return new o(e,n,r)}if(i&&"y"in i&&"x"in i){e=t.ex.x*i.x+t.ey.x*i.y,n=t.ex.y*i.x+t.ey.y*i.y;return s.neo(e,n)}},n.mulVec3=function(t,i){var e=t.ex.x*i.x+t.ey.x*i.y+t.ez.x*i.z,s=t.ex.y*i.x+t.ey.y*i.y+t.ez.y*i.z,n=t.ex.z*i.x+t.ey.z*i.y+t.ez.z*i.z;return new o(e,s,n)},n.mulVec2=function(t,i){var e=t.ex.x*i.x+t.ey.x*i.y,o=t.ex.y*i.x+t.ey.y*i.y;return s.neo(e,o)},n.add=function(t,i){return new n(o.add(t.ex,i.ex),o.add(t.ey,i.ey),o.add(t.ez,i.ez))}},function(t,i,e){t.exports=s;e(1);function s(){this.m_type,this.m_radius}s.prototype._reset=function(){},s.prototype._serialize=function(){return{}},s.TYPES={},s._deserialize=function(t,i,e){var o=s.TYPES[t.type];return o&&e(o,t)},s.isValid=function(t){return!!t},s.prototype.getRadius=function(){return this.m_radius},s.prototype.getType=function(){return this.m_type},s.prototype._clone=function(){},s.prototype.getChildCount=function(){},s.prototype.testPoint=function(t,i){},s.prototype.rayCast=function(t,i,e,s){},s.prototype.computeAABB=function(t,i,e){},s.prototype.computeMass=function(t,i){},s.prototype.computeDistanceProxy=function(t){}},function(t,i,e){e(4),e(2);var s=e(1),o=e(0);function n(t,i){if(!(this instanceof n))return new n(t,i);this.lowerBound=o.zero(),this.upperBound=o.zero(),"object"==typeof t&&this.lowerBound.set(t),"object"==typeof i?this.upperBound.set(i):"object"==typeof t&&this.upperBound.set(t)}t.exports=n,n.prototype.isValid=function(){return n.isValid(this)},n.isValid=function(t){var i=o.sub(t.upperBound,t.lowerBound);return i.x>=0&&i.y>=0&&o.isValid(t.lowerBound)&&o.isValid(t.upperBound)},n.assert=function(t){},n.prototype.getCenter=function(){return o.neo(.5*(this.lowerBound.x+this.upperBound.x),.5*(this.lowerBound.y+this.upperBound.y))},n.prototype.getExtents=function(){return o.neo(.5*(this.upperBound.x-this.lowerBound.x),.5*(this.upperBound.y-this.lowerBound.y))},n.prototype.getPerimeter=function(){return 2*(this.upperBound.x-this.lowerBound.x+this.upperBound.y-this.lowerBound.y)},n.prototype.combine=function(t,i){i=i||this;var e=t.lowerBound,o=t.upperBound,n=i.lowerBound,r=i.upperBound,h=s.min(e.x,n.x),a=s.min(e.y,n.y),m=s.max(r.x,o.x),c=s.max(r.y,o.y);this.lowerBound.set(h,a),this.upperBound.set(m,c)},n.prototype.combinePoints=function(t,i){this.lowerBound.set(s.min(t.x,i.x),s.min(t.y,i.y)),this.upperBound.set(s.max(t.x,i.x),s.max(t.y,i.y))},n.prototype.set=function(t){this.lowerBound.set(t.lowerBound.x,t.lowerBound.y),this.upperBound.set(t.upperBound.x,t.upperBound.y)},n.prototype.contains=function(t){var i=!0;return i=(i=(i=(i=i&&this.lowerBound.x<=t.lowerBound.x)&&this.lowerBound.y<=t.lowerBound.y)&&t.upperBound.x<=this.upperBound.x)&&t.upperBound.y<=this.upperBound.y},n.prototype.extend=function(t){return n.extend(this,t),this},n.extend=function(t,i){t.lowerBound.x-=i,t.lowerBound.y-=i,t.upperBound.x+=i,t.upperBound.y+=i},n.testOverlap=function(t,i){var e=i.lowerBound.x-t.upperBound.x,s=t.lowerBound.x-i.upperBound.x,o=i.lowerBound.y-t.upperBound.y,n=t.lowerBound.y-i.upperBound.y;return!(e>0||o>0||s>0||n>0)},n.areEqual=function(t,i){return o.areEqual(t.lowerBound,i.lowerBound)&&o.areEqual(t.upperBound,i.upperBound)},n.diff=function(t,i){var e=s.max(0,s.min(t.upperBound.x,i.upperBound.x)-s.max(i.lowerBound.x,t.lowerBound.x)),o=s.max(0,s.min(t.upperBound.y,i.upperBound.y)-s.max(i.lowerBound.y,t.lowerBound.y));return(t.upperBound.x-t.lowerBound.x)*(t.upperBound.y-t.lowerBound.y)+(i.upperBound.x-i.lowerBound.x)*(i.upperBound.y-i.lowerBound.y)-e*o},n.prototype.rayCast=function(t,i){for(var e=-1/0,n=1/0,r=i.p1,h=o.sub(i.p2,i.p1),a=o.abs(h),m=o.zero(),c="x";null!==c;c="x"===c?"y":null)if(a.x<s.EPSILON){if(r[c]<this.lowerBound[c]||this.upperBound[c]<r[c])return!1}else{var _=1/h[c],l=(this.lowerBound[c]-r[c])*_,u=(this.upperBound[c]-r[c])*_,p=-1;if(l>u){var y=l;l=u,u=y,p=1}if(l>e&&(m.setZero(),m[c]=p,e=l),e>(n=s.min(n,u)))return!1}return!(e<0||i.maxFraction<e)&&(t.fraction=e,t.normal=m,!0)},n.prototype.toString=function(){return JSON.stringify(this)}},function(t,i,e){e(2);var s=e(1),o=e(0),n=e(5),r=e(10),h=e(3),a=e(4),m=e(18),c=e(21);function _(t){this.contact=t,this.prev,this.next,this.other}function l(t,i,e,s,n){this.m_nodeA=new _(this),this.m_nodeB=new _(this),this.m_fixtureA=t,this.m_fixtureB=e,this.m_indexA=i,this.m_indexB=s,this.m_evaluateFcn=n,this.m_manifold=new m,this.m_prev=null,this.m_next=null,this.m_toi=1,this.m_toiCount=0,this.m_toiFlag=!1,this.m_friction=p(this.m_fixtureA.m_friction,this.m_fixtureB.m_friction),this.m_restitution=y(this.m_fixtureA.m_restitution,this.m_fixtureB.m_restitution),this.m_tangentSpeed=0,this.m_enabledFlag=!0,this.m_islandFlag=!1,this.m_touchingFlag=!1,this.m_filterFlag=!1,this.m_bulletHitFlag=!1,this.v_points=[],this.v_normal=o.zero(),this.v_normalMass=new r,this.v_K=new r,this.v_pointCount,this.v_tangentSpeed,this.v_friction,this.v_restitution,this.v_invMassA,this.v_invMassB,this.v_invIA,this.v_invIB,this.p_localPoints=[],this.p_localNormal=o.zero(),this.p_localPoint=o.zero(),this.p_localCenterA=o.zero(),this.p_localCenterB=o.zero(),this.p_type,this.p_radiusA,this.p_radiusB,this.p_pointCount,this.p_invMassA,this.p_invMassB,this.p_invIA,this.p_invIB}function u(){this.rA=o.zero(),this.rB=o.zero(),this.normalImpulse=0,this.tangentImpulse=0,this.normalMass=0,this.tangentMass=0,this.velocityBias=0}function p(t,i){return s.sqrt(t*i)}function y(t,i){return t>i?t:i}t.exports=l,l.prototype.initConstraint=function(t){var i=this.m_fixtureA,e=this.m_fixtureB,s=i.getShape(),n=e.getShape(),r=i.getBody(),h=e.getBody(),a=this.getManifold(),m=a.pointCount;this.v_invMassA=r.m_invMass,this.v_invMassB=h.m_invMass,this.v_invIA=r.m_invI,this.v_invIB=h.m_invI,this.v_friction=this.m_friction,this.v_restitution=this.m_restitution,this.v_tangentSpeed=this.m_tangentSpeed,this.v_pointCount=m,this.v_K.setZero(),this.v_normalMass.setZero(),this.p_invMassA=r.m_invMass,this.p_invMassB=h.m_invMass,this.p_invIA=r.m_invI,this.p_invIB=h.m_invI,this.p_localCenterA=o.clone(r.m_sweep.localCenter),this.p_localCenterB=o.clone(h.m_sweep.localCenter),this.p_radiusA=s.m_radius,this.p_radiusB=n.m_radius,this.p_type=a.type,this.p_localNormal=o.clone(a.localNormal),this.p_localPoint=o.clone(a.localPoint),this.p_pointCount=m;for(var c=0;c<m;++c){var _=a.points[c],l=this.v_points[c]=new u;t.warmStarting?(l.normalImpulse=t.dtRatio*_.normalImpulse,l.tangentImpulse=t.dtRatio*_.tangentImpulse):(l.normalImpulse=0,l.tangentImpulse=0),l.rA.setZero(),l.rB.setZero(),l.normalMass=0,l.tangentMass=0,l.velocityBias=0,this.p_localPoints[c]=o.clone(_.localPoint)}},l.prototype.getManifold=function(){return this.m_manifold},l.prototype.getWorldManifold=function(t){var i=this.m_fixtureA.getBody(),e=this.m_fixtureB.getBody(),s=this.m_fixtureA.getShape(),o=this.m_fixtureB.getShape();return this.m_manifold.getWorldManifold(t,i.getTransform(),s.m_radius,e.getTransform(),o.m_radius)},l.prototype.setEnabled=function(t){this.m_enabledFlag=!!t},l.prototype.isEnabled=function(){return this.m_enabledFlag},l.prototype.isTouching=function(){return this.m_touchingFlag},l.prototype.getNext=function(){return this.m_next},l.prototype.getFixtureA=function(){return this.m_fixtureA},l.prototype.getFixtureB=function(){return this.m_fixtureB},l.prototype.getChildIndexA=function(){return this.m_indexA},l.prototype.getChildIndexB=function(){return this.m_indexB},l.prototype.flagForFiltering=function(){this.m_filterFlag=!0},l.prototype.setFriction=function(t){this.m_friction=t},l.prototype.getFriction=function(){return this.m_friction},l.prototype.resetFriction=function(){this.m_friction=p(this.m_fixtureA.m_friction,this.m_fixtureB.m_friction)},l.prototype.setRestitution=function(t){this.m_restitution=t},l.prototype.getRestitution=function(){return this.m_restitution},l.prototype.resetRestitution=function(){this.m_restitution=y(this.m_fixtureA.m_restitution,this.m_fixtureB.m_restitution)},l.prototype.setTangentSpeed=function(t){this.m_tangentSpeed=t},l.prototype.getTangentSpeed=function(){return this.m_tangentSpeed},l.prototype.evaluate=function(t,i,e){this.m_evaluateFcn(t,i,this.m_fixtureA,this.m_indexA,e,this.m_fixtureB,this.m_indexB)},l.prototype.update=function(t){this.m_enabledFlag=!0;var i=!1,e=this.m_touchingFlag,s=this.m_fixtureA.isSensor(),o=this.m_fixtureB.isSensor(),n=s||o,r=this.m_fixtureA.getBody(),h=this.m_fixtureB.getBody(),a=r.getTransform(),_=h.getTransform();if(n){var l=this.m_fixtureA.getShape(),u=this.m_fixtureB.getShape();i=c.testOverlap(l,this.m_indexA,u,this.m_indexB,a,_),this.m_manifold.pointCount=0}else{var p=this.m_manifold;this.m_manifold=new m,this.evaluate(this.m_manifold,a,_),i=this.m_manifold.pointCount>0;for(var y=0;y<this.m_manifold.pointCount;++y){var d=this.m_manifold.points[y];d.normalImpulse=0,d.tangentImpulse=0;for(var f=0;f<p.pointCount;++f){var v=p.points[f];if(v.id.key==d.id.key){d.normalImpulse=v.normalImpulse,d.tangentImpulse=v.tangentImpulse;break}}}i!=e&&(r.setAwake(!0),h.setAwake(!0))}this.m_touchingFlag=i,0==e&&1==i&&t&&t.beginContact(this),1==e&&0==i&&t&&t.endContact(this),0==n&&i&&t&&t.preSolve(this,p)},l.prototype.solvePositionConstraint=function(t){return this._solvePositionConstraint(t,!1)},l.prototype.solvePositionConstraintTOI=function(t,i,e){return this._solvePositionConstraint(t,!0,i,e)},l.prototype._solvePositionConstraint=function(t,i,e,r){var c=this.m_fixtureA,_=this.m_fixtureB,l=c.getBody(),u=_.getBody(),p=(l.c_velocity,u.c_velocity,l.c_position),y=u.c_position,d=o.clone(this.p_localCenterA),f=o.clone(this.p_localCenterB),v=0,x=0;i&&l!=e&&l!=r||(v=this.p_invMassA,x=this.p_invIA);var g=0,b=0;i&&u!=e&&u!=r||(g=this.p_invMassB,b=this.p_invIB);for(var A=o.clone(p.c),B=p.a,w=o.clone(y.c),C=y.a,M=0,I=0;I<this.p_pointCount;++I){var S,P,z,T=n.identity(),V=n.identity();switch(T.q.set(B),V.q.set(C),T.p=o.sub(A,h.mulVec2(T.q,d)),V.p=o.sub(w,h.mulVec2(V.q,f)),this.p_type){case m.e_circles:var k=n.mulVec2(T,this.p_localPoint),L=n.mulVec2(V,this.p_localPoints[0]);(S=o.sub(L,k)).normalize(),P=o.combine(.5,k,.5,L),z=o.dot(o.sub(L,k),S)-this.p_radiusA-this.p_radiusB;break;case m.e_faceA:S=h.mulVec2(T.q,this.p_localNormal);var q=n.mulVec2(T,this.p_localPoint),F=n.mulVec2(V,this.p_localPoints[I]);z=o.dot(o.sub(F,q),S)-this.p_radiusA-this.p_radiusB,P=F;break;case m.e_faceB:S=h.mulVec2(V.q,this.p_localNormal);q=n.mulVec2(V,this.p_localPoint),F=n.mulVec2(T,this.p_localPoints[I]);z=o.dot(o.sub(F,q),S)-this.p_radiusA-this.p_radiusB,P=F,S.mul(-1)}var j=o.sub(P,A),E=o.sub(P,w);M=s.min(M,z);var Y=i?a.toiBaugarte:a.baumgarte,D=a.linearSlop,R=a.maxLinearCorrection,O=s.clamp(Y*(z+D),-R,0),J=o.cross(j,S),W=o.cross(E,S),X=v+g+x*J*J+b*W*W,N=X>0?-O/X:0,H=o.mul(N,S);A.subMul(v,H),B-=x*o.cross(j,H),w.addMul(g,H),C+=b*o.cross(E,H)}return p.c.set(A),p.a=B,y.c.set(w),y.a=C,M},l.prototype.initVelocityConstraint=function(t){var i=this.m_fixtureA,e=this.m_fixtureB,s=i.getBody(),r=e.getBody(),m=s.c_velocity,c=r.c_velocity,_=s.c_position,l=r.c_position,u=this.p_radiusA,p=this.p_radiusB,y=this.getManifold(),d=this.v_invMassA,f=this.v_invMassB,v=this.v_invIA,x=this.v_invIB,g=o.clone(this.p_localCenterA),b=o.clone(this.p_localCenterB),A=o.clone(_.c),B=_.a,w=o.clone(m.v),C=m.w,M=o.clone(l.c),I=l.a,S=o.clone(c.v),P=c.w,z=n.identity(),T=n.identity();z.q.set(B),T.q.set(I),z.p.setCombine(1,A,-1,h.mulVec2(z.q,g)),T.p.setCombine(1,M,-1,h.mulVec2(T.q,b));var V=y.getWorldManifold(null,z,u,T,p);this.v_normal.set(V.normal);for(var k=0;k<this.v_pointCount;++k){var L=this.v_points[k];L.rA.set(o.sub(V.points[k],A)),L.rB.set(o.sub(V.points[k],M));var q=o.cross(L.rA,this.v_normal),F=o.cross(L.rB,this.v_normal),j=d+f+v*q*q+x*F*F;L.normalMass=j>0?1/j:0;var E=o.cross(this.v_normal,1),Y=o.cross(L.rA,E),D=o.cross(L.rB,E),R=d+f+v*Y*Y+x*D*D;L.tangentMass=R>0?1/R:0,L.velocityBias=0;var O=o.dot(this.v_normal,S)+o.dot(this.v_normal,o.cross(P,L.rB))-o.dot(this.v_normal,w)-o.dot(this.v_normal,o.cross(C,L.rA));O<-a.velocityThreshold&&(L.velocityBias=-this.v_restitution*O)}if(2==this.v_pointCount&&t.blockSolve){var J=this.v_points[0],W=this.v_points[1],X=o.cross(J.rA,this.v_normal),N=o.cross(J.rB,this.v_normal),H=o.cross(W.rA,this.v_normal),Z=o.cross(W.rB,this.v_normal),K=d+f+v*X*X+x*N*N,G=d+f+v*H*H+x*Z*Z,U=d+f+v*X*H+x*N*Z;K*K<1e3*(K*G-U*U)?(this.v_K.ex.set(K,U),this.v_K.ey.set(U,G),this.v_normalMass.set(this.v_K.getInverse())):this.v_pointCount=1}_.c.set(A),_.a=B,m.v.set(w),m.w=C,l.c.set(M),l.a=I,c.v.set(S),c.w=P},l.prototype.warmStartConstraint=function(t){for(var i=this.m_fixtureA,e=this.m_fixtureB,s=i.getBody(),n=e.getBody(),r=s.c_velocity,h=n.c_velocity,a=(s.c_position,n.c_position,this.v_invMassA),m=this.v_invIA,c=this.v_invMassB,_=this.v_invIB,l=o.clone(r.v),u=r.w,p=o.clone(h.v),y=h.w,d=this.v_normal,f=o.cross(d,1),v=0;v<this.v_pointCount;++v){var x=this.v_points[v],g=o.combine(x.normalImpulse,d,x.tangentImpulse,f);u-=m*o.cross(x.rA,g),l.subMul(a,g),y+=_*o.cross(x.rB,g),p.addMul(c,g)}r.v.set(l),r.w=u,h.v.set(p),h.w=y},l.prototype.storeConstraintImpulses=function(t){for(var i=this.m_manifold,e=0;e<this.v_pointCount;++e)i.points[e].normalImpulse=this.v_points[e].normalImpulse,i.points[e].tangentImpulse=this.v_points[e].tangentImpulse},l.prototype.solveVelocityConstraint=function(t){for(var i=this.m_fixtureA.m_body,e=this.m_fixtureB.m_body,n=i.c_velocity,h=(i.c_position,e.c_velocity),a=(e.c_position,this.v_invMassA),m=this.v_invIA,c=this.v_invMassB,_=this.v_invIB,l=o.clone(n.v),u=n.w,p=o.clone(h.v),y=h.w,d=this.v_normal,f=o.cross(d,1),v=this.v_friction,x=0;x<this.v_pointCount;++x){var g=this.v_points[x];(M=o.zero()).addCombine(1,p,1,o.cross(y,g.rB)),M.subCombine(1,l,1,o.cross(u,g.rA));var b=o.dot(M,f)-this.v_tangentSpeed,A=g.tangentMass*-b,B=v*g.normalImpulse;A=(I=s.clamp(g.tangentImpulse+A,-B,B))-g.tangentImpulse,g.tangentImpulse=I;var w=o.mul(A,f);l.subMul(a,w),u-=m*o.cross(g.rA,w),p.addMul(c,w),y+=_*o.cross(g.rB,w)}if(1==this.v_pointCount||0==t.blockSolve)for(var C=0;C<this.v_pointCount;++C){var M;g=this.v_points[C];(M=o.zero()).addCombine(1,p,1,o.cross(y,g.rB)),M.subCombine(1,l,1,o.cross(u,g.rA));var I,S=o.dot(M,d);A=-g.normalMass*(S-g.velocityBias);A=(I=s.max(g.normalImpulse+A,0))-g.normalImpulse,g.normalImpulse=I;w=o.mul(A,d);l.subMul(a,w),u-=m*o.cross(g.rA,w),p.addMul(c,w),y+=_*o.cross(g.rB,w)}else{var P=this.v_points[0],z=this.v_points[1],T=o.neo(P.normalImpulse,z.normalImpulse),V=o.zero().add(p).add(o.cross(y,P.rB)).sub(l).sub(o.cross(u,P.rA)),k=o.zero().add(p).add(o.cross(y,z.rB)).sub(l).sub(o.cross(u,z.rA)),L=o.dot(V,d),q=o.dot(k,d),F=o.neo(L-P.velocityBias,q-z.velocityBias);F.sub(r.mulVec2(this.v_K,T));for(;;){var j=r.mulVec2(this.v_normalMass,F).neg();if(j.x>=0&&j.y>=0){var E=o.sub(j,T),Y=o.mul(E.x,d),D=o.mul(E.y,d);l.subCombine(a,Y,a,D),u-=m*(o.cross(P.rA,Y)+o.cross(z.rA,D)),p.addCombine(c,Y,c,D),y+=_*(o.cross(P.rB,Y)+o.cross(z.rB,D)),P.normalImpulse=j.x,z.normalImpulse=j.y;break}if(j.x=-P.normalMass*F.x,j.y=0,L=0,q=this.v_K.ex.y*j.x+F.y,j.x>=0&&q>=0){E=o.sub(j,T),Y=o.mul(E.x,d),D=o.mul(E.y,d);l.subCombine(a,Y,a,D),u-=m*(o.cross(P.rA,Y)+o.cross(z.rA,D)),p.addCombine(c,Y,c,D),y+=_*(o.cross(P.rB,Y)+o.cross(z.rB,D)),P.normalImpulse=j.x,z.normalImpulse=j.y;break}if(j.x=0,j.y=-z.normalMass*F.y,L=this.v_K.ey.x*j.y+F.x,q=0,j.y>=0&&L>=0){E=o.sub(j,T),Y=o.mul(E.x,d),D=o.mul(E.y,d);l.subCombine(a,Y,a,D),u-=m*(o.cross(P.rA,Y)+o.cross(z.rA,D)),p.addCombine(c,Y,c,D),y+=_*(o.cross(P.rB,Y)+o.cross(z.rB,D)),P.normalImpulse=j.x,z.normalImpulse=j.y;break}if(j.x=0,j.y=0,L=F.x,q=F.y,L>=0&&q>=0){E=o.sub(j,T),Y=o.mul(E.x,d),D=o.mul(E.y,d);l.subCombine(a,Y,a,D),u-=m*(o.cross(P.rA,Y)+o.cross(z.rA,D)),p.addCombine(c,Y,c,D),y+=_*(o.cross(P.rB,Y)+o.cross(z.rB,D)),P.normalImpulse=j.x,z.normalImpulse=j.y;break}break}}n.v.set(l),n.w=u,h.v.set(p),h.w=y};var d=[];l.addType=function(t,i,e){d[t]=d[t]||{},d[t][i]=e},l.create=function(t,i,e,s){var o,n,r=t.getType(),h=e.getType();if(n=d[r]&&d[r][h])o=new l(t,i,e,s,n);else{if(!(n=d[h]&&d[h][r]))return null;o=new l(e,s,t,i,n)}t=o.getFixtureA(),e=o.getFixtureB(),i=o.getChildIndexA(),s=o.getChildIndexB();var a=t.getBody(),m=e.getBody();return o.m_nodeA.contact=o,o.m_nodeA.other=m,o.m_nodeA.prev=null,o.m_nodeA.next=a.m_contactList,null!=a.m_contactList&&(a.m_contactList.prev=o.m_nodeA),a.m_contactList=o.m_nodeA,o.m_nodeB.contact=o,o.m_nodeB.other=a,o.m_nodeB.prev=null,o.m_nodeB.next=m.m_contactList,null!=m.m_contactList&&(m.m_contactList.prev=o.m_nodeB),m.m_contactList=o.m_nodeB,0==t.isSensor()&&0==e.isSensor()&&(a.setAwake(!0),m.setAwake(!0)),o},l.destroy=function(t,i){var e=t.m_fixtureA,s=t.m_fixtureB,o=e.getBody(),n=s.getBody();t.isTouching()&&i.endContact(t),t.m_nodeA.prev&&(t.m_nodeA.prev.next=t.m_nodeA.next),t.m_nodeA.next&&(t.m_nodeA.next.prev=t.m_nodeA.prev),t.m_nodeA==o.m_contactList&&(o.m_contactList=t.m_nodeA.next),t.m_nodeB.prev&&(t.m_nodeB.prev.next=t.m_nodeB.next),t.m_nodeB.next&&(t.m_nodeB.next.prev=t.m_nodeB.prev),t.m_nodeB==n.m_contactList&&(n.m_contactList=t.m_nodeB.next),t.m_manifold.pointCount>0&&0==e.isSensor()&&0==s.isSensor()&&(o.setAwake(!0),n.setAwake(!0));var r=e.getType(),h=s.getType(),a=d[r][h].destroyFcn;"function"==typeof a&&a(t)}},function(t,i,e){e(2);var s=e(0),o=e(5),n=e(1),r=e(3);function h(){this.type,this.localNormal=s.zero(),this.localPoint=s.zero(),this.points=[new a,new a],this.pointCount=0}function a(){this.localPoint=s.zero(),this.normalImpulse=0,this.tangentImpulse=0,this.id=new m}function m(){this.cf=new c}function c(){this.indexA,this.indexB,this.typeA,this.typeB}function _(){this.normal,this.points=[],this.separations=[]}t.exports=h,t.exports.clipSegmentToLine=function(t,i,e,o,n){var r=0,a=s.dot(e,i[0].v)-o,m=s.dot(e,i[1].v)-o;a<=0&&t[r++].set(i[0]);m<=0&&t[r++].set(i[1]);if(a*m<0){var c=a/(a-m);t[r].v.setCombine(1-c,i[0].v,c,i[1].v),t[r].id.cf.indexA=n,t[r].id.cf.indexB=i[0].id.cf.indexB,t[r].id.cf.typeA=h.e_vertex,t[r].id.cf.typeB=h.e_face,++r}return r},t.exports.clipVertex=u,t.exports.getPointStates=function(t,i,e,s){for(var o=0;o<e.pointCount;++o){var n=e.points[o].id;t[o]=l.removeState;for(var r=0;r<s.pointCount;++r)if(s.points[r].id.key==n.key){t[o]=l.persistState;break}}for(o=0;o<s.pointCount;++o){n=s.points[o].id;i[o]=l.addState;for(r=0;r<e.pointCount;++r)if(e.points[r].id.key==n.key){i[o]=l.persistState;break}}},t.exports.PointState=l,h.e_circles=0,h.e_faceA=1,h.e_faceB=2,h.e_vertex=0,h.e_face=1,Object.defineProperty(m.prototype,"key",{get:function(){return this.cf.indexA+4*this.cf.indexB+16*this.cf.typeA+64*this.cf.typeB},enumerable:!0,configurable:!0}),m.prototype.set=function(t){this.cf.set(t.cf)},c.prototype.set=function(t){this.indexA=t.indexA,this.indexB=t.indexB,this.typeA=t.typeA,this.typeB=t.typeB},h.prototype.getWorldManifold=function(t,i,e,a,m){if(0!=this.pointCount){var c=(t=t||new _).normal,l=t.points,u=t.separations;switch(this.type){case h.e_circles:c=s.neo(1,0);var p=o.mulVec2(i,this.localPoint),y=o.mulVec2(a,this.points[0].localPoint),d=s.sub(y,p);s.lengthSquared(d)>n.EPSILON*n.EPSILON&&(c.set(d),c.normalize());var f=p.clone().addMul(e,c),v=y.clone().addMul(-m,c);l[0]=s.mid(f,v),u[0]=s.dot(s.sub(v,f),c),l.length=1,u.length=1;break;case h.e_faceA:c=r.mulVec2(i.q,this.localNormal);for(var x=o.mulVec2(i,this.localPoint),g=0;g<this.pointCount;++g){var b=o.mulVec2(a,this.points[g].localPoint);f=s.clone(b).addMul(e-s.dot(s.sub(b,x),c),c),v=s.clone(b).subMul(m,c);l[g]=s.mid(f,v),u[g]=s.dot(s.sub(v,f),c)}l.length=this.pointCount,u.length=this.pointCount;break;case h.e_faceB:c=r.mulVec2(a.q,this.localNormal);for(x=o.mulVec2(a,this.localPoint),g=0;g<this.pointCount;++g){b=o.mulVec2(i,this.points[g].localPoint),v=s.combine(1,b,m-s.dot(s.sub(b,x),c),c),f=s.combine(1,b,-e,c);l[g]=s.mid(f,v),u[g]=s.dot(s.sub(f,v),c)}l.length=this.pointCount,u.length=this.pointCount,c.mul(-1)}return t.normal=c,t.points=l,t.separations=u,t}};var l={nullState:0,addState:1,persistState:2,removeState:3};function u(){this.v=s.zero(),this.id=new m}u.prototype.set=function(t){this.v.set(t.v),this.id.set(t.id)}},function(t,i,e){var s=e(35),o=e(36),n=e(37),r=e(65);function h(t){if(!(this instanceof h))return n.fn(t)?h.app.apply(h,arguments):n.object(t)?h.atlas.apply(h,arguments):t;s.create++;for(var i=0;i<a.length;i++)a[i].call(this)}s.create=0;var a=[];h._init=function(t){a.push(t)};var m=[];h._load=function(t){m.push(t)};var c={};h.config=function(){if(1===arguments.length&&n.string(arguments[0]))return c[arguments[0]];1===arguments.length&&n.object(arguments[0])&&o(c,arguments[0]),2===arguments.length&&n.string(arguments[0])};var _=[],l=[],u=!1,p=!1;h.app=function(t,i){if(u){var e=h.config("app-loader");e((function(i,e){for(var s=0;s<m.length;s++)m[s].call(this,i,e);t(i,e),l.push(i),i.start()}),i)}else _.push(arguments)};var y=r();h.preload=function(t){if("string"==typeof t){var i=h.resolve(t);/\.js($|\?|\#)/.test(i)&&(t=function(t){!function(t,i){var e=document.createElement("script");e.addEventListener("load",(function(){i()})),e.addEventListener("error",(function(e){i(e||"Error loading script: "+t)})),e.src=t,e.id="preload-"+Date.now(),document.body.appendChild(e)}(i,t)})}"function"==typeof t&&t(y())},h.start=function(t){h.config(t),y.then((function(){for(u=!0;_.length;){var t=_.shift();h.app.apply(h,t)}}))},h.pause=function(){if(!p){p=!0;for(var t=l.length-1;t>=0;t--)l[t].pause()}},h.resume=function(){if(p){p=!1;for(var t=l.length-1;t>=0;t--)l[t].resume()}},h.create=function(){return new h},h.resolve=function(){if("undefined"==typeof window||"undefined"==typeof document)return function(t){return t};var t=document.getElementsByTagName("script");return function(i){if(/^\.\//.test(i)){var e=function(){if(document.currentScript)return document.currentScript.src;var i;try{var e=new Error;if(!e.stack)throw e;i=e.stack}catch(e){i=e.stack}if("string"==typeof i)for(var s=(i=i.split("\n")).length;s--;){var o=i[s].match(/(\w+\:\/\/[^/]*?\/.+?)(:\d+)(:\d+)?/);if(o)return o[1]}if(t.length&&"readyState"in t[0])for(s=t.length;s--;)if("interactive"===t[s].readyState)return t[s].src;return location.href}();i=e.substring(0,e.lastIndexOf("/")+1)+i.substring(2)}return i}}(),t.exports=h},function(t,i,e){t.exports=m;e(2),e(6);var s=e(1),o=e(5),n=e(3),r=e(0),h=(e(16),e(4)),a=e(15);function m(t){if(!(this instanceof m))return new m(t);m._super.call(this),this.m_type=m.TYPE,this.m_radius=h.polygonRadius,this.m_centroid=r.zero(),this.m_vertices=[],this.m_normals=[],this.m_count=0,t&&t.length&&this._set(t)}m._super=a,m.prototype=Object.create(m._super.prototype),m.TYPE="polygon",a.TYPES[m.TYPE]=m,m.prototype._serialize=function(){return{type:this.m_type,vertices:this.m_vertices}},m._deserialize=function(t,i,e){var s=[];if(t.vertices)for(var o=0;o<t.vertices.length;o++)s.push(e(r,t.vertices[o]));return new m(s)},m.prototype.getVertex=function(t){return this.m_vertices[t]},m.prototype._clone=function(){var t=new m;t.m_type=this.m_type,t.m_radius=this.m_radius,t.m_count=this.m_count,t.m_centroid.set(this.m_centroid);for(var i=0;i<this.m_count;i++)t.m_vertices.push(this.m_vertices[i].clone());for(i=0;i<this.m_normals.length;i++)t.m_normals.push(this.m_normals[i].clone());return t},m.prototype.getChildCount=function(){return 1},m.prototype._reset=function(){this._set(this.m_vertices)},m.prototype._set=function(t){if(t.length<3)this._setAsBox(1,1);else{for(var i=s.min(t.length,h.maxPolygonVertices),e=[],o=0;o<i;++o){for(var n=t[o],a=!0,m=0;m<e.length;++m)if(r.distanceSquared(n,e[m])<.25*h.linearSlopSquared){a=!1;break}a&&e.push(n)}if((i=e.length)<3)this._setAsBox(1,1);else{var c=0,_=e[0].x;for(o=1;o<i;++o){var l=e[o].x;(l>_||l===_&&e[o].y<e[c].y)&&(c=o,_=l)}for(var u=[],p=0,y=c;;){u[p]=y;var d=0;for(m=1;m<i;++m)if(d!==y){var f=r.sub(e[d],e[u[p]]),v=(n=r.sub(e[m],e[u[p]]),r.cross(f,n));v<0&&(d=m),0===v&&n.lengthSquared()>f.lengthSquared()&&(d=m)}else d=m;if(++p,y=d,d===c)break}if(p<3)this._setAsBox(1,1);else{this.m_count=p,this.m_vertices=[];for(o=0;o<p;++o)this.m_vertices[o]=e[u[o]];for(o=0;o<p;++o){var x=o,g=o+1<p?o+1:0,b=r.sub(this.m_vertices[g],this.m_vertices[x]);this.m_normals[o]=r.cross(b,1),this.m_normals[o].normalize()}this.m_centroid=function(t,i){for(var e=r.zero(),s=0,o=r.zero(),n=0;n<i;++n){var h=o,a=t[n],m=n+1<i?t[n+1]:t[0],c=r.sub(a,h),_=r.sub(m,h),l=.5*r.cross(c,_);s+=l,e.addMul(l*(1/3),h),e.addMul(l*(1/3),a),e.addMul(l*(1/3),m)}return e.mul(1/s),e}(this.m_vertices,p)}}}},m.prototype._setAsBox=function(t,i,e,s){if(this.m_vertices[0]=r.neo(t,-i),this.m_vertices[1]=r.neo(t,i),this.m_vertices[2]=r.neo(-t,i),this.m_vertices[3]=r.neo(-t,-i),this.m_normals[0]=r.neo(1,0),this.m_normals[1]=r.neo(0,1),this.m_normals[2]=r.neo(-1,0),this.m_normals[3]=r.neo(0,-1),this.m_count=4,r.isValid(e)){s=s||0,this.m_centroid.set(e);var h=o.identity();h.p.set(e),h.q.set(s);for(var a=0;a<this.m_count;++a)this.m_vertices[a]=o.mulVec2(h,this.m_vertices[a]),this.m_normals[a]=n.mulVec2(h.q,this.m_normals[a])}},m.prototype.testPoint=function(t,i){for(var e=n.mulTVec2(t.q,r.sub(i,t.p)),s=0;s<this.m_count;++s){if(r.dot(this.m_normals[s],r.sub(e,this.m_vertices[s]))>0)return!1}return!0},m.prototype.rayCast=function(t,i,e,s){for(var o=n.mulTVec2(e.q,r.sub(i.p1,e.p)),h=n.mulTVec2(e.q,r.sub(i.p2,e.p)),a=r.sub(h,o),m=0,c=i.maxFraction,_=-1,l=0;l<this.m_count;++l){var u=r.dot(this.m_normals[l],r.sub(this.m_vertices[l],o)),p=r.dot(this.m_normals[l],a);if(0==p){if(u<0)return!1}else p<0&&u<m*p?(m=u/p,_=l):p>0&&u<c*p&&(c=u/p);if(c<m)return!1}return _>=0&&(t.fraction=m,t.normal=n.mulVec2(e.q,this.m_normals[_]),!0)},m.prototype.computeAABB=function(t,i,e){for(var n=1/0,r=1/0,h=-1/0,a=-1/0,m=0;m<this.m_count;++m){var c=o.mulVec2(i,this.m_vertices[m]);n=s.min(n,c.x),h=s.max(h,c.x),r=s.min(r,c.y),a=s.max(a,c.y)}t.lowerBound.set(n,r),t.upperBound.set(h,a),t.extend(this.m_radius)},m.prototype.computeMass=function(t,i){for(var e=r.zero(),s=0,o=0,n=r.zero(),h=0;h<this.m_count;++h)n.add(this.m_vertices[h]);n.mul(1/this.m_count);for(h=0;h<this.m_count;++h){var a=r.sub(this.m_vertices[h],n),m=h+1<this.m_count?r.sub(this.m_vertices[h+1],n):r.sub(this.m_vertices[0],n),c=r.cross(a,m),_=.5*c;s+=_,e.addCombine(_*(1/3),a,_*(1/3),m);var l=a.x,u=a.y,p=m.x,y=m.y;o+=1/3*.25*c*(l*l+p*l+p*p+(u*u+y*u+y*y))}t.mass=i*s,e.mul(1/s),t.center.setCombine(1,e,1,n),t.I=i*o,t.I+=t.mass*(r.dot(t.center,t.center)-r.dot(e,e))},m.prototype.validate=function(){for(var t=0;t<this.m_count;++t)for(var i=t,e=t<this.m_count-1?i+1:0,s=this.m_vertices[i],o=r.sub(this.m_vertices[e],s),n=0;n<this.m_count;++n)if(n!=i&&n!=e){var h=r.sub(this.m_vertices[n],s);if(r.cross(o,h)<0)return!1}return!0},m.prototype.computeDistanceProxy=function(t){t.m_vertices=this.m_vertices,t.m_count=this.m_count,t.m_radius=this.m_radius}},function(t,i,e){t.exports=l,t.exports.Input=m,t.exports.Output=c,t.exports.Proxy=u,t.exports.Cache=_;var s=e(4),o=(e(2),e(27)),n=e(1),r=e(0),h=(e(7),e(10),e(14),e(3)),a=(e(9),e(5));e(12),e(13);function m(){this.proxyA=new u,this.proxyB=new u,this.transformA=null,this.transformB=null,this.useRadii=!1}function c(){this.pointA=r.zero(),this.pointB=r.zero(),this.distance,this.iterations}function _(){this.metric=0,this.indexA=[],this.indexB=[],this.count=0}function l(t,i,e){++o.gjkCalls;var m=e.proxyA,c=e.proxyB,_=e.transformA,l=e.transformB,u=new y;u.readCache(i,m,_,c,l);for(var p=u.m_v,d=s.maxDistnceIterations,f=[],v=[],x=0,g=0;g<d;){x=u.m_count;for(var b=0;b<x;++b)f[b]=p[b].indexA,v[b]=p[b].indexB;if(u.solve(),3==u.m_count)break;(S=u.getClosestPoint()).lengthSquared();var A=u.getSearchDirection();if(A.lengthSquared()<n.EPSILON*n.EPSILON)break;var B=p[u.m_count];B.indexA=m.getSupport(h.mulTVec2(_.q,r.neg(A))),B.wA=a.mulVec2(_,m.getVertex(B.indexA)),B.indexB=c.getSupport(h.mulTVec2(l.q,A)),B.wB=a.mulVec2(l,c.getVertex(B.indexB)),B.w=r.sub(B.wB,B.wA),++g,++o.gjkIters;var w=!1;for(b=0;b<x;++b)if(B.indexA==f[b]&&B.indexB==v[b]){w=!0;break}if(w)break;++u.m_count}if(o.gjkMaxIters=n.max(o.gjkMaxIters,g),u.getWitnessPoints(t.pointA,t.pointB),t.distance=r.distance(t.pointA,t.pointB),t.iterations=g,u.writeCache(i),e.useRadii){var C=m.m_radius,M=c.m_radius;if(t.distance>C+M&&t.distance>n.EPSILON){t.distance-=C+M;var I=r.sub(t.pointB,t.pointA);I.normalize(),t.pointA.addMul(C,I),t.pointB.subMul(M,I)}else{var S=r.mid(t.pointA,t.pointB);t.pointA.set(S),t.pointB.set(S),t.distance=0}}}function u(){this.m_buffer=[],this.m_vertices=[],this.m_count=0,this.m_radius=0}function p(){this.indexA,this.indexB,this.wA=r.zero(),this.wB=r.zero(),this.w=r.zero(),this.a}function y(){this.m_v1=new p,this.m_v2=new p,this.m_v3=new p,this.m_v=[this.m_v1,this.m_v2,this.m_v3],this.m_count}o.gjkCalls=0,o.gjkIters=0,o.gjkMaxIters=0,u.prototype.getVertexCount=function(){return this.m_count},u.prototype.getVertex=function(t){return this.m_vertices[t]},u.prototype.getSupport=function(t){for(var i=0,e=r.dot(this.m_vertices[0],t),s=0;s<this.m_count;++s){var o=r.dot(this.m_vertices[s],t);o>e&&(i=s,e=o)}return i},u.prototype.getSupportVertex=function(t){return this.m_vertices[this.getSupport(t)]},u.prototype.set=function(t,i){t.computeDistanceProxy(this,i)},p.prototype.set=function(t){this.indexA=t.indexA,this.indexB=t.indexB,this.wA=r.clone(t.wA),this.wB=r.clone(t.wB),this.w=r.clone(t.w),this.a=t.a},y.prototype.print=function(){return 3==this.m_count?["+"+this.m_count,this.m_v1.a,this.m_v1.wA.x,this.m_v1.wA.y,this.m_v1.wB.x,this.m_v1.wB.y,this.m_v2.a,this.m_v2.wA.x,this.m_v2.wA.y,this.m_v2.wB.x,this.m_v2.wB.y,this.m_v3.a,this.m_v3.wA.x,this.m_v3.wA.y,this.m_v3.wB.x,this.m_v3.wB.y].toString():2==this.m_count?["+"+this.m_count,this.m_v1.a,this.m_v1.wA.x,this.m_v1.wA.y,this.m_v1.wB.x,this.m_v1.wB.y,this.m_v2.a,this.m_v2.wA.x,this.m_v2.wA.y,this.m_v2.wB.x,this.m_v2.wB.y].toString():1==this.m_count?["+"+this.m_count,this.m_v1.a,this.m_v1.wA.x,this.m_v1.wA.y,this.m_v1.wB.x,this.m_v1.wB.y].toString():"+"+this.m_count},y.prototype.readCache=function(t,i,e,s,o){this.m_count=t.count;for(var h=0;h<this.m_count;++h){(u=this.m_v[h]).indexA=t.indexA[h],u.indexB=t.indexB[h];var m=i.getVertex(u.indexA),c=s.getVertex(u.indexB);u.wA=a.mulVec2(e,m),u.wB=a.mulVec2(o,c),u.w=r.sub(u.wB,u.wA),u.a=0}if(this.m_count>1){var _=t.metric,l=this.getMetric();(l<.5*_||2*_<l||l<n.EPSILON)&&(this.m_count=0)}if(0==this.m_count){var u;(u=this.m_v[0]).indexA=0,u.indexB=0;m=i.getVertex(0),c=s.getVertex(0);u.wA=a.mulVec2(e,m),u.wB=a.mulVec2(o,c),u.w=r.sub(u.wB,u.wA),u.a=1,this.m_count=1}},y.prototype.writeCache=function(t){t.metric=this.getMetric(),t.count=this.m_count;for(var i=0;i<this.m_count;++i)t.indexA[i]=this.m_v[i].indexA,t.indexB[i]=this.m_v[i].indexB},y.prototype.getSearchDirection=function(){switch(this.m_count){case 1:return r.neg(this.m_v1.w);case 2:var t=r.sub(this.m_v2.w,this.m_v1.w);return r.cross(t,r.neg(this.m_v1.w))>0?r.cross(1,t):r.cross(t,1);default:return r.zero()}},y.prototype.getClosestPoint=function(){switch(this.m_count){case 0:return r.zero();case 1:return r.clone(this.m_v1.w);case 2:return r.combine(this.m_v1.a,this.m_v1.w,this.m_v2.a,this.m_v2.w);case 3:default:return r.zero()}},y.prototype.getWitnessPoints=function(t,i){switch(this.m_count){case 0:break;case 1:t.set(this.m_v1.wA),i.set(this.m_v1.wB);break;case 2:t.setCombine(this.m_v1.a,this.m_v1.wA,this.m_v2.a,this.m_v2.wA),i.setCombine(this.m_v1.a,this.m_v1.wB,this.m_v2.a,this.m_v2.wB);break;case 3:t.setCombine(this.m_v1.a,this.m_v1.wA,this.m_v2.a,this.m_v2.wA),t.addMul(this.m_v3.a,this.m_v3.wA),i.set(t)}},y.prototype.getMetric=function(){switch(this.m_count){case 0:case 1:return 0;case 2:return r.distance(this.m_v1.w,this.m_v2.w);case 3:return r.cross(r.sub(this.m_v2.w,this.m_v1.w),r.sub(this.m_v3.w,this.m_v1.w));default:return 0}},y.prototype.solve=function(){switch(this.m_count){case 1:break;case 2:this.solve2();break;case 3:this.solve3()}},y.prototype.solve2=function(){var t=this.m_v1.w,i=this.m_v2.w,e=r.sub(i,t),s=-r.dot(t,e);if(s<=0)return this.m_v1.a=1,void(this.m_count=1);var o=r.dot(i,e);if(o<=0)return this.m_v2.a=1,this.m_count=1,void this.m_v1.set(this.m_v2);var n=1/(o+s);this.m_v1.a=o*n,this.m_v2.a=s*n,this.m_count=2},y.prototype.solve3=function(){var t=this.m_v1.w,i=this.m_v2.w,e=this.m_v3.w,s=r.sub(i,t),o=r.dot(t,s),n=r.dot(i,s),h=-o,a=r.sub(e,t),m=r.dot(t,a),c=r.dot(e,a),_=-m,l=r.sub(e,i),u=r.dot(i,l),p=r.dot(e,l),y=-u,d=r.cross(s,a),f=d*r.cross(i,e),v=d*r.cross(e,t),x=d*r.cross(t,i);if(h<=0&&_<=0)return this.m_v1.a=1,void(this.m_count=1);if(n>0&&h>0&&x<=0){var g=1/(n+h);return this.m_v1.a=n*g,this.m_v2.a=h*g,void(this.m_count=2)}if(c>0&&_>0&&v<=0){var b=1/(c+_);return this.m_v1.a=c*b,this.m_v3.a=_*b,this.m_count=2,void this.m_v2.set(this.m_v3)}if(n<=0&&y<=0)return this.m_v2.a=1,this.m_count=1,void this.m_v1.set(this.m_v2);if(c<=0&&p<=0)return this.m_v3.a=1,this.m_count=1,void this.m_v1.set(this.m_v3);if(p>0&&y>0&&f<=0){var A=1/(p+y);return this.m_v2.a=p*A,this.m_v3.a=y*A,this.m_count=2,void this.m_v1.set(this.m_v3)}var B=1/(f+v+x);this.m_v1.a=f*B,this.m_v2.a=v*B,this.m_v3.a=x*B,this.m_count=3},l.testOverlap=function(t,i,e,s,o,r){var h=new m;h.proxyA.set(t,i),h.proxyB.set(e,s),h.transformA=o,h.transformB=r,h.useRadii=!0;var a=new _,u=new c;return l(u,a,h),u.distance<10*n.EPSILON}},function(t,i,e){t.exports=h;e(2),e(6);var s=e(1),o=(e(5),e(3)),n=e(0),r=(e(16),e(4),e(15));function h(t,i){if(!(this instanceof h))return new h(t,i);h._super.call(this),this.m_type=h.TYPE,this.m_p=n.zero(),this.m_radius=1,"object"==typeof t&&n.isValid(t)?(this.m_p.set(t),"number"==typeof i&&(this.m_radius=i)):"number"==typeof t&&(this.m_radius=t)}h._super=r,h.prototype=Object.create(h._super.prototype),h.TYPE="circle",r.TYPES[h.TYPE]=h,h.prototype._serialize=function(){return{type:this.m_type,p:this.m_p,radius:this.m_radius}},h._deserialize=function(t){return new h(t.p,t.radius)},h.prototype.getRadius=function(){return this.m_radius},h.prototype.getCenter=function(){return this.m_p},h.prototype.getVertex=function(t){return this.m_p},h.prototype.getVertexCount=function(t){return 1},h.prototype._clone=function(){var t=new h;return t.m_type=this.m_type,t.m_radius=this.m_radius,t.m_p=this.m_p.clone(),t},h.prototype.getChildCount=function(){return 1},h.prototype.testPoint=function(t,i){var e=n.add(t.p,o.mulVec2(t.q,this.m_p)),s=n.sub(i,e);return n.dot(s,s)<=this.m_radius*this.m_radius},h.prototype.rayCast=function(t,i,e,r){var h=n.add(e.p,o.mulVec2(e.q,this.m_p)),a=n.sub(i.p1,h),m=n.dot(a,a)-this.m_radius*this.m_radius,c=n.sub(i.p2,i.p1),_=n.dot(a,c),l=n.dot(c,c),u=_*_-l*m;if(u<0||l<s.EPSILON)return!1;var p=-(_+s.sqrt(u));return 0<=p&&p<=i.maxFraction*l&&(p/=l,t.fraction=p,t.normal=n.add(a,n.mul(p,c)),t.normal.normalize(),!0)},h.prototype.computeAABB=function(t,i,e){var s=n.add(i.p,o.mulVec2(i.q,this.m_p));t.lowerBound.set(s.x-this.m_radius,s.y-this.m_radius),t.upperBound.set(s.x+this.m_radius,s.y+this.m_radius)},h.prototype.computeMass=function(t,i){t.mass=i*s.PI*this.m_radius*this.m_radius,t.center=this.m_p,t.I=t.mass*(.5*this.m_radius*this.m_radius+n.dot(this.m_p,this.m_p))},h.prototype.computeDistanceProxy=function(t){t.m_vertices.push(this.m_p),t.m_count=1,t.m_radius=this.m_radius}},function(t,i,e){t.exports=a;e(6);var s=e(4),o=e(15),n=(e(1),e(5)),r=e(3),h=e(0);e(16);function a(t,i){if(!(this instanceof a))return new a(t,i);a._super.call(this),this.m_type=a.TYPE,this.m_radius=s.polygonRadius,this.m_vertex1=t?h.clone(t):h.zero(),this.m_vertex2=i?h.clone(i):h.zero(),this.m_vertex0=h.zero(),this.m_vertex3=h.zero(),this.m_hasVertex0=!1,this.m_hasVertex3=!1}a._super=o,a.prototype=Object.create(a._super.prototype),a.TYPE="edge",o.TYPES[a.TYPE]=a,a.prototype._serialize=function(){return{type:this.m_type,vertex1:this.m_vertex1,vertex2:this.m_vertex2,vertex0:this.m_vertex0,vertex3:this.m_vertex3,hasVertex0:this.m_hasVertex0,hasVertex3:this.m_hasVertex3}},a._deserialize=function(t){var i=new a(t.vertex1,t.vertex2);return i.hasVertex0&&i.setPrev(t.vertex0),i.hasVertex3&&i.setNext(t.vertex3),i},a.prototype.setNext=function(t){return t?(this.m_vertex3.set(t),this.m_hasVertex3=!0):(this.m_vertex3.setZero(),this.m_hasVertex3=!1),this},a.prototype.setPrev=function(t){return t?(this.m_vertex0.set(t),this.m_hasVertex0=!0):(this.m_vertex0.setZero(),this.m_hasVertex0=!1),this},a.prototype._set=function(t,i){return this.m_vertex1.set(t),this.m_vertex2.set(i),this.m_hasVertex0=!1,this.m_hasVertex3=!1,this},a.prototype._clone=function(){var t=new a;return t.m_type=this.m_type,t.m_radius=this.m_radius,t.m_vertex1.set(this.m_vertex1),t.m_vertex2.set(this.m_vertex2),t.m_vertex0.set(this.m_vertex0),t.m_vertex3.set(this.m_vertex3),t.m_hasVertex0=this.m_hasVertex0,t.m_hasVertex3=this.m_hasVertex3,t},a.prototype.getChildCount=function(){return 1},a.prototype.testPoint=function(t,i){return!1},a.prototype.rayCast=function(t,i,e,s){var o=r.mulTVec2(e.q,h.sub(i.p1,e.p)),n=r.mulTVec2(e.q,h.sub(i.p2,e.p)),a=h.sub(n,o),m=this.m_vertex1,c=this.m_vertex2,_=h.sub(c,m),l=h.neo(_.y,-_.x);l.normalize();var u=h.dot(l,h.sub(m,o)),p=h.dot(l,a);if(0==p)return!1;var y=u/p;if(y<0||i.maxFraction<y)return!1;var d=h.add(o,h.mul(y,a)),f=h.sub(c,m),v=h.dot(f,f);if(0==v)return!1;var x=h.dot(h.sub(d,m),f)/v;return!(x<0||1<x)&&(t.fraction=y,t.normal=u>0?r.mulVec2(e.q,l).neg():r.mulVec2(e.q,l),!0)},a.prototype.computeAABB=function(t,i,e){var s=n.mulVec2(i,this.m_vertex1),o=n.mulVec2(i,this.m_vertex2);t.combinePoints(s,o),t.extend(this.m_radius)},a.prototype.computeMass=function(t,i){t.mass=0,t.center.setCombine(.5,this.m_vertex1,.5,this.m_vertex2),t.I=0},a.prototype.computeDistanceProxy=function(t){t.m_vertices.push(this.m_vertex1),t.m_vertices.push(this.m_vertex2),t.m_count=2,t.m_radius=this.m_radius}},function(t,i){if("function"==typeof Object.create)t.exports=function(t,i){return Object.create.call(Object,t,i)};else{function e(){}t.exports=function(t,i){if(i)throw Error("Second argument is not supported!");if("object"!=typeof t||null===t)throw Error("Invalid prototype!");return e.prototype=t,new e}}},function(t,i,e){var s=e(19),o=e(61),n=0;function r(t){this._owner=t,this._parent=null,this._relativeMatrix=new o,this._absoluteMatrix=new o,this.reset()}s._init((function(){this._pin=new r(this)})),s.prototype.matrix=function(t){return!0===t?this._pin.relativeMatrix():this._pin.absoluteMatrix()},s.prototype.pin=function(t,i){return"object"==typeof t?(this._pin.set(t),this):"string"==typeof t?void 0===i?this._pin.get(t):(this._pin.set(t,i),this):void 0===t?this._pin:void 0},r.prototype.reset=function(){this._textureAlpha=1,this._alpha=1,this._width=0,this._height=0,this._scaleX=1,this._scaleY=1,this._skewX=0,this._skewY=0,this._rotation=0,this._pivoted=!1,this._pivotX=null,this._pivotY=null,this._handled=!1,this._handleX=0,this._handleY=0,this._aligned=!1,this._alignX=0,this._alignY=0,this._offsetX=0,this._offsetY=0,this._boxX=0,this._boxY=0,this._boxWidth=this._width,this._boxHeight=this._height,this._ts_translate=++n,this._ts_transform=++n,this._ts_matrix=++n},r.prototype._update=function(){return this._parent=this._owner._parent&&this._owner._parent._pin,this._handled&&this._mo_handle!=this._ts_transform&&(this._mo_handle=this._ts_transform,this._ts_translate=++n),this._aligned&&this._parent&&this._mo_align!=this._parent._ts_transform&&(this._mo_align=this._parent._ts_transform,this._ts_translate=++n),this},r.prototype.toString=function(){return this._owner+" ("+(this._parent?this._parent._owner:null)+")"},r.prototype.absoluteMatrix=function(){this._update();var t=Math.max(this._ts_transform,this._ts_translate,this._parent?this._parent._ts_matrix:0);if(this._mo_abs==t)return this._absoluteMatrix;this._mo_abs=t;var i=this._absoluteMatrix;return i.reset(this.relativeMatrix()),this._parent&&i.concat(this._parent._absoluteMatrix),this._ts_matrix=++n,i},r.prototype.relativeMatrix=function(){this._update();var t=Math.max(this._ts_transform,this._ts_translate,this._parent?this._parent._ts_transform:0);if(this._mo_rel==t)return this._relativeMatrix;this._mo_rel=t;var i,e,s=this._relativeMatrix;(s.identity(),this._pivoted&&s.translate(-this._pivotX*this._width,-this._pivotY*this._height),s.scale(this._scaleX,this._scaleY),s.skew(this._skewX,this._skewY),s.rotate(this._rotation),this._pivoted&&s.translate(this._pivotX*this._width,this._pivotY*this._height),this._pivoted)?(this._boxX=0,this._boxY=0,this._boxWidth=this._width,this._boxHeight=this._height):(s.a>0&&s.c>0||s.a<0&&s.c<0?(i=0,e=s.a*this._width+s.c*this._height):(i=s.a*this._width,e=s.c*this._height),i>e?(this._boxX=e,this._boxWidth=i-e):(this._boxX=i,this._boxWidth=e-i),s.b>0&&s.d>0||s.b<0&&s.d<0?(i=0,e=s.b*this._width+s.d*this._height):(i=s.b*this._width,e=s.d*this._height),i>e?(this._boxY=e,this._boxHeight=i-e):(this._boxY=i,this._boxHeight=e-i));return this._x=this._offsetX,this._y=this._offsetY,this._x-=this._boxX+this._handleX*this._boxWidth,this._y-=this._boxY+this._handleY*this._boxHeight,this._aligned&&this._parent&&(this._parent.relativeMatrix(),this._x+=this._alignX*this._parent._width,this._y+=this._alignY*this._parent._height),s.translate(this._x,this._y),this._relativeMatrix},r.prototype.get=function(t){if("function"==typeof h[t])return h[t](this)},r.prototype.set=function(t,i){if("string"==typeof t)"function"==typeof a[t]&&void 0!==i&&a[t](this,i);else if("object"==typeof t)for(i in t)"function"==typeof a[i]&&void 0!==t[i]&&a[i](this,t[i],t);return this._owner&&(this._owner._ts_pin=++n,this._owner.touch()),this};var h={alpha:function(t){return t._alpha},textureAlpha:function(t){return t._textureAlpha},width:function(t){return t._width},height:function(t){return t._height},boxWidth:function(t){return t._boxWidth},boxHeight:function(t){return t._boxHeight},scaleX:function(t){return t._scaleX},scaleY:function(t){return t._scaleY},skewX:function(t){return t._skewX},skewY:function(t){return t._skewY},rotation:function(t){return t._rotation},pivotX:function(t){return t._pivotX},pivotY:function(t){return t._pivotY},offsetX:function(t){return t._offsetX},offsetY:function(t){return t._offsetY},alignX:function(t){return t._alignX},alignY:function(t){return t._alignY},handleX:function(t){return t._handleX},handleY:function(t){return t._handleY}},a={alpha:function(t,i){t._alpha=i},textureAlpha:function(t,i){t._textureAlpha=i},width:function(t,i){t._width_=i,t._width=i,t._ts_transform=++n},height:function(t,i){t._height_=i,t._height=i,t._ts_transform=++n},scale:function(t,i){t._scaleX=i,t._scaleY=i,t._ts_transform=++n},scaleX:function(t,i){t._scaleX=i,t._ts_transform=++n},scaleY:function(t,i){t._scaleY=i,t._ts_transform=++n},skew:function(t,i){t._skewX=i,t._skewY=i,t._ts_transform=++n},skewX:function(t,i){t._skewX=i,t._ts_transform=++n},skewY:function(t,i){t._skewY=i,t._ts_transform=++n},rotation:function(t,i){t._rotation=i,t._ts_transform=++n},pivot:function(t,i){t._pivotX=i,t._pivotY=i,t._pivoted=!0,t._ts_transform=++n},pivotX:function(t,i){t._pivotX=i,t._pivoted=!0,t._ts_transform=++n},pivotY:function(t,i){t._pivotY=i,t._pivoted=!0,t._ts_transform=++n},offset:function(t,i){t._offsetX=i,t._offsetY=i,t._ts_translate=++n},offsetX:function(t,i){t._offsetX=i,t._ts_translate=++n},offsetY:function(t,i){t._offsetY=i,t._ts_translate=++n},align:function(t,i){this.alignX(t,i),this.alignY(t,i)},alignX:function(t,i){t._alignX=i,t._aligned=!0,t._ts_translate=++n,this.handleX(t,i)},alignY:function(t,i){t._alignY=i,t._aligned=!0,t._ts_translate=++n,this.handleY(t,i)},handle:function(t,i){this.handleX(t,i),this.handleY(t,i)},handleX:function(t,i){t._handleX=i,t._handled=!0,t._ts_translate=++n},handleY:function(t,i){t._handleY=i,t._handled=!0,t._ts_translate=++n},resizeMode:function(t,i,e){e&&("in"==i?i="in-pad":"out"==i&&(i="out-crop"),m(t,e.resizeWidth,e.resizeHeight,i))},resizeWidth:function(t,i,e){e&&e.resizeMode||m(t,i,null)},resizeHeight:function(t,i,e){e&&e.resizeMode||m(t,null,i)},scaleMode:function(t,i,e){e&&m(t,e.scaleWidth,e.scaleHeight,i)},scaleWidth:function(t,i,e){e&&e.scaleMode||m(t,i,null)},scaleHeight:function(t,i,e){e&&e.scaleMode||m(t,null,i)},matrix:function(t,i){this.scaleX(t,i.a),this.skewX(t,i.c/i.d),this.skewY(t,i.b/i.a),this.scaleY(t,i.d),this.offsetX(t,i.e),this.offsetY(t,i.f),this.rotation(t,0)}};function m(t,i,e,s){var o="number"==typeof i,r="number"==typeof e,h="string"==typeof s;t._ts_transform=++n,o&&(t._scaleX=i/t._width_,t._width=t._width_),r&&(t._scaleY=e/t._height_,t._height=t._height_),o&&r&&h&&("out"==s||"out-crop"==s?t._scaleX=t._scaleY=Math.max(t._scaleX,t._scaleY):"in"!=s&&"in-pad"!=s||(t._scaleX=t._scaleY=Math.min(t._scaleX,t._scaleY)),"out-crop"!=s&&"in-pad"!=s||(t._width=i/t._scaleX,t._height=e/t._scaleY))}s.prototype.scaleTo=function(t,i,e){return"object"==typeof t&&(e=i,i=t.y,t=t.x),m(this._pin,t,i,e),this},r._add_shortcuts=function(t){t.prototype.size=function(t,i){return this.pin("width",t),this.pin("height",i),this},t.prototype.width=function(t){return void 0===t?this.pin("width"):(this.pin("width",t),this)},t.prototype.height=function(t){return void 0===t?this.pin("height"):(this.pin("height",t),this)},t.prototype.offset=function(t,i){return"object"==typeof t&&(i=t.y,t=t.x),this.pin("offsetX",t),this.pin("offsetY",i),this},t.prototype.rotate=function(t){return this.pin("rotation",t),this},t.prototype.skew=function(t,i){return"object"==typeof t?(i=t.y,t=t.x):void 0===i&&(i=t),this.pin("skewX",t),this.pin("skewY",i),this},t.prototype.scale=function(t,i){return"object"==typeof t?(i=t.y,t=t.x):void 0===i&&(i=t),this.pin("scaleX",t),this.pin("scaleY",i),this},t.prototype.alpha=function(t,i){return this.pin("alpha",t),void 0!==i&&this.pin("textureAlpha",i),this}},r._add_shortcuts(s),t.exports=r},function(t,i,e){t.exports=m;e(2);var s=e(6),o=(e(1),e(0)),n=e(16),r=e(15),h={userData:null,friction:.2,restitution:0,density:0,isSensor:!1,filterGroupIndex:0,filterCategoryBits:1,filterMaskBits:65535};function a(t,i){this.aabb=new n,this.fixture=t,this.childIndex=i,this.proxyId}function m(t,i,e){i.shape?(e=i,i=i.shape):"number"==typeof e&&(e={density:e}),e=s(e,h),this.m_body=t,this.m_friction=e.friction,this.m_restitution=e.restitution,this.m_density=e.density,this.m_isSensor=e.isSensor,this.m_filterGroupIndex=e.filterGroupIndex,this.m_filterCategoryBits=e.filterCategoryBits,this.m_filterMaskBits=e.filterMaskBits,this.m_shape=i,this.m_next=null,this.m_proxies=[],this.m_proxyCount=0;for(var o=this.m_shape.getChildCount(),n=0;n<o;++n)this.m_proxies[n]=new a(this,n);this.m_userData=e.userData}m.prototype._reset=function(){var t=this.getBody(),i=t.m_world.m_broadPhase;this.destroyProxies(i),this.m_shape._reset&&this.m_shape._reset();for(var e=this.m_shape.getChildCount(),s=0;s<e;++s)this.m_proxies[s]=new a(this,s);this.createProxies(i,t.m_xf),t.resetMassData()},m.prototype._serialize=function(){return{friction:this.m_friction,restitution:this.m_restitution,density:this.m_density,isSensor:this.m_isSensor,filterGroupIndex:this.m_filterGroupIndex,filterCategoryBits:this.m_filterCategoryBits,filterMaskBits:this.m_filterMaskBits,shape:this.m_shape}},m._deserialize=function(t,i,e){var s=e(r,t.shape);return s&&new m(i,s,t)},m.prototype.getType=function(){return this.m_shape.getType()},m.prototype.getShape=function(){return this.m_shape},m.prototype.isSensor=function(){return this.m_isSensor},m.prototype.setSensor=function(t){t!=this.m_isSensor&&(this.m_body.setAwake(!0),this.m_isSensor=t)},m.prototype.getUserData=function(){return this.m_userData},m.prototype.setUserData=function(t){this.m_userData=t},m.prototype.getBody=function(){return this.m_body},m.prototype.getNext=function(){return this.m_next},m.prototype.getDensity=function(){return this.m_density},m.prototype.setDensity=function(t){this.m_density=t},m.prototype.getFriction=function(){return this.m_friction},m.prototype.setFriction=function(t){this.m_friction=t},m.prototype.getRestitution=function(){return this.m_restitution},m.prototype.setRestitution=function(t){this.m_restitution=t},m.prototype.testPoint=function(t){return this.m_shape.testPoint(this.m_body.getTransform(),t)},m.prototype.rayCast=function(t,i,e){return this.m_shape.rayCast(t,i,this.m_body.getTransform(),e)},m.prototype.getMassData=function(t){this.m_shape.computeMass(t,this.m_density)},m.prototype.getAABB=function(t){return this.m_proxies[t].aabb},m.prototype.createProxies=function(t,i){this.m_proxyCount=this.m_shape.getChildCount();for(var e=0;e<this.m_proxyCount;++e){var s=this.m_proxies[e];this.m_shape.computeAABB(s.aabb,i,e),s.proxyId=t.createProxy(s.aabb,s)}},m.prototype.destroyProxies=function(t){for(var i=0;i<this.m_proxyCount;++i){var e=this.m_proxies[i];t.destroyProxy(e.proxyId),e.proxyId=null}this.m_proxyCount=0},m.prototype.synchronize=function(t,i,e){for(var s=0;s<this.m_proxyCount;++s){var r=this.m_proxies[s],h=new n,a=new n;this.m_shape.computeAABB(h,i,r.childIndex),this.m_shape.computeAABB(a,e,r.childIndex),r.aabb.combine(h,a);var m=o.sub(e.p,i.p);t.moveProxy(r.proxyId,r.aabb,m)}},m.prototype.setFilterData=function(t){this.m_filterGroupIndex=t.groupIndex,this.m_filterCategoryBits=t.categoryBits,this.m_filterMaskBits=t.maskBits,this.refilter()},m.prototype.getFilterGroupIndex=function(){return this.m_filterGroupIndex},m.prototype.setFilterGroupIndex=function(t){return this.m_filterGroupIndex=t},m.prototype.getFilterCategoryBits=function(){return this.m_filterCategoryBits},m.prototype.setFilterCategoryBits=function(t){this.m_filterCategoryBits=t},m.prototype.getFilterMaskBits=function(){return this.m_filterMaskBits},m.prototype.setFilterMaskBits=function(t){this.m_filterMaskBits=t},m.prototype.refilter=function(){if(null!=this.m_body){for(var t=this.m_body.getContactList();t;){var i=t.contact,e=i.getFixtureA(),s=i.getFixtureB();e!=this&&s!=this||i.flagForFiltering(),t=t.next}var o=this.m_body.getWorld();if(null!=o)for(var n=o.m_broadPhase,r=0;r<this.m_proxyCount;++r)n.touchProxy(this.m_proxies[r].proxyId)}},m.prototype.shouldCollide=function(t){if(t.m_filterGroupIndex===this.m_filterGroupIndex&&0!==t.m_filterGroupIndex)return t.m_filterGroupIndex>0;var i=0!=(t.m_filterMaskBits&this.m_filterCategoryBits),e=0!=(t.m_filterCategoryBits&this.m_filterMaskBits);return i&&e}},function(t,i,e){i.toString=function(t){t="string"==typeof t?t:"\n";var i="";for(var e in this)"function"!=typeof this[e]&&"object"!=typeof this[e]&&(i+=e+": "+this[e]+t);return i}},function(t,i,e){t.exports=a;e(2),e(6),e(1);var s=e(5),o=(e(3),e(0)),n=(e(16),e(4)),r=e(15),h=e(23);function a(t,i){if(!(this instanceof a))return new a(t,i);a._super.call(this),this.m_type=a.TYPE,this.m_radius=n.polygonRadius,this.m_vertices=[],this.m_count=0,this.m_prevVertex=null,this.m_nextVertex=null,this.m_hasPrevVertex=!1,this.m_hasNextVertex=!1,this.m_isLoop=i,t&&t.length&&(i?this._createLoop(t):this._createChain(t))}a._super=r,a.prototype=Object.create(a._super.prototype),a.TYPE="chain",r.TYPES[a.TYPE]=a,a.prototype._serialize=function(){const t={type:this.m_type,vertices:this.m_vertices,isLoop:this.m_isLoop,hasPrevVertex:this.m_hasPrevVertex,hasNextVertex:this.m_hasNextVertex};return this.m_prevVertex&&(t.prevVertex=this.m_prevVertex),this.m_nextVertex&&(t.nextVertex=this.m_nextVertex),t},a._deserialize=function(t,i,e){var s=[];if(t.vertices)for(var n=0;n<t.vertices.length;n++)s.push(e(o,t.vertices[n]));var r=new a(s,t.isLoop);return t.prevVertex&&r.setPrevVertex(t.prevVertex),t.nextVertex&&r.setNextVertex(t.nextVertex),r},a.prototype._createLoop=function(t){for(var i=1;i<t.length;++i)t[i-1],t[i];this.m_vertices=[],this.m_count=t.length+1;for(i=0;i<t.length;++i)this.m_vertices[i]=o.clone(t[i]);return this.m_vertices[t.length]=o.clone(t[0]),this.m_prevVertex=this.m_vertices[this.m_count-2],this.m_nextVertex=this.m_vertices[1],this.m_hasPrevVertex=!0,this.m_hasNextVertex=!0,this},a.prototype._createChain=function(t){for(var i=1;i<t.length;++i)t[i-1],t[i];this.m_count=t.length;for(i=0;i<t.length;++i)this.m_vertices[i]=o.clone(t[i]);return this.m_hasPrevVertex=!1,this.m_hasNextVertex=!1,this.m_prevVertex=null,this.m_nextVertex=null,this},a.prototype._reset=function(){this.m_isLoop?this._createLoop(this.m_vertices):this._createChain(this.m_vertices)},a.prototype.setPrevVertex=function(t){this.m_prevVertex=t,this.m_hasPrevVertex=!0},a.prototype.setNextVertex=function(t){this.m_nextVertex=t,this.m_hasNextVertex=!0},a.prototype._clone=function(){var t=new a;return t.createChain(this.m_vertices),t.m_type=this.m_type,t.m_radius=this.m_radius,t.m_prevVertex=this.m_prevVertex,t.m_nextVertex=this.m_nextVertex,t.m_hasPrevVertex=this.m_hasPrevVertex,t.m_hasNextVertex=this.m_hasNextVertex,t},a.prototype.getChildCount=function(){return this.m_count-1},a.prototype.getChildEdge=function(t,i){t.m_type=h.TYPE,t.m_radius=this.m_radius,t.m_vertex1=this.m_vertices[i],t.m_vertex2=this.m_vertices[i+1],i>0?(t.m_vertex0=this.m_vertices[i-1],t.m_hasVertex0=!0):(t.m_vertex0=this.m_prevVertex,t.m_hasVertex0=this.m_hasPrevVertex),i<this.m_count-2?(t.m_vertex3=this.m_vertices[i+2],t.m_hasVertex3=!0):(t.m_vertex3=this.m_nextVertex,t.m_hasVertex3=this.m_hasNextVertex)},a.prototype.getVertex=function(t){return t<this.m_count?this.m_vertices[t]:this.m_vertices[0]},a.prototype.testPoint=function(t,i){return!1},a.prototype.rayCast=function(t,i,e,s){return new h(this.getVertex(s),this.getVertex(s+1)).rayCast(t,i,e,0)},a.prototype.computeAABB=function(t,i,e){var o=s.mulVec2(i,this.getVertex(e)),n=s.mulVec2(i,this.getVertex(e+1));t.combinePoints(o,n)},a.prototype.computeMass=function(t,i){t.mass=0,t.center=o.neo(),t.I=0},a.prototype.computeDistanceProxy=function(t,i){t.m_buffer[0]=this.getVertex(i),t.m_buffer[1]=this.getVertex(i+1),t.m_vertices=t.m_buffer,t.m_count=2,t.m_radius=this.m_radius}},function(t,i,e){var s=e(19);e(25);var o=e(35);s.prototype._textures=null,s.prototype._alpha=1,s.prototype.render=function(t){if(this._visible){o.node++;var i=this.matrix();t.setTransform(i.a,i.b,i.c,i.d,i.e,i.f),this._alpha=this._pin._alpha*(this._parent?this._parent._alpha:1);var e=this._pin._textureAlpha*this._alpha;if(t.globalAlpha!=e&&(t.globalAlpha=e),null!==this._textures)for(var s=0,n=this._textures.length;s<n;s++)this._textures[s].draw(t);t.globalAlpha!=this._alpha&&(t.globalAlpha=this._alpha);for(var r,h=this._first;r=h;)h=r._next,r.render(t)}},s.prototype._tickBefore=null,s.prototype._tickAfter=null,s.prototype.MAX_ELAPSE=1/0,s.prototype._tick=function(t,i,e){if(this._visible){t>this.MAX_ELAPSE&&(t=this.MAX_ELAPSE);var s=!1;if(null!==this._tickBefore)for(var n=0;n<this._tickBefore.length;n++){o.tick++,s=!0===this._tickBefore[n].call(this,t,i,e)||s}for(var r,h=this._first;r=h;)h=r._next,r._flag("_tick")&&(s=!0===r._tick(t,i,e)||s);if(null!==this._tickAfter)for(n=0;n<this._tickAfter.length;n++){o.tick++,s=!0===this._tickAfter[n].call(this,t,i,e)||s}return s}},s.prototype.tick=function(t,i){"function"==typeof t&&(i?(null===this._tickBefore&&(this._tickBefore=[]),this._tickBefore.push(t)):(null===this._tickAfter&&(this._tickAfter=[]),this._tickAfter.push(t)),this._flag("_tick",null!==this._tickAfter&&this._tickAfter.length>0||null!==this._tickBefore&&this._tickBefore.length>0))},s.prototype.untick=function(t){var i;"function"==typeof t&&(null!==this._tickBefore&&(i=this._tickBefore.indexOf(t))>=0&&this._tickBefore.splice(i,1),null!==this._tickAfter&&(i=this._tickAfter.indexOf(t))>=0&&this._tickAfter.splice(i,1))},s.prototype.timeout=function(t,i){this.setTimeout(t,i)},s.prototype.setTimeout=function(t,i){function e(s){if(!((i-=s)<0))return!0;this.untick(e),t.call(this)}return this.tick(e),e},s.prototype.clearTimeout=function(t){this.untick(t)}},function(t,i,e){t.exports=_;var s=e(6),o=(e(2),e(0)),n=e(40),r=e(42),h=e(8),a=e(11),m=e(17),c={gravity:o.zero(),allowSleep:!0,warmStarting:!0,continuousPhysics:!0,subStepping:!1,blockSolve:!0,velocityIterations:8,positionIterations:3};function _(t){if(!(this instanceof _))return new _(t);t&&o.isValid(t)&&(t={gravity:t}),t=s(t,c),this.m_solver=new r(this),this.m_broadPhase=new n,this.m_contactList=null,this.m_contactCount=0,this.m_bodyList=null,this.m_bodyCount=0,this.m_jointList=null,this.m_jointCount=0,this.m_stepComplete=!0,this.m_allowSleep=t.allowSleep,this.m_gravity=o.clone(t.gravity),this.m_clearForces=!0,this.m_newFixture=!1,this.m_locked=!1,this.m_warmStarting=t.warmStarting,this.m_continuousPhysics=t.continuousPhysics,this.m_subStepping=t.subStepping,this.m_blockSolve=t.blockSolve,this.m_velocityIterations=t.velocityIterations,this.m_positionIterations=t.positionIterations,this.m_t=0,this.addPair=this.createContact.bind(this)}_.prototype._serialize=function(){for(var t=[],i=[],e=this.getBodyList();e;e=e.getNext())t.push(e);for(var s=this.getJointList();s;s=s.getNext())"function"==typeof s._serialize&&i.push(s);return{gravity:this.m_gravity,bodies:t,joints:i}},_._deserialize=function(t,i,e){if(!t)return new _;var s=new _(t.gravity);if(t.bodies)for(var o=t.bodies.length-1;o>=0;o-=1)s._addBody(e(h,t.bodies[o],s));if(t.joints)for(o=t.joints.length-1;o>=0;o--)s.createJoint(e(a,t.joints[o],s));return s},_.prototype.getBodyList=function(){return this.m_bodyList},_.prototype.getJointList=function(){return this.m_jointList},_.prototype.getContactList=function(){return this.m_contactList},_.prototype.getBodyCount=function(){return this.m_bodyCount},_.prototype.getJointCount=function(){return this.m_jointCount},_.prototype.getContactCount=function(){return this.m_contactCount},_.prototype.setGravity=function(t){this.m_gravity=t},_.prototype.getGravity=function(){return this.m_gravity},_.prototype.isLocked=function(){return this.m_locked},_.prototype.setAllowSleeping=function(t){if(t!=this.m_allowSleep&&(this.m_allowSleep=t,0==this.m_allowSleep))for(var i=this.m_bodyList;i;i=i.m_next)i.setAwake(!0)},_.prototype.getAllowSleeping=function(){return this.m_allowSleep},_.prototype.setWarmStarting=function(t){this.m_warmStarting=t},_.prototype.getWarmStarting=function(){return this.m_warmStarting},_.prototype.setContinuousPhysics=function(t){this.m_continuousPhysics=t},_.prototype.getContinuousPhysics=function(){return this.m_continuousPhysics},_.prototype.setSubStepping=function(t){this.m_subStepping=t},_.prototype.getSubStepping=function(){return this.m_subStepping},_.prototype.setAutoClearForces=function(t){this.m_clearForces=t},_.prototype.getAutoClearForces=function(){return this.m_clearForces},_.prototype.clearForces=function(){for(var t=this.m_bodyList;t;t=t.getNext())t.m_force.setZero(),t.m_torque=0},_.prototype.queryAABB=function(t,i){var e=this.m_broadPhase;this.m_broadPhase.query(t,(function(t){var s=e.getUserData(t);return i(s.fixture)}))},_.prototype.rayCast=function(t,i,e){var s=this.m_broadPhase;this.m_broadPhase.rayCast({maxFraction:1,p1:t,p2:i},(function(t,i){var n=s.getUserData(i),r=n.fixture,h=n.childIndex,a={};if(r.rayCast(a,t,h)){var m=a.fraction,c=o.add(o.mul(1-m,t.p1),o.mul(m,t.p2));return e(r,c,a.normal,m)}return t.maxFraction}))},_.prototype.getProxyCount=function(){return this.m_broadPhase.getProxyCount()},_.prototype.getTreeHeight=function(){return this.m_broadPhase.getTreeHeight()},_.prototype.getTreeBalance=function(){return this.m_broadPhase.getTreeBalance()},_.prototype.getTreeQuality=function(){return this.m_broadPhase.getTreeQuality()},_.prototype.shiftOrigin=function(t){if(!this.m_locked){for(var i=this.m_bodyList;i;i=i.m_next)i.m_xf.p.sub(t),i.m_sweep.c0.sub(t),i.m_sweep.c.sub(t);for(var e=this.m_jointList;e;e=e.m_next)e.shiftOrigin(t);this.m_broadPhase.shiftOrigin(t)}},_.prototype._addBody=function(t){this.isLocked()||(t.m_prev=null,t.m_next=this.m_bodyList,this.m_bodyList&&(this.m_bodyList.m_prev=t),this.m_bodyList=t,++this.m_bodyCount)},_.prototype.createBody=function(t,i){if(this.isLocked())return null;t&&o.isValid(t)&&(t={position:t,angle:i});var e=new h(this,t);return this._addBody(e),e},_.prototype.createDynamicBody=function(t,i){return t?o.isValid(t)&&(t={position:t,angle:i}):t={},t.type="dynamic",this.createBody(t)},_.prototype.createKinematicBody=function(t,i){return t?o.isValid(t)&&(t={position:t,angle:i}):t={},t.type="kinematic",this.createBody(t)},_.prototype.destroyBody=function(t){if(!this.isLocked()){if(t.m_destroyed)return!1;for(var i=t.m_jointList;i;){var e=i;i=i.next,this.publish("remove-joint",e.joint),this.destroyJoint(e.joint),t.m_jointList=i}t.m_jointList=null;for(var s=t.m_contactList;s;){var o=s;s=s.next,this.destroyContact(o.contact),t.m_contactList=s}t.m_contactList=null;for(var n=t.m_fixtureList;n;){var r=n;n=n.m_next,this.publish("remove-fixture",r),r.destroyProxies(this.m_broadPhase),t.m_fixtureList=n}return t.m_fixtureList=null,t.m_prev&&(t.m_prev.m_next=t.m_next),t.m_next&&(t.m_next.m_prev=t.m_prev),t==this.m_bodyList&&(this.m_bodyList=t.m_next),t.m_destroyed=!0,--this.m_bodyCount,this.publish("remove-body",t),!0}},_.prototype.createJoint=function(t){if(this.isLocked())return null;if(t.m_prev=null,t.m_next=this.m_jointList,this.m_jointList&&(this.m_jointList.m_prev=t),this.m_jointList=t,++this.m_jointCount,t.m_edgeA.joint=t,t.m_edgeA.other=t.m_bodyB,t.m_edgeA.prev=null,t.m_edgeA.next=t.m_bodyA.m_jointList,t.m_bodyA.m_jointList&&(t.m_bodyA.m_jointList.prev=t.m_edgeA),t.m_bodyA.m_jointList=t.m_edgeA,t.m_edgeB.joint=t,t.m_edgeB.other=t.m_bodyA,t.m_edgeB.prev=null,t.m_edgeB.next=t.m_bodyB.m_jointList,t.m_bodyB.m_jointList&&(t.m_bodyB.m_jointList.prev=t.m_edgeB),t.m_bodyB.m_jointList=t.m_edgeB,0==t.m_collideConnected)for(var i=t.m_bodyB.getContactList();i;i=i.next)i.other==t.m_bodyA&&i.contact.flagForFiltering();return t},_.prototype.destroyJoint=function(t){if(!this.isLocked()){t.m_prev&&(t.m_prev.m_next=t.m_next),t.m_next&&(t.m_next.m_prev=t.m_prev),t==this.m_jointList&&(this.m_jointList=t.m_next);var i=t.m_bodyA,e=t.m_bodyB;if(i.setAwake(!0),e.setAwake(!0),t.m_edgeA.prev&&(t.m_edgeA.prev.next=t.m_edgeA.next),t.m_edgeA.next&&(t.m_edgeA.next.prev=t.m_edgeA.prev),t.m_edgeA==i.m_jointList&&(i.m_jointList=t.m_edgeA.next),t.m_edgeA.prev=null,t.m_edgeA.next=null,t.m_edgeB.prev&&(t.m_edgeB.prev.next=t.m_edgeB.next),t.m_edgeB.next&&(t.m_edgeB.next.prev=t.m_edgeB.prev),t.m_edgeB==e.m_jointList&&(e.m_jointList=t.m_edgeB.next),t.m_edgeB.prev=null,t.m_edgeB.next=null,--this.m_jointCount,0==t.m_collideConnected)for(var s=e.getContactList();s;)s.other==i&&s.contact.flagForFiltering(),s=s.next;this.publish("remove-joint",t)}};var l=new r.TimeStep;_.prototype.step=function(t,i,e){if(this.publish("pre-step",t),(0|i)!==i&&(i=0),i=i||this.m_velocityIterations,e=e||this.m_positionIterations,this.m_newFixture&&(this.findNewContacts(),this.m_newFixture=!1),this.m_locked=!0,l.reset(t),l.velocityIterations=i,l.positionIterations=e,l.warmStarting=this.m_warmStarting,l.blockSolve=this.m_blockSolve,this.updateContacts(),this.m_stepComplete&&t>0){this.m_solver.solveWorld(l);for(var s=this.m_bodyList;s;s=s.getNext())0!=s.m_islandFlag&&(s.isStatic()||s.synchronizeFixtures());this.findNewContacts()}this.m_continuousPhysics&&t>0&&this.m_solver.solveWorldTOI(l),this.m_clearForces&&this.clearForces(),this.m_locked=!1,this.publish("post-step",t)},_.prototype.findNewContacts=function(){this.m_broadPhase.updatePairs(this.addPair)},_.prototype.createContact=function(t,i){var e=t.fixture,s=i.fixture,o=t.childIndex,n=i.childIndex,r=e.getBody(),h=s.getBody();if(r!=h){for(var a=h.getContactList();a;){if(a.other==r){var c=a.contact.getFixtureA(),_=a.contact.getFixtureB(),l=a.contact.getChildIndexA(),u=a.contact.getChildIndexB();if(c==e&&_==s&&l==o&&u==n)return;if(c==s&&_==e&&l==n&&u==o)return}a=a.next}if(0!=h.shouldCollide(r)&&0!=s.shouldCollide(e)){var p=m.create(e,o,s,n);null!=p&&(p.m_prev=null,null!=this.m_contactList&&(p.m_next=this.m_contactList,this.m_contactList.m_prev=p),this.m_contactList=p,++this.m_contactCount)}}},_.prototype.updateContacts=function(){for(var t,i=this.m_contactList;t=i;){i=t.getNext();var e=t.getFixtureA(),s=t.getFixtureB(),o=t.getChildIndexA(),n=t.getChildIndexB(),r=e.getBody(),h=s.getBody();if(t.m_filterFlag){if(0==h.shouldCollide(r)){this.destroyContact(t);continue}if(0==s.shouldCollide(e)){this.destroyContact(t);continue}t.m_filterFlag=!1}var a=r.isAwake()&&!r.isStatic(),m=h.isAwake()&&!h.isStatic();if(0!=a||0!=m){var c=e.m_proxies[o].proxyId,_=s.m_proxies[n].proxyId;0!=this.m_broadPhase.testOverlap(c,_)?t.update(this):this.destroyContact(t)}}},_.prototype.destroyContact=function(t){m.destroy(t,this),t.m_prev&&(t.m_prev.m_next=t.m_next),t.m_next&&(t.m_next.m_prev=t.m_prev),t==this.m_contactList&&(this.m_contactList=t.m_next),--this.m_contactCount},_.prototype._listeners=null,_.prototype.on=function(t,i){return"string"!=typeof t||"function"!=typeof i||(this._listeners||(this._listeners={}),this._listeners[t]||(this._listeners[t]=[]),this._listeners[t].push(i)),this},_.prototype.off=function(t,i){if("string"!=typeof t||"function"!=typeof i)return this;var e=this._listeners&&this._listeners[t];if(!e||!e.length)return this;var s=e.indexOf(i);return s>=0&&e.splice(s,1),this},_.prototype.publish=function(t,i,e,s){var o=this._listeners&&this._listeners[t];if(!o||!o.length)return 0;for(var n=0;n<o.length;n++)o[n].call(this,i,e,s);return o.length},_.prototype.beginContact=function(t){this.publish("begin-contact",t)},_.prototype.endContact=function(t){this.publish("end-contact",t)},_.prototype.preSolve=function(t,i){this.publish("pre-solve",t,i)},_.prototype.postSolve=function(t,i){this.publish("post-solve",t,i)}},function(t,i,e){var s=e(4),o=(e(2),e(41)),n=e(0),r=e(1),h=e(16);function a(t){this.id=t,this.aabb=new h,this.userData=null,this.parent=null,this.child1=null,this.child2=null,this.height=-1,this.toString=function(){return this.id+": "+this.userData}}function m(){this.m_root=null,this.m_nodes={},this.m_lastProxyId=0,this.m_pool=new o({create:function(){return new a}})}t.exports=m,a.prototype.isLeaf=function(){return null==this.child1},m.prototype.getUserData=function(t){var i=this.m_nodes[t];return i.userData},m.prototype.getFatAABB=function(t){var i=this.m_nodes[t];return i.aabb},m.prototype.allocateNode=function(){var t=this.m_pool.allocate();return t.id=++this.m_lastProxyId,t.userData=null,t.parent=null,t.child1=null,t.child2=null,t.height=-1,this.m_nodes[t.id]=t,t},m.prototype.freeNode=function(t){this.m_pool.release(t),t.height=-1,delete this.m_nodes[t.id]},m.prototype.createProxy=function(t,i){var e=this.allocateNode();return e.aabb.set(t),h.extend(e.aabb,s.aabbExtension),e.userData=i,e.height=0,this.insertLeaf(e),e.id},m.prototype.destroyProxy=function(t){var i=this.m_nodes[t];this.removeLeaf(i),this.freeNode(i)},m.prototype.moveProxy=function(t,i,e){var o=this.m_nodes[t];return!o.aabb.contains(i)&&(this.removeLeaf(o),o.aabb.set(i),i=o.aabb,h.extend(i,s.aabbExtension),e.x<0?i.lowerBound.x+=e.x*s.aabbMultiplier:i.upperBound.x+=e.x*s.aabbMultiplier,e.y<0?i.lowerBound.y+=e.y*s.aabbMultiplier:i.upperBound.y+=e.y*s.aabbMultiplier,this.insertLeaf(o),!0)},m.prototype.insertLeaf=function(t){if(null==this.m_root)return this.m_root=t,void(this.m_root.parent=null);for(var i=t.aabb,e=this.m_root;0==e.isLeaf();){var s=e.child1,o=e.child2,n=e.aabb.getPerimeter(),a=new h;a.combine(e.aabb,i);var m,c,_=a.getPerimeter(),l=2*_,u=2*(_-n);if(s.isLeaf()){(y=new h).combine(i,s.aabb),m=y.getPerimeter()+u}else{(y=new h).combine(i,s.aabb);var p=s.aabb.getPerimeter();m=y.getPerimeter()-p+u}if(o.isLeaf()){(y=new h).combine(i,o.aabb),c=y.getPerimeter()+u}else{var y;(y=new h).combine(i,o.aabb);p=o.aabb.getPerimeter();c=y.getPerimeter()-p+u}if(l<m&&l<c)break;e=m<c?s:o}var d=e,f=d.parent,v=this.allocateNode();for(v.parent=f,v.userData=null,v.aabb.combine(i,d.aabb),v.height=d.height+1,null!=f?(f.child1==d?f.child1=v:f.child2=v,v.child1=d,v.child2=t,d.parent=v,t.parent=v):(v.child1=d,v.child2=t,d.parent=v,t.parent=v,this.m_root=v),e=t.parent;null!=e;){s=(e=this.balance(e)).child1,o=e.child2;e.height=1+r.max(s.height,o.height),e.aabb.combine(s.aabb,o.aabb),e=e.parent}},m.prototype.removeLeaf=function(t){if(t!=this.m_root){var i,e=t.parent,s=e.parent;if(i=e.child1==t?e.child2:e.child1,null!=s){s.child1==e?s.child1=i:s.child2=i,i.parent=s,this.freeNode(e);for(var o=s;null!=o;){var n=(o=this.balance(o)).child1,h=o.child2;o.aabb.combine(n.aabb,h.aabb),o.height=1+r.max(n.height,h.height),o=o.parent}}else this.m_root=i,i.parent=null,this.freeNode(e)}else this.m_root=null},m.prototype.balance=function(t){var i=t;if(i.isLeaf()||i.height<2)return t;var e=i.child1,s=i.child2,o=s.height-e.height;if(o>1){var n=s.child1,h=s.child2;return s.child1=i,s.parent=i.parent,i.parent=s,null!=s.parent?s.parent.child1==t?s.parent.child1=s:s.parent.child2=s:this.m_root=s,n.height>h.height?(s.child2=n,i.child2=h,h.parent=i,i.aabb.combine(e.aabb,h.aabb),s.aabb.combine(i.aabb,n.aabb),i.height=1+r.max(e.height,h.height),s.height=1+r.max(i.height,n.height)):(s.child2=h,i.child2=n,n.parent=i,i.aabb.combine(e.aabb,n.aabb),s.aabb.combine(i.aabb,h.aabb),i.height=1+r.max(e.height,n.height),s.height=1+r.max(i.height,h.height)),s}if(o<-1){var a=e.child1,m=e.child2;return e.child1=i,e.parent=i.parent,i.parent=e,null!=e.parent?e.parent.child1==i?e.parent.child1=e:e.parent.child2=e:this.m_root=e,a.height>m.height?(e.child2=a,i.child1=m,m.parent=i,i.aabb.combine(s.aabb,m.aabb),e.aabb.combine(i.aabb,a.aabb),i.height=1+r.max(s.height,m.height),e.height=1+r.max(i.height,a.height)):(e.child2=m,i.child1=a,a.parent=i,i.aabb.combine(s.aabb,a.aabb),e.aabb.combine(i.aabb,m.aabb),i.height=1+r.max(s.height,a.height),e.height=1+r.max(i.height,m.height)),e}return i},m.prototype.getHeight=function(){return null==this.m_root?0:this.m_root.height},m.prototype.getAreaRatio=function(){if(null==this.m_root)return 0;for(var t,i=this.m_root.aabb.getPerimeter(),e=0,s=l.allocate().preorder(this.m_root);t=s.next();)t.height<0||(e+=t.aabb.getPerimeter());return l.release(s),e/i},m.prototype.computeHeight=function(t){var i;if((i=void 0!==t?this.m_nodes[t]:this.m_root).isLeaf())return 0;var e=this.computeHeight(i.child1.id),s=this.computeHeight(i.child2.id);return 1+r.max(e,s)},m.prototype.validateStructure=function(t){if(null!=t){this.m_root;var i=t.child1,e=t.child2;t.isLeaf()||(this.validateStructure(i),this.validateStructure(e))}},m.prototype.validateMetrics=function(t){if(null!=t){var i=t.child1,e=t.child2;if(!t.isLeaf()){var s=i.height,o=e.height,n=(r.max(s,o),new h);n.combine(i.aabb,e.aabb),this.validateMetrics(i),this.validateMetrics(e)}}},m.prototype.validate=function(){this.validateStructure(this.m_root),this.validateMetrics(this.m_root)},m.prototype.getMaxBalance=function(){for(var t,i=0,e=l.allocate().preorder(this.m_root);t=e.next();)if(!(t.height<=1)){var s=r.abs(t.child2.height-t.child1.height);i=r.max(i,s)}return l.release(e),i},m.prototype.rebuildBottomUp=function(){for(var t,i=[],e=0,s=l.allocate().preorder(this.m_root);t=s.next();)t.height<0||(t.isLeaf()?(t.parent=null,i[e]=t,++e):this.freeNode(t));for(l.release(s);e>1;){for(var o=1/0,n=-1,a=-1,m=0;m<e;++m)for(var c=i[m].aabb,_=m+1;_<e;++_){var u=i[_].aabb,p=new h;p.combine(c,u);var y=p.getPerimeter();y<o&&(n=m,a=_,o=y)}var d=i[n],f=i[a],v=this.allocateNode();v.child1=d,v.child2=f,v.height=1+r.max(d.height,f.height),v.aabb.combine(d.aabb,f.aabb),v.parent=null,d.parent=v,f.parent=v,i[a]=i[e-1],i[n]=v,--e}this.m_root=i[0],this.validate()},m.prototype.shiftOrigin=function(t){for(var i,e=l.allocate().preorder(this.m_root);i=e.next();){var s=i.aabb;s.lowerBound.x-=t.x,s.lowerBound.y-=t.y,s.upperBound.x-=t.x,s.upperBound.y-=t.y}l.release(e)},m.prototype.query=function(t,i){var e=_.allocate();for(e.push(this.m_root);e.length>0;){var s=e.pop();if(null!=s)if(h.testOverlap(s.aabb,t))if(s.isLeaf()){if(0==i(s.id))return}else e.push(s.child1),e.push(s.child2)}_.release(e)},m.prototype.rayCast=function(t,i){var e=t.p1,s=t.p2,o=n.sub(s,e);o.normalize();var a=n.cross(1,o),m=n.abs(a),l=t.maxFraction,u=new h,p=n.combine(1-l,e,l,s);u.combinePoints(e,p);var y=_.allocate(),d=c.allocate();for(y.push(this.m_root);y.length>0;){var f=y.pop();if(null!=f&&0!=h.testOverlap(f.aabb,u)){var v=f.aabb.getCenter(),x=f.aabb.getExtents();if(!(r.abs(n.dot(a,n.sub(e,v)))-n.dot(m,x)>0))if(f.isLeaf()){d.p1=n.clone(t.p1),d.p2=n.clone(t.p2),d.maxFraction=l;var g=i(d,f.id);if(0==g)return;g>0&&(l=g,p=n.combine(1-l,e,l,s),u.combinePoints(e,p))}else y.push(f.child1),y.push(f.child2)}}_.release(y),c.release(d)};var c=new o({create:function(){return{}},release:function(t){}}),_=new o({create:function(){return[]},release:function(t){t.length=0}}),l=new o({create:function(){return new u},release:function(t){t.close()}});function u(){var t=[],i=[];return{preorder:function(e){return t.length=0,t.push(e),i.length=0,i.push(0),this},next:function(){for(;t.length>0;){var e=t.length-1,s=t[e];if(0===i[e])return i[e]=1,s;if(1===i[e]&&(i[e]=2,s.child1))return t.push(s.child1),i.push(1),s.child1;if(2===i[e]&&(i[e]=3,s.child2))return t.push(s.child2),i.push(1),s.child2;t.pop(),i.pop()}},close:function(){t.length=0}}}},function(t,i,e){t.exports=function(t,i){var e=o.now();++n.toiCalls,t.state=d.e_unknown,t.t=i.tMax;var h=i.proxyA,a=i.proxyB,m=i.sweepA,p=i.sweepB;m.normalize(),p.normalize();var v=i.tMax,x=h.m_radius+a.m_radius,g=r.max(s.linearSlop,x-3*s.linearSlop),b=.25*s.linearSlop;var A=0,B=s.maxTOIIterations,w=0,C=new y,M=new l;for(M.proxyA=i.proxyA,M.proxyB=i.proxyB,M.useRadii=!1;;){var I=c.identity(),S=c.identity();m.getTransform(I,A),p.getTransform(S,A),M.transformA=I,M.transformB=S;var P=new u;if(_(P,C,M),P.distance<=0){t.state=d.e_overlapped,t.t=0;break}if(P.distance<g+b){t.state=d.e_touching,t.t=A;break}var z=new f;z.initialize(C,h,m,a,p,A);for(var T=!1,V=v,k=0;;){var L=z.findMinSeparation(V);z.indexA,z.indexB;if(L>g+b){t.state=d.e_separated,t.t=v,T=!0;break}if(L>g-b){A=V;break}var q=z.evaluate(A);z.indexA,z.indexB;if(q<g-b){t.state=d.e_failed,t.t=A,T=!0;break}if(q<=g+b){t.state=d.e_touching,t.t=A,T=!0;break}for(var F=0,j=A,E=V;;){var Y;Y=1&F?j+(g-q)*(E-j)/(L-q):.5*(j+E),++F,++n.toiRootIters;var D=z.evaluate(Y);z.indexA,z.indexB;if(r.abs(D-g)<b){V=Y;break}if(D>g?(j=Y,q=D):(E=Y,L=D),50==F)break}if(n.toiMaxRootIters=r.max(n.toiMaxRootIters,F),++k==s.maxPolygonVertices)break}if(++w,++n.toiIters,T)break;if(w==B){t.state=d.e_failed,t.t=A;break}}n.toiMaxIters=r.max(n.toiMaxIters,w);var R=o.diff(e);n.toiMaxTime=r.max(n.toiMaxTime,R),n.toiTime+=R},t.exports.Input=function(){this.proxyA=new p,this.proxyB=new p,this.sweepA=new m,this.sweepB=new m,this.tMax},t.exports.Output=d;var s=e(4),o=(e(2),e(43)),n=e(27),r=e(1),h=e(0),a=(e(7),e(10),e(14),e(3)),m=e(9),c=e(5),_=(e(12),e(13),e(21)),l=_.Input,u=_.Output,p=_.Proxy,y=_.Cache;function d(){this.state,this.t}d.e_unknown=0,d.e_failed=1,d.e_overlapped=2,d.e_touching=3,d.e_separated=4,n.toiTime=0,n.toiMaxTime=0,n.toiCalls=0,n.toiIters=0,n.toiMaxIters=0,n.toiRootIters=0,n.toiMaxRootIters=0;function f(){this.m_proxyA=new p,this.m_proxyB=new p,this.m_sweepA,this.m_sweepB,this.indexA,this.indexB,this.m_type,this.m_localPoint=h.zero(),this.m_axis=h.zero()}f.prototype.initialize=function(t,i,e,s,o,n){this.m_proxyA=i,this.m_proxyB=s;var r=t.count;this.m_sweepA=e,this.m_sweepB=o;var m=c.identity(),_=c.identity();if(this.m_sweepA.getTransform(m,n),this.m_sweepB.getTransform(_,n),1==r){this.m_type=1;var l=this.m_proxyA.getVertex(t.indexA[0]),u=this.m_proxyB.getVertex(t.indexB[0]),p=c.mulVec2(m,l),y=c.mulVec2(_,u);return this.m_axis.setCombine(1,y,-1,p),b=this.m_axis.normalize()}if(t.indexA[0]==t.indexA[1]){this.m_type=3;var d=s.getVertex(t.indexB[0]),f=s.getVertex(t.indexB[1]);this.m_axis=h.cross(h.sub(f,d),1),this.m_axis.normalize();var v=a.mulVec2(_.q,this.m_axis);this.m_localPoint=h.mid(d,f);y=c.mulVec2(_,this.m_localPoint),l=i.getVertex(t.indexA[0]),p=c.mulVec2(m,l);return(b=h.dot(p,v)-h.dot(y,v))<0&&(this.m_axis=h.neg(this.m_axis),b=-b),b}this.m_type=2;var x=this.m_proxyA.getVertex(t.indexA[0]),g=this.m_proxyA.getVertex(t.indexA[1]);this.m_axis=h.cross(h.sub(g,x),1),this.m_axis.normalize();v=a.mulVec2(m.q,this.m_axis);this.m_localPoint=h.mid(x,g);var b;p=c.mulVec2(m,this.m_localPoint),u=this.m_proxyB.getVertex(t.indexB[0]),y=c.mulVec2(_,u);return(b=h.dot(y,v)-h.dot(p,v))<0&&(this.m_axis=h.neg(this.m_axis),b=-b),b},f.prototype.compute=function(t,i){var e=c.identity(),s=c.identity();switch(this.m_sweepA.getTransform(e,i),this.m_sweepB.getTransform(s,i),this.m_type){case 1:if(t){var o=a.mulTVec2(e.q,this.m_axis),n=a.mulTVec2(s.q,h.neg(this.m_axis));this.indexA=this.m_proxyA.getSupport(o),this.indexB=this.m_proxyB.getSupport(n)}var r=this.m_proxyA.getVertex(this.indexA),m=this.m_proxyB.getVertex(this.indexB),_=c.mulVec2(e,r),l=c.mulVec2(s,m);return h.dot(l,this.m_axis)-h.dot(_,this.m_axis);case 2:var u=a.mulVec2(e.q,this.m_axis);_=c.mulVec2(e,this.m_localPoint);if(t){n=a.mulTVec2(s.q,h.neg(u));this.indexA=-1,this.indexB=this.m_proxyB.getSupport(n)}m=this.m_proxyB.getVertex(this.indexB),l=c.mulVec2(s,m);return h.dot(l,u)-h.dot(_,u);case 3:u=a.mulVec2(s.q,this.m_axis),l=c.mulVec2(s,this.m_localPoint);if(t){o=a.mulTVec2(e.q,h.neg(u));this.indexB=-1,this.indexA=this.m_proxyA.getSupport(o)}r=this.m_proxyA.getVertex(this.indexA),_=c.mulVec2(e,r);return h.dot(_,u)-h.dot(l,u);default:return t&&(this.indexA=-1,this.indexB=-1),0}},f.prototype.findMinSeparation=function(t){return this.compute(!0,t)},f.prototype.evaluate=function(t){return this.compute(!1,t)}},function(t,i,e){t.exports=p;e(2);var s=e(6),o=e(4),n=e(1),r=e(0),h=e(7),a=e(10),m=e(14),c=e(3),_=(e(9),e(5),e(12),e(13),e(11)),l=e(8);p.TYPE="revolute-joint",_.TYPES[p.TYPE]=p,p._super=_,p.prototype=Object.create(p._super.prototype);var u={lowerAngle:0,upperAngle:0,maxMotorTorque:0,motorSpeed:0,enableLimit:!1,enableMotor:!1};function p(t,i,e,o){if(!(this instanceof p))return new p(t,i,e,o);t=s(t,u),_.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=p.TYPE,this.m_localAnchorA=r.clone(o?i.getLocalPoint(o):t.localAnchorA||r.zero()),this.m_localAnchorB=r.clone(o?e.getLocalPoint(o):t.localAnchorB||r.zero()),this.m_referenceAngle=n.isFinite(t.referenceAngle)?t.referenceAngle:e.getAngle()-i.getAngle(),this.m_impulse=h(),this.m_motorImpulse=0,this.m_lowerAngle=t.lowerAngle,this.m_upperAngle=t.upperAngle,this.m_maxMotorTorque=t.maxMotorTorque,this.m_motorSpeed=t.motorSpeed,this.m_enableLimit=t.enableLimit,this.m_enableMotor=t.enableMotor,this.m_rA,this.m_rB,this.m_localCenterA,this.m_localCenterB,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_mass=new m,this.m_motorMass,this.m_limitState=0}p.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,lowerAngle:this.m_lowerAngle,upperAngle:this.m_upperAngle,maxMotorTorque:this.m_maxMotorTorque,motorSpeed:this.m_motorSpeed,enableLimit:this.m_enableLimit,enableMotor:this.m_enableMotor,localAnchorA:this.m_localAnchorA,localAnchorB:this.m_localAnchorB,referenceAngle:this.m_referenceAngle}},p._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(l,t.bodyA,i),t.bodyB=e(l,t.bodyB,i),new p(t)},p.prototype._setAnchors=function(t){t.anchorA?this.m_localAnchorA.set(this.m_bodyA.getLocalPoint(t.anchorA)):t.localAnchorA&&this.m_localAnchorA.set(t.localAnchorA),t.anchorB?this.m_localAnchorB.set(this.m_bodyB.getLocalPoint(t.anchorB)):t.localAnchorB&&this.m_localAnchorB.set(t.localAnchorB)},p.prototype.getLocalAnchorA=function(){return this.m_localAnchorA},p.prototype.getLocalAnchorB=function(){return this.m_localAnchorB},p.prototype.getReferenceAngle=function(){return this.m_referenceAngle},p.prototype.getJointAngle=function(){var t=this.m_bodyA;return this.m_bodyB.m_sweep.a-t.m_sweep.a-this.m_referenceAngle},p.prototype.getJointSpeed=function(){var t=this.m_bodyA;return this.m_bodyB.m_angularVelocity-t.m_angularVelocity},p.prototype.isMotorEnabled=function(){return this.m_enableMotor},p.prototype.enableMotor=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_enableMotor=t},p.prototype.getMotorTorque=function(t){return t*this.m_motorImpulse},p.prototype.setMotorSpeed=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_motorSpeed=t},p.prototype.getMotorSpeed=function(){return this.m_motorSpeed},p.prototype.setMaxMotorTorque=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_maxMotorTorque=t},p.prototype.getMaxMotorTorque=function(){return this.m_maxMotorTorque},p.prototype.isLimitEnabled=function(){return this.m_enableLimit},p.prototype.enableLimit=function(t){t!=this.m_enableLimit&&(this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_enableLimit=t,this.m_impulse.z=0)},p.prototype.getLowerLimit=function(){return this.m_lowerAngle},p.prototype.getUpperLimit=function(){return this.m_upperAngle},p.prototype.setLimits=function(t,i){t==this.m_lowerAngle&&i==this.m_upperAngle||(this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_impulse.z=0,this.m_lowerAngle=t,this.m_upperAngle=i)},p.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},p.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},p.prototype.getReactionForce=function(t){return r.neo(this.m_impulse.x,this.m_impulse.y).mul(t)},p.prototype.getReactionTorque=function(t){return t*this.m_impulse.z},p.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyA.c_position.a,e=this.m_bodyA.c_velocity.v,s=this.m_bodyA.c_velocity.w,h=this.m_bodyB.c_position.a,a=this.m_bodyB.c_velocity.v,m=this.m_bodyB.c_velocity.w,_=c.neo(i),l=c.neo(h);this.m_rA=c.mulVec2(_,r.sub(this.m_localAnchorA,this.m_localCenterA)),this.m_rB=c.mulVec2(l,r.sub(this.m_localAnchorB,this.m_localCenterB));var u=this.m_invMassA,p=this.m_invMassB,y=this.m_invIA,d=this.m_invIB,f=y+d===0;if(this.m_mass.ex.x=u+p+this.m_rA.y*this.m_rA.y*y+this.m_rB.y*this.m_rB.y*d,this.m_mass.ey.x=-this.m_rA.y*this.m_rA.x*y-this.m_rB.y*this.m_rB.x*d,this.m_mass.ez.x=-this.m_rA.y*y-this.m_rB.y*d,this.m_mass.ex.y=this.m_mass.ey.x,this.m_mass.ey.y=u+p+this.m_rA.x*this.m_rA.x*y+this.m_rB.x*this.m_rB.x*d,this.m_mass.ez.y=this.m_rA.x*y+this.m_rB.x*d,this.m_mass.ex.z=this.m_mass.ez.x,this.m_mass.ey.z=this.m_mass.ez.y,this.m_mass.ez.z=y+d,this.m_motorMass=y+d,this.m_motorMass>0&&(this.m_motorMass=1/this.m_motorMass),(0==this.m_enableMotor||f)&&(this.m_motorImpulse=0),this.m_enableLimit&&0==f){var v=h-i-this.m_referenceAngle;n.abs(this.m_upperAngle-this.m_lowerAngle)<2*o.angularSlop?this.m_limitState=3:v<=this.m_lowerAngle?(1!=this.m_limitState&&(this.m_impulse.z=0),this.m_limitState=1):v>=this.m_upperAngle?(2!=this.m_limitState&&(this.m_impulse.z=0),this.m_limitState=2):(this.m_limitState=0,this.m_impulse.z=0)}else this.m_limitState=0;if(t.warmStarting){this.m_impulse.mul(t.dtRatio),this.m_motorImpulse*=t.dtRatio;var x=r.neo(this.m_impulse.x,this.m_impulse.y);e.subMul(u,x),s-=y*(r.cross(this.m_rA,x)+this.m_motorImpulse+this.m_impulse.z),a.addMul(p,x),m+=d*(r.cross(this.m_rB,x)+this.m_motorImpulse+this.m_impulse.z)}else this.m_impulse.setZero(),this.m_motorImpulse=0;this.m_bodyA.c_velocity.v=e,this.m_bodyA.c_velocity.w=s,this.m_bodyB.c_velocity.v=a,this.m_bodyB.c_velocity.w=m},p.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,o=this.m_bodyB.c_velocity.w,a=this.m_invMassA,m=this.m_invMassB,c=this.m_invIA,_=this.m_invIB,l=c+_===0;if(this.m_enableMotor&&3!=this.m_limitState&&0==l){var u=o-e-this.m_motorSpeed,p=-this.m_motorMass*u,y=this.m_motorImpulse,d=t.dt*this.m_maxMotorTorque;this.m_motorImpulse=n.clamp(this.m_motorImpulse+p,-d,d),e-=c*(p=this.m_motorImpulse-y),o+=_*p}if(this.m_enableLimit&&0!=this.m_limitState&&0==l){var f=r.zero();f.addCombine(1,s,1,r.cross(o,this.m_rB)),f.subCombine(1,i,1,r.cross(e,this.m_rA));var v=o-e;u=h(f.x,f.y,v),p=h.neg(this.m_mass.solve33(u));if(3==this.m_limitState)this.m_impulse.add(p);else if(1==this.m_limitState){if(this.m_impulse.z+p.z<0){var x=r.combine(-1,f,this.m_impulse.z,r.neo(this.m_mass.ez.x,this.m_mass.ez.y)),g=this.m_mass.solve22(x);p.x=g.x,p.y=g.y,p.z=-this.m_impulse.z,this.m_impulse.x+=g.x,this.m_impulse.y+=g.y,this.m_impulse.z=0}else this.m_impulse.add(p)}else if(2==this.m_limitState){if(this.m_impulse.z+p.z>0){x=r.combine(-1,f,this.m_impulse.z,r.neo(this.m_mass.ez.x,this.m_mass.ez.y)),g=this.m_mass.solve22(x);p.x=g.x,p.y=g.y,p.z=-this.m_impulse.z,this.m_impulse.x+=g.x,this.m_impulse.y+=g.y,this.m_impulse.z=0}else this.m_impulse.add(p)}var b=r.neo(p.x,p.y);i.subMul(a,b),e-=c*(r.cross(this.m_rA,b)+p.z),s.addMul(m,b),o+=_*(r.cross(this.m_rB,b)+p.z)}else{(u=r.zero()).addCombine(1,s,1,r.cross(o,this.m_rB)),u.subCombine(1,i,1,r.cross(e,this.m_rA));p=this.m_mass.solve22(r.neg(u));this.m_impulse.x+=p.x,this.m_impulse.y+=p.y,i.subMul(a,p),e-=c*r.cross(this.m_rA,p),s.addMul(m,p),o+=_*r.cross(this.m_rB,p)}this.m_bodyA.c_velocity.v=i,this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v=s,this.m_bodyB.c_velocity.w=o},p.prototype.solvePositionConstraints=function(t){var i,e=this.m_bodyA.c_position.c,s=this.m_bodyA.c_position.a,h=this.m_bodyB.c_position.c,m=this.m_bodyB.c_position.a,_=c.neo(s),l=c.neo(m),u=0,p=this.m_invIA+this.m_invIB==0;if(this.m_enableLimit&&0!=this.m_limitState&&0==p){var y=m-s-this.m_referenceAngle,d=0;if(3==this.m_limitState){var f=n.clamp(y-this.m_lowerAngle,-o.maxAngularCorrection,o.maxAngularCorrection);d=-this.m_motorMass*f,u=n.abs(f)}else if(1==this.m_limitState){u=-(f=y-this.m_lowerAngle),f=n.clamp(f+o.angularSlop,-o.maxAngularCorrection,0),d=-this.m_motorMass*f}else if(2==this.m_limitState){u=f=y-this.m_upperAngle,f=n.clamp(f-o.angularSlop,0,o.maxAngularCorrection),d=-this.m_motorMass*f}s-=this.m_invIA*d,m+=this.m_invIB*d}_.set(s),l.set(m);var v=c.mulVec2(_,r.sub(this.m_localAnchorA,this.m_localCenterA)),x=c.mulVec2(l,r.sub(this.m_localAnchorB,this.m_localCenterB));(f=r.zero()).addCombine(1,h,1,x),f.subCombine(1,e,1,v),i=f.length();var g=this.m_invMassA,b=this.m_invMassB,A=this.m_invIA,B=this.m_invIB,w=new a;w.ex.x=g+b+A*v.y*v.y+B*x.y*x.y,w.ex.y=-A*v.x*v.y-B*x.x*x.y,w.ey.x=w.ex.y,w.ey.y=g+b+A*v.x*v.x+B*x.x*x.x;var C=r.neg(w.solve(f));return e.subMul(g,C),s-=A*r.cross(v,C),h.addMul(b,C),m+=B*r.cross(x,C),this.m_bodyA.c_position.c.set(e),this.m_bodyA.c_position.a=s,this.m_bodyB.c_position.c.set(h),this.m_bodyB.c_position.a=m,i<=o.linearSlop&&u<=o.angularSlop}},function(t,i,e){t.exports=p;e(2);var s=e(6),o=e(4),n=e(1),r=e(0),h=e(7),a=e(10),m=e(14),c=e(3),_=(e(9),e(5),e(12),e(13),e(11)),l=e(8);p.TYPE="prismatic-joint",_.TYPES[p.TYPE]=p,p._super=_,p.prototype=Object.create(p._super.prototype);var u={enableLimit:!1,lowerTranslation:0,upperTranslation:0,enableMotor:!1,maxMotorForce:0,motorSpeed:0};function p(t,i,e,o,a){if(!(this instanceof p))return new p(t,i,e,o,a);t=s(t,u),_.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=p.TYPE,this.m_localAnchorA=r.clone(o?i.getLocalPoint(o):t.localAnchorA||r.zero()),this.m_localAnchorB=r.clone(o?e.getLocalPoint(o):t.localAnchorB||r.zero()),this.m_localXAxisA=r.clone(a?i.getLocalVector(a):t.localAxisA||r.neo(1,0)),this.m_localXAxisA.normalize(),this.m_localYAxisA=r.cross(1,this.m_localXAxisA),this.m_referenceAngle=n.isFinite(t.referenceAngle)?t.referenceAngle:e.getAngle()-i.getAngle(),this.m_impulse=h(),this.m_motorMass=0,this.m_motorImpulse=0,this.m_lowerTranslation=t.lowerTranslation,this.m_upperTranslation=t.upperTranslation,this.m_maxMotorForce=t.maxMotorForce,this.m_motorSpeed=t.motorSpeed,this.m_enableLimit=t.enableLimit,this.m_enableMotor=t.enableMotor,this.m_limitState=0,this.m_axis=r.zero(),this.m_perp=r.zero(),this.m_localCenterA,this.m_localCenterB,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_axis,this.m_perp,this.m_s1,this.m_s2,this.m_a1,this.m_a2,this.m_K=new m,this.m_motorMass}p.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,lowerTranslation:this.m_lowerTranslation,upperTranslation:this.m_upperTranslation,maxMotorForce:this.m_maxMotorForce,motorSpeed:this.m_motorSpeed,enableLimit:this.m_enableLimit,enableMotor:this.m_enableMotor,localAnchorA:this.m_localAnchorA,localAnchorB:this.m_localAnchorB,localAxisA:this.m_localXAxisA,referenceAngle:this.m_referenceAngle}},p._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(l,t.bodyA,i),t.bodyB=e(l,t.bodyB,i),t.localAxisA=r(t.localAxisA),new p(t)},p.prototype._setAnchors=function(t){t.anchorA?this.m_localAnchorA.set(this.m_bodyA.getLocalPoint(t.anchorA)):t.localAnchorA&&this.m_localAnchorA.set(t.localAnchorA),t.anchorB?this.m_localAnchorB.set(this.m_bodyB.getLocalPoint(t.anchorB)):t.localAnchorB&&this.m_localAnchorB.set(t.localAnchorB),t.localAxisA&&(this.m_localXAxisA.set(t.localAxisA),this.m_localYAxisA.set(r.cross(1,t.localAxisA)))},p.prototype.getLocalAnchorA=function(){return this.m_localAnchorA},p.prototype.getLocalAnchorB=function(){return this.m_localAnchorB},p.prototype.getLocalAxisA=function(){return this.m_localXAxisA},p.prototype.getReferenceAngle=function(){return this.m_referenceAngle},p.prototype.getJointTranslation=function(){var t=this.m_bodyA.getWorldPoint(this.m_localAnchorA),i=this.m_bodyB.getWorldPoint(this.m_localAnchorB),e=r.sub(i,t),s=this.m_bodyA.getWorldVector(this.m_localXAxisA);return r.dot(e,s)},p.prototype.getJointSpeed=function(){var t=this.m_bodyA,i=this.m_bodyB,e=c.mulVec2(t.m_xf.q,r.sub(this.m_localAnchorA,t.m_sweep.localCenter)),s=c.mulVec2(i.m_xf.q,r.sub(this.m_localAnchorB,i.m_sweep.localCenter)),o=r.add(t.m_sweep.c,e),n=r.add(i.m_sweep.c,s),h=r.sub(n,o),a=c.mulVec2(t.m_xf.q,this.m_localXAxisA),m=t.m_linearVelocity,_=i.m_linearVelocity,l=t.m_angularVelocity,u=i.m_angularVelocity;return r.dot(h,r.cross(l,a))+r.dot(a,r.sub(r.addCross(_,u,s),r.addCross(m,l,e)))},p.prototype.isLimitEnabled=function(){return this.m_enableLimit},p.prototype.enableLimit=function(t){t!=this.m_enableLimit&&(this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_enableLimit=t,this.m_impulse.z=0)},p.prototype.getLowerLimit=function(){return this.m_lowerTranslation},p.prototype.getUpperLimit=function(){return this.m_upperTranslation},p.prototype.setLimits=function(t,i){t==this.m_lowerTranslation&&i==this.m_upperTranslation||(this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_lowerTranslation=t,this.m_upperTranslation=i,this.m_impulse.z=0)},p.prototype.isMotorEnabled=function(){return this.m_enableMotor},p.prototype.enableMotor=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_enableMotor=t},p.prototype.setMotorSpeed=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_motorSpeed=t},p.prototype.setMaxMotorForce=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_maxMotorForce=t},p.prototype.getMaxMotorForce=function(){return this.m_maxMotorForce},p.prototype.getMotorSpeed=function(){return this.m_motorSpeed},p.prototype.getMotorForce=function(t){return t*this.m_motorImpulse},p.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},p.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},p.prototype.getReactionForce=function(t){return r.combine(this.m_impulse.x,this.m_perp,this.m_motorImpulse+this.m_impulse.z,this.m_axis).mul(t)},p.prototype.getReactionTorque=function(t){return t*this.m_impulse.y},p.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyA.c_velocity.v,h=this.m_bodyA.c_velocity.w,a=this.m_bodyB.c_position.c,m=this.m_bodyB.c_position.a,_=this.m_bodyB.c_velocity.v,l=this.m_bodyB.c_velocity.w,u=c.neo(e),p=c.neo(m),y=c.mulVec2(u,r.sub(this.m_localAnchorA,this.m_localCenterA)),d=c.mulVec2(p,r.sub(this.m_localAnchorB,this.m_localCenterB)),f=r.zero();f.addCombine(1,a,1,d),f.subCombine(1,i,1,y);var v=this.m_invMassA,x=this.m_invMassB,g=this.m_invIA,b=this.m_invIB;this.m_axis=c.mulVec2(u,this.m_localXAxisA),this.m_a1=r.cross(r.add(f,y),this.m_axis),this.m_a2=r.cross(d,this.m_axis),this.m_motorMass=v+x+g*this.m_a1*this.m_a1+b*this.m_a2*this.m_a2,this.m_motorMass>0&&(this.m_motorMass=1/this.m_motorMass),this.m_perp=c.mulVec2(u,this.m_localYAxisA),this.m_s1=r.cross(r.add(f,y),this.m_perp),this.m_s2=r.cross(d,this.m_perp);r.cross(y,this.m_perp);var A=v+x+g*this.m_s1*this.m_s1+b*this.m_s2*this.m_s2,B=g*this.m_s1+b*this.m_s2,w=g*this.m_s1*this.m_a1+b*this.m_s2*this.m_a2,C=g+b;0==C&&(C=1);var M=g*this.m_a1+b*this.m_a2,I=v+x+g*this.m_a1*this.m_a1+b*this.m_a2*this.m_a2;if(this.m_K.ex.set(A,B,w),this.m_K.ey.set(B,C,M),this.m_K.ez.set(w,M,I),this.m_enableLimit){var S=r.dot(this.m_axis,f);n.abs(this.m_upperTranslation-this.m_lowerTranslation)<2*o.linearSlop?this.m_limitState=3:S<=this.m_lowerTranslation?1!=this.m_limitState&&(this.m_limitState=1,this.m_impulse.z=0):S>=this.m_upperTranslation?2!=this.m_limitState&&(this.m_limitState=2,this.m_impulse.z=0):(this.m_limitState=0,this.m_impulse.z=0)}else this.m_limitState=0,this.m_impulse.z=0;if(0==this.m_enableMotor&&(this.m_motorImpulse=0),t.warmStarting){this.m_impulse.mul(t.dtRatio),this.m_motorImpulse*=t.dtRatio;var P=r.combine(this.m_impulse.x,this.m_perp,this.m_motorImpulse+this.m_impulse.z,this.m_axis),z=this.m_impulse.x*this.m_s1+this.m_impulse.y+(this.m_motorImpulse+this.m_impulse.z)*this.m_a1,T=this.m_impulse.x*this.m_s2+this.m_impulse.y+(this.m_motorImpulse+this.m_impulse.z)*this.m_a2;s.subMul(v,P),h-=g*z,_.addMul(x,P),l+=b*T}else this.m_impulse.setZero(),this.m_motorImpulse=0;this.m_bodyA.c_velocity.v.set(s),this.m_bodyA.c_velocity.w=h,this.m_bodyB.c_velocity.v.set(_),this.m_bodyB.c_velocity.w=l},p.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,o=this.m_bodyB.c_velocity.w,a=this.m_invMassA,m=this.m_invMassB,c=this.m_invIA,_=this.m_invIB;if(this.m_enableMotor&&3!=this.m_limitState){var l=r.dot(this.m_axis,r.sub(s,i))+this.m_a2*o-this.m_a1*e,u=this.m_motorMass*(this.m_motorSpeed-l),p=this.m_motorImpulse,y=t.dt*this.m_maxMotorForce;this.m_motorImpulse=n.clamp(this.m_motorImpulse+u,-y,y),u=this.m_motorImpulse-p;var d=r.mul(u,this.m_axis),f=u*this.m_a1,v=u*this.m_a2;i.subMul(a,d),e-=c*f,s.addMul(m,d),o+=_*v}var x=r.zero();if(x.x+=r.dot(this.m_perp,s)+this.m_s2*o,x.x-=r.dot(this.m_perp,i)+this.m_s1*e,x.y=o-e,this.m_enableLimit&&0!=this.m_limitState){var g=0;g+=r.dot(this.m_axis,s)+this.m_a2*o,g-=r.dot(this.m_axis,i)+this.m_a1*e;l=h(x.x,x.y,g);var b=h(this.m_impulse),A=this.m_K.solve33(h.neg(l));this.m_impulse.add(A),1==this.m_limitState?this.m_impulse.z=n.max(this.m_impulse.z,0):2==this.m_limitState&&(this.m_impulse.z=n.min(this.m_impulse.z,0));var B=r.combine(-1,x,-(this.m_impulse.z-b.z),r.neo(this.m_K.ez.x,this.m_K.ez.y)),w=r.add(this.m_K.solve22(B),r.neo(b.x,b.y));this.m_impulse.x=w.x,this.m_impulse.y=w.y,A=h.sub(this.m_impulse,b);d=r.combine(A.x,this.m_perp,A.z,this.m_axis),f=A.x*this.m_s1+A.y+A.z*this.m_a1,v=A.x*this.m_s2+A.y+A.z*this.m_a2;i.subMul(a,d),e-=c*f,s.addMul(m,d),o+=_*v}else{A=this.m_K.solve22(r.neg(x));this.m_impulse.x+=A.x,this.m_impulse.y+=A.y;d=r.mul(A.x,this.m_perp),f=A.x*this.m_s1+A.y,v=A.x*this.m_s2+A.y;i.subMul(a,d),e-=c*f,s.addMul(m,d),o+=_*v}this.m_bodyA.c_velocity.v=i,this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v=s,this.m_bodyB.c_velocity.w=o},p.prototype.solvePositionConstraints=function(t){var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyB.c_position.c,_=this.m_bodyB.c_position.a,l=c.neo(e),u=c.neo(_),p=this.m_invMassA,y=this.m_invMassB,d=this.m_invIA,f=this.m_invIB,v=c.mulVec2(l,r.sub(this.m_localAnchorA,this.m_localCenterA)),x=c.mulVec2(u,r.sub(this.m_localAnchorB,this.m_localCenterB)),g=r.sub(r.add(s,x),r.add(i,v)),b=c.mulVec2(l,this.m_localXAxisA),A=r.cross(r.add(g,v),b),B=r.cross(x,b),w=c.mulVec2(l,this.m_localYAxisA),C=r.cross(r.add(g,v),w),M=r.cross(x,w),I=h(),S=r.zero();S.x=r.dot(w,g),S.y=_-e-this.m_referenceAngle;var P=n.abs(S.x),z=n.abs(S.y),T=o.linearSlop,V=o.maxLinearCorrection,k=!1,L=0;if(this.m_enableLimit){var q=r.dot(b,g);n.abs(this.m_upperTranslation-this.m_lowerTranslation)<2*T?(L=n.clamp(q,-V,V),P=n.max(P,n.abs(q)),k=!0):q<=this.m_lowerTranslation?(L=n.clamp(q-this.m_lowerTranslation+T,-V,0),P=n.max(P,this.m_lowerTranslation-q),k=!0):q>=this.m_upperTranslation&&(L=n.clamp(q-this.m_upperTranslation-T,0,V),P=n.max(P,q-this.m_upperTranslation),k=!0)}if(k){var F=p+y+d*C*C+f*M*M,j=d*C+f*M,E=d*C*A+f*M*B;0==(O=d+f)&&(O=1);var Y=d*A+f*B,D=p+y+d*A*A+f*B*B;(J=new m).ex.set(F,j,E),J.ey.set(j,O,Y),J.ez.set(E,Y,D);var R=h();R.x=S.x,R.y=S.y,R.z=L,I=J.solve33(h.neg(R))}else{var O,J;F=p+y+d*C*C+f*M*M,j=d*C+f*M;0==(O=d+f)&&(O=1),(J=new a).ex.set(F,j),J.ey.set(j,O);var W=J.solve(r.neg(S));I.x=W.x,I.y=W.y,I.z=0}var X=r.combine(I.x,w,I.z,b),N=I.x*C+I.y+I.z*A,H=I.x*M+I.y+I.z*B;return i.subMul(p,X),e-=d*N,s.addMul(y,X),_+=f*H,this.m_bodyA.c_position.c=i,this.m_bodyA.c_position.a=e,this.m_bodyB.c_position.c=s,this.m_bodyB.c_position.a=_,P<=o.linearSlop&&z<=o.angularSlop}},function(t,i){t.exports={}},function(t,i){t.exports=function(t){for(var i=1;i<arguments.length;i++){var e=arguments[i];for(var s in e)e.hasOwnProperty(s)&&(t[s]=e[s])}return t}},function(t,i){
/**
 * ! is the definitive JavaScript type testing library
 * 
 * @copyright 2013-2014 Enrico Marino / Jordan Harband
 * @license MIT
 */
var e=Object.prototype,s=e.hasOwnProperty,o=e.toString,n=/^[A-Fa-f0-9]+$/,r=t.exports={};r.a=r.an=r.type=function(t,i){return typeof t===i},r.defined=function(t){return void 0!==t},r.empty=function(t){var i,e=o.call(t);if("[object Array]"===e||"[object Arguments]"===e||"[object String]"===e)return 0===t.length;if("[object Object]"===e){for(i in t)if(s.call(t,i))return!1;return!0}return!t},r.equal=function(t,i){if(t===i)return!0;var e,s=o.call(t);if(s!==o.call(i))return!1;if("[object Object]"===s){for(e in t)if(!r.equal(t[e],i[e])||!(e in i))return!1;for(e in i)if(!r.equal(t[e],i[e])||!(e in t))return!1;return!0}if("[object Array]"===s){if((e=t.length)!==i.length)return!1;for(;--e;)if(!r.equal(t[e],i[e]))return!1;return!0}return"[object Function]"===s?t.prototype===i.prototype:"[object Date]"===s&&t.getTime()===i.getTime()},r.instance=function(t,i){return t instanceof i},r.nil=function(t){return null===t},r.undef=function(t){return void 0===t},r.array=function(t){return"[object Array]"===o.call(t)},r.emptyarray=function(t){return r.array(t)&&0===t.length},r.arraylike=function(t){return!!t&&!r.boolean(t)&&s.call(t,"length")&&isFinite(t.length)&&r.number(t.length)&&t.length>=0},r.boolean=function(t){return"[object Boolean]"===o.call(t)},r.element=function(t){return void 0!==t&&"undefined"!=typeof HTMLElement&&t instanceof HTMLElement&&1===t.nodeType},r.fn=function(t){return"[object Function]"===o.call(t)},r.number=function(t){return"[object Number]"===o.call(t)},r.nan=function(t){return!r.number(t)||t!=t},r.object=function(t){return"[object Object]"===o.call(t)},r.hash=function(t){return r.object(t)&&t.constructor===Object&&!t.nodeType&&!t.setInterval},r.regexp=function(t){return"[object RegExp]"===o.call(t)},r.string=function(t){return"[object String]"===o.call(t)},r.hex=function(t){return r.string(t)&&(!t.length||n.test(t))}},function(t,i,e){i.internal={},i.Serializer=e(39),i.Math=e(1),i.Vec2=e(0),i.Vec3=e(7),i.Mat22=e(10),i.Mat33=e(14),i.Transform=e(5),i.Rot=e(3),i.AABB=e(16),i.Shape=e(15),i.Fixture=e(26),i.Body=e(8),i.Contact=e(17),i.Joint=e(11),i.World=e(30),i.Circle=e(22),i.Edge=e(23),i.Polygon=e(20),i.Chain=e(28),i.Box=e(44),e(45),e(46),i.internal.CollidePolygons=e(47),e(48),e(49),i.DistanceJoint=e(50),i.FrictionJoint=e(51),i.GearJoint=e(52),i.MotorJoint=e(53),i.MouseJoint=e(54),i.PrismaticJoint=e(34),i.PulleyJoint=e(55),i.RevoluteJoint=e(33),i.RopeJoint=e(56),i.WeldJoint=e(57),i.WheelJoint=e(58),i.Settings=e(4),i.internal.Sweep=e(9),i.internal.stats=e(27),i.internal.Manifold=e(18),i.internal.Distance=e(21),i.internal.TimeOfImpact=e(32),i.internal.DynamicTree=e(31),i.internal.Settings=i.Settings},function(t,i,e){var s=e(30),o=e(8),n=e(11),r=e(26),h=e(15),a=e(0),m=e(7),c=0;function _(t){var i=(t=t||{}).rootClass||s,e=t.preSerialize||function(t){return t},_=t.postSerialize||function(t,i){return t},l=t.preDeserialize||function(t){return t},u=t.postDeserialize||function(t,i){return t},p={World:s,Body:o,Joint:n,Fixture:r,Shape:h},y=Object.assign({Vec2:a,Vec3:m},p);this.toJson=function(t){var i=[],s=[t],o={};function n(t,e){if(t.__sid=t.__sid||++c,!o[t.__sid]){s.push(t);var n={refIndex:i.length+s.length,refType:e};o[t.__sid]=n}return o[t.__sid]}function r(t,i){if("object"!=typeof t||null===t)return t;if("function"==typeof t._serialize){if(t!==i)for(var s in p)if(t instanceof p[s])return n(t,s);t=function(t){var i=(t=e(t))._serialize();return i=_(i,t)}(t)}if(Array.isArray(t)){for(var o=[],h=0;h<t.length;h++)o[h]=r(t[h]);t=o}else{o={};for(var h in t)t.hasOwnProperty(h)&&(o[h]=r(t[h]));t=o}return t}for(;s.length;){var h=s.shift(),a=r(h,h);i.push(a)}return i},this.fromJson=function(t){var e={};function s(t,i,e){i=l(i);var s=t._deserialize(i,e,o);return s=u(s,i)}function o(i,o,n){if(!o.refIndex)return i&&i._deserialize&&s(i,o,n);i=y[o.refType]||i;var r=o.refIndex;if(!e[r]){var h=s(i,t[r],n);e[r]=h}return e[r]}return i._deserialize(t[0],null,o)}}t.exports=_;var l=new _;t.exports.toJson=l.toJson,t.exports.fromJson=l.fromJson},function(t,i,e){e(4),e(2);var s=e(1),o=e(16),n=e(31);function r(){this.m_tree=new n,this.m_proxyCount=0,this.m_moveBuffer=[],this.queryCallback=this.queryCallback.bind(this)}t.exports=r,r.prototype.getUserData=function(t){return this.m_tree.getUserData(t)},r.prototype.testOverlap=function(t,i){var e=this.m_tree.getFatAABB(t),s=this.m_tree.getFatAABB(i);return o.testOverlap(e,s)},r.prototype.getFatAABB=function(t){return this.m_tree.getFatAABB(t)},r.prototype.getProxyCount=function(){return this.m_proxyCount},r.prototype.getTreeHeight=function(){return this.m_tree.getHeight()},r.prototype.getTreeBalance=function(){return this.m_tree.getMaxBalance()},r.prototype.getTreeQuality=function(){return this.m_tree.getAreaRatio()},r.prototype.query=function(t,i){this.m_tree.query(t,i)},r.prototype.rayCast=function(t,i){this.m_tree.rayCast(t,i)},r.prototype.shiftOrigin=function(t){this.m_tree.shiftOrigin(t)},r.prototype.createProxy=function(t,i){var e=this.m_tree.createProxy(t,i);return this.m_proxyCount++,this.bufferMove(e),e},r.prototype.destroyProxy=function(t){this.unbufferMove(t),this.m_proxyCount--,this.m_tree.destroyProxy(t)},r.prototype.moveProxy=function(t,i,e){this.m_tree.moveProxy(t,i,e)&&this.bufferMove(t)},r.prototype.touchProxy=function(t){this.bufferMove(t)},r.prototype.bufferMove=function(t){this.m_moveBuffer.push(t)},r.prototype.unbufferMove=function(t){for(var i=0;i<this.m_moveBuffer.length;++i)this.m_moveBuffer[i]==t&&(this.m_moveBuffer[i]=null)},r.prototype.updatePairs=function(t){for(this.m_callback=t;this.m_moveBuffer.length>0;)if(this.m_queryProxyId=this.m_moveBuffer.pop(),null!==this.m_queryProxyId){var i=this.m_tree.getFatAABB(this.m_queryProxyId);this.m_tree.query(i,this.queryCallback)}},r.prototype.queryCallback=function(t){if(t==this.m_queryProxyId)return!0;var i=s.min(t,this.m_queryProxyId),e=s.max(t,this.m_queryProxyId),o=this.m_tree.getUserData(i),n=this.m_tree.getUserData(e);return this.m_callback(o,n),!0}},function(t,i,e){t.exports=function(t){var i=[],e=t.max||1/0,s=t.create,o=t.allocate,n=t.release,r=t.discard,h=0,a=0,m=0,c=0;this.max=function(t){return"number"==typeof t?(e=t,this):e},this.size=function(){return i.length},this.allocate=function(){var t;return i.length>0?t=i.shift():(h++,t="function"==typeof s?s():{}),a++,"function"==typeof o&&o(t),t},this.release=function(t){i.length<e?(m++,"function"==typeof n&&n(t),i.push(t)):(c++,"function"==typeof r&&(t=r(t)))},this.toString=function(){return" +"+h+" >"+a+" <"+m+" -"+c+" ="+i.length+"/"+e}}},function(t,i,e){t.exports=l,t.exports.TimeStep=_;var s=e(4),o=e(2),n=e(0),r=e(1),h=(e(8),e(17),e(11),e(32)),a=h.Input,m=h.Output,c=e(21);c.Input,c.Output,c.Proxy,c.Cache;function _(t){this.dt=0,this.inv_dt=0,this.velocityIterations=0,this.positionIterations=0,this.warmStarting=!1,this.blockSolve=!0,this.inv_dt0=0,this.dtRatio=1}function l(t){this.m_world=t,this.m_stack=[],this.m_bodies=[],this.m_contacts=[],this.m_joints=[]}_.prototype.reset=function(t){this.dt>0&&(this.inv_dt0=this.inv_dt),this.dt=t,this.inv_dt=0==t?0:1/t,this.dtRatio=t*this.inv_dt0},l.prototype.clear=function(){this.m_stack.length=0,this.m_bodies.length=0,this.m_contacts.length=0,this.m_joints.length=0},l.prototype.addBody=function(t){this.m_bodies.push(t)},l.prototype.addContact=function(t){this.m_contacts.push(t)},l.prototype.addJoint=function(t){this.m_joints.push(t)},l.prototype.solveWorld=function(t){for(var i=this.m_world,e=i.m_bodyList;e;e=e.m_next)e.m_islandFlag=!1;for(var s=i.m_contactList;s;s=s.m_next)s.m_islandFlag=!1;for(var o=i.m_jointList;o;o=o.m_next)o.m_islandFlag=!1;for(var n=this.m_stack,r=i.m_bodyList;r;r=r.m_next)if(!r.m_islandFlag&&0!=r.isAwake()&&0!=r.isActive()&&!r.isStatic()){for(this.clear(),n.push(r),r.m_islandFlag=!0;n.length>0;){e=n.pop();if(this.addBody(e),e.setAwake(!0),!e.isStatic()){for(var h=e.m_contactList;h;h=h.next){var a=h.contact;if(!a.m_islandFlag&&(0!=a.isEnabled()&&0!=a.isTouching())){var m=a.m_fixtureA.m_isSensor,c=a.m_fixtureB.m_isSensor;if(!m&&!c)this.addContact(a),a.m_islandFlag=!0,(l=h.other).m_islandFlag||(n.push(l),l.m_islandFlag=!0)}}for(var _=e.m_jointList;_;_=_.next){var l;if(1!=_.joint.m_islandFlag)0!=(l=_.other).isActive()&&(this.addJoint(_.joint),_.joint.m_islandFlag=!0,l.m_islandFlag||(n.push(l),l.m_islandFlag=!0))}}}this.solveIsland(t);for(var u=0;u<this.m_bodies.length;++u){(e=this.m_bodies[u]).isStatic()&&(e.m_islandFlag=!1)}}},l.prototype.solveIsland=function(t){for(var i=this.m_world,e=i.m_gravity,o=i.m_allowSleep,h=t.dt,a=0;a<this.m_bodies.length;++a){var m=this.m_bodies[a],c=n.clone(m.m_sweep.c),_=m.m_sweep.a,l=n.clone(m.m_linearVelocity),u=m.m_angularVelocity;m.m_sweep.c0.set(m.m_sweep.c),m.m_sweep.a0=m.m_sweep.a,m.isDynamic()&&(l.addMul(h*m.m_gravityScale,e),l.addMul(h*m.m_invMass,m.m_force),u+=h*m.m_invI*m.m_torque,l.mul(1/(1+h*m.m_linearDamping)),u*=1/(1+h*m.m_angularDamping)),m.c_position.c=c,m.c_position.a=_,m.c_velocity.v=l,m.c_velocity.w=u}for(a=0;a<this.m_contacts.length;++a){this.m_contacts[a].initConstraint(t)}for(a=0;a<this.m_contacts.length;++a){this.m_contacts[a].initVelocityConstraint(t)}if(t.warmStarting)for(a=0;a<this.m_contacts.length;++a){this.m_contacts[a].warmStartConstraint(t)}for(a=0;a<this.m_joints.length;++a){this.m_joints[a].initVelocityConstraints(t)}for(a=0;a<t.velocityIterations;++a){for(var p=0;p<this.m_joints.length;++p){this.m_joints[p].solveVelocityConstraints(t)}for(p=0;p<this.m_contacts.length;++p){this.m_contacts[p].solveVelocityConstraint(t)}}for(a=0;a<this.m_contacts.length;++a){this.m_contacts[a].storeConstraintImpulses(t)}for(a=0;a<this.m_bodies.length;++a){m=this.m_bodies[a],c=n.clone(m.c_position.c),_=m.c_position.a,l=n.clone(m.c_velocity.v),u=m.c_velocity.w;var y=n.mul(h,l);if(n.lengthSquared(y)>s.maxTranslationSquared){var d=s.maxTranslation/y.length();l.mul(d)}var f=h*u;if(f*f>s.maxRotationSquared)u*=d=s.maxRotation/r.abs(f);c.addMul(h,l),_+=h*u,m.c_position.c.set(c),m.c_position.a=_,m.c_velocity.v.set(l),m.c_velocity.w=u}var v=!1;for(a=0;a<t.positionIterations;++a){var x=0;for(p=0;p<this.m_contacts.length;++p){var g=this.m_contacts[p].solvePositionConstraint(t);x=r.min(x,g)}var b=x>=-3*s.linearSlop,A=!0;for(p=0;p<this.m_joints.length;++p){var B=this.m_joints[p].solvePositionConstraints(t);A=A&&B}if(b&&A){v=!0;break}}for(a=0;a<this.m_bodies.length;++a){(m=this.m_bodies[a]).m_sweep.c.set(m.c_position.c),m.m_sweep.a=m.c_position.a,m.m_linearVelocity.set(m.c_velocity.v),m.m_angularVelocity=m.c_velocity.w,m.synchronizeTransform()}if(this.postSolveIsland(),o){var w=1/0,C=s.linearSleepToleranceSqr,M=s.angularSleepToleranceSqr;for(a=0;a<this.m_bodies.length;++a){(m=this.m_bodies[a]).isStatic()||(0==m.m_autoSleepFlag||m.m_angularVelocity*m.m_angularVelocity>M||n.lengthSquared(m.m_linearVelocity)>C?(m.m_sleepTime=0,w=0):(m.m_sleepTime+=h,w=r.min(w,m.m_sleepTime)))}if(w>=s.timeToSleep&&v)for(a=0;a<this.m_bodies.length;++a){(m=this.m_bodies[a]).setAwake(!1)}}},l.prototype.printBodies=function(t){for(var i=0;i<this.m_bodies.length;++i){var e=this.m_bodies[i];o.debug(t,e.c_position.a,e.c_position.c.x,e.c_position.c.y,e.c_velocity.w,e.c_velocity.v.x,e.c_velocity.v.y)}};var u=new _;function p(){this.normalImpulses=[],this.tangentImpulses=[]}l.prototype.solveWorldTOI=function(t){var i=this.m_world;if(i.m_stepComplete){for(var e=i.m_bodyList;e;e=e.m_next)e.m_islandFlag=!1,e.m_sweep.alpha0=0;for(var o=i.m_contactList;o;o=o.m_next)o.m_toiFlag=!1,o.m_islandFlag=!1,o.m_toiCount=0,o.m_toi=1}for(;;){for(var n=null,c=1,o=i.m_contactList;o;o=o.m_next)if(0!=o.isEnabled()&&!(o.m_toiCount>s.maxSubSteps)){var _=1;if(o.m_toiFlag)_=o.m_toi;else{var l=o.getFixtureA(),p=o.getFixtureB();if(l.isSensor()||p.isSensor())continue;var y=l.getBody(),d=p.getBody(),f=y.isAwake()&&!y.isStatic(),v=d.isAwake()&&!d.isStatic();if(0==f&&0==v)continue;var x=y.isBullet()||!y.isDynamic(),g=d.isBullet()||!d.isDynamic();if(0==x&&0==g)continue;var b=y.m_sweep.alpha0;y.m_sweep.alpha0<d.m_sweep.alpha0?(b=d.m_sweep.alpha0,y.m_sweep.advance(b)):d.m_sweep.alpha0<y.m_sweep.alpha0&&(b=y.m_sweep.alpha0,d.m_sweep.advance(b));var A=o.getChildIndexA(),B=o.getChildIndexB(),w=(y.m_sweep,d.m_sweep,new a);w.proxyA.set(l.getShape(),A),w.proxyB.set(p.getShape(),B),w.sweepA.set(y.m_sweep),w.sweepB.set(d.m_sweep),w.tMax=1;var C=new m;h(C,w);var M=C.t;_=C.state==m.e_touching?r.min(b+(1-b)*M,1):1,o.m_toi=_,o.m_toiFlag=!0}_<c&&(n=o,c=_)}if(null==n||1-10*r.EPSILON<c){i.m_stepComplete=!0;break}l=n.getFixtureA(),p=n.getFixtureB(),y=l.getBody(),d=p.getBody();var I=y.m_sweep.clone(),S=d.m_sweep.clone();if(y.advance(c),d.advance(c),n.update(i),n.m_toiFlag=!1,++n.m_toiCount,0!=n.isEnabled()&&0!=n.isTouching()){y.setAwake(!0),d.setAwake(!0),this.clear(),this.addBody(y),this.addBody(d),this.addContact(n),y.m_islandFlag=!0,d.m_islandFlag=!0,n.m_islandFlag=!0;for(var P=[y,d],z=0;z<P.length;++z){if((j=P[z]).isDynamic())for(var T=j.m_contactList;T;T=T.next){var V=T.contact;if(!V.m_islandFlag){var k=T.other;if(!k.isDynamic()||j.isBullet()||k.isBullet()){var L=V.m_fixtureA.m_isSensor,q=V.m_fixtureB.m_isSensor;if(!L&&!q){var F=k.m_sweep.clone();0==k.m_islandFlag&&k.advance(c),V.update(i),0!=V.isEnabled()&&0!=V.isTouching()?(V.m_islandFlag=!0,this.addContact(V),k.m_islandFlag||(k.m_islandFlag=!0,k.isStatic()||k.setAwake(!0),this.addBody(k))):(k.m_sweep.set(F),k.synchronizeTransform())}}}}}u.reset((1-c)*t.dt),u.dtRatio=1,u.positionIterations=20,u.velocityIterations=t.velocityIterations,u.warmStarting=!1,this.solveIslandTOI(u,y,d);for(z=0;z<this.m_bodies.length;++z){var j;if((j=this.m_bodies[z]).m_islandFlag=!1,j.isDynamic()){j.synchronizeFixtures();for(T=j.m_contactList;T;T=T.next)T.contact.m_toiFlag=!1,T.contact.m_islandFlag=!1}}if(i.findNewContacts(),i.m_subStepping){i.m_stepComplete=!1;break}}else n.setEnabled(!1),y.m_sweep.set(I),d.m_sweep.set(S),y.synchronizeTransform(),d.synchronizeTransform()}},l.prototype.solveIslandTOI=function(t,i,e){this.m_world;for(var o=0;o<this.m_bodies.length;++o){(_=this.m_bodies[o]).c_position.c.set(_.m_sweep.c),_.c_position.a=_.m_sweep.a,_.c_velocity.v.set(_.m_linearVelocity),_.c_velocity.w=_.m_angularVelocity}for(var o=0;o<this.m_contacts.length;++o){this.m_contacts[o].initConstraint(t)}for(o=0;o<t.positionIterations;++o){for(var h=0,a=0;a<this.m_contacts.length;++a){var m=this.m_contacts[a].solvePositionConstraintTOI(t,i,e);h=r.min(h,m)}if(h>=-1.5*s.linearSlop)break}i.m_sweep.c0.set(i.c_position.c),i.m_sweep.a0=i.c_position.a,e.m_sweep.c0.set(e.c_position.c),e.m_sweep.a0=e.c_position.a;for(o=0;o<this.m_contacts.length;++o){this.m_contacts[o].initVelocityConstraint(t)}for(o=0;o<t.velocityIterations;++o)for(a=0;a<this.m_contacts.length;++a){this.m_contacts[a].solveVelocityConstraint(t)}var c=t.dt;for(o=0;o<this.m_bodies.length;++o){var _=this.m_bodies[o],l=n.clone(_.c_position.c),u=_.c_position.a,p=n.clone(_.c_velocity.v),y=_.c_velocity.w,d=n.mul(c,p);if(n.dot(d,d)>s.maxTranslationSquared){var f=s.maxTranslation/d.length();p.mul(f)}var v=c*y;if(v*v>s.maxRotationSquared)y*=f=s.maxRotation/r.abs(v);l.addMul(c,p),u+=c*y,_.c_position.c=l,_.c_position.a=u,_.c_velocity.v=p,_.c_velocity.w=y,_.m_sweep.c=l,_.m_sweep.a=u,_.m_linearVelocity=p,_.m_angularVelocity=y,_.synchronizeTransform()}this.postSolveIsland()},l.prototype.postSolveIsland=function(){for(var t=new p,i=0;i<this.m_contacts.length;++i){for(var e=this.m_contacts[i],s=0;s<e.v_points.length;++s)t.normalImpulses.push(e.v_points[s].normalImpulse),t.tangentImpulses.push(e.v_points[s].tangentImpulse);this.m_world.postSolve(e,t)}}},function(t,i,e){t.exports.now=function(){return Date.now()},t.exports.diff=function(t){return Date.now()-t}},function(t,i,e){t.exports=o;e(2);var s=e(20);function o(t,i,e,s){if(!(this instanceof o))return new o(t,i,e,s);o._super.call(this),this._setAsBox(t,i,e,s)}o._super=s,o.prototype=Object.create(o._super.prototype),o.TYPE="polygon"},function(t,i,e){e(2),e(1);var s=e(5),o=e(0),n=(e(4),e(15),e(17)),r=e(18),h=e(22);function a(t,i,e,n,h){t.pointCount=0;var a=s.mulVec2(e,i.m_p),m=s.mulVec2(h,n.m_p),c=o.distanceSquared(m,a),_=i.m_radius+n.m_radius;c>_*_||(t.type=r.e_circles,t.localPoint.set(i.m_p),t.localNormal.setZero(),t.pointCount=1,t.points[0].localPoint.set(n.m_p),t.points[0].id.cf.indexA=0,t.points[0].id.cf.typeA=r.e_vertex,t.points[0].id.cf.indexB=0,t.points[0].id.cf.typeB=r.e_vertex)}n.addType(h.TYPE,h.TYPE,(function(t,i,e,s,o,n,r){a(t,e.getShape(),i,n.getShape(),o)})),i.CollideCircles=a},function(t,i,e){e(2),e(1);var s=e(5),o=e(0),n=(e(3),e(4),e(15),e(17)),r=e(18),h=e(23),a=e(28),m=e(22);function c(t,i,e,n,h){t.pointCount=0;var a=s.mulTVec2(e,s.mulVec2(h,n.m_p)),m=i.m_vertex1,c=i.m_vertex2,_=o.sub(c,m),l=o.dot(_,o.sub(c,a)),u=o.dot(_,o.sub(a,m)),p=i.m_radius+n.m_radius;if(u<=0){var y=o.clone(m),d=o.sub(a,y);if(o.dot(d,d)>p*p)return;if(i.m_hasVertex0){var f=i.m_vertex0,v=m,x=o.sub(v,f);if(o.dot(x,o.sub(v,a))>0)return}return t.type=r.e_circles,t.localNormal.setZero(),t.localPoint.set(y),t.pointCount=1,t.points[0].localPoint.set(n.m_p),t.points[0].id.cf.indexA=0,t.points[0].id.cf.typeA=r.e_vertex,t.points[0].id.cf.indexB=0,void(t.points[0].id.cf.typeB=r.e_vertex)}if(l<=0){y=o.clone(c),d=o.sub(a,y);if(o.dot(d,d)>p*p)return;if(i.m_hasVertex3){var g=i.m_vertex3,b=c,A=o.sub(g,b);if(o.dot(A,o.sub(a,b))>0)return}return t.type=r.e_circles,t.localNormal.setZero(),t.localPoint.set(y),t.pointCount=1,t.points[0].localPoint.set(n.m_p),t.points[0].id.cf.indexA=1,t.points[0].id.cf.typeA=r.e_vertex,t.points[0].id.cf.indexB=0,void(t.points[0].id.cf.typeB=r.e_vertex)}var B=o.dot(_,_);y=o.combine(l/B,m,u/B,c),d=o.sub(a,y);if(!(o.dot(d,d)>p*p)){var w=o.neo(-_.y,_.x);o.dot(w,o.sub(a,m))<0&&w.set(-w.x,-w.y),w.normalize(),t.type=r.e_faceA,t.localNormal=w,t.localPoint.set(m),t.pointCount=1,t.points[0].localPoint.set(n.m_p),t.points[0].id.cf.indexA=0,t.points[0].id.cf.typeA=r.e_face,t.points[0].id.cf.indexB=0,t.points[0].id.cf.typeB=r.e_vertex}}n.addType(h.TYPE,m.TYPE,(function(t,i,e,s,o,n,r){var h=e.getShape(),a=n.getShape();c(t,h,i,a,o)})),n.addType(a.TYPE,m.TYPE,(function(t,i,e,s,o,n,r){var a=e.getShape(),m=new h;a.getChildEdge(m,s);var _=m,l=n.getShape();c(t,_,i,l,o)}))},function(t,i,e){e(2),e(1);var s=e(5),o=e(3),n=e(0),r=(e(16),e(4)),h=e(18),a=e(17),m=(e(15),e(20));function c(t,i,e,r){for(var h=t.m_count,a=e.m_count,m=t.m_normals,_=t.m_vertices,l=e.m_vertices,u=s.mulTXf(r,i),p=0,y=-1/0,d=0;d<h;++d){for(var f=o.mulVec2(u.q,m[d]),v=s.mulVec2(u,_[d]),x=1/0,g=0;g<a;++g){var b=n.dot(f,l[g])-n.dot(f,v);b<x&&(x=b)}x>y&&(y=x,p=d)}c._maxSeparation=y,c._bestIndex=p}function _(t,i,e,a,m){t.pointCount=0;var _=i.m_radius+a.m_radius;c(i,e,a,m);var l=c._bestIndex,u=c._maxSeparation;if(!(u>_)){c(a,m,i,e);var p=c._bestIndex,y=c._maxSeparation;if(!(y>_)){var d,f,v,x,g,b;y>u+.1*r.linearSlop?(d=a,f=i,v=m,x=e,g=p,t.type=h.e_faceB,b=1):(d=i,f=a,v=e,x=m,g=l,t.type=h.e_faceA,b=0);var A=[new h.clipVertex,new h.clipVertex];!function(t,i,e,r,a,m){for(var c=i.m_normals,_=a.m_count,l=a.m_vertices,u=a.m_normals,p=o.mulT(m.q,o.mulVec2(e.q,c[r])),y=0,d=1/0,f=0;f<_;++f){var v=n.dot(p,u[f]);v<d&&(d=v,y=f)}var x=y,g=x+1<_?x+1:0;t[0].v=s.mulVec2(m,l[x]),t[0].id.cf.indexA=r,t[0].id.cf.indexB=x,t[0].id.cf.typeA=h.e_face,t[0].id.cf.typeB=h.e_vertex,t[1].v=s.mulVec2(m,l[g]),t[1].id.cf.indexA=r,t[1].id.cf.indexB=g,t[1].id.cf.typeA=h.e_face,t[1].id.cf.typeB=h.e_vertex}(A,d,v,g,f,x);var B=d.m_count,w=d.m_vertices,C=g,M=g+1<B?g+1:0,I=w[C],S=w[M],P=n.sub(S,I);P.normalize();var z=n.cross(P,1),T=n.combine(.5,I,.5,S),V=o.mulVec2(v.q,P),k=n.cross(V,1);I=s.mulVec2(v,I),S=s.mulVec2(v,S);var L=n.dot(k,I),q=-n.dot(V,I)+_,F=n.dot(V,S)+_,j=[new h.clipVertex,new h.clipVertex],E=[new h.clipVertex,new h.clipVertex];if(!(h.clipSegmentToLine(j,A,n.neg(V),q,C)<2||h.clipSegmentToLine(E,j,V,F,M)<2)){t.localNormal=z,t.localPoint=T;for(var Y=0,D=0;D<E.length;++D){if(n.dot(k,E[D].v)-L<=_){var R=t.points[Y];if(R.localPoint.set(s.mulTVec2(x,E[D].v)),R.id=E[D].id,b){var O=R.id.cf,J=O.indexA,W=O.indexB,X=O.typeA,N=O.typeB;O.indexA=W,O.indexB=J,O.typeA=N,O.typeB=X}++Y}}t.pointCount=Y}}}}t.exports=_,a.addType(m.TYPE,m.TYPE,(function(t,i,e,s,o,n,r){_(t,e.getShape(),i,n.getShape(),o)}))},function(t,i,e){e(2);var s=e(1),o=e(5),n=(e(3),e(0)),r=(e(16),e(4),e(18)),h=e(17),a=(e(15),e(22)),m=e(20);h.addType(m.TYPE,a.TYPE,(function(t,i,e,h,a,m,c){!function(t,i,e,h,a){t.pointCount=0;for(var m=o.mulVec2(a,h.m_p),c=o.mulTVec2(e,m),_=0,l=-1/0,u=i.m_radius+h.m_radius,p=i.m_count,y=i.m_vertices,d=i.m_normals,f=0;f<p;++f){var v=n.dot(d[f],n.sub(c,y[f]));if(v>u)return;v>l&&(l=v,_=f)}var x=_,g=x+1<p?x+1:0,b=y[x],A=y[g];if(l<s.EPSILON)return t.pointCount=1,t.type=r.e_faceA,t.localNormal.set(d[_]),t.localPoint.setCombine(.5,b,.5,A),t.points[0].localPoint=h.m_p,t.points[0].id.cf.indexA=0,t.points[0].id.cf.typeA=r.e_vertex,t.points[0].id.cf.indexB=0,void(t.points[0].id.cf.typeB=r.e_vertex);var B=n.dot(n.sub(c,b),n.sub(A,b)),w=n.dot(n.sub(c,A),n.sub(b,A));if(B<=0){if(n.distanceSquared(c,b)>u*u)return;t.pointCount=1,t.type=r.e_faceA,t.localNormal.setCombine(1,c,-1,b),t.localNormal.normalize(),t.localPoint=b,t.points[0].localPoint.set(h.m_p),t.points[0].id.cf.indexA=0,t.points[0].id.cf.typeA=r.e_vertex,t.points[0].id.cf.indexB=0,t.points[0].id.cf.typeB=r.e_vertex}else if(w<=0){if(n.distanceSquared(c,A)>u*u)return;t.pointCount=1,t.type=r.e_faceA,t.localNormal.setCombine(1,c,-1,A),t.localNormal.normalize(),t.localPoint.set(A),t.points[0].localPoint.set(h.m_p),t.points[0].id.cf.indexA=0,t.points[0].id.cf.typeA=r.e_vertex,t.points[0].id.cf.indexB=0,t.points[0].id.cf.typeB=r.e_vertex}else{var C=n.mid(b,A);if((l=n.dot(c,d[x])-n.dot(C,d[x]))>u)return;t.pointCount=1,t.type=r.e_faceA,t.localNormal.set(d[x]),t.localPoint.set(C),t.points[0].localPoint.set(h.m_p),t.points[0].id.cf.indexA=0,t.points[0].id.cf.typeA=r.e_vertex,t.points[0].id.cf.indexB=0,t.points[0].id.cf.typeB=r.e_vertex}}(t,e.getShape(),i,m.getShape(),a)}))},function(t,i,e){e(2);var s=e(1),o=e(5),n=e(0),r=e(3),h=e(4),a=(e(15),e(17)),m=e(18),c=e(23),_=e(28),l=e(20);a.addType(c.TYPE,l.TYPE,(function(t,i,e,s,o,n,r){v(t,e.getShape(),i,n.getShape(),o)})),a.addType(_.TYPE,l.TYPE,(function(t,i,e,s,o,n,r){var h=e.getShape(),a=new c;h.getChildEdge(a,s),v(t,a,i,n.getShape(),o)}));function u(){this.type,this.index,this.separation}var p=new u,y=new u,d=new function(){this.vertices=[],this.normals=[],this.count=0},f=new function(){this.i1,this.i2,this.v1,this.v2,this.normal=n.zero(),this.sideNormal1=n.zero(),this.sideOffset1,this.sideNormal2=n.zero(),this.sideOffset2};function v(t,i,e,a,c){var _=o.mulTXf(e,c),l=o.mulVec2(_,a.m_centroid),u=i.m_vertex0,v=i.m_vertex1,x=i.m_vertex2,g=i.m_vertex3,b=i.m_hasVertex0,A=i.m_hasVertex3,B=n.sub(x,v);B.normalize();var w,C=n.neo(B.y,-B.x),M=n.dot(C,n.sub(l,v)),I=0,S=0,P=!1,z=!1;if(b){var T=n.sub(v,u);T.normalize();var V=n.neo(T.y,-T.x);P=n.cross(T,B)>=0,I=n.dot(V,l)-n.dot(V,u)}if(A){var k=n.sub(g,x);k.normalize();var L=n.neo(k.y,-k.x);z=n.cross(B,k)>0,S=n.dot(L,l)-n.dot(L,x)}var q=n.zero(),F=n.zero(),j=n.zero();b&&A?P&&z?(w=I>=0||M>=0||S>=0)?(q.set(C),F.set(V),j.set(L)):(q.setMul(-1,C),F.setMul(-1,C),j.setMul(-1,C)):P?(w=I>=0||M>=0&&S>=0)?(q.set(C),F.set(V),j.set(C)):(q.setMul(-1,C),F.setMul(-1,L),j.setMul(-1,C)):z?(w=S>=0||I>=0&&M>=0)?(q.set(C),F.set(C),j.set(L)):(q.setMul(-1,C),F.setMul(-1,C),j.setMul(-1,V)):(w=I>=0&&M>=0&&S>=0)?(q.set(C),F.set(C),j.set(C)):(q.setMul(-1,C),F.setMul(-1,L),j.setMul(-1,V)):b?P?(w=I>=0||M>=0)?(q.set(C),F.set(V),j.setMul(-1,C)):(q.setMul(-1,C),F.set(C),j.setMul(-1,C)):(w=I>=0&&M>=0)?(q.set(C),F.set(C),j.setMul(-1,C)):(q.setMul(-1,C),F.set(C),j.setMul(-1,V)):A?z?(w=M>=0||S>=0)?(q.set(C),F.setMul(-1,C),j.set(L)):(q.setMul(-1,C),F.setMul(-1,C),j.set(C)):(w=M>=0&&S>=0)?(q.set(C),F.setMul(-1,C),j.set(C)):(q.setMul(-1,C),F.setMul(-1,L),j.set(C)):(w=M>=0)?(q.set(C),F.setMul(-1,C),j.setMul(-1,C)):(q.setMul(-1,C),F.set(C),j.set(C)),d.count=a.m_count;for(var E=0;E<a.m_count;++E)d.vertices[E]=o.mulVec2(_,a.m_vertices[E]),d.normals[E]=r.mulVec2(_.q,a.m_normals[E]);var Y=2*h.polygonRadius;t.pointCount=0,p.type=1,p.index=w?0:1,p.separation=1/0;for(E=0;E<d.count;++E){(R=n.dot(q,n.sub(d.vertices[E],v)))<p.separation&&(p.separation=R)}if(-1!=p.type&&!(p.separation>Y)){y.type=-1,y.index=-1,y.separation=-1/0;var D=n.neo(-q.y,q.x);for(E=0;E<d.count;++E){var R,O=n.neg(d.normals[E]),J=n.dot(O,n.sub(d.vertices[E],v)),W=n.dot(O,n.sub(d.vertices[E],x));if((R=s.min(J,W))>Y){y.type=2,y.index=E,y.separation=R;break}if(n.dot(O,D)>=0){if(n.dot(n.sub(O,j),q)<-h.angularSlop)continue}else if(n.dot(n.sub(O,F),q)<-h.angularSlop)continue;R>y.separation&&(y.type=2,y.index=E,y.separation=R)}if(!(-1!=y.type&&y.separation>Y)){var X;X=-1==y.type?p:y.separation>.98*p.separation+.001?y:p;var N=[new m.clipVertex,new m.clipVertex];if(1==X.type){t.type=m.e_faceA;var H=0,Z=n.dot(q,d.normals[0]);for(E=1;E<d.count;++E){var K=n.dot(q,d.normals[E]);K<Z&&(Z=K,H=E)}var G=H,U=G+1<d.count?G+1:0;N[0].v=d.vertices[G],N[0].id.cf.indexA=0,N[0].id.cf.indexB=G,N[0].id.cf.typeA=m.e_face,N[0].id.cf.typeB=m.e_vertex,N[1].v=d.vertices[U],N[1].id.cf.indexA=0,N[1].id.cf.indexB=U,N[1].id.cf.typeA=m.e_face,N[1].id.cf.typeB=m.e_vertex,w?(f.i1=0,f.i2=1,f.v1=v,f.v2=x,f.normal.set(C)):(f.i1=1,f.i2=0,f.v1=x,f.v2=v,f.normal.setMul(-1,C))}else t.type=m.e_faceB,N[0].v=v,N[0].id.cf.indexA=0,N[0].id.cf.indexB=X.index,N[0].id.cf.typeA=m.e_vertex,N[0].id.cf.typeB=m.e_face,N[1].v=x,N[1].id.cf.indexA=0,N[1].id.cf.indexB=X.index,N[1].id.cf.typeA=m.e_vertex,N[1].id.cf.typeB=m.e_face,f.i1=X.index,f.i2=f.i1+1<d.count?f.i1+1:0,f.v1=d.vertices[f.i1],f.v2=d.vertices[f.i2],f.normal.set(d.normals[f.i1]);f.sideNormal1.set(f.normal.y,-f.normal.x),f.sideNormal2.setMul(-1,f.sideNormal1),f.sideOffset1=n.dot(f.sideNormal1,f.v1),f.sideOffset2=n.dot(f.sideNormal2,f.v2);var $=[new m.clipVertex,new m.clipVertex],Q=[new m.clipVertex,new m.clipVertex];if(!(m.clipSegmentToLine($,N,f.sideNormal1,f.sideOffset1,f.i1)<h.maxManifoldPoints||m.clipSegmentToLine(Q,$,f.sideNormal2,f.sideOffset2,f.i2)<h.maxManifoldPoints)){1==X.type?(t.localNormal=n.clone(f.normal),t.localPoint=n.clone(f.v1)):(t.localNormal=n.clone(a.m_normals[f.i1]),t.localPoint=n.clone(a.m_vertices[f.i1]));var tt=0;for(E=0;E<h.maxManifoldPoints;++E){if(n.dot(f.normal,n.sub(Q[E].v,f.v1))<=Y){var it=t.points[tt];1==X.type?(it.localPoint=o.mulT(_,Q[E].v),it.id=Q[E].id):(it.localPoint=Q[E].v,it.id.cf.typeA=Q[E].id.cf.typeB,it.id.cf.typeB=Q[E].id.cf.typeA,it.id.cf.indexA=Q[E].id.cf.indexB,it.id.cf.indexB=Q[E].id.cf.indexA),++tt}}t.pointCount=tt}}}}},function(t,i,e){t.exports=_;var s=e(6),o=e(4),n=e(1),r=e(0),h=(e(7),e(10),e(14),e(3)),a=(e(9),e(5),e(12),e(13),e(11)),m=e(8);_.TYPE="distance-joint",a.TYPES[_.TYPE]=_,_._super=a,_.prototype=Object.create(_._super.prototype);var c={frequencyHz:0,dampingRatio:0};function _(t,i,e,o,h){if(!(this instanceof _))return new _(t,i,e,o,h);if(e&&o&&"m_type"in o&&"x"in e&&"y"in e){var m=e;e=o,o=m}t=s(t,c),a.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=_.TYPE,this.m_localAnchorA=r.clone(o?i.getLocalPoint(o):t.localAnchorA||r.zero()),this.m_localAnchorB=r.clone(h?e.getLocalPoint(h):t.localAnchorB||r.zero()),this.m_length=n.isFinite(t.length)?t.length:r.distance(i.getWorldPoint(this.m_localAnchorA),e.getWorldPoint(this.m_localAnchorB)),this.m_frequencyHz=t.frequencyHz,this.m_dampingRatio=t.dampingRatio,this.m_impulse=0,this.m_gamma=0,this.m_bias=0,this.m_u,this.m_rA,this.m_rB,this.m_localCenterA,this.m_localCenterB,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_mass}_.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,frequencyHz:this.m_frequencyHz,dampingRatio:this.m_dampingRatio,localAnchorA:this.m_localAnchorA,localAnchorB:this.m_localAnchorB,length:this.m_length,impulse:this.m_impulse,gamma:this.m_gamma,bias:this.m_bias}},_._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(m,t.bodyA,i),t.bodyB=e(m,t.bodyB,i),new _(t)},_.prototype._setAnchors=function(t){t.anchorA?this.m_localAnchorA.set(this.m_bodyA.getLocalPoint(t.anchorA)):t.localAnchorA&&this.m_localAnchorA.set(t.localAnchorA),t.anchorB?this.m_localAnchorB.set(this.m_bodyB.getLocalPoint(t.anchorB)):t.localAnchorB&&this.m_localAnchorB.set(t.localAnchorB),t.length>0?this.m_length=+t.length:t.length<0||(t.anchorA||t.anchorA||t.anchorA||t.anchorA)&&(this.m_length=r.distance(this.m_bodyA.getWorldPoint(this.m_localAnchorA),this.m_bodyB.getWorldPoint(this.m_localAnchorB)))},_.prototype.getLocalAnchorA=function(){return this.m_localAnchorA},_.prototype.getLocalAnchorB=function(){return this.m_localAnchorB},_.prototype.setLength=function(t){this.m_length=t},_.prototype.getLength=function(){return this.m_length},_.prototype.setFrequency=function(t){this.m_frequencyHz=t},_.prototype.getFrequency=function(){return this.m_frequencyHz},_.prototype.setDampingRatio=function(t){this.m_dampingRatio=t},_.prototype.getDampingRatio=function(){return this.m_dampingRatio},_.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},_.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},_.prototype.getReactionForce=function(t){return r.mul(this.m_impulse,this.m_u).mul(t)},_.prototype.getReactionTorque=function(t){return 0},_.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyA.c_velocity.v,a=this.m_bodyA.c_velocity.w,m=this.m_bodyB.c_position.c,c=this.m_bodyB.c_position.a,_=this.m_bodyB.c_velocity.v,l=this.m_bodyB.c_velocity.w,u=h.neo(e),p=h.neo(c);this.m_rA=h.mulVec2(u,r.sub(this.m_localAnchorA,this.m_localCenterA)),this.m_rB=h.mulVec2(p,r.sub(this.m_localAnchorB,this.m_localCenterB)),this.m_u=r.sub(r.add(m,this.m_rB),r.add(i,this.m_rA));var y=this.m_u.length();y>o.linearSlop?this.m_u.mul(1/y):this.m_u.set(0,0);var d=r.cross(this.m_rA,this.m_u),f=r.cross(this.m_rB,this.m_u),v=this.m_invMassA+this.m_invIA*d*d+this.m_invMassB+this.m_invIB*f*f;if(this.m_mass=0!=v?1/v:0,this.m_frequencyHz>0){var x=y-this.m_length,g=2*n.PI*this.m_frequencyHz,b=2*this.m_mass*this.m_dampingRatio*g,A=this.m_mass*g*g,B=t.dt;this.m_gamma=B*(b+B*A),this.m_gamma=0!=this.m_gamma?1/this.m_gamma:0,this.m_bias=x*B*A*this.m_gamma,v+=this.m_gamma,this.m_mass=0!=v?1/v:0}else this.m_gamma=0,this.m_bias=0;if(t.warmStarting){this.m_impulse*=t.dtRatio;var w=r.mul(this.m_impulse,this.m_u);s.subMul(this.m_invMassA,w),a-=this.m_invIA*r.cross(this.m_rA,w),_.addMul(this.m_invMassB,w),l+=this.m_invIB*r.cross(this.m_rB,w)}else this.m_impulse=0;this.m_bodyA.c_velocity.v.set(s),this.m_bodyA.c_velocity.w=a,this.m_bodyB.c_velocity.v.set(_),this.m_bodyB.c_velocity.w=l},_.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,o=this.m_bodyB.c_velocity.w,n=r.add(i,r.cross(e,this.m_rA)),h=r.add(s,r.cross(o,this.m_rB)),a=r.dot(this.m_u,h)-r.dot(this.m_u,n),m=-this.m_mass*(a+this.m_bias+this.m_gamma*this.m_impulse);this.m_impulse+=m;var c=r.mul(m,this.m_u);i.subMul(this.m_invMassA,c),e-=this.m_invIA*r.cross(this.m_rA,c),s.addMul(this.m_invMassB,c),o+=this.m_invIB*r.cross(this.m_rB,c),this.m_bodyA.c_velocity.v.set(i),this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v.set(s),this.m_bodyB.c_velocity.w=o},_.prototype.solvePositionConstraints=function(t){if(this.m_frequencyHz>0)return!0;var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyB.c_position.c,a=this.m_bodyB.c_position.a,m=h.neo(e),c=h.neo(a),_=h.mulSub(m,this.m_localAnchorA,this.m_localCenterA),l=h.mulSub(c,this.m_localAnchorB,this.m_localCenterB),u=r.sub(r.add(s,l),r.add(i,_)),p=u.normalize()-this.m_length;p=n.clamp(p,-o.maxLinearCorrection,o.maxLinearCorrection);var y=-this.m_mass*p,d=r.mul(y,u);return i.subMul(this.m_invMassA,d),e-=this.m_invIA*r.cross(_,d),s.addMul(this.m_invMassB,d),a+=this.m_invIB*r.cross(l,d),this.m_bodyA.c_position.c.set(i),this.m_bodyA.c_position.a=e,this.m_bodyB.c_position.c.set(s),this.m_bodyB.c_position.a=a,n.abs(p)<o.linearSlop}},function(t,i,e){t.exports=_;e(2);var s=e(6),o=(e(4),e(1)),n=e(0),r=(e(7),e(10)),h=(e(14),e(3)),a=(e(9),e(5),e(12),e(13),e(11)),m=e(8);_.TYPE="friction-joint",a.TYPES[_.TYPE]=_,_._super=a,_.prototype=Object.create(_._super.prototype);var c={maxForce:0,maxTorque:0};function _(t,i,e,o){if(!(this instanceof _))return new _(t,i,e,o);t=s(t,c),a.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=_.TYPE,this.m_localAnchorA=n.clone(o?i.getLocalPoint(o):t.localAnchorA||n.zero()),this.m_localAnchorB=n.clone(o?e.getLocalPoint(o):t.localAnchorB||n.zero()),this.m_linearImpulse=n.zero(),this.m_angularImpulse=0,this.m_maxForce=t.maxForce,this.m_maxTorque=t.maxTorque,this.m_rA,this.m_rB,this.m_localCenterA,this.m_localCenterB,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_linearMass,this.m_angularMass}_.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,maxForce:this.m_maxForce,maxTorque:this.m_maxTorque,localAnchorA:this.m_localAnchorA,localAnchorB:this.m_localAnchorB}},_._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(m,t.bodyA,i),t.bodyB=e(m,t.bodyB,i),new _(t)},_.prototype._setAnchors=function(t){t.anchorA?this.m_localAnchorA.set(this.m_bodyA.getLocalPoint(t.anchorA)):t.localAnchorA&&this.m_localAnchorA.set(t.localAnchorA),t.anchorB?this.m_localAnchorB.set(this.m_bodyB.getLocalPoint(t.anchorB)):t.localAnchorB&&this.m_localAnchorB.set(t.localAnchorB)},_.prototype.getLocalAnchorA=function(){return this.m_localAnchorA},_.prototype.getLocalAnchorB=function(){return this.m_localAnchorB},_.prototype.setMaxForce=function(t){this.m_maxForce=t},_.prototype.getMaxForce=function(){return this.m_maxForce},_.prototype.setMaxTorque=function(t){this.m_maxTorque=t},_.prototype.getMaxTorque=function(){return this.m_maxTorque},_.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},_.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},_.prototype.getReactionForce=function(t){return n.mul(t,this.m_linearImpulse)},_.prototype.getReactionTorque=function(t){return t*this.m_angularImpulse},_.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyA.c_position.a,e=this.m_bodyA.c_velocity.v,s=this.m_bodyA.c_velocity.w,o=this.m_bodyB.c_position.a,a=this.m_bodyB.c_velocity.v,m=this.m_bodyB.c_velocity.w,c=h.neo(i),_=h.neo(o);this.m_rA=h.mulVec2(c,n.sub(this.m_localAnchorA,this.m_localCenterA)),this.m_rB=h.mulVec2(_,n.sub(this.m_localAnchorB,this.m_localCenterB));var l=this.m_invMassA,u=this.m_invMassB,p=this.m_invIA,y=this.m_invIB,d=new r;if(d.ex.x=l+u+p*this.m_rA.y*this.m_rA.y+y*this.m_rB.y*this.m_rB.y,d.ex.y=-p*this.m_rA.x*this.m_rA.y-y*this.m_rB.x*this.m_rB.y,d.ey.x=d.ex.y,d.ey.y=l+u+p*this.m_rA.x*this.m_rA.x+y*this.m_rB.x*this.m_rB.x,this.m_linearMass=d.getInverse(),this.m_angularMass=p+y,this.m_angularMass>0&&(this.m_angularMass=1/this.m_angularMass),t.warmStarting){this.m_linearImpulse.mul(t.dtRatio),this.m_angularImpulse*=t.dtRatio;var f=n.neo(this.m_linearImpulse.x,this.m_linearImpulse.y);e.subMul(l,f),s-=p*(n.cross(this.m_rA,f)+this.m_angularImpulse),a.addMul(u,f),m+=y*(n.cross(this.m_rB,f)+this.m_angularImpulse)}else this.m_linearImpulse.setZero(),this.m_angularImpulse=0;this.m_bodyA.c_velocity.v=e,this.m_bodyA.c_velocity.w=s,this.m_bodyB.c_velocity.v=a,this.m_bodyB.c_velocity.w=m},_.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,h=this.m_bodyB.c_velocity.w,a=this.m_invMassA,m=this.m_invMassB,c=this.m_invIA,_=this.m_invIB,l=t.dt,u=h-e,p=-this.m_angularMass*u,y=this.m_angularImpulse,d=l*this.m_maxTorque;this.m_angularImpulse=o.clamp(this.m_angularImpulse+p,-d,d),e-=c*(p=this.m_angularImpulse-y),h+=_*p;u=n.sub(n.add(s,n.cross(h,this.m_rB)),n.add(i,n.cross(e,this.m_rA))),p=n.neg(r.mulVec2(this.m_linearMass,u)),y=this.m_linearImpulse;this.m_linearImpulse.add(p);d=l*this.m_maxForce;this.m_linearImpulse.lengthSquared()>d*d&&(this.m_linearImpulse.normalize(),this.m_linearImpulse.mul(d)),p=n.sub(this.m_linearImpulse,y),i.subMul(a,p),e-=c*n.cross(this.m_rA,p),s.addMul(m,p),h+=_*n.cross(this.m_rB,p),this.m_bodyA.c_velocity.v=i,this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v=s,this.m_bodyB.c_velocity.w=h},_.prototype.solvePositionConstraints=function(t){return!0}},function(t,i,e){t.exports=l;e(2);var s=e(6),o=e(4),n=e(1),r=e(0),h=(e(7),e(10),e(14),e(3)),a=(e(9),e(5),e(12),e(13),e(11)),m=e(8),c=e(33);e(34);l.TYPE="gear-joint",a.TYPES[l.TYPE]=l,l._super=a,l.prototype=Object.create(l._super.prototype);var _={ratio:1};function l(t,i,e,o,m,u){if(!(this instanceof l))return new l(t,i,e,o,m,u);var p,y;t=s(t,_),a.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=l.TYPE,this.m_joint1=o||t.joint1,this.m_joint2=m||t.joint2,this.m_ratio=n.isFinite(u)?u:t.ratio,this.m_type1=this.m_joint1.getType(),this.m_type2=this.m_joint2.getType(),this.m_bodyC=this.m_joint1.getBodyA(),this.m_bodyA=this.m_joint1.getBodyB();var d=this.m_bodyA.m_xf,f=this.m_bodyA.m_sweep.a,v=this.m_bodyC.m_xf,x=this.m_bodyC.m_sweep.a;if(this.m_type1===c.TYPE){var g=this.m_joint1;this.m_localAnchorC=g.m_localAnchorA,this.m_localAnchorA=g.m_localAnchorB,this.m_referenceAngleA=g.m_referenceAngle,this.m_localAxisC=r.zero(),p=f-x-this.m_referenceAngleA}else{var b=this.m_joint1;this.m_localAnchorC=b.m_localAnchorA,this.m_localAnchorA=b.m_localAnchorB,this.m_referenceAngleA=b.m_referenceAngle,this.m_localAxisC=b.m_localXAxisA;var A=this.m_localAnchorC,B=h.mulTVec2(v.q,r.add(h.mul(d.q,this.m_localAnchorA),r.sub(d.p,v.p)));p=r.dot(B,this.m_localAxisC)-r.dot(A,this.m_localAxisC)}this.m_bodyD=this.m_joint2.getBodyA(),this.m_bodyB=this.m_joint2.getBodyB();var w=this.m_bodyB.m_xf,C=this.m_bodyB.m_sweep.a,M=this.m_bodyD.m_xf,I=this.m_bodyD.m_sweep.a;if(this.m_type2===c.TYPE){g=this.m_joint2;this.m_localAnchorD=g.m_localAnchorA,this.m_localAnchorB=g.m_localAnchorB,this.m_referenceAngleB=g.m_referenceAngle,this.m_localAxisD=r.zero(),y=C-I-this.m_referenceAngleB}else{b=this.m_joint2;this.m_localAnchorD=b.m_localAnchorA,this.m_localAnchorB=b.m_localAnchorB,this.m_referenceAngleB=b.m_referenceAngle,this.m_localAxisD=b.m_localXAxisA;var S=this.m_localAnchorD,P=h.mulTVec2(M.q,r.add(h.mul(w.q,this.m_localAnchorB),r.sub(w.p,M.p)));y=r.dot(P,this.m_localAxisD)-r.dot(S,this.m_localAxisD)}this.m_constant=p+this.m_ratio*y,this.m_impulse=0,this.m_lcA,this.m_lcB,this.m_lcC,this.m_lcD,this.m_mA,this.m_mB,this.m_mC,this.m_mD,this.m_iA,this.m_iB,this.m_iC,this.m_iD,this.m_JvAC,this.m_JvBD,this.m_JwA,this.m_JwB,this.m_JwC,this.m_JwD,this.m_mass}l.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,joint1:this.m_joint1,joint2:this.m_joint2,ratio:this.m_ratio}},l._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(m,t.bodyA,i),t.bodyB=e(m,t.bodyB,i),t.joint1=e(a,t.joint1,i),t.joint2=e(a,t.joint2,i),new l(t)},l.prototype.getJoint1=function(){return this.m_joint1},l.prototype.getJoint2=function(){return this.m_joint2},l.prototype.setRatio=function(t){this.m_ratio=t},l.prototype.getRatio=function(){return this.m_ratio},l.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},l.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},l.prototype.getReactionForce=function(t){return r.mul(this.m_impulse,this.m_JvAC).mul(t)},l.prototype.getReactionTorque=function(t){return t*(this.m_impulse*this.m_JwA)},l.prototype.initVelocityConstraints=function(t){this.m_lcA=this.m_bodyA.m_sweep.localCenter,this.m_lcB=this.m_bodyB.m_sweep.localCenter,this.m_lcC=this.m_bodyC.m_sweep.localCenter,this.m_lcD=this.m_bodyD.m_sweep.localCenter,this.m_mA=this.m_bodyA.m_invMass,this.m_mB=this.m_bodyB.m_invMass,this.m_mC=this.m_bodyC.m_invMass,this.m_mD=this.m_bodyD.m_invMass,this.m_iA=this.m_bodyA.m_invI,this.m_iB=this.m_bodyB.m_invI,this.m_iC=this.m_bodyC.m_invI,this.m_iD=this.m_bodyD.m_invI;var i=this.m_bodyA.c_position.a,e=this.m_bodyA.c_velocity.v,s=this.m_bodyA.c_velocity.w,o=this.m_bodyB.c_position.a,n=this.m_bodyB.c_velocity.v,a=this.m_bodyB.c_velocity.w,m=this.m_bodyC.c_position.a,_=this.m_bodyC.c_velocity.v,l=this.m_bodyC.c_velocity.w,u=this.m_bodyD.c_position.a,p=this.m_bodyD.c_velocity.v,y=this.m_bodyD.c_velocity.w,d=h.neo(i),f=h.neo(o),v=h.neo(m),x=h.neo(u);if(this.m_mass=0,this.m_type1==c.TYPE)this.m_JvAC=r.zero(),this.m_JwA=1,this.m_JwC=1,this.m_mass+=this.m_iA+this.m_iC;else{var g=h.mulVec2(v,this.m_localAxisC),b=h.mulSub(v,this.m_localAnchorC,this.m_lcC),A=h.mulSub(d,this.m_localAnchorA,this.m_lcA);this.m_JvAC=g,this.m_JwC=r.cross(b,g),this.m_JwA=r.cross(A,g),this.m_mass+=this.m_mC+this.m_mA+this.m_iC*this.m_JwC*this.m_JwC+this.m_iA*this.m_JwA*this.m_JwA}if(this.m_type2==c.TYPE)this.m_JvBD=r.zero(),this.m_JwB=this.m_ratio,this.m_JwD=this.m_ratio,this.m_mass+=this.m_ratio*this.m_ratio*(this.m_iB+this.m_iD);else{g=h.mulVec2(x,this.m_localAxisD);var B=h.mulSub(x,this.m_localAnchorD,this.m_lcD),w=h.mulSub(f,this.m_localAnchorB,this.m_lcB);this.m_JvBD=r.mul(this.m_ratio,g),this.m_JwD=this.m_ratio*r.cross(B,g),this.m_JwB=this.m_ratio*r.cross(w,g),this.m_mass+=this.m_ratio*this.m_ratio*(this.m_mD+this.m_mB)+this.m_iD*this.m_JwD*this.m_JwD+this.m_iB*this.m_JwB*this.m_JwB}this.m_mass=this.m_mass>0?1/this.m_mass:0,t.warmStarting?(e.addMul(this.m_mA*this.m_impulse,this.m_JvAC),s+=this.m_iA*this.m_impulse*this.m_JwA,n.addMul(this.m_mB*this.m_impulse,this.m_JvBD),a+=this.m_iB*this.m_impulse*this.m_JwB,_.subMul(this.m_mC*this.m_impulse,this.m_JvAC),l-=this.m_iC*this.m_impulse*this.m_JwC,p.subMul(this.m_mD*this.m_impulse,this.m_JvBD),y-=this.m_iD*this.m_impulse*this.m_JwD):this.m_impulse=0,this.m_bodyA.c_velocity.v.set(e),this.m_bodyA.c_velocity.w=s,this.m_bodyB.c_velocity.v.set(n),this.m_bodyB.c_velocity.w=a,this.m_bodyC.c_velocity.v.set(_),this.m_bodyC.c_velocity.w=l,this.m_bodyD.c_velocity.v.set(p),this.m_bodyD.c_velocity.w=y},l.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,o=this.m_bodyB.c_velocity.w,n=this.m_bodyC.c_velocity.v,h=this.m_bodyC.c_velocity.w,a=this.m_bodyD.c_velocity.v,m=this.m_bodyD.c_velocity.w,c=r.dot(this.m_JvAC,i)-r.dot(this.m_JvAC,n)+r.dot(this.m_JvBD,s)-r.dot(this.m_JvBD,a);c+=this.m_JwA*e-this.m_JwC*h+(this.m_JwB*o-this.m_JwD*m);var _=-this.m_mass*c;this.m_impulse+=_,i.addMul(this.m_mA*_,this.m_JvAC),e+=this.m_iA*_*this.m_JwA,s.addMul(this.m_mB*_,this.m_JvBD),o+=this.m_iB*_*this.m_JwB,n.subMul(this.m_mC*_,this.m_JvAC),h-=this.m_iC*_*this.m_JwC,a.subMul(this.m_mD*_,this.m_JvBD),m-=this.m_iD*_*this.m_JwD,this.m_bodyA.c_velocity.v.set(i),this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v.set(s),this.m_bodyB.c_velocity.w=o,this.m_bodyC.c_velocity.v.set(n),this.m_bodyC.c_velocity.w=h,this.m_bodyD.c_velocity.v.set(a),this.m_bodyD.c_velocity.w=m},l.prototype.solvePositionConstraints=function(t){var i,e,s,n,a,m,_,l,u=this.m_bodyA.c_position.c,p=this.m_bodyA.c_position.a,y=this.m_bodyB.c_position.c,d=this.m_bodyB.c_position.a,f=this.m_bodyC.c_position.c,v=this.m_bodyC.c_position.a,x=this.m_bodyD.c_position.c,g=this.m_bodyD.c_position.a,b=h.neo(p),A=h.neo(d),B=h.neo(v),w=h.neo(g),C=0;if(this.m_type1==c.TYPE)s=r.zero(),a=1,_=1,C+=this.m_iA+this.m_iC,i=p-v-this.m_referenceAngleA;else{var M=h.mulVec2(B,this.m_localAxisC),I=h.mulSub(B,this.m_localAnchorC,this.m_lcC),S=h.mulSub(b,this.m_localAnchorA,this.m_lcA);s=M,_=r.cross(I,M),a=r.cross(S,M),C+=this.m_mC+this.m_mA+this.m_iC*_*_+this.m_iA*a*a;var P=r.sub(this.m_localAnchorC,this.m_lcC),z=h.mulTVec2(B,r.add(S,r.sub(u,f)));i=r.dot(r.sub(z,P),this.m_localAxisC)}if(this.m_type2==c.TYPE)n=r.zero(),m=this.m_ratio,l=this.m_ratio,C+=this.m_ratio*this.m_ratio*(this.m_iB+this.m_iD),e=d-g-this.m_referenceAngleB;else{M=h.mulVec2(w,this.m_localAxisD);var T=h.mulSub(w,this.m_localAnchorD,this.m_lcD),V=h.mulSub(A,this.m_localAnchorB,this.m_lcB);n=r.mul(this.m_ratio,M),l=this.m_ratio*r.cross(T,M),m=this.m_ratio*r.cross(V,M),C+=this.m_ratio*this.m_ratio*(this.m_mD+this.m_mB)+this.m_iD*l*l+this.m_iB*m*m;var k=r.sub(this.m_localAnchorD,this.m_lcD),L=h.mulTVec2(w,r.add(V,r.sub(y,x)));e=r.dot(L,this.m_localAxisD)-r.dot(k,this.m_localAxisD)}var q=i+this.m_ratio*e-this.m_constant,F=0;return C>0&&(F=-q/C),u.addMul(this.m_mA*F,s),p+=this.m_iA*F*a,y.addMul(this.m_mB*F,n),d+=this.m_iB*F*m,f.subMul(this.m_mC*F,s),v-=this.m_iC*F*_,x.subMul(this.m_mD*F,n),g-=this.m_iD*F*l,this.m_bodyA.c_position.c.set(u),this.m_bodyA.c_position.a=p,this.m_bodyB.c_position.c.set(y),this.m_bodyB.c_position.a=d,this.m_bodyC.c_position.c.set(f),this.m_bodyC.c_position.a=v,this.m_bodyD.c_position.c.set(x),this.m_bodyD.c_position.a=g,0<o.linearSlop}},function(t,i,e){t.exports=_;e(2);var s=e(6),o=(e(4),e(1)),n=e(0),r=(e(7),e(10)),h=(e(14),e(3)),a=(e(9),e(5),e(12),e(13),e(11)),m=e(8);_.TYPE="motor-joint",a.TYPES[_.TYPE]=_,_._super=a,_.prototype=Object.create(_._super.prototype);var c={maxForce:1,maxTorque:1,correctionFactor:.3};function _(t,i,e){if(!(this instanceof _))return new _(t,i,e);t=s(t,c),a.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=_.TYPE,this.m_linearOffset=o.isFinite(t.linearOffset)?t.linearOffset:i.getLocalPoint(e.getPosition()),this.m_angularOffset=o.isFinite(t.angularOffset)?t.angularOffset:e.getAngle()-i.getAngle(),this.m_linearImpulse=n.zero(),this.m_angularImpulse=0,this.m_maxForce=t.maxForce,this.m_maxTorque=t.maxTorque,this.m_correctionFactor=t.correctionFactor,this.m_rA,this.m_rB,this.m_localCenterA,this.m_localCenterB,this.m_linearError,this.m_angularError,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_linearMass,this.m_angularMass}_.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,maxForce:this.m_maxForce,maxTorque:this.m_maxTorque,correctionFactor:this.m_correctionFactor,linearOffset:this.m_linearOffset,angularOffset:this.m_angularOffset}},_._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(m,t.bodyA,i),t.bodyB=e(m,t.bodyB,i),new _(t)},_.prototype._setAnchors=function(t){t.anchorA?this.m_localAnchorA.set(this.m_bodyA.getLocalPoint(t.anchorA)):t.localAnchorA&&this.m_localAnchorA.set(t.localAnchorA),t.anchorB?this.m_localAnchorB.set(this.m_bodyB.getLocalPoint(t.anchorB)):t.localAnchorB&&this.m_localAnchorB.set(t.localAnchorB)},_.prototype.setMaxForce=function(t){this.m_maxForce=t},_.prototype.getMaxForce=function(){return this.m_maxForce},_.prototype.setMaxTorque=function(t){this.m_maxTorque=t},_.prototype.getMaxTorque=function(){return this.m_maxTorque},_.prototype.setCorrectionFactor=function(t){this.m_correctionFactor=t},_.prototype.getCorrectionFactor=function(){return this.m_correctionFactor},_.prototype.setLinearOffset=function(t){t.x==this.m_linearOffset.x&&t.y==this.m_linearOffset.y||(this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_linearOffset=t)},_.prototype.getLinearOffset=function(){return this.m_linearOffset},_.prototype.setAngularOffset=function(t){t!=this.m_angularOffset&&(this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_angularOffset=t)},_.prototype.getAngularOffset=function(){return this.m_angularOffset},_.prototype.getAnchorA=function(){return this.m_bodyA.getPosition()},_.prototype.getAnchorB=function(){return this.m_bodyB.getPosition()},_.prototype.getReactionForce=function(t){return n.mul(t,this.m_linearImpulse)},_.prototype.getReactionTorque=function(t){return t*this.m_angularImpulse},_.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyA.c_velocity.v,o=this.m_bodyA.c_velocity.w,a=this.m_bodyB.c_position.c,m=this.m_bodyB.c_position.a,c=this.m_bodyB.c_velocity.v,_=this.m_bodyB.c_velocity.w,l=h.neo(e),u=h.neo(m);this.m_rA=h.mulVec2(l,n.neg(this.m_localCenterA)),this.m_rB=h.mulVec2(u,n.neg(this.m_localCenterB));var p=this.m_invMassA,y=this.m_invMassB,d=this.m_invIA,f=this.m_invIB,v=new r;if(v.ex.x=p+y+d*this.m_rA.y*this.m_rA.y+f*this.m_rB.y*this.m_rB.y,v.ex.y=-d*this.m_rA.x*this.m_rA.y-f*this.m_rB.x*this.m_rB.y,v.ey.x=v.ex.y,v.ey.y=p+y+d*this.m_rA.x*this.m_rA.x+f*this.m_rB.x*this.m_rB.x,this.m_linearMass=v.getInverse(),this.m_angularMass=d+f,this.m_angularMass>0&&(this.m_angularMass=1/this.m_angularMass),this.m_linearError=n.zero(),this.m_linearError.addCombine(1,a,1,this.m_rB),this.m_linearError.subCombine(1,i,1,this.m_rA),this.m_linearError.sub(h.mulVec2(l,this.m_linearOffset)),this.m_angularError=m-e-this.m_angularOffset,t.warmStarting){this.m_linearImpulse.mul(t.dtRatio),this.m_angularImpulse*=t.dtRatio;var x=n.neo(this.m_linearImpulse.x,this.m_linearImpulse.y);s.subMul(p,x),o-=d*(n.cross(this.m_rA,x)+this.m_angularImpulse),c.addMul(y,x),_+=f*(n.cross(this.m_rB,x)+this.m_angularImpulse)}else this.m_linearImpulse.setZero(),this.m_angularImpulse=0;this.m_bodyA.c_velocity.v=s,this.m_bodyA.c_velocity.w=o,this.m_bodyB.c_velocity.v=c,this.m_bodyB.c_velocity.w=_},_.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,h=this.m_bodyB.c_velocity.w,a=this.m_invMassA,m=this.m_invMassB,c=this.m_invIA,_=this.m_invIB,l=t.dt,u=t.inv_dt,p=h-e+u*this.m_correctionFactor*this.m_angularError,y=-this.m_angularMass*p,d=this.m_angularImpulse,f=l*this.m_maxTorque;this.m_angularImpulse=o.clamp(this.m_angularImpulse+y,-f,f),e-=c*(y=this.m_angularImpulse-d),h+=_*y,(p=n.zero()).addCombine(1,s,1,n.cross(h,this.m_rB)),p.subCombine(1,i,1,n.cross(e,this.m_rA)),p.addMul(u*this.m_correctionFactor,this.m_linearError);y=n.neg(r.mulVec2(this.m_linearMass,p)),d=n.clone(this.m_linearImpulse);this.m_linearImpulse.add(y);f=l*this.m_maxForce;this.m_linearImpulse.clamp(f),y=n.sub(this.m_linearImpulse,d),i.subMul(a,y),e-=c*n.cross(this.m_rA,y),s.addMul(m,y),h+=_*n.cross(this.m_rB,y),this.m_bodyA.c_velocity.v=i,this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v=s,this.m_bodyB.c_velocity.w=h},_.prototype.solvePositionConstraints=function(t){return!0}},function(t,i,e){t.exports=l;e(2);var s=e(6),o=e(1),n=e(0),r=(e(7),e(10)),h=(e(14),e(3)),a=(e(9),e(5)),m=(e(12),e(13),e(11)),c=e(8);l.TYPE="mouse-joint",m.TYPES[l.TYPE]=l,l._super=m,l.prototype=Object.create(l._super.prototype);var _={maxForce:0,frequencyHz:5,dampingRatio:.7};function l(t,i,e,o){if(!(this instanceof l))return new l(t,i,e,o);t=s(t,_),m.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=l.TYPE,this.m_targetA=o?n.clone(o):t.target||n.zero(),this.m_localAnchorB=a.mulTVec2(e.getTransform(),this.m_targetA),this.m_maxForce=t.maxForce,this.m_impulse=n.zero(),this.m_frequencyHz=t.frequencyHz,this.m_dampingRatio=t.dampingRatio,this.m_beta=0,this.m_gamma=0,this.m_rB=n.zero(),this.m_localCenterB=n.zero(),this.m_invMassB=0,this.m_invIB=0,this.mass=new r,this.m_C=n.zero()}l.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,target:this.m_targetA,maxForce:this.m_maxForce,frequencyHz:this.m_frequencyHz,dampingRatio:this.m_dampingRatio,_localAnchorB:this.m_localAnchorB}},l._deserialize=function(t,i,e){(t=Object.assign({},t)).bodyA=e(c,t.bodyA,i),t.bodyB=e(c,t.bodyB,i),t.target=n(t.target);var s=new l(t);return t._localAnchorB&&(s.m_localAnchorB=t._localAnchorB),s},l.prototype.setTarget=function(t){0==this.m_bodyB.isAwake()&&this.m_bodyB.setAwake(!0),this.m_targetA=n.clone(t)},l.prototype.getTarget=function(){return this.m_targetA},l.prototype.setMaxForce=function(t){this.m_maxForce=t},l.getMaxForce=function(){return this.m_maxForce},l.prototype.setFrequency=function(t){this.m_frequencyHz=t},l.prototype.getFrequency=function(){return this.m_frequencyHz},l.prototype.setDampingRatio=function(t){this.m_dampingRatio=t},l.prototype.getDampingRatio=function(){return this.m_dampingRatio},l.prototype.getAnchorA=function(){return n.clone(this.m_targetA)},l.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},l.prototype.getReactionForce=function(t){return n.mul(t,this.m_impulse)},l.prototype.getReactionTorque=function(t){return 0*t},l.prototype.shiftOrigin=function(t){this.m_targetA.sub(t)},l.prototype.initVelocityConstraints=function(t){this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyB.c_position,e=this.m_bodyB.c_velocity,s=i.c,a=i.a,m=e.v,c=e.w,_=h.neo(a),l=this.m_bodyB.getMass(),u=2*o.PI*this.m_frequencyHz,p=2*l*this.m_dampingRatio*u,y=l*(u*u),d=t.dt;this.m_gamma=d*(p+d*y),0!=this.m_gamma&&(this.m_gamma=1/this.m_gamma),this.m_beta=d*y*this.m_gamma,this.m_rB=h.mulVec2(_,n.sub(this.m_localAnchorB,this.m_localCenterB));var f=new r;f.ex.x=this.m_invMassB+this.m_invIB*this.m_rB.y*this.m_rB.y+this.m_gamma,f.ex.y=-this.m_invIB*this.m_rB.x*this.m_rB.y,f.ey.x=f.ex.y,f.ey.y=this.m_invMassB+this.m_invIB*this.m_rB.x*this.m_rB.x+this.m_gamma,this.m_mass=f.getInverse(),this.m_C.set(s),this.m_C.addCombine(1,this.m_rB,-1,this.m_targetA),this.m_C.mul(this.m_beta),c*=.98,t.warmStarting?(this.m_impulse.mul(t.dtRatio),m.addMul(this.m_invMassB,this.m_impulse),c+=this.m_invIB*n.cross(this.m_rB,this.m_impulse)):this.m_impulse.setZero(),e.v.set(m),e.w=c},l.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyB.c_velocity,e=n.clone(i.v),s=i.w,o=n.cross(s,this.m_rB);o.add(e),o.addCombine(1,this.m_C,this.m_gamma,this.m_impulse),o.neg();var h=r.mulVec2(this.m_mass,o),a=n.clone(this.m_impulse);this.m_impulse.add(h);var m=t.dt*this.m_maxForce;this.m_impulse.clamp(m),h=n.sub(this.m_impulse,a),e.addMul(this.m_invMassB,h),s+=this.m_invIB*n.cross(this.m_rB,h),i.v.set(e),i.w=s},l.prototype.solvePositionConstraints=function(t){return!0}},function(t,i,e){t.exports=_;e(2);var s=e(6),o=e(4),n=e(1),r=e(0),h=(e(7),e(10),e(14),e(3)),a=(e(9),e(5),e(12),e(13),e(11)),m=e(8);_.TYPE="pulley-joint",_.MIN_PULLEY_LENGTH=2,a.TYPES[_.TYPE]=_,_._super=a,_.prototype=Object.create(_._super.prototype);var c={collideConnected:!0};function _(t,i,e,o,h,m,l,u){if(!(this instanceof _))return new _(t,i,e,o,h,m,l,u);t=s(t,c),a.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=_.TYPE,this.m_groundAnchorA=o||(t.groundAnchorA||r.neo(-1,1)),this.m_groundAnchorB=h||(t.groundAnchorB||r.neo(1,1)),this.m_localAnchorA=m?i.getLocalPoint(m):t.localAnchorA||r.neo(-1,0),this.m_localAnchorB=l?e.getLocalPoint(l):t.localAnchorB||r.neo(1,0),this.m_lengthA=n.isFinite(t.lengthA)?t.lengthA:r.distance(m,o),this.m_lengthB=n.isFinite(t.lengthB)?t.lengthB:r.distance(l,h),this.m_ratio=n.isFinite(u)?u:t.ratio,this.m_constant=this.m_lengthA+this.m_ratio*this.m_lengthB,this.m_impulse=0,this.m_uA,this.m_uB,this.m_rA,this.m_rB,this.m_localCenterA,this.m_localCenterB,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_mass}_.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,groundAnchorA:this.m_groundAnchorA,groundAnchorB:this.m_groundAnchorB,localAnchorA:this.m_localAnchorA,localAnchorB:this.m_localAnchorB,lengthA:this.m_lengthA,lengthB:this.m_lengthB,ratio:this.m_ratio}},_._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(m,t.bodyA,i),t.bodyB=e(m,t.bodyB,i),new _(t)},_.prototype.getGroundAnchorA=function(){return this.m_groundAnchorA},_.prototype.getGroundAnchorB=function(){return this.m_groundAnchorB},_.prototype.getLengthA=function(){return this.m_lengthA},_.prototype.getLengthB=function(){return this.m_lengthB},_.prototype.getRatio=function(){return this.m_ratio},_.prototype.getCurrentLengthA=function(){var t=this.m_bodyA.getWorldPoint(this.m_localAnchorA),i=this.m_groundAnchorA;return r.distance(t,i)},_.prototype.getCurrentLengthB=function(){var t=this.m_bodyB.getWorldPoint(this.m_localAnchorB),i=this.m_groundAnchorB;return r.distance(t,i)},_.prototype.shiftOrigin=function(t){this.m_groundAnchorA.sub(t),this.m_groundAnchorB.sub(t)},_.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},_.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},_.prototype.getReactionForce=function(t){return r.mul(this.m_impulse,this.m_uB).mul(t)},_.prototype.getReactionTorque=function(t){return 0},_.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyA.c_velocity.v,n=this.m_bodyA.c_velocity.w,a=this.m_bodyB.c_position.c,m=this.m_bodyB.c_position.a,c=this.m_bodyB.c_velocity.v,_=this.m_bodyB.c_velocity.w,l=h.neo(e),u=h.neo(m);this.m_rA=h.mulVec2(l,r.sub(this.m_localAnchorA,this.m_localCenterA)),this.m_rB=h.mulVec2(u,r.sub(this.m_localAnchorB,this.m_localCenterB)),this.m_uA=r.sub(r.add(i,this.m_rA),this.m_groundAnchorA),this.m_uB=r.sub(r.add(a,this.m_rB),this.m_groundAnchorB);var p=this.m_uA.length(),y=this.m_uB.length();p>10*o.linearSlop?this.m_uA.mul(1/p):this.m_uA.setZero(),y>10*o.linearSlop?this.m_uB.mul(1/y):this.m_uB.setZero();var d=r.cross(this.m_rA,this.m_uA),f=r.cross(this.m_rB,this.m_uB),v=this.m_invMassA+this.m_invIA*d*d,x=this.m_invMassB+this.m_invIB*f*f;if(this.m_mass=v+this.m_ratio*this.m_ratio*x,this.m_mass>0&&(this.m_mass=1/this.m_mass),t.warmStarting){this.m_impulse*=t.dtRatio;var g=r.mul(-this.m_impulse,this.m_uA),b=r.mul(-this.m_ratio*this.m_impulse,this.m_uB);s.addMul(this.m_invMassA,g),n+=this.m_invIA*r.cross(this.m_rA,g),c.addMul(this.m_invMassB,b),_+=this.m_invIB*r.cross(this.m_rB,b)}else this.m_impulse=0;this.m_bodyA.c_velocity.v=s,this.m_bodyA.c_velocity.w=n,this.m_bodyB.c_velocity.v=c,this.m_bodyB.c_velocity.w=_},_.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,o=this.m_bodyB.c_velocity.w,n=r.add(i,r.cross(e,this.m_rA)),h=r.add(s,r.cross(o,this.m_rB)),a=-r.dot(this.m_uA,n)-this.m_ratio*r.dot(this.m_uB,h),m=-this.m_mass*a;this.m_impulse+=m;var c=r.mul(-m,this.m_uA),_=r.mul(-this.m_ratio*m,this.m_uB);i.addMul(this.m_invMassA,c),e+=this.m_invIA*r.cross(this.m_rA,c),s.addMul(this.m_invMassB,_),o+=this.m_invIB*r.cross(this.m_rB,_),this.m_bodyA.c_velocity.v=i,this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v=s,this.m_bodyB.c_velocity.w=o},_.prototype.solvePositionConstraints=function(t){var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyB.c_position.c,a=this.m_bodyB.c_position.a,m=h.neo(e),c=h.neo(a),_=h.mulVec2(m,r.sub(this.m_localAnchorA,this.m_localCenterA)),l=h.mulVec2(c,r.sub(this.m_localAnchorB,this.m_localCenterB)),u=r.sub(r.add(i,this.m_rA),this.m_groundAnchorA),p=r.sub(r.add(s,this.m_rB),this.m_groundAnchorB),y=u.length(),d=p.length();y>10*o.linearSlop?u.mul(1/y):u.setZero(),d>10*o.linearSlop?p.mul(1/d):p.setZero();var f=r.cross(_,u),v=r.cross(l,p),x=this.m_invMassA+this.m_invIA*f*f,g=this.m_invMassB+this.m_invIB*v*v,b=x+this.m_ratio*this.m_ratio*g;b>0&&(b=1/b);var A=this.m_constant-y-this.m_ratio*d,B=n.abs(A),w=-b*A,C=r.mul(-w,u),M=r.mul(-this.m_ratio*w,p);return i.addMul(this.m_invMassA,C),e+=this.m_invIA*r.cross(_,C),s.addMul(this.m_invMassB,M),a+=this.m_invIB*r.cross(l,M),this.m_bodyA.c_position.c=i,this.m_bodyA.c_position.a=e,this.m_bodyB.c_position.c=s,this.m_bodyB.c_position.a=a,B<o.linearSlop}},function(t,i,e){t.exports=_;var s=e(6),o=e(4),n=e(1),r=e(0),h=(e(7),e(10),e(14),e(3)),a=(e(9),e(5),e(12),e(13),e(11)),m=e(8);_.TYPE="rope-joint",a.TYPES[_.TYPE]=_,_._super=a,_.prototype=Object.create(_._super.prototype);var c={maxLength:0};function _(t,i,e,o){if(!(this instanceof _))return new _(t,i,e,o);t=s(t,c),a.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=_.TYPE,this.m_localAnchorA=o?i.getLocalPoint(o):t.localAnchorA||r.neo(-1,0),this.m_localAnchorB=o?e.getLocalPoint(o):t.localAnchorB||r.neo(1,0),this.m_maxLength=t.maxLength,this.m_mass=0,this.m_impulse=0,this.m_length=0,this.m_state=0,this.m_u,this.m_rA,this.m_rB,this.m_localCenterA,this.m_localCenterB,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_mass}_.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,localAnchorA:this.m_localAnchorA,localAnchorB:this.m_localAnchorB,maxLength:this.m_maxLength}},_._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(m,t.bodyA,i),t.bodyB=e(m,t.bodyB,i),new _(t)},_.prototype.getLocalAnchorA=function(){return this.m_localAnchorA},_.prototype.getLocalAnchorB=function(){return this.m_localAnchorB},_.prototype.setMaxLength=function(t){this.m_maxLength=t},_.prototype.getMaxLength=function(){return this.m_maxLength},_.prototype.getLimitState=function(){return this.m_state},_.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},_.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},_.prototype.getReactionForce=function(t){return r.mul(this.m_impulse,this.m_u).mul(t)},_.prototype.getReactionTorque=function(t){return 0},_.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyA.c_velocity.v,n=this.m_bodyA.c_velocity.w,a=this.m_bodyB.c_position.c,m=this.m_bodyB.c_position.a,c=this.m_bodyB.c_velocity.v,_=this.m_bodyB.c_velocity.w,l=h.neo(e),u=h.neo(m);this.m_rA=h.mulSub(l,this.m_localAnchorA,this.m_localCenterA),this.m_rB=h.mulSub(u,this.m_localAnchorB,this.m_localCenterB),this.m_u=r.zero(),this.m_u.addCombine(1,a,1,this.m_rB),this.m_u.subCombine(1,i,1,this.m_rA),this.m_length=this.m_u.length();var p=this.m_length-this.m_maxLength;if(this.m_state=p>0?2:0,!(this.m_length>o.linearSlop))return this.m_u.setZero(),this.m_mass=0,void(this.m_impulse=0);this.m_u.mul(1/this.m_length);var y=r.cross(this.m_rA,this.m_u),d=r.cross(this.m_rB,this.m_u),f=this.m_invMassA+this.m_invIA*y*y+this.m_invMassB+this.m_invIB*d*d;if(this.m_mass=0!=f?1/f:0,t.warmStarting){this.m_impulse*=t.dtRatio;var v=r.mul(this.m_impulse,this.m_u);s.subMul(this.m_invMassA,v),n-=this.m_invIA*r.cross(this.m_rA,v),c.addMul(this.m_invMassB,v),_+=this.m_invIB*r.cross(this.m_rB,v)}else this.m_impulse=0;this.m_bodyA.c_velocity.v.set(s),this.m_bodyA.c_velocity.w=n,this.m_bodyB.c_velocity.v.set(c),this.m_bodyB.c_velocity.w=_},_.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,o=this.m_bodyB.c_velocity.w,h=r.addCross(i,e,this.m_rA),a=r.addCross(s,o,this.m_rB),m=this.m_length-this.m_maxLength,c=r.dot(this.m_u,r.sub(a,h));m<0&&(c+=t.inv_dt*m);var _=-this.m_mass*c,l=this.m_impulse;this.m_impulse=n.min(0,this.m_impulse+_),_=this.m_impulse-l;var u=r.mul(_,this.m_u);i.subMul(this.m_invMassA,u),e-=this.m_invIA*r.cross(this.m_rA,u),s.addMul(this.m_invMassB,u),o+=this.m_invIB*r.cross(this.m_rB,u),this.m_bodyA.c_velocity.v=i,this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v=s,this.m_bodyB.c_velocity.w=o},_.prototype.solvePositionConstraints=function(t){var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyB.c_position.c,a=this.m_bodyB.c_position.a,m=h.neo(e),c=h.neo(a),_=h.mulSub(m,this.m_localAnchorA,this.m_localCenterA),l=h.mulSub(c,this.m_localAnchorB,this.m_localCenterB),u=r.zero();u.addCombine(1,s,1,l),u.subCombine(1,i,1,_);var p=u.normalize(),y=p-this.m_maxLength;y=n.clamp(y,0,o.maxLinearCorrection);var d=-this.m_mass*y,f=r.mul(d,u);return i.subMul(this.m_invMassA,f),e-=this.m_invIA*r.cross(_,f),s.addMul(this.m_invMassB,f),a+=this.m_invIB*r.cross(l,f),this.m_bodyA.c_position.c.set(i),this.m_bodyA.c_position.a=e,this.m_bodyB.c_position.c.set(s),this.m_bodyB.c_position.a=a,p-this.m_maxLength<o.linearSlop}},function(t,i,e){t.exports=u;var s=e(6),o=e(4),n=e(1),r=e(0),h=e(7),a=(e(10),e(14)),m=e(3),c=(e(9),e(5),e(12),e(13),e(11)),_=e(8);u.TYPE="weld-joint",c.TYPES[u.TYPE]=u,u._super=c,u.prototype=Object.create(u._super.prototype);var l={frequencyHz:0,dampingRatio:0};function u(t,i,e,o){if(!(this instanceof u))return new u(t,i,e,o);t=s(t,l),c.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=u.TYPE,this.m_localAnchorA=r.clone(o?i.getLocalPoint(o):t.localAnchorA||r.zero()),this.m_localAnchorB=r.clone(o?e.getLocalPoint(o):t.localAnchorB||r.zero()),this.m_referenceAngle=n.isFinite(t.referenceAngle)?t.referenceAngle:e.getAngle()-i.getAngle(),this.m_frequencyHz=t.frequencyHz,this.m_dampingRatio=t.dampingRatio,this.m_impulse=h(),this.m_bias=0,this.m_gamma=0,this.m_rA,this.m_rB,this.m_localCenterA,this.m_localCenterB,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_mass=new a}u.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,frequencyHz:this.m_frequencyHz,dampingRatio:this.m_dampingRatio,localAnchorA:this.m_localAnchorA,localAnchorB:this.m_localAnchorB,referenceAngle:this.m_referenceAngle}},u._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(_,t.bodyA,i),t.bodyB=e(_,t.bodyB,i),new u(t)},u.prototype._setAnchors=function(t){t.anchorA?this.m_localAnchorA.set(this.m_bodyA.getLocalPoint(t.anchorA)):t.localAnchorA&&this.m_localAnchorA.set(t.localAnchorA),t.anchorB?this.m_localAnchorB.set(this.m_bodyB.getLocalPoint(t.anchorB)):t.localAnchorB&&this.m_localAnchorB.set(t.localAnchorB)},u.prototype.getLocalAnchorA=function(){return this.m_localAnchorA},u.prototype.getLocalAnchorB=function(){return this.m_localAnchorB},u.prototype.getReferenceAngle=function(){return this.m_referenceAngle},u.prototype.setFrequency=function(t){this.m_frequencyHz=t},u.prototype.getFrequency=function(){return this.m_frequencyHz},u.prototype.setDampingRatio=function(t){this.m_dampingRatio=t},u.prototype.getDampingRatio=function(){return this.m_dampingRatio},u.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},u.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},u.prototype.getReactionForce=function(t){return r.neo(this.m_impulse.x,this.m_impulse.y).mul(t)},u.prototype.getReactionTorque=function(t){return t*this.m_impulse.z},u.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_bodyA.c_position.a,e=this.m_bodyA.c_velocity.v,s=this.m_bodyA.c_velocity.w,o=this.m_bodyB.c_position.a,h=this.m_bodyB.c_velocity.v,c=this.m_bodyB.c_velocity.w,_=m.neo(i),l=m.neo(o);this.m_rA=m.mulVec2(_,r.sub(this.m_localAnchorA,this.m_localCenterA)),this.m_rB=m.mulVec2(l,r.sub(this.m_localAnchorB,this.m_localCenterB));var u=this.m_invMassA,p=this.m_invMassB,y=this.m_invIA,d=this.m_invIB,f=new a;if(f.ex.x=u+p+this.m_rA.y*this.m_rA.y*y+this.m_rB.y*this.m_rB.y*d,f.ey.x=-this.m_rA.y*this.m_rA.x*y-this.m_rB.y*this.m_rB.x*d,f.ez.x=-this.m_rA.y*y-this.m_rB.y*d,f.ex.y=f.ey.x,f.ey.y=u+p+this.m_rA.x*this.m_rA.x*y+this.m_rB.x*this.m_rB.x*d,f.ez.y=this.m_rA.x*y+this.m_rB.x*d,f.ex.z=f.ez.x,f.ey.z=f.ez.y,f.ez.z=y+d,this.m_frequencyHz>0){f.getInverse22(this.m_mass);var v=y+d,x=v>0?1/v:0,g=o-i-this.m_referenceAngle,b=2*n.PI*this.m_frequencyHz,A=2*x*this.m_dampingRatio*b,B=x*b*b,w=t.dt;this.m_gamma=w*(A+w*B),this.m_gamma=0!=this.m_gamma?1/this.m_gamma:0,this.m_bias=g*w*B*this.m_gamma,v+=this.m_gamma,this.m_mass.ez.z=0!=v?1/v:0}else 0==f.ez.z?(f.getInverse22(this.m_mass),this.m_gamma=0,this.m_bias=0):(f.getSymInverse33(this.m_mass),this.m_gamma=0,this.m_bias=0);if(t.warmStarting){this.m_impulse.mul(t.dtRatio);var C=r.neo(this.m_impulse.x,this.m_impulse.y);e.subMul(u,C),s-=y*(r.cross(this.m_rA,C)+this.m_impulse.z),h.addMul(p,C),c+=d*(r.cross(this.m_rB,C)+this.m_impulse.z)}else this.m_impulse.setZero();this.m_bodyA.c_velocity.v=e,this.m_bodyA.c_velocity.w=s,this.m_bodyB.c_velocity.v=h,this.m_bodyB.c_velocity.w=c},u.prototype.solveVelocityConstraints=function(t){var i=this.m_bodyA.c_velocity.v,e=this.m_bodyA.c_velocity.w,s=this.m_bodyB.c_velocity.v,o=this.m_bodyB.c_velocity.w,n=this.m_invMassA,m=this.m_invMassB,c=this.m_invIA,_=this.m_invIB;if(this.m_frequencyHz>0){var l=o-e,u=-this.m_mass.ez.z*(l+this.m_bias+this.m_gamma*this.m_impulse.z);this.m_impulse.z+=u,e-=c*u,o+=_*u,(d=r.zero()).addCombine(1,s,1,r.cross(o,this.m_rB)),d.subCombine(1,i,1,r.cross(e,this.m_rA));var p=r.neg(a.mulVec2(this.m_mass,d));this.m_impulse.x+=p.x,this.m_impulse.y+=p.y;var y=r.clone(p);i.subMul(n,y),e-=c*r.cross(this.m_rA,y),s.addMul(m,y),o+=_*r.cross(this.m_rB,y)}else{var d;(d=r.zero()).addCombine(1,s,1,r.cross(o,this.m_rB)),d.subCombine(1,i,1,r.cross(e,this.m_rA));l=o-e;var f=h(d.x,d.y,l),v=h.neg(a.mulVec3(this.m_mass,f));this.m_impulse.add(v);y=r.neo(v.x,v.y);i.subMul(n,y),e-=c*(r.cross(this.m_rA,y)+v.z),s.addMul(m,y),o+=_*(r.cross(this.m_rB,y)+v.z)}this.m_bodyA.c_velocity.v=i,this.m_bodyA.c_velocity.w=e,this.m_bodyB.c_velocity.v=s,this.m_bodyB.c_velocity.w=o},u.prototype.solvePositionConstraints=function(t){var i,e,s=this.m_bodyA.c_position.c,c=this.m_bodyA.c_position.a,_=this.m_bodyB.c_position.c,l=this.m_bodyB.c_position.a,u=m.neo(c),p=m.neo(l),y=this.m_invMassA,d=this.m_invMassB,f=this.m_invIA,v=this.m_invIB,x=m.mulVec2(u,r.sub(this.m_localAnchorA,this.m_localCenterA)),g=m.mulVec2(p,r.sub(this.m_localAnchorB,this.m_localCenterB)),b=new a;if(b.ex.x=y+d+x.y*x.y*f+g.y*g.y*v,b.ey.x=-x.y*x.x*f-g.y*g.x*v,b.ez.x=-x.y*f-g.y*v,b.ex.y=b.ey.x,b.ey.y=y+d+x.x*x.x*f+g.x*g.x*v,b.ez.y=x.x*f+g.x*v,b.ex.z=b.ez.x,b.ey.z=b.ez.y,b.ez.z=f+v,this.m_frequencyHz>0){(B=r.zero()).addCombine(1,_,1,g),B.subCombine(1,s,1,x),i=B.length(),e=0;var A=r.neg(b.solve22(B));s.subMul(y,A),c-=f*r.cross(x,A),_.addMul(d,A),l+=v*r.cross(g,A)}else{var B;(B=r.zero()).addCombine(1,_,1,g),B.subCombine(1,s,1,x);var w=l-c-this.m_referenceAngle;i=B.length(),e=n.abs(w);var C=h(B.x,B.y,w),M=h();if(b.ez.z>0)M=h.neg(b.solve33(C));else{var I=r.neg(b.solve22(B));M.set(I.x,I.y,0)}A=r.neo(M.x,M.y);s.subMul(y,A),c-=f*(r.cross(x,A)+M.z),_.addMul(d,A),l+=v*(r.cross(g,A)+M.z)}return this.m_bodyA.c_position.c=s,this.m_bodyA.c_position.a=c,this.m_bodyB.c_position.c=_,this.m_bodyB.c_position.a=l,i<=o.linearSlop&&e<=o.angularSlop}},function(t,i,e){t.exports=_;var s=e(6),o=e(4),n=e(1),r=e(0),h=(e(7),e(10),e(14),e(3)),a=(e(9),e(5),e(12),e(13),e(11)),m=e(8);_.TYPE="wheel-joint",a.TYPES[_.TYPE]=_,_._super=a,_.prototype=Object.create(_._super.prototype);var c={enableMotor:!1,maxMotorTorque:0,motorSpeed:0,frequencyHz:2,dampingRatio:.7};function _(t,i,e,o,n){if(!(this instanceof _))return new _(t,i,e,o,n);t=s(t,c),a.call(this,t,i,e),i=this.m_bodyA,e=this.m_bodyB,this.m_type=_.TYPE,this.m_localAnchorA=r.clone(o?i.getLocalPoint(o):t.localAnchorA||r.zero()),this.m_localAnchorB=r.clone(o?e.getLocalPoint(o):t.localAnchorB||r.zero()),this.m_localXAxisA=r.clone(n?i.getLocalVector(n):t.localAxisA||t.localAxis||r.neo(1,0)),this.m_localYAxisA=r.cross(1,this.m_localXAxisA),this.m_mass=0,this.m_impulse=0,this.m_motorMass=0,this.m_motorImpulse=0,this.m_springMass=0,this.m_springImpulse=0,this.m_maxMotorTorque=t.maxMotorTorque,this.m_motorSpeed=t.motorSpeed,this.m_enableMotor=t.enableMotor,this.m_frequencyHz=t.frequencyHz,this.m_dampingRatio=t.dampingRatio,this.m_bias=0,this.m_gamma=0,this.m_localCenterA,this.m_localCenterB,this.m_invMassA,this.m_invMassB,this.m_invIA,this.m_invIB,this.m_ax=r.zero(),this.m_ay=r.zero(),this.m_sAx,this.m_sBx,this.m_sAy,this.m_sBy}_.prototype._serialize=function(){return{type:this.m_type,bodyA:this.m_bodyA,bodyB:this.m_bodyB,collideConnected:this.m_collideConnected,enableMotor:this.m_enableMotor,maxMotorTorque:this.m_maxMotorTorque,motorSpeed:this.m_motorSpeed,frequencyHz:this.m_frequencyHz,dampingRatio:this.m_dampingRatio,localAnchorA:this.m_localAnchorA,localAnchorB:this.m_localAnchorB,localAxisA:this.m_localXAxisA}},_._deserialize=function(t,i,e){return(t=Object.assign({},t)).bodyA=e(m,t.bodyA,i),t.bodyB=e(m,t.bodyB,i),new _(t)},_.prototype._setAnchors=function(t){t.anchorA?this.m_localAnchorA.set(this.m_bodyA.getLocalPoint(t.anchorA)):t.localAnchorA&&this.m_localAnchorA.set(t.localAnchorA),t.anchorB?this.m_localAnchorB.set(this.m_bodyB.getLocalPoint(t.anchorB)):t.localAnchorB&&this.m_localAnchorB.set(t.localAnchorB),t.localAxisA&&(this.m_localXAxisA.set(t.localAxisA),this.m_localYAxisA.set(r.cross(1,t.localAxisA)))},_.prototype.getLocalAnchorA=function(){return this.m_localAnchorA},_.prototype.getLocalAnchorB=function(){return this.m_localAnchorB},_.prototype.getLocalAxisA=function(){return this.m_localXAxisA},_.prototype.getJointTranslation=function(){var t=this.m_bodyA,i=this.m_bodyB,e=t.getWorldPoint(this.m_localAnchorA),s=i.getWorldPoint(this.m_localAnchorB),o=r.sub(s,e),n=t.getWorldVector(this.m_localXAxisA);return r.dot(o,n)},_.prototype.getJointSpeed=function(){var t=this.m_bodyA.m_angularVelocity;return this.m_bodyB.m_angularVelocity-t},_.prototype.isMotorEnabled=function(){return this.m_enableMotor},_.prototype.enableMotor=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_enableMotor=t},_.prototype.setMotorSpeed=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_motorSpeed=t},_.prototype.getMotorSpeed=function(){return this.m_motorSpeed},_.prototype.setMaxMotorTorque=function(t){this.m_bodyA.setAwake(!0),this.m_bodyB.setAwake(!0),this.m_maxMotorTorque=t},_.prototype.getMaxMotorTorque=function(){return this.m_maxMotorTorque},_.prototype.getMotorTorque=function(t){return t*this.m_motorImpulse},_.prototype.setSpringFrequencyHz=function(t){this.m_frequencyHz=t},_.prototype.getSpringFrequencyHz=function(){return this.m_frequencyHz},_.prototype.setSpringDampingRatio=function(t){this.m_dampingRatio=t},_.prototype.getSpringDampingRatio=function(){return this.m_dampingRatio},_.prototype.getAnchorA=function(){return this.m_bodyA.getWorldPoint(this.m_localAnchorA)},_.prototype.getAnchorB=function(){return this.m_bodyB.getWorldPoint(this.m_localAnchorB)},_.prototype.getReactionForce=function(t){return r.combine(this.m_impulse,this.m_ay,this.m_springImpulse,this.m_ax).mul(t)},_.prototype.getReactionTorque=function(t){return t*this.m_motorImpulse},_.prototype.initVelocityConstraints=function(t){this.m_localCenterA=this.m_bodyA.m_sweep.localCenter,this.m_localCenterB=this.m_bodyB.m_sweep.localCenter,this.m_invMassA=this.m_bodyA.m_invMass,this.m_invMassB=this.m_bodyB.m_invMass,this.m_invIA=this.m_bodyA.m_invI,this.m_invIB=this.m_bodyB.m_invI;var i=this.m_invMassA,e=this.m_invMassB,s=this.m_invIA,o=this.m_invIB,a=this.m_bodyA.c_position.c,m=this.m_bodyA.c_position.a,c=this.m_bodyA.c_velocity.v,_=this.m_bodyA.c_velocity.w,l=this.m_bodyB.c_position.c,u=this.m_bodyB.c_position.a,p=this.m_bodyB.c_velocity.v,y=this.m_bodyB.c_velocity.w,d=h.neo(m),f=h.neo(u),v=h.mulVec2(d,r.sub(this.m_localAnchorA,this.m_localCenterA)),x=h.mulVec2(f,r.sub(this.m_localAnchorB,this.m_localCenterB));if((B=r.zero()).addCombine(1,l,1,x),B.subCombine(1,a,1,v),this.m_ay=h.mulVec2(d,this.m_localYAxisA),this.m_sAy=r.cross(r.add(B,v),this.m_ay),this.m_sBy=r.cross(x,this.m_ay),this.m_mass=i+e+s*this.m_sAy*this.m_sAy+o*this.m_sBy*this.m_sBy,this.m_mass>0&&(this.m_mass=1/this.m_mass),this.m_springMass=0,this.m_bias=0,this.m_gamma=0,this.m_frequencyHz>0){this.m_ax=h.mulVec2(d,this.m_localXAxisA),this.m_sAx=r.cross(r.add(B,v),this.m_ax),this.m_sBx=r.cross(x,this.m_ax);var g=i+e+s*this.m_sAx*this.m_sAx+o*this.m_sBx*this.m_sBx;if(g>0){this.m_springMass=1/g;var b=r.dot(B,this.m_ax),A=2*n.PI*this.m_frequencyHz,B=2*this.m_springMass*this.m_dampingRatio*A,w=this.m_springMass*A*A,C=t.dt;this.m_gamma=C*(B+C*w),this.m_gamma>0&&(this.m_gamma=1/this.m_gamma),this.m_bias=b*C*w*this.m_gamma,this.m_springMass=g+this.m_gamma,this.m_springMass>0&&(this.m_springMass=1/this.m_springMass)}}else this.m_springImpulse=0;if(this.m_enableMotor?(this.m_motorMass=s+o,this.m_motorMass>0&&(this.m_motorMass=1/this.m_motorMass)):(this.m_motorMass=0,this.m_motorImpulse=0),t.warmStarting){this.m_impulse*=t.dtRatio,this.m_springImpulse*=t.dtRatio,this.m_motorImpulse*=t.dtRatio;var M=r.combine(this.m_impulse,this.m_ay,this.m_springImpulse,this.m_ax),I=this.m_impulse*this.m_sAy+this.m_springImpulse*this.m_sAx+this.m_motorImpulse,S=this.m_impulse*this.m_sBy+this.m_springImpulse*this.m_sBx+this.m_motorImpulse;c.subMul(this.m_invMassA,M),_-=this.m_invIA*I,p.addMul(this.m_invMassB,M),y+=this.m_invIB*S}else this.m_impulse=0,this.m_springImpulse=0,this.m_motorImpulse=0;this.m_bodyA.c_velocity.v.set(c),this.m_bodyA.c_velocity.w=_,this.m_bodyB.c_velocity.v.set(p),this.m_bodyB.c_velocity.w=y},_.prototype.solveVelocityConstraints=function(t){var i=this.m_invMassA,e=this.m_invMassB,s=this.m_invIA,o=this.m_invIB,h=this.m_bodyA.c_velocity.v,a=this.m_bodyA.c_velocity.w,m=this.m_bodyB.c_velocity.v,c=this.m_bodyB.c_velocity.w,_=r.dot(this.m_ax,m)-r.dot(this.m_ax,h)+this.m_sBx*c-this.m_sAx*a,l=-this.m_springMass*(_+this.m_bias+this.m_gamma*this.m_springImpulse);this.m_springImpulse+=l;var u=r.mul(l,this.m_ax),p=l*this.m_sAx,y=l*this.m_sBx;h.subMul(i,u),a-=s*p,m.addMul(e,u);_=(c+=o*y)-a-this.m_motorSpeed,l=-this.m_motorMass*_;var d=this.m_motorImpulse,f=t.dt*this.m_maxMotorTorque;this.m_motorImpulse=n.clamp(this.m_motorImpulse+l,-f,f),a-=s*(l=this.m_motorImpulse-d),c+=o*l;_=r.dot(this.m_ay,m)-r.dot(this.m_ay,h)+this.m_sBy*c-this.m_sAy*a,l=-this.m_mass*_;this.m_impulse+=l;u=r.mul(l,this.m_ay),p=l*this.m_sAy,y=l*this.m_sBy;h.subMul(i,u),a-=s*p,m.addMul(e,u),c+=o*y,this.m_bodyA.c_velocity.v.set(h),this.m_bodyA.c_velocity.w=a,this.m_bodyB.c_velocity.v.set(m),this.m_bodyB.c_velocity.w=c},_.prototype.solvePositionConstraints=function(t){var i=this.m_bodyA.c_position.c,e=this.m_bodyA.c_position.a,s=this.m_bodyB.c_position.c,a=this.m_bodyB.c_position.a,m=h.neo(e),c=h.neo(a),_=h.mulVec2(m,r.sub(this.m_localAnchorA,this.m_localCenterA)),l=h.mulVec2(c,r.sub(this.m_localAnchorB,this.m_localCenterB)),u=r.zero();u.addCombine(1,s,1,l),u.subCombine(1,i,1,_);var p,y=h.mulVec2(m,this.m_localYAxisA),d=r.cross(r.add(u,_),y),f=r.cross(l,y),v=r.dot(u,y),x=this.m_invMassA+this.m_invMassB+this.m_invIA*this.m_sAy*this.m_sAy+this.m_invIB*this.m_sBy*this.m_sBy;p=0!=x?-v/x:0;var g=r.mul(p,y),b=p*d,A=p*f;return i.subMul(this.m_invMassA,g),e-=this.m_invIA*b,s.addMul(this.m_invMassB,g),a+=this.m_invIB*A,this.m_bodyA.c_position.c.set(i),this.m_bodyA.c_position.a=e,this.m_bodyB.c_position.c.set(s),this.m_bodyB.c_position.a=a,n.abs(v)<=o.linearSlop}},function(t,i,e){var s=e(35),o=e(60);function n(t,i){"object"==typeof t&&this.src(t,i)}n.prototype.pipe=function(){return new n(this)},n.prototype.src=function(t,i,e,s){if("object"==typeof t){var o=t,n=i||1;this._image=o,this._sx=this._dx=0,this._sy=this._dy=0,this._sw=this._dw=o.width/n,this._sh=this._dh=o.height/n,this.width=o.width/n,this.height=o.height/n,this.ratio=n}else void 0===e?(e=t,s=i):(this._sx=t,this._sy=i),this._sw=this._dw=e,this._sh=this._dh=s,this.width=e,this.height=s;return this},n.prototype.dest=function(t,i,e,s){return this._dx=t,this._dy=i,this._dx=t,this._dy=i,void 0!==e&&(this._dw=e,this._dh=s,this.width=e,this.height=s),this},n.prototype.draw=function(t,i,e,n,r,h,a,m,c){var _=this._image;if(null!==_&&"object"==typeof _){var l=this._sx,u=this._sy,p=this._sw,y=this._sh,d=this._dx,f=this._dy,v=this._dw,x=this._dh;void 0!==h?(i=o.limit(i,0,this._sw),n=o.limit(n,0,this._sw-i),l+=i,u+=e=o.limit(e,0,this._sh),p=n,y=r=o.limit(r,0,this._sh-e),d=h,f=a,v=m,x=c):void 0!==n?(d=i,f=e,v=n,x=r):void 0!==i&&(v=i,x=e);var g=this.ratio||1;l*=g,u*=g,p*=g,y*=g;try{"function"==typeof _.draw?_.draw(t,l,u,p,y,d,f,v,x):(s.draw++,t.drawImage(_,l,u,p,y,d,f,v,x))}catch(t){_._draw_failed||(console.log("Unable to draw: ",_),console.log(t),_._draw_failed=!0)}}},t.exports=n},function(t,i,e){var s=e(24),o=Math;t.exports=s(Math),t.exports.random=function(t,i){return void 0===t?(i=1,t=0):void 0===i&&(i=t,t=0),t==i?t:o.random()*(i-t)+t},t.exports.rotate=function(t,i,e){return void 0===i?(e=1,i=0):void 0===e&&(e=i,i=0),e>i?(t=(t-i)%(e-i))+(t<0?e:i):(t=(t-e)%(i-e))+(t<=0?i:e)},t.exports.limit=function(t,i,e){return t<i?i:t>e?e:t},t.exports.length=function(t,i){return o.sqrt(t*t+i*i)}},function(t,i){function e(t,i,e,s,o,n){this.reset(t,i,e,s,o,n)}e.prototype.toString=function(){return"["+this.a+", "+this.b+", "+this.c+", "+this.d+", "+this.e+", "+this.f+"]"},e.prototype.clone=function(){return new e(this.a,this.b,this.c,this.d,this.e,this.f)},e.prototype.reset=function(t,i,e,s,o,n){return this._dirty=!0,"object"==typeof t?(this.a=t.a,this.d=t.d,this.b=t.b,this.c=t.c,this.e=t.e,this.f=t.f):(this.a=t||1,this.d=s||1,this.b=i||0,this.c=e||0,this.e=o||0,this.f=n||0),this},e.prototype.identity=function(){return this._dirty=!0,this.a=1,this.b=0,this.c=0,this.d=1,this.e=0,this.f=0,this},e.prototype.rotate=function(t){if(!t)return this;this._dirty=!0;var i=t?Math.cos(t):1,e=t?Math.sin(t):0,s=i*this.a-e*this.b,o=i*this.b+e*this.a,n=i*this.c-e*this.d,r=i*this.d+e*this.c,h=i*this.e-e*this.f,a=i*this.f+e*this.e;return this.a=s,this.b=o,this.c=n,this.d=r,this.e=h,this.f=a,this},e.prototype.translate=function(t,i){return t||i?(this._dirty=!0,this.e+=t,this.f+=i,this):this},e.prototype.scale=function(t,i){return t-1||i-1?(this._dirty=!0,this.a*=t,this.b*=i,this.c*=t,this.d*=i,this.e*=t,this.f*=i,this):this},e.prototype.skew=function(t,i){if(!t&&!i)return this;this._dirty=!0;var e=this.a+this.b*t,s=this.b+this.a*i,o=this.c+this.d*t,n=this.d+this.c*i,r=this.e+this.f*t,h=this.f+this.e*i;return this.a=e,this.b=s,this.c=o,this.d=n,this.e=r,this.f=h,this},e.prototype.concat=function(t){this._dirty=!0;var i=this,e=i.a*t.a+i.b*t.c,s=i.b*t.d+i.a*t.b,o=i.c*t.a+i.d*t.c,n=i.d*t.d+i.c*t.b,r=i.e*t.a+t.e+i.f*t.c,h=i.f*t.d+t.f+i.e*t.b;return this.a=e,this.b=s,this.c=o,this.d=n,this.e=r,this.f=h,this},e.prototype.inverse=e.prototype.reverse=function(){if(this._dirty){this._dirty=!1,this.inversed=this.inversed||new e;var t=this.a*this.d-this.b*this.c;this.inversed.a=this.d/t,this.inversed.b=-this.b/t,this.inversed.c=-this.c/t,this.inversed.d=this.a/t,this.inversed.e=(this.c*this.f-this.e*this.d)/t,this.inversed.f=(this.e*this.b-this.a*this.f)/t}return this.inversed},e.prototype.map=function(t,i){return(i=i||{}).x=this.a*t.x+this.c*t.y+this.e,i.y=this.b*t.x+this.d*t.y+this.f,i},e.prototype.mapX=function(t,i){return"object"==typeof t&&(i=t.y,t=t.x),this.a*t+this.c*i+this.e},e.prototype.mapY=function(t,i){return"object"==typeof t&&(i=t.y,t=t.x),this.b*t+this.d*i+this.f},t.exports=e},function(t,i,e){var s=e(38),o=e(63);function n(t,i){n._super.call(this),this.label("Planck"),i=i||{};var e=this._options={};this._options.speed=i.speed||1,this._options.hz=i.hz||60,Math.abs(this._options.hz)<1&&(this._options.hz=1/this._options.hz),this._options.scaleY=i.scaleY||-1,this._options.ratio=i.ratio||16,this._options.lineWidth=2/this._options.ratio,this._world=t;var s=1/this._options.hz,o=0;this.tick((function(i){for(o+=i=.001*i*e.speed;o>s;)t.step(s),o-=s;return this.renderWorld(),!0}),!0),t.on("remove-fixture",(function(t){t.ui&&t.ui.remove()})),t.on("remove-joint",(function(t){t.ui&&t.ui.remove()}))}t.exports=s,s.testbed=function(t,i){"function"==typeof t&&(i=t,t=null),o((function(t,e){t.on(o.Mouse.START,(function(){window.focus(),document.activeElement&&document.activeElement.blur(),e.focus()})),t.MAX_ELAPSE=1e3/30;var r=s.Vec2,h={};h.canvas=e;var a=!1;t.on("resume",(function(){a=!1,h._resume&&h._resume()})),t.on("pause",(function(){a=!0,h._pause&&h._pause()})),h.isPaused=function(){return a},h.togglePause=function(){a?h.resume():h.pause()},h.pause=function(){t.pause()},h.resume=function(){t.resume(),h.focus()},h.focus=function(){document.activeElement&&document.activeElement.blur(),e.focus()},h.debug=!1,h.width=80,h.height=60,h.x=0,h.y=-10,h.scaleY=-1,h.ratio=16,h.hz=60,h.speed=1,h.activeKeys={},h.background="#222222",h.findOne=function(){return null},h.findAll=function(){return[]};var m="",c={};function _(t,i){"function"!=typeof i&&"object"!=typeof i&&(c[t]=i)}h.status=function(t,i){void 0!==i?_(t,i):t&&"object"==typeof t?function(t){for(var i in t)_(i,t[i])}(t):"string"==typeof t&&(m=t),h._status&&h._status(m,c)},h.info=function(t){h._info&&h._info(t)};var l="",u="";!function(){var i=new o.Texture;t.append(o.image(i));var e=[];t.tick((function(){e.length=0}),!0),i.draw=function(t){t.save(),t.transform(1,0,0,h.scaleY,-h.x,-h.y),t.lineWidth=2/h.ratio,t.lineCap="round";for(var i=e.shift();i;i=e.shift())i(t,h.ratio);t.restore()},h.drawPoint=function(t,i,s){e.push((function(i,e){i.beginPath(),i.arc(t.x,t.y,5/e,0,2*Math.PI),i.strokeStyle=s,i.stroke()})),u+="point"+t.x+","+t.y+","+i+","+s},h.drawCircle=function(t,i,s){e.push((function(e){e.beginPath(),e.arc(t.x,t.y,i,0,2*Math.PI),e.strokeStyle=s,e.stroke()})),u+="circle"+t.x+","+t.y+","+i+","+s},h.drawSegment=function(t,i,s){e.push((function(e){e.beginPath(),e.moveTo(t.x,t.y),e.lineTo(i.x,i.y),e.strokeStyle=s,e.stroke()})),u+="segment"+t.x+","+t.y+","+i.x+","+i.y+","+s},h.drawPolygon=function(t,i){if(t&&t.length){e.push((function(e){e.beginPath(),e.moveTo(t[0].x,t[0].y);for(var s=1;s<t.length;s++)e.lineTo(t[s].x,t[s].y);e.strokeStyle=i,e.closePath(),e.stroke()})),u+="segment";for(var s=1;s<t.length;s++)u+=t[s].x+","+t[s].y+",";u+=i}},h.drawAABB=function(t,i){e.push((function(e){e.beginPath(),e.moveTo(t.lowerBound.x,t.lowerBound.y),e.lineTo(t.upperBound.x,t.lowerBound.y),e.lineTo(t.upperBound.x,t.upperBound.y),e.lineTo(t.lowerBound.x,t.upperBound.y),e.strokeStyle=i,e.closePath(),e.stroke()})),u+="aabb",u+=t.lowerBound.x+","+t.lowerBound.y+",",u+=t.upperBound.x+","+t.upperBound.y+",",u+=i},h.color=function(t,i,e){return"rgb("+(t=256*t|0)+", "+(i=256*i|0)+", "+(e=256*e|0)+")"}}();var p=i(h),y=new n(p,h),d=0,f=0;t.tick((function(t,i){d===h.x&&f===h.y||(y.offset(-h.x,-h.y),d=h.x,f=h.y)})),y.tick((function(i,e){return"function"==typeof h.step&&h.step(i,e),x&&h.drawSegment(x.getPosition(),b,"rgba(255,255,255,0.2)"),l!==u&&(l=u,t.touch()),u="",!0})),t.background(h.background),t.viewbox(h.width,h.height),t.pin("alignX",-.5),t.pin("alignY",-.5),t.prepend(y);var v,x,g=p.createBody(),b={x:0,y:0};y.attr("spy",!0).on(o.Mouse.START,(function(t){if(t={x:t.x,y:h.scaleY*t.y},!x){var i=function(t){var i,e=s.AABB(t,t);return p.queryAABB(e,(function(e){if(!i&&e.getBody().isDynamic()&&e.testPoint(t))return i=e.getBody(),!0})),i}(t);i&&(h.mouseForce?x=i:(v=s.MouseJoint({maxForce:1e3},g,i,r(t)),p.createJoint(v)))}})).on(o.Mouse.MOVE,(function(t){t={x:t.x,y:h.scaleY*t.y},v&&v.setTarget(t),b.x=t.x,b.y=t.y})).on(o.Mouse.END,(function(t){if(t={x:t.x,y:h.scaleY*t.y},v&&(p.destroyJoint(v),v=null),x){var i=r.sub(t,x.getPosition());x.applyForceToCenter(i.mul(h.mouseForce),!0),x=null}})).on(o.Mouse.CANCEL,(function(t){t={x:t.x,y:h.scaleY*t.y},v&&(p.destroyJoint(v),v=null),x&&(x=null)})),window.addEventListener("keydown",(function(t){switch(t.keyCode){case"P".charCodeAt(0):h.togglePause()}}),!1);var A={};window.addEventListener("keydown",(function(t){var i=t.keyCode;A[i]=!0,w(i,!0),h.keydown&&h.keydown(i,String.fromCharCode(i))})),window.addEventListener("keyup",(function(t){var i=t.keyCode;A[i]=!1,w(i,!1),h.keyup&&h.keyup(i,String.fromCharCode(i))}));var B=h.activeKeys;function w(t,i){var e=String.fromCharCode(t);/\w/.test(e)&&(B[e]=i),B.right=A[39]||B.D,B.left=A[37]||B.A,B.up=A[38]||B.W,B.down=A[40]||B.S,B.fire=A[32]||A[13]}}))},n._super=o,n.prototype=o._create(n._super.prototype),n.prototype.renderWorld=function(t){t=this._world;for(var i=this._options,e=t.getBodyList();e;e=e.getNext())for(var s=e.getFixtureList();s;s=s.getNext()){if(!s.ui){s.render&&s.render.stroke?i.strokeStyle=s.render.stroke:e.render&&e.render.stroke?i.strokeStyle=e.render.stroke:e.isDynamic()?i.strokeStyle="rgba(255,255,255,0.9)":e.isKinematic()?i.strokeStyle="rgba(255,255,255,0.7)":e.isStatic()&&(i.strokeStyle="rgba(255,255,255,0.5)"),s.render&&s.render.fill?i.fillStyle=s.render.fill:e.render&&e.render.fill?i.fillStyle=e.render.fill:i.fillStyle="";var o=s.getType(),n=s.getShape();"circle"==o&&(s.ui=this.drawCircle(n,i)),"edge"==o&&(s.ui=this.drawEdge(n,i)),"polygon"==o&&(s.ui=this.drawPolygon(n,i)),"chain"==o&&(s.ui=this.drawChain(n,i)),s.ui&&s.ui.appendTo(this)}if(s.ui){var r=e.getPosition(),h=e.getAngle();s.ui.__lastX===r.x&&s.ui.__lastY===r.y&&s.ui.__lastR===h||(s.ui.__lastX=r.x,s.ui.__lastY=r.y,s.ui.__lastR=h,s.ui.offset(r.x,i.scaleY*r.y),s.ui.rotate(i.scaleY*h))}}for(var a=t.getJointList();a;a=a.getNext()){o=a.getType();var m=a.getAnchorA();e=a.getAnchorB();if(a.ui||(i.strokeStyle="rgba(255,255,255,0.2)",a.ui=this.drawJoint(a,i),a.ui.pin("handle",.5),a.ui&&a.ui.appendTo(this)),a.ui){var c=.5*(m.x+e.x),_=i.scaleY*(m.y+e.y)*.5,l=m.x-e.x,u=i.scaleY*(m.y-e.y),p=Math.sqrt(l*l+u*u);a.ui.width(p),a.ui.rotate(Math.atan2(u,l)),a.ui.offset(c,_)}}},n.prototype.drawJoint=function(t,i){var e=i.lineWidth,s=i.ratio,n=o.canvas((function(t){this.size(10+2*e,2*e,s),t.scale(s,s),t.beginPath(),t.moveTo(e,e),t.lineTo(e+10,e),t.lineCap="round",t.lineWidth=i.lineWidth,t.strokeStyle=i.strokeStyle,t.stroke()}));return o.image(n).stretch()},n.prototype.drawCircle=function(t,i){var e=i.lineWidth,s=i.ratio,n=t.m_radius,r=n+e,h=n+e,a=2*n+2*e,m=2*n+2*e,c=o.canvas((function(t){this.size(a,m,s),t.scale(s,s),t.arc(r,h,n,0,2*Math.PI),i.fillStyle&&(t.fillStyle=i.fillStyle,t.fill()),t.lineTo(r,h),t.lineWidth=i.lineWidth,t.strokeStyle=i.strokeStyle,t.stroke()})),_=o.image(c).offset(t.m_p.x-r,i.scaleY*t.m_p.y-h);return o.create().append(_)},n.prototype.drawEdge=function(t,i){var e=i.lineWidth,s=i.ratio,n=t.m_vertex1,r=t.m_vertex2,h=r.x-n.x,a=r.y-n.y,m=Math.sqrt(h*h+a*a),c=o.canvas((function(t){this.size(m+2*e,2*e,s),t.scale(s,s),t.beginPath(),t.moveTo(e,e),t.lineTo(e+m,e),t.lineCap="round",t.lineWidth=i.lineWidth,t.strokeStyle=i.strokeStyle,t.stroke()})),_=Math.min(n.x,r.x),l=Math.min(i.scaleY*n.y,i.scaleY*r.y),u=o.image(c);return u.rotate(i.scaleY*Math.atan2(a,h)),u.offset(_-e,l-e),o.create().append(u)},n.prototype.drawPolygon=function(t,i){var e=i.lineWidth,s=i.ratio,n=t.m_vertices;if(n.length){for(var r=1/0,h=1/0,a=-1/0,m=-1/0,c=0;c<n.length;++c){var _=n[c];r=Math.min(r,_.x),a=Math.max(a,_.x),h=Math.min(h,i.scaleY*_.y),m=Math.max(m,i.scaleY*_.y)}var l=a-r,u=m-h,p=o.canvas((function(t){this.size(l+2*e,u+2*e,s),t.scale(s,s),t.beginPath();for(var o=0;o<n.length;++o){var a=n[o],m=a.x-r+e,c=i.scaleY*a.y-h+e;0==o?t.moveTo(m,c):t.lineTo(m,c)}n.length>2&&t.closePath(),i.fillStyle&&(t.fillStyle=i.fillStyle,t.fill(),t.closePath()),t.lineCap="round",t.lineWidth=i.lineWidth,t.strokeStyle=i.strokeStyle,t.stroke()})),y=o.image(p);return y.offset(r-e,h-e),o.create().append(y)}},n.prototype.drawChain=function(t,i){var e=i.lineWidth,s=i.ratio,n=t.m_vertices;if(n.length){for(var r=1/0,h=1/0,a=-1/0,m=-1/0,c=0;c<n.length;++c){var _=n[c];r=Math.min(r,_.x),a=Math.max(a,_.x),h=Math.min(h,i.scaleY*_.y),m=Math.max(m,i.scaleY*_.y)}var l=a-r,u=m-h,p=o.canvas((function(t){this.size(l+2*e,u+2*e,s),t.scale(s,s),t.beginPath();for(var o=0;o<n.length;++o){var a=n[o],m=a.x-r+e,c=i.scaleY*a.y-h+e;0==o?t.moveTo(m,c):t.lineTo(m,c)}n.length,i.fillStyle&&(t.fillStyle=i.fillStyle,t.fill(),t.closePath()),t.lineCap="round",t.lineWidth=i.lineWidth,t.strokeStyle=i.strokeStyle,t.stroke()})),y=o.image(p);return y.offset(r-e,h-e),o.create().append(y)}}},function(t,i,e){t.exports=e(64),t.exports.internal={},e(72),t.exports.internal.Image=e(73),e(75),e(76),e(77),e(78),t.exports.Mouse=e(80),t.exports.Math=e(60),t.exports._extend=e(36),t.exports._create=e(24),e(81)},function(t,i,e){t.exports=e(19),t.exports.Matrix=e(61),t.exports.Texture=e(59),e(66),e(68),e(69),e(25),e(29),e(71)},function(t,i){t.exports=function(){var t=0;function i(i,e){return t+=e="number"==typeof e&&e>=1?e:1,function(){i&&i.apply(this,arguments),e>0&&(e--,t--,s())}}var e=[];function s(){if(0===t)for(;e.length;)setTimeout(e.shift(),0)}return i.then=function(i){0===t?setTimeout(i,0):e.push(i)},i}},function(t,i,e){var s=e(19),o=e(59),n=e(36),r=e(24),h=e(37),a=e(67),m={},c=[];function _(t){_._super.call(this);var i=this;y(t,"filter"),y(t,"cutouts"),y(t,"sprites"),y(t,"factory");var e=t.map||t.filter,s=t.ppu||t.ratio||1,o=t.trim||0,r=t.textures,m=t.factory,c=t.cutouts||t.sprites;function l(t){if(!t||h.fn(t.draw))return t;t=n({},t),h.fn(e)&&(t=e(t)),1!=s&&(t.x*=s,t.y*=s,t.width*=s,t.height*=s,t.top*=s,t.bottom*=s,t.left*=s,t.right*=s),0!=o&&(t.x+=o,t.y+=o,t.width-=2*o,t.height-=2*o,t.top-=o,t.bottom-=o,t.left-=o,t.right-=o);var r=i.pipe();return r.top=t.top,r.bottom=t.bottom,r.left=t.left,r.right=t.right,r.src(t.x,t.y,t.width,t.height),r}function u(t){if(r){if(h.fn(r))return r(t);if(h.hash(r))return r[t]}if(c){for(var i=null,e=0,s=0;s<c.length;s++)a.startsWith(c[s].name,t)&&(0===e?i=c[s]:1===e?i=[i,c[s]]:i.push(c[s]),e++);return 0===e&&h.fn(m)&&(i=function(i){return m(t+(i||""))}),i}}this.select=function(t){if(!t)return new p(this.pipe());var i=u(t);return i?new p(i,u,l):void 0}}s.atlas=function(t){var i=h.fn(t.draw)?t:new _(t);t.name&&(m[t.name]=i),c.push(i),y(t,"imagePath"),y(t,"imageRatio");var e=t.imagePath,o=t.imageRatio||1;return h.string(t.image)?e=t.image:h.hash(t.image)&&(e=t.image.src||t.image.url,o=t.image.ratio||o),e&&s.preload((function(t){e=s.resolve(e),s.config("image-loader")(e,(function(e){i.src(e,o),t()}),(function(i){t()}))})),i},_._super=o,_.prototype=r(_._super.prototype);var l=new o;l.x=l.y=l.width=l.height=0,l.pipe=l.src=l.dest=function(){return this},l.draw=function(){};var u=new p(l);function p(t,i,e){function s(t,o){return t?h.fn(t.draw)?t:h.hash(t)&&h.number(t.width)&&h.number(t.height)&&h.fn(e)?e(t):h.hash(t)&&h.defined(o)?s(t[o]):h.fn(t)?s(t(o)):h.array(t)?s(t[0]):h.string(t)&&h.fn(i)?s(i(t)):void 0:l}this.one=function(i){return s(t,i)},this.array=function(i){var e=h.array(i)?i:[];if(h.array(t))for(var o=0;o<t.length;o++)e[o]=s(t[o]);else e[0]=s(t);return e}}function y(t,i,e){i in t&&console.log(e?e.replace("%name",i):"'"+i+"' field of texture atlas is deprecated.")}s.texture=function(t){if(!h.string(t))return new p(t);var i,e,s=null;for((e=t.indexOf(":"))>0&&t.length>e+1&&(s=(i=m[t.slice(0,e)])&&i.select(t.slice(e+1))),!s&&(i=m[t])&&(s=i.select()),e=0;!s&&e<c.length;e++)s=c[e].select(t);return s||(console.error("Texture not found: "+t),s=u),s},t.exports=_},function(t,i){t.exports.startsWith=function(t,i){return"string"==typeof t&&"string"==typeof i&&t.substring(0,i.length)==i}},function(t,i,e){var s=e(19),o=e(37),n=0;function r(t,i){c(i),c(t),i.remove(),t._last&&(t._last._next=i,i._prev=t._last),i._parent=t,t._last=i,t._first||(t._first=i),i._parent._flag(i,!0),i._ts_parent=++n,t._ts_children=++n,t.touch()}function h(t,i){c(i),c(t),i.remove(),t._first&&(t._first._prev=i,i._next=t._first),i._parent=t,t._first=i,t._last||(t._last=i),i._parent._flag(i,!0),i._ts_parent=++n,t._ts_children=++n,t.touch()}function a(t,i){c(t),c(i),t.remove();var e=i._parent,s=i._prev;i._prev=t,s&&(s._next=t)||e&&(e._first=t),t._parent=e,t._prev=s,t._next=i,t._parent._flag(t,!0),t._ts_parent=++n,t.touch()}function m(t,i){c(t),c(i),t.remove();var e=i._parent,s=i._next;i._next=t,s&&(s._prev=t)||e&&(e._last=t),t._parent=e,t._prev=i,t._next=s,t._parent._flag(t,!0),t._ts_parent=++n,t.touch()}function c(t){if(t&&t instanceof s)return t;throw"Invalid node: "+t}s.prototype._label="",s.prototype._visible=!0,s.prototype._parent=null,s.prototype._next=null,s.prototype._prev=null,s.prototype._first=null,s.prototype._last=null,s.prototype._attrs=null,s.prototype._flags=null,s.prototype.toString=function(){return"["+this._label+"]"},s.prototype.id=function(t){return this.label(t)},s.prototype.label=function(t){return void 0===t?this._label:(this._label=t,this)},s.prototype.attr=function(t,i){return void 0===i?null!==this._attrs?this._attrs[t]:void 0:((null!==this._attrs?this._attrs:this._attrs={})[t]=i,this)},s.prototype.visible=function(t){return void 0===t?this._visible:(this._visible=t,this._parent&&(this._parent._ts_children=++n),this._ts_pin=++n,this.touch(),this)},s.prototype.hide=function(){return this.visible(!1)},s.prototype.show=function(){return this.visible(!0)},s.prototype.parent=function(){return this._parent},s.prototype.next=function(t){for(var i=this._next;i&&t&&!i._visible;)i=i._next;return i},s.prototype.prev=function(t){for(var i=this._prev;i&&t&&!i._visible;)i=i._prev;return i},s.prototype.first=function(t){for(var i=this._first;i&&t&&!i._visible;)i=i._next;return i},s.prototype.last=function(t){for(var i=this._last;i&&t&&!i._visible;)i=i._prev;return i},s.prototype.visit=function(t,i){var e=t.reverse,s=t.visible;if(!t.start||!t.start(this,i)){for(var o,n=e?this.last(s):this.first(s);o=n;)if(n=e?o.prev(s):o.next(s),o.visit(t,i))return!0;return t.end&&t.end(this,i)}},s.prototype.append=function(t,i){if(o.array(t))for(var e=0;e<t.length;e++)r(this,t[e]);else if(void 0!==i)for(e=0;e<arguments.length;e++)r(this,arguments[e]);else void 0!==t&&r(this,t);return this},s.prototype.prepend=function(t,i){if(o.array(t))for(var e=t.length-1;e>=0;e--)h(this,t[e]);else if(void 0!==i)for(e=arguments.length-1;e>=0;e--)h(this,arguments[e]);else void 0!==t&&h(this,t);return this},s.prototype.appendTo=function(t){return r(t,this),this},s.prototype.prependTo=function(t){return h(t,this),this},s.prototype.insertNext=function(t,i){if(o.array(t))for(var e=0;e<t.length;e++)m(t[e],this);else if(void 0!==i)for(e=0;e<arguments.length;e++)m(arguments[e],this);else void 0!==t&&m(t,this);return this},s.prototype.insertPrev=function(t,i){if(o.array(t))for(var e=t.length-1;e>=0;e--)a(t[e],this);else if(void 0!==i)for(e=arguments.length-1;e>=0;e--)a(arguments[e],this);else void 0!==t&&a(t,this);return this},s.prototype.insertAfter=function(t){return m(this,t),this},s.prototype.insertBefore=function(t){return a(this,t),this},s.prototype.remove=function(t,i){if(void 0!==t){if(o.array(t))for(var e=0;e<t.length;e++)c(t[e]).remove();else if(void 0!==i)for(e=0;e<arguments.length;e++)c(arguments[e]).remove();else c(t).remove();return this}return this._prev&&(this._prev._next=this._next),this._next&&(this._next._prev=this._prev),this._parent&&(this._parent._first===this&&(this._parent._first=this._next),this._parent._last===this&&(this._parent._last=this._prev),this._parent._flag(this,!1),this._parent._ts_children=++n,this._parent.touch()),this._prev=this._next=this._parent=null,this._ts_parent=++n,this},s.prototype.empty=function(){for(var t,i=this._first;t=i;)i=t._next,t._prev=t._next=t._parent=null,this._flag(t,!1);return this._first=this._last=null,this._ts_children=++n,this.touch(),this},s.prototype.touch=function(){return this._ts_touch=++n,this._parent&&this._parent.touch(),this},s.prototype._flag=function(t,i){if(void 0===i)return null!==this._flags&&this._flags[t]||0;if("string"==typeof t&&(i?(this._flags=this._flags||{},!this._flags[t]&&this._parent&&this._parent._flag(t,!0),this._flags[t]=(this._flags[t]||0)+1):this._flags&&this._flags[t]>0&&(1==this._flags[t]&&this._parent&&this._parent._flag(t,!1),this._flags[t]=this._flags[t]-1)),"object"==typeof t&&t._flags)for(var e in t._flags)t._flags[e]>0&&this._flag(e,i);return this},s.prototype.hitTest=function(t){return!!this.attr("spy")||t.x>=0&&t.x<=this._pin._width&&t.y>=0&&t.y<=this._pin._height},t.exports=s},function(t,i,e){e(70)(e(19).prototype,(function(t,i,e){t._flag(i,e)}))},function(t,i){t.exports=function(t,i){t._listeners=null,t.on=t.listen=function(t,e){if(!t||!t.length||"function"!=typeof e)return this;if(null===this._listeners&&(this._listeners={}),t=("string"!=typeof t&&"function"==typeof t.join?t.join(" "):t).match(/\S+/g))for(var s=0;s<t.length;s++){var o=t[s];this._listeners[o]=this._listeners[o]||[],this._listeners[o].push(e),"function"==typeof i&&i(this,o,!0)}return this},t.off=function(t,e){if(!t||!t.length||"function"!=typeof e)return this;if(null===this._listeners)return this;if(t=("string"!=typeof t&&"function"==typeof t.join?t.join(" "):t).match(/\S+/g))for(var s=0;s<t.length;s++){var o,n=t[s],r=this._listeners[n];r&&(o=r.indexOf(e))>=0&&(r.splice(o,1),r.length||delete this._listeners[n],"function"==typeof i&&i(this,n,!1))}return this},t.listeners=function(t){return this._listeners&&this._listeners[t]},t.publish=function(t,i){var e=this.listeners(t);if(!e||!e.length)return 0;for(var s=0;s<e.length;s++)e[s].apply(this,i);return e.length},t.trigger=function(t,i){return this.publish(t,i),this}}},function(t,i,e){var s=e(19);e(25),e(29);var o=e(35),n=e(24),r=e(36);function h(t,i){h._super.call(this),this.label("Root");var e=!0,s=this,n=0,r=function(h){if(!0!==e){o.tick=o.node=o.draw=0;var a=n||h,m=h-a;n=h;var c=s._tick(m,h,a);s._mo_touch!=s._ts_touch?(s._mo_touch=s._ts_touch,i(s),t(r)):c?t(r):e=!0,o.fps=m?1e3/m:0}};this.start=function(){return this.resume()},this.resume=function(){return e&&(this.publish("resume"),e=!1,t(r)),this},this.pause=function(){return e||this.publish("pause"),e=!0,this},this.touch_root=this.touch,this.touch=function(){return this.resume(),this.touch_root()}}h._super=s,h.prototype=n(h._super.prototype),s.root=function(t,i){return new h(t,i)},h.prototype.background=function(t){return this},h.prototype.viewport=function(t,i,e){if(void 0===t)return r({},this._viewport);this._viewport={width:t,height:i,ratio:e||1},this.viewbox();var s=r({},this._viewport);return this.visit({start:function(t){if(!t._flag("viewport"))return!0;t.publish("viewport",[s])}}),this},h.prototype.viewbox=function(t,i,e){"number"==typeof t&&"number"==typeof i&&(this._viewbox={width:t,height:i,mode:/^(in|out|in-pad|out-crop)$/.test(e)?e:"in-pad"});var s=this._viewbox,o=this._viewport;return o&&s?(this.pin({width:s.width,height:s.height}),this.scaleTo(o.width,o.height,s.mode)):o&&this.pin({width:o.width,height:o.height}),this}},function(t,i,e){var s=e(19),o=e(59);s.canvas=function(t,i,e){"string"==typeof t?"object"==typeof i||("function"==typeof i&&(e=i),i={}):("function"==typeof t&&(e=t),i={},t="2d");var s=document.createElement("canvas"),n=s.getContext(t,i),r=new o(s);return r.context=function(){return n},r.size=function(t,i,e){return e=e||1,s.width=t*e,s.height=i*e,this.src(s,e),this},r.canvas=function(t){return"function"==typeof t?t.call(this,n):void 0===t&&"function"==typeof e&&e.call(this,n),this},"function"==typeof e&&e.call(r,n),r}},function(t,i,e){var s=e(19);e(25),e(29);var o=e(74),n=e(24);function r(){r._super.call(this),this.label("Image"),this._textures=[],this._image=null}t.exports=r,s.image=function(t){var i=new r;return t&&i.image(t),i},r._super=s,r.prototype=n(r._super.prototype),r.prototype.setImage=function(t,i,e){return this.image(t,i,e)},r.prototype.image=function(t){return this._image=s.texture(t).one(),this.pin("width",this._image?this._image.width:0),this.pin("height",this._image?this._image.height:0),this._textures[0]=this._image.pipe(),this._textures.length=1,this},r.prototype.tile=function(t){return this._repeat(!1,t),this},r.prototype.stretch=function(t){return this._repeat(!0,t),this},r.prototype._repeat=function(t,i){var e=this;function s(t,i,s,o,n,r,h,a,m){var c=e._textures.length>t?e._textures[t]:e._textures[t]=e._image.pipe();c.src(i,s,o,n),c.dest(r,h,a,m)}this.untick(this._repeatTicker),this.tick(this._repeatTicker=function(){if(this._mo_stretch!=this._pin._ts_transform){this._mo_stretch=this._pin._ts_transform;var e=this.pin("width"),n=this.pin("height");this._textures.length=o(this._image,e,n,t,i,s)}})}},function(t,i){t.exports=function(t,i,e,s,o,n){var r=t.width,h=t.height,a=t.left,m=t.right,c=t.top,_=t.bottom;r=r-(a="number"==typeof a&&a==a?a:0)-(m="number"==typeof m&&m==m?m:0),h=h-(c="number"==typeof c&&c==c?c:0)-(_="number"==typeof _&&_==_?_:0),o||(i=Math.max(i-a-m,0),e=Math.max(e-c-_,0));var l=0;if(c>0&&a>0&&n(l++,0,0,a,c,0,0,a,c),_>0&&a>0&&n(l++,0,h+c,a,_,0,e+c,a,_),c>0&&m>0&&n(l++,r+a,0,m,c,i+a,0,m,c),_>0&&m>0&&n(l++,r+a,h+c,m,_,i+a,e+c,m,_),s)c>0&&n(l++,a,0,r,c,a,0,i,c),_>0&&n(l++,a,h+c,r,_,a,e+c,i,_),a>0&&n(l++,0,c,a,h,0,c,a,e),m>0&&n(l++,r+a,c,m,h,i+a,c,m,e),n(l++,a,c,r,h,a,c,i,e);else for(var u,p=a,y=i;y>0;){u=Math.min(r,y),y-=r;for(var d,f=c,v=e;v>0;)d=Math.min(h,v),v-=h,n(l++,a,c,u,d,p,f,u,d),y<=0&&(a&&n(l++,0,c,a,d,0,f,a,d),m&&n(l++,r+a,c,m,d,p+u,f,m,d)),f+=d;c&&n(l++,a,0,u,c,p,0,u,c),_&&n(l++,a,h+c,u,_,p,f,u,_),p+=u}return l}},function(t,i,e){var s=e(19);e(25),e(29);var o=e(24),n=e(60);function r(){r._super.call(this),this.label("Anim"),this._textures=[],this._fps=s.Anim.FPS,this._ft=1e3/this._fps,this._time=-1,this._repeat=0,this._index=0,this._frames=[];var t=0;this.tick((function(i,e,s){if(!(this._time<0||this._frames.length<=1)){var o=t!=s;if(t=e,o)return!0;if(this._time+=i,this._time<this._ft)return!0;var n=this._time/this._ft|0;return this._time-=n*this._ft,this.moveFrame(n),!(this._repeat>0&&(this._repeat-=n)<=0)||(this.stop(),this._callback&&this._callback(),!1)}}),!1)}s.anim=function(t,i){var e=new r;return e.frames(t).gotoFrame(0),i&&e.fps(i),e},r._super=s,r.prototype=o(r._super.prototype),s.Anim={FPS:15},r.prototype.fps=function(t){return void 0===t?this._fps:(this._fps=t>0?t:s.Anim.FPS,this._ft=1e3/this._fps,this)},r.prototype.setFrames=function(t,i,e){return this.frames(t,i,e)},r.prototype.frames=function(t){return this._index=0,this._frames=s.texture(t).array(),this.touch(),this},r.prototype.length=function(){return this._frames?this._frames.length:0},r.prototype.gotoFrame=function(t,i){return this._index=0|n.rotate(t,this._frames.length),i=i||!this._textures[0],this._textures[0]=this._frames[this._index],i&&(this.pin("width",this._textures[0].width),this.pin("height",this._textures[0].height)),this.touch(),this},r.prototype.moveFrame=function(t){return this.gotoFrame(this._index+t)},r.prototype.repeat=function(t,i){return this._repeat=t*this._frames.length-1,this._callback=i,this.play(),this},r.prototype.play=function(t){return void 0!==t?(this.gotoFrame(t),this._time=0):this._time<0&&(this._time=0),this.touch(),this},r.prototype.stop=function(t){return this._time=-1,void 0!==t&&this.gotoFrame(t),this}},function(t,i,e){var s=e(19);e(25),e(29);var o=e(24),n=e(37);function r(){r._super.call(this),this.label("String"),this._textures=[]}s.string=function(t){return(new r).frames(t)},r._super=s,r.prototype=o(r._super.prototype),r.prototype.setFont=function(t,i,e){return this.frames(t,i,e)},r.prototype.frames=function(t){return this._textures=[],"string"==typeof t?(t=s.texture(t),this._item=function(i){return t.one(i)}):"object"==typeof t?this._item=function(i){return t[i]}:"function"==typeof t&&(this._item=t),this},r.prototype.setValue=function(t,i,e){return this.value(t,i,e)},r.prototype.value=function(t){if(void 0===t)return this._value;if(this._value===t)return this;this._value=t,null===t?t="":"string"==typeof t||n.array(t)||(t=t.toString()),this._spacing=this._spacing||0;for(var i=0,e=0,s=0;s<t.length;s++){var o=this._textures[s]=this._item(t[s]);i+=s>0?this._spacing:0,o.dest(i,0),i+=o.width,e=Math.max(e,o.height)}return this.pin("width",i),this.pin("height",e),this._textures.length=t.length,this}},function(t,i,e){var s=e(19);e(25),e(29);e(24);s.row=function(t){return s.create().row(t).label("Row")},s.prototype.row=function(t){return this.sequence("row",t),this},s.column=function(t){return s.create().column(t).label("Row")},s.prototype.column=function(t){return this.sequence("column",t),this},s.sequence=function(t,i){return s.create().sequence(t,i).label("Sequence")},s.prototype.sequence=function(t,i){return this._padding=this._padding||0,this._spacing=this._spacing||0,this.untick(this._layoutTiker),this.tick(this._layoutTiker=function(){if(this._mo_seq!=this._ts_touch){this._mo_seq=this._ts_touch;var e=this._mo_seqAlign!=this._ts_children;this._mo_seqAlign=this._ts_children;for(var s,o=0,n=0,r=this.first(!0),h=!0;s=r;){r=s.next(!0),s.matrix(!0);var a=s.pin("boxWidth"),m=s.pin("boxHeight");"column"==t?(!h&&(n+=this._spacing),s.pin("offsetY")!=n&&s.pin("offsetY",n),o=Math.max(o,a),n+=m,e&&s.pin("alignX",i)):"row"==t&&(!h&&(o+=this._spacing),s.pin("offsetX")!=o&&s.pin("offsetX",o),o+=a,n=Math.max(n,m),e&&s.pin("alignY",i)),h=!1}o+=2*this._padding,n+=2*this._padding,this.pin("width")!=o&&this.pin("width",o),this.pin("height")!=n&&this.pin("height",n)}}),this},s.box=function(){return s.create().box().label("Box")},s.prototype.box=function(){return this._padding=this._padding||0,this.untick(this._layoutTiker),this.tick(this._layoutTiker=function(){if(this._mo_box!=this._ts_touch){this._mo_box=this._ts_touch;for(var t,i=0,e=0,s=this.first(!0);t=s;){s=t.next(!0),t.matrix(!0);var o=t.pin("boxWidth"),n=t.pin("boxHeight");i=Math.max(i,o),e=Math.max(e,n)}i+=2*this._padding,e+=2*this._padding,this.pin("width")!=i&&this.pin("width",i),this.pin("height")!=e&&this.pin("height",e)}}),this},s.layer=function(){return s.create().layer().label("Layer")},s.prototype.layer=function(){return this.untick(this._layoutTiker),this.tick(this._layoutTiker=function(){var t=this.parent();if(t){var i=t.pin("width");this.pin("width")!=i&&this.pin("width",i);var e=t.pin("height");this.pin("height")!=e&&this.pin("height",e)}},!0),this},s.prototype.padding=function(t){return this._padding=t,this},s.prototype.spacing=function(t){return this._spacing=t,this}},function(t,i,e){var s=e(79),o=e(19),n=e(25);function r(t,i,e){this._end={},this._duration=i||400,this._delay=e||0,this._owner=t,this._time=0}function h(t,i,e,s){"number"==typeof t.pin(e)?i[e]=s:"number"==typeof t.pin(e+"X")&&"number"==typeof t.pin(e+"Y")&&(i[e+"X"]=s,i[e+"Y"]=s)}o.prototype.tween=function(t,i,e){if("number"!=typeof t?(e=t,i=0,t=0):"number"!=typeof i&&(e=i,i=0),!this._tweens){this._tweens=[];var s=0;this.tick((function(t,i,e){if(this._tweens.length){var o=s!=e;if(s=i,o)return!0;var n=this._tweens[0],r=n.tick(this,t,i,e);if(r&&n===this._tweens[0]&&this._tweens.shift(),"function"==typeof r)try{r.call(this)}catch(t){console.log(t)}return"object"==typeof r&&this._tweens.unshift(r),!0}}),!0)}this.touch(),e||(this._tweens.length=0);var o=new r(this,t,i);return this._tweens.push(o),o},r.prototype.tick=function(t,i,e,s){if(this._time+=i,!(this._time<this._delay)){var o,n,r=this._time-this._delay;if(!this._start)for(var h in this._start={},this._end)this._start[h]=this._owner.pin(h);r<this._duration?(o=r/this._duration,n=!1):(o=1,n=!0),"function"==typeof this._easing&&(o=this._easing(o));var a=1-o;for(var h in this._end)this._owner.pin(h,this._start[h]*a+this._end[h]*o);return n?this._next||this._done||!0:void 0}},r.prototype.tween=function(t,i){return this._next=new r(this._owner,t,i)},r.prototype.duration=function(t){return this._duration=t,this},r.prototype.delay=function(t){return this._delay=t,this},r.prototype.ease=function(t){return this._easing=s(t),this},r.prototype.done=function(t){return this._done=t,this},r.prototype.hide=function(){return this.done((function(){this.hide()})),this},r.prototype.remove=function(){return this.done((function(){this.remove()})),this},r.prototype.pin=function(t,i){if("object"==typeof t)for(var e in t)h(this._owner,this._end,e,t[e]);else void 0!==i&&h(this._owner,this._end,t,i);return this},n._add_shortcuts(r),r.prototype.then=function(t){return this.done(t),this},r.prototype.clear=function(t){return this},t.exports=r},function(t,i){function e(t){return t}var s={},o={},n={};function r(t){if("function"==typeof t)return t;if("string"!=typeof t)return e;var i=s[t];if(i)return i;var r=/^(\w+)(-(in|out|in-out|out-in))?(\((.*)\))?$/i.exec(t);if(!r||!r.length)return e;var h=n[r[1]],a=o[r[3]],m=r[5];return i=h&&h.fn?h.fn:h&&h.fc?h.fc.apply(h.fc,m&&m.replace(/\s+/,"").split(",")):e,a&&(i=a.fn(i)),s[t]=i,i}r.add=function(t){for(var i=(t.name||t.mode).split(/\s+/),e=0;e<i.length;e++){var s=i[e];s&&((t.name?n:o)[s]=t)}},r.add({mode:"in",fn:function(t){return t}}),r.add({mode:"out",fn:function(t){return function(i){return 1-t(1-i)}}}),r.add({mode:"in-out",fn:function(t){return function(i){return i<.5?t(2*i)/2:1-t(2*(1-i))/2}}}),r.add({mode:"out-in",fn:function(t){return function(i){return i<.5?1-t(2*(1-i))/2:t(2*i)/2}}}),r.add({name:"linear",fn:function(t){return t}}),r.add({name:"quad",fn:function(t){return t*t}}),r.add({name:"cubic",fn:function(t){return t*t*t}}),r.add({name:"quart",fn:function(t){return t*t*t*t}}),r.add({name:"quint",fn:function(t){return t*t*t*t*t}}),r.add({name:"sin sine",fn:function(t){return 1-Math.cos(t*Math.PI/2)}}),r.add({name:"exp expo",fn:function(t){return 0==t?0:Math.pow(2,10*(t-1))}}),r.add({name:"circle circ",fn:function(t){return 1-Math.sqrt(1-t*t)}}),r.add({name:"bounce",fn:function(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375}}),r.add({name:"poly",fc:function(t){return function(i){return Math.pow(i,t)}}}),r.add({name:"elastic",fc:function(t,i){t=t||1;var e=(i=i||.45)/(2*Math.PI)*Math.asin(1/t);return function(s){return 1+t*Math.pow(2,-10*s)*Math.sin((s-e)*(2*Math.PI)/i)}}}),r.add({name:"back",fc:function(t){return t=void 0!==t?t:1.70158,function(i){return i*i*((t+1)*i-t)}}}),t.exports=r},function(t,i,e){function s(t,i){if(this instanceof s){var e=t.viewport().ratio||1;t.on("viewport",(function(t){e=t.ratio||e})),this.x=0,this.y=0,this.toString=function(){return(0|this.x)+"x"+(0|this.y)},this.locate=function(t){!function(t,i,e){i.touches&&i.touches.length?(e.x=i.touches[0].clientX,e.y=i.touches[0].clientY):(e.x=i.clientX,e.y=i.clientY);var s=t.getBoundingClientRect();e.x-=s.left,e.y-=s.top,e.x-=0|t.clientLeft,e.y-=0|t.clientTop}(i,t,this),this.x*=e,this.y*=e},this.lookup=function(i,e){this.type=i,this.root=t,this.event=null,e.length=0,this.collect=e,this.root.visit(this.visitor,this)},this.publish=function(i,e,s){if(this.type=i,this.root=t,this.event=e,this.collect=!1,this.timeStamp=Date.now(),s){for(;s.length&&!this.visitor.end(s.shift(),this););s.length=0}else this.root.visit(this.visitor,this)},this.visitor={reverse:!0,visible:!0,start:function(t,i){return!t._flag(i.type)},end:function(t,i){o.raw=i.event,o.type=i.type,o.timeStamp=i.timeStamp,o.abs.x=i.x,o.abs.y=i.y;var e=t.listeners(i.type);if(e&&(t.matrix().inverse().map(i,o),(t===i.root||t.hitTest(o))&&(i.collect&&i.collect.push(t),i.event))){for(var s=!1,n=0;n<e.length;n++)s=!!e[n].call(t,o)||s;return s}}}}}e(19)._load((function(t,i){s.subscribe(t,i)})),s.CLICK="click",s.START="touchstart mousedown",s.MOVE="touchmove mousemove",s.END="touchend mouseup",s.CANCEL="touchcancel mousecancel",s.subscribe=function(t,i){if(!t.mouse){t.mouse=new s(t,i),i.addEventListener("touchstart",n),i.addEventListener("touchend",h),i.addEventListener("touchmove",r),i.addEventListener("touchcancel",a),i.addEventListener("mousedown",n),i.addEventListener("mouseup",h),i.addEventListener("mousemove",r),document.addEventListener("mouseup",a),window.addEventListener("blur",a);var e=[],o=[]}function n(i){i.preventDefault(),t.mouse.locate(i),t.mouse.publish(i.type,i),t.mouse.lookup("click",e),t.mouse.lookup("mousecancel",o)}function r(i){i.preventDefault(),t.mouse.locate(i),t.mouse.publish(i.type,i)}function h(i){i.preventDefault(),t.mouse.publish(i.type,i),e.length&&t.mouse.publish("click",i,e),o.length=0}function a(i){o.length&&t.mouse.publish("mousecancel",i,o),e.length=0}};var o={},n={};function r(t,i,e){Object.defineProperty(t,i,{value:e})}r(o,"clone",(function(t){return(t=t||{}).x=this.x,t.y=this.y,t})),r(o,"toString",(function(){return(0|this.x)+"x"+(0|this.y)+" ("+this.abs+")"})),r(o,"abs",n),r(n,"clone",(function(t){return(t=t||{}).x=this.x,t.y=this.y,t})),r(n,"toString",(function(){return(0|this.x)+"x"+(0|this.y)})),t.exports=s},function(t,i,e){var s,o=e(19);o._supported=!(!(s=document.createElement("canvas")).getContext||!s.getContext("2d")),window.addEventListener("load",(function(){o._supported&&o.start()}),!1),o.config({"app-loader":function(t,i){var e,s=(i=i||{}).canvas,n=null,r=!1,h=0,a=0;"string"==typeof s&&(s=document.getElementById(s));s||(s=document.getElementById("cutjs")||document.getElementById("stage"));if(!s){r=!0,(s=document.createElement("canvas")).style.position="absolute",s.style.top="0",s.style.left="0";var m=document.body;m.insertBefore(s,m.firstChild)}n=s.getContext("2d");var c=window.devicePixelRatio||1,_=n.webkitBackingStorePixelRatio||n.mozBackingStorePixelRatio||n.msBackingStorePixelRatio||n.oBackingStorePixelRatio||n.backingStorePixelRatio||1;e=c/_;var l=window.requestAnimationFrame||window.msRequestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.oRequestAnimationFrame||function(t){return window.setTimeout(t,1e3/60)};var u=o.root(l,p);function p(){n.setTransform(1,0,0,1,0,0),n.clearRect(0,0,h,a),u.render(n)}function y(){r?(h=window.innerWidth>0?window.innerWidth:screen.width,a=window.innerHeight>0?window.innerHeight:screen.height,s.style.width=h+"px",s.style.height=a+"px"):(h=s.clientWidth,a=s.clientHeight),h*=e,a*=e,s.width===h&&s.height===a||(s.width=h,s.height=a,u.viewport(h,a,e),p())}u.background=function(t){return s.style.backgroundColor=t,this},t(u,s),y(),window.addEventListener("resize",y,!1),window.addEventListener("orientationchange",y,!1)},"image-loader":function(t,i,e){var s=new Image;s.onload=function(){i(s)},s.onerror=e,s.src=t}})}])}));
//# sourceMappingURL=planck-with-testbed.min.js.map