---
layout: default
title: Update to v0.23.0
parent: Update
grand_parent: Install Script
redirect_from:
  - /installation/update/v0.23.0
  - /installation/update/v0.23.0.html
nav_order: 1
---

# Updating to v0.23.0
{: .no_toc }

Since v0.23.0, AliasVault has moved from `lanedirt/aliasvault` to the new `aliasvault/aliasvault` GitHub organization, and Docker image names have been simplified.

## Update Methods

### 1. Installed via install.sh

If you have installed AliasVault using the official `install.sh` method, you don't need to do anything. Running the built-in `install.sh update` command will take care of all necessary changes for you.

```bash
./install.sh update
```

### 2. Manually installed

If you have manually installed AliasVault via a custom `docker-compose.yml` file or other Docker management interface such as Portainer, you need to update your Docker image references.

#### Docker Image Name Changes

Update all Docker image references in your `docker-compose.yml` file according to this mapping:

| Old Image Name | New Image Name |
|----------------|----------------|
| ghcr.io/lanedirt/aliasvault-postgres | ghcr.io/aliasvault/postgres |
| ghcr.io/lanedirt/aliasvault-reverse-proxy | ghcr.io/aliasvault/reverse-proxy |
| ghcr.io/lanedirt/aliasvault-api | ghcr.io/aliasvault/api |
| ghcr.io/lanedirt/aliasvault-client | ghcr.io/aliasvault/client |
| ghcr.io/lanedirt/aliasvault-admin | ghcr.io/aliasvault/admin |
| ghcr.io/lanedirt/aliasvault-smtp | ghcr.io/aliasvault/smtp |
| ghcr.io/lanedirt/aliasvault-task-runner | ghcr.io/aliasvault/task-runner |

#### Example docker-compose.yml Update

**Before (v0.22.0 and earlier):**
```yaml
services:
  postgres:
    image: ghcr.io/lanedirt/aliasvault-postgres:0.22.0

  reverse-proxy:
    image: ghcr.io/lanedirt/aliasvault-reverse-proxy:0.22.0

  api:
    image: ghcr.io/lanedirt/aliasvault-api:0.22.0

  client:
    image: ghcr.io/lanedirt/aliasvault-client:0.22.0

  admin:
    image: ghcr.io/lanedirt/aliasvault-admin:0.22.0

  smtp:
    image: ghcr.io/lanedirt/aliasvault-smtp:0.22.0

  task-runner:
    image: ghcr.io/lanedirt/aliasvault-task-runner:0.22.0
```

**After (v0.23.0 and later):**
```yaml
services:
  postgres:
    image: ghcr.io/aliasvault/postgres:0.23.0

  reverse-proxy:
    image: ghcr.io/aliasvault/reverse-proxy:0.23.0

  api:
    image: ghcr.io/aliasvault/api:0.23.0

  client:
    image: ghcr.io/aliasvault/client:0.23.0

  admin:
    image: ghcr.io/aliasvault/admin:0.23.0

  smtp:
    image: ghcr.io/aliasvault/smtp:0.23.0

  task-runner:
    image: ghcr.io/aliasvault/task-runner:0.23.0
```

#### Update and restart

After updating your `docker-compose.yml`, pull the latest images and restart your containers:

```bash
docker-compose pull
docker-compose down
docker-compose up -d
```

If you encounter any issues during the upgrade, please join the AliasVault Discord, create an issue on GitHub or contact us by email.