---
layout: default
title: Update to v0.22.0
parent: Update
grand_parent: Install Script
redirect_from:
  - /installation/update/v0.22.0
  - /installation/update/v0.22.0.html
nav_order: 2
---

# Updating to v0.22.0
{: .no_toc }

Since v0.22.0, the AliasVault docker structure has changed due to the introduction of the new (optional) all-in-one docker image that simplifies self-hosting use for NAS/Unraid and other home use. Data structure changes involve secrets that have moved from .env to a new `./secrets` bind mount, and several other .env params that are now optional and do not require to be explicitly set for a clean install.

## Update Methods

### 1. Installed via install.sh

If you have installed AliasVault using the official `install.sh` method, you don't need to do anything. Running the built-in `install.sh update` command will take care of all necessary data migrations for you.

```bash
./install.sh update
```

### 2. Manually installed

If you have manually installed AliasVault via a custom `docker-compose.yml` file or other Docker management interface such as Portainer, follow the following manual steps:

#### Step 1: Move secrets from .env to ./secrets folder

Create a new `./secrets` folder and move your secrets from environment variables to individual text files:

```bash
mkdir -p ./secrets
```

**Migration mapping:**

| Old .env key | New file location | File content format |
|--------------|-------------------|-------------------|
| `ADMIN_PASSWORD_HASH + ADMIN_PASSWORD_GENERATED` | `./secrets/admin_password_hash` | `hash|generated` |
| `DATA_PROTECTION_CERT_PASS` | `./secrets/data_protection_cert_pass` | `password` |
| `JWT_KEY` | `./secrets/jwt_key` | `key` |
| `POSTGRES_PASSWORD` | `./secrets/postgres_password` | `password` |

**Update permissions for new secret files:**

```bash
# Set proper permissions
chmod 600 ./secrets/*
```

The final structure should look like:
```
-rw------- 1 root root  106 Aug  8 11:30 admin_password_hash
-rw------- 1 root root   44 Aug  7 22:46 data_protection_cert_pass
-rw------- 1 root root   44 Aug  7 22:46 jwt_key
-rw------- 1 root root   44 Aug  7 22:46 postgres_password
```

#### Step 2: Update docker-compose.yml

Update your `docker-compose.yml` to mount the new `./secrets` folder to `/secrets` in the `api`, `admin`, `smtp` and `taskrunner` containers:

```yaml
services:
  api:
    # ... other configuration
    volumes:
      - ./secrets:/secrets:ro
      # ... other volumes

  admin:
    # ... other configuration
    volumes:
      - ./secrets:/secrets:ro
      # ... other volumes

  smtp:
    # ... other configuration
    volumes:
        - ./secrets:/secrets:ro
        # ... other volumes

  task-runner:
      # ... other configuration
    volumes:
        - ./secrets:/secrets:ro
        # ... other volumes
```

#### Step 3: Remove optional environment variables (optional)

You can optionally remove the following environment variables from .env as they now fallback to default values:

- `HOSTNAME` (defaults to auto-detection)
- `PUBLIC_REGISTRATION_ENABLED` (defaults to true/enabled)
- `IP_LOGGING_ENABLED` (defaults to true/enabled)

#### Step 4: Update and restart

Pull the latest images and restart your containers:

```bash
docker-compose pull
docker-compose down
docker-compose up -d
```

If you encounter any issues during the upgrade, please join the AliasVault Discord, create an issue on GitHub or contact us by email.
