

# Diagrams

This folder contains architecture and flow diagrams for AliasVault in various formats.

## Draw.io Diagrams (.drawio)
Files with `.drawio` extension are created with Draw.io (also known as diagrams.net), an open-source diagramming tool.

### How to Open/Edit Draw.io Files
1. Web Interface (Cloud)
    - Visit [diagrams.net](https://app.diagrams.net/)
    - Open source code available at [github.com/jgraph/drawio](https://github.com/jgraph/drawio)

2. Desktop Applications (Offline)
    - Available for Windows, macOS, and Linux
    - Download from [github.com/jgraph/drawio-desktop/releases](https://github.com/jgraph/drawio-desktop/releases)
    - Open source code available at [github.com/jgraph/drawio-desktop](https://github.com/jgraph/drawio-desktop)

3. VS Code Extension
    - Install the [Draw.io Integration](https://marketplace.visualstudio.com/items?itemName=hediet.vscode-drawio) extension
    - Edit diagrams directly within VS Code
    - Source code at [github.com/hediet/vscode-drawio](https://github.com/hediet/vscode-drawio)

## Mermaid Diagrams (.mmd)
Files with `.mmd` extension are [Mermaid](https://mermaid.js.org/) format diagrams. These are text-based diagram definitions that can be rendered by various tools.

### Editors & Tools for Mermaid
- [Mermaid Live Editor](https://github.com/mermaid-js/mermaid-live-editor) - Web-based editor with live preview
- [VS Code Mermaid Extension](https://github.com/mermaid-js/vscode-mermaid) - Preview and edit Mermaid diagrams directly in VS Code
- [Obsidian Mermaid Plugin](https://github.com/jobindj/obsidian-mermaid) - If you use Obsidian for documentation
- [GitLab](https://docs.gitlab.com/ee/user/markdown.html#mermaid) and [GitHub](https://github.blog/2022-02-14-include-diagrams-markdown-files-mermaid/) both render Mermaid diagrams natively in markdown
