import { type ImportFormat, type SubtleAlgorithm, type KeyUsage, CryptoKey, type AnyAlgorithm, type JWK, type CryptoKeyPair, type EncryptDecryptParams } from './keys';
import { type BufferLike, type BinaryLike } from './Utils';
export declare class Subtle {
    decrypt(algorithm: EncryptDecryptParams, key: CryptoKey, data: BufferLike): Promise<ArrayBuffer>;
    digest(algorithm: SubtleAlgorithm | AnyAlgorithm, data: BufferLike): Promise<ArrayBuffer>;
    deriveBits(algorithm: SubtleAlgorithm, baseKey: CryptoKey, length: number): Promise<ArrayBuffer>;
    encrypt(algorithm: EncryptDecryptParams, key: CryptoKey, data: BufferLike): Promise<ArrayBuffer>;
    exportKey(format: ImportFormat, key: CryptoKey): Promise<ArrayBuffer | JWK>;
    generateKey(algorithm: SubtleAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey | CryptoKeyPair>;
    importKey(format: ImportFormat, data: BufferLike | BinaryLike | JWK, algorithm: SubtleAlgorithm | AnyAlgorithm, extractable: boolean, keyUsages: KeyUsage[]): Promise<CryptoKey>;
    sign(algorithm: SubtleAlgorithm, key: CryptoKey, data: BufferLike): Promise<ArrayBuffer>;
    verify(algorithm: SubtleAlgorithm, key: CryptoKey, signature: BufferLike, data: BufferLike): Promise<ArrayBuffer>;
}
export declare const subtle: Subtle;
//# sourceMappingURL=subtle.d.ts.map