import Stream, { type WritableOptions } from 'readable-stream';
import { type BinaryLike } from './Utils';
import { type EncodingOptions } from './keys';
declare class Verify extends Stream.Writable {
    private internal;
    constructor(algorithm: string, options?: WritableOptions);
    _write(chunk: BinaryLike, encoding: string, callback: () => void): void;
    update(data: BinaryLike, encoding?: string): this;
    verify(options: EncodingOptions, signature: BinaryLike): boolean;
}
declare class Sign extends Stream.Writable {
    private internal;
    constructor(algorithm: string, options?: WritableOptions);
    _write(chunk: BinaryLike, encoding: string, callback: () => void): void;
    update(data: BinaryLike, encoding?: string): this;
    sign(options: EncodingOptions, encoding?: string): string | Buffer<ArrayBuffer>;
}
export declare function createSign(algorithm: string, options?: WritableOptions): Sign;
export declare function createVerify(algorithm: string, options?: WritableOptions): Verify;
export {};
//# sourceMappingURL=sig.d.ts.map