import { type BufferLike } from './Utils';
import { CryptoKey, type ImportFormat, type JWK, type KeyUsage, type SubtleAlgorithm, type CryptoKeyPair, KWebCryptoKeyFormat, CipherOrWrapMode, type RsaOaepParams } from './keys';
export declare enum RSAKeyVariant {
    RSA_SSA_PKCS1_v1_5 = 0,
    RSA_PSS = 1,
    RSA_OAEP = 2
}
export declare const rsaCipher: (mode: CipherOrWrapMode, key: CryptoKey, data: ArrayBuffer, { label }: RsaOaepParams) => Promise<ArrayBuffer>;
export declare const rsaKeyGenerate: (algorithm: SubtleAlgorithm, extractable: boolean, keyUsages: KeyUsage[]) => Promise<CryptoKeyPair>;
export declare const rsaExportKey: (key: CryptoKey, format: KWebCryptoKeyFormat) => ArrayBuffer;
export declare const rsaImportKey: (format: ImportFormat, keyData: BufferLike | JWK, algorithm: SubtleAlgorithm, extractable: boolean, keyUsages: KeyUsage[]) => CryptoKey;
//# sourceMappingURL=rsa.d.ts.map