import { Buffer } from '@craftzdog/react-native-buffer';
import { type BinaryLike } from './Utils';
import type { CryptoKey, SubtleAlgorithm } from './keys';
type Password = BinaryLike;
type Salt = BinaryLike;
type Pbkdf2Callback = (err: Error | null, derivedKey?: Buffer) => void;
export declare function pbkdf2(password: Password, salt: Salt, iterations: number, keylen: number, digest: string, callback: Pbkdf2Callback): void;
export declare function pbkdf2Sync(password: Password, salt: Salt, iterations: number, keylen: number, digest?: string): Buffer;
export declare function pbkdf2DeriveBits(algorithm: SubtleAlgorithm, baseKey: CryptoKey, length: number): Promise<ArrayBuffer>;
export {};
//# sourceMappingURL=pbkdf2.d.ts.map