import { type BufferLike } from './Utils';
import { type ImportFormat, type SubtleAlgorithm, type KeyUsage, CryptoKey, type JWK, CipherOrWrapMode, type EncryptDecryptParams, type AesKeyGenParams } from './keys';
export declare enum AESKeyVariant {
    AES_CTR_128 = 0,
    AES_CTR_192 = 1,
    AES_CTR_256 = 2,
    AES_CBC_128 = 3,
    AES_CBC_192 = 4,
    AES_CBC_256 = 5,
    AES_GCM_128 = 6,
    AES_GCM_192 = 7,
    AES_GCM_256 = 8,
    AES_KW_128 = 9,
    AES_KW_192 = 10,
    AES_KW_256 = 11
}
export declare const kAesKeyLengths: number[];
export declare const getAlgorithmName: (name: string, length?: number) => string;
export declare const aesCipher: (mode: CipherOrWrapMode, key: CryptoKey, data: ArrayBuffer, algorithm: EncryptDecryptParams) => Promise<ArrayBuffer>;
export declare const aesGenerateKey: (algorithm: AesKeyGenParams, extractable: boolean, keyUsages: KeyUsage[]) => Promise<CryptoKey>;
export declare const aesImportKey: (algorithm: SubtleAlgorithm, format: ImportFormat, keyData: BufferLike | JWK, extractable: boolean, keyUsages: KeyUsage[]) => Promise<CryptoKey>;
//# sourceMappingURL=aes.d.ts.map