import Stream, { type TransformOptions } from 'readable-stream';
import { type BinaryLike, type CipherEncoding, type Encoding, type BinaryLikeNode, type CipherType } from './Utils';
import type { CipherCCMOptions, CipherCCMTypes, CipherGCMTypes, CipherGCMOptions, CipherOCBOptions, CipherOCBTypes, DecipherGCM, DecipherOCB, DecipherCCM, CipherCCM, CipherOCB, CipherGCM } from 'crypto';
import { Buffer } from '@craftzdog/react-native-buffer';
import { CryptoKey, type CryptoKeyPair, type EncodingOptions, type KeyPairType } from './keys';
import type { KeyObjectHandle } from './NativeQuickCrypto/webcrypto';
export declare enum ECCurve {
    OPENSSL_EC_EXPLICIT_CURVE = 0,
    OPENSSL_EC_NAMED_CURVE = 1
}
declare class CipherCommon extends Stream.Transform {
    private internal;
    private decoder;
    constructor(cipherType: string, cipherKey: BinaryLikeNode, isCipher: boolean, options?: Record<string, TransformOptions>, iv?: BinaryLike | null);
    update(data: BinaryLike, inputEncoding?: CipherEncoding, outputEncoding?: CipherEncoding): ArrayBuffer | string;
    final(): ArrayBuffer;
    final(outputEncoding: BufferEncoding | 'buffer'): string;
    _transform(chunk: BinaryLike, encoding: Encoding, callback: () => void): void;
    _flush(callback: () => void): void;
    setAutoPadding(autoPadding?: boolean): this;
    setAAD(buffer: Buffer, options?: {
        plaintextLength: number;
    }): this;
    getAuthTag(): Buffer;
    setAuthTag(tag: Buffer): this;
}
declare class Cipher extends CipherCommon {
    constructor(cipherType: string, cipherKey: BinaryLikeNode, options?: Record<string, TransformOptions>, iv?: BinaryLike | null);
}
declare class Decipher extends CipherCommon {
    constructor(cipherType: string, cipherKey: BinaryLikeNode, options?: Record<string, TransformOptions>, iv?: BinaryLike | null);
}
/**
 * @deprecated Use createDecipheriv instead.  This function will be removed in 1.0+
 */
export declare function createDecipher(algorithm: CipherCCMTypes, password: BinaryLikeNode, options: CipherCCMOptions): DecipherCCM;
/**
 * @deprecated Use createDecipheriv instead.  This function will be removed in 1.0+
 */
export declare function createDecipher(algorithm: CipherGCMTypes, password: BinaryLikeNode, options?: CipherGCMOptions): DecipherGCM;
/**
 * @deprecated Use createDecipheriv instead.  This function will be removed in 1.0+
 */
export declare function createDecipher(algorithm: CipherType, password: BinaryLikeNode, options?: Stream.TransformOptions): DecipherCCM | DecipherGCM | Decipher;
export declare function createDecipheriv(algorithm: CipherCCMTypes, key: BinaryLikeNode, iv: BinaryLike, options: CipherCCMOptions): DecipherCCM;
export declare function createDecipheriv(algorithm: CipherOCBTypes, key: BinaryLikeNode, iv: BinaryLike, options: CipherOCBOptions): DecipherOCB;
export declare function createDecipheriv(algorithm: CipherGCMTypes, key: BinaryLikeNode, iv: BinaryLike, options?: CipherGCMOptions): DecipherGCM;
export declare function createDecipheriv(algorithm: CipherType, key: BinaryLikeNode, iv: BinaryLike | null, options?: Stream.TransformOptions): DecipherCCM | DecipherOCB | DecipherGCM | Decipher;
/**
 * @deprecated Use createCipheriv instead.  This function will be removed in 1.0+
 */
export declare function createCipher(algorithm: CipherCCMTypes, password: BinaryLikeNode, options: CipherCCMOptions): CipherCCM;
/**
 * @deprecated Use createCipheriv instead.  This function will be removed in 1.0+
 */
export declare function createCipher(algorithm: CipherGCMTypes, password: BinaryLikeNode, options?: CipherGCMOptions): CipherGCM;
/**
 * @deprecated Use createCipheriv instead.  This function will be removed in 1.0+
 */
export declare function createCipher(algorithm: CipherType, password: BinaryLikeNode, options?: Stream.TransformOptions): CipherCCM | CipherGCM | Cipher;
export declare function createCipheriv(algorithm: CipherCCMTypes, key: BinaryLikeNode, iv: BinaryLike, options: CipherCCMOptions): CipherCCM;
export declare function createCipheriv(algorithm: CipherOCBTypes, key: BinaryLikeNode, iv: BinaryLike, options: CipherOCBOptions): CipherOCB;
export declare function createCipheriv(algorithm: CipherGCMTypes, key: BinaryLikeNode, iv: BinaryLike, options?: CipherGCMOptions): CipherGCM;
export declare function createCipheriv(algorithm: CipherType, key: BinaryLikeNode, iv: BinaryLike | null, options?: Stream.TransformOptions): CipherCCM | CipherOCB | CipherGCM | Cipher;
export declare const publicEncrypt: (options: EncodingOptions | BinaryLike, buffer: BinaryLike) => Buffer;
export declare const publicDecrypt: (options: EncodingOptions | BinaryLike, buffer: BinaryLike) => Buffer;
export declare const privateDecrypt: (options: EncodingOptions | BinaryLike, buffer: BinaryLike) => Buffer;
export type GenerateKeyPairOptions = {
    modulusLength?: number;
    publicExponent?: number;
    hashAlgorithm?: string;
    mgf1HashAlgorithm?: string;
    saltLength?: number;
    divisorLength?: number;
    namedCurve?: string;
    prime?: Buffer;
    primeLength?: number;
    generator?: number;
    groupName?: string;
    publicKeyEncoding?: EncodingOptions;
    privateKeyEncoding?: EncodingOptions;
    paramEncoding?: string;
    hash?: string;
    mgf1Hash?: string;
};
export type KeyPairKey = Buffer | KeyObjectHandle | CryptoKey | undefined;
export type GenerateKeyPairReturn = [
    error?: Error,
    privateKey?: KeyPairKey,
    publicKey?: KeyPairKey
];
export type GenerateKeyPairCallback = (error?: Error, publicKey?: KeyPairKey, privateKey?: KeyPairKey) => GenerateKeyPairReturn | void;
export type KeyPair = {
    publicKey?: KeyPairKey;
    privateKey?: KeyPairKey;
};
export type GenerateKeyPairPromiseReturn = [error?: Error, keypair?: KeyPair];
export declare const generateKeyPair: (type: KeyPairType, options: GenerateKeyPairOptions, callback: GenerateKeyPairCallback) => void;
export declare const generateKeyPairPromise: (type: KeyPairType, options: GenerateKeyPairOptions) => Promise<GenerateKeyPairPromiseReturn>;
export declare function generateKeyPairSync(type: KeyPairType): CryptoKeyPair;
export declare function generateKeyPairSync(type: KeyPairType, options: GenerateKeyPairOptions): CryptoKeyPair;
export {};
//# sourceMappingURL=Cipher.d.ts.map