"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateKeySync = exports.generateKeyPromise = exports.generateKey = void 0;
var _NativeQuickCrypto = require("./NativeQuickCrypto/NativeQuickCrypto");
var _Utils = require("./Utils");
var _aes = require("./aes");
var _keys = require("./keys");
const generateKeyPromise = (type, options // | HmacKeyGenParams
) => {
  return new Promise((resolve, reject) => {
    generateKey(type, options, (err, key) => {
      if (err) {
        reject([err, undefined]);
      }
      resolve([undefined, key]);
    });
  });
};
exports.generateKeyPromise = generateKeyPromise;
const generateKey = (type, options, callback) => {
  validateLength(type, options.length);
  if (!(0, _Utils.validateFunction)(callback)) {
    throw (0, _Utils.lazyDOMException)('Callback is not a function', 'SyntaxError');
  }
  _NativeQuickCrypto.NativeQuickCrypto.webcrypto.generateSecretKey(options.length).then(handle => {
    callback(undefined, new _keys.SecretKeyObject(handle));
  }).catch(err => {
    callback(err, undefined);
  });
};
exports.generateKey = generateKey;
const generateKeySync = (type, options // | HmacKeyGenParams,
) => {
  validateLength(type, options.length);
  const handle = _NativeQuickCrypto.NativeQuickCrypto.webcrypto.generateSecretKeySync(options.length);
  return new _keys.SecretKeyObject(handle);
};
exports.generateKeySync = generateKeySync;
const validateLength = (type, length) => {
  switch (type) {
    case 'aes':
      if (!_aes.kAesKeyLengths.includes(length)) {
        throw (0, _Utils.lazyDOMException)('AES key length must be 128, 192, or 256 bits', 'OperationError');
      }
      break;
    case 'hmac':
      if (length < 8 || length > 2 ** 31 - 1) {
        throw (0, _Utils.lazyDOMException)('HMAC key length must be between 8 and 2^31 - 1', 'OperationError');
      }
      break;
    default:
      throw new Error(`Unsupported key type '${type}' for generateKey()`);
  }
};
//# sourceMappingURL=keygen.js.map