export type TokenType =
  '('
  | ')'
  | '['
  | ']'
  | '{'
  | '}'
  | '|'
  | '&'
  | '<'
  | '>'
  | ';'
  | ','
  | '*'
  | '?'
  | '!'
  | '='
  | ':'
  | '.'
  | '@'
  | '#'
  | '~'
  | '/'
  | '=>'
  | '...'
  | 'null'
  | 'undefined'
  | 'function'
  | 'this'
  | 'new'
  | 'module'
  | 'event'
  | 'extends'
  | 'external'
  | 'typeof'
  | 'keyof'
  | 'readonly'
  | 'import'
  | 'infer'
  | 'is'
  | 'in'
  | 'asserts'
  | 'Identifier'
  | 'StringValue'
  | 'Number'
  | 'EOF'

export interface Token {
  type: TokenType
  text: string
  startOfLine: boolean
}
