export default index;
/**
 * @type {((
 *   cfg?: import('eslint').Linter.Config & {
 *     mergeSettings?: boolean,
 *     config?: `flat/${ConfigGroups}${ConfigVariants}${ErrorLevelVariants}`,
 *     settings?: Partial<import('./iterateJsdoc.js').Settings>,
 *     rules?: {[key in keyof import('./rules.d.ts').Rules]?: import('eslint').Linter.RuleEntry<import('./rules.d.ts').Rules[key]>}
 *   }
 * ) => import('eslint').Linter.Config)}
 */
export const jsdoc: ((cfg?: import("eslint").Linter.Config & {
    mergeSettings?: boolean;
    config?: `flat/${ConfigGroups}${ConfigVariants}${ErrorLevelVariants}`;
    settings?: Partial<import("./iterateJsdoc.js").Settings>;
    rules?: { [key in keyof import("./rules.d.ts").Rules]?: import("eslint").Linter.RuleEntry<import("./rules.d.ts").Rules[key]>; };
}) => import("eslint").Linter.Config);
export { getJsdocProcessorPlugin } from "./getJsdocProcessorPlugin.js";
export type ConfigGroups = "recommended" | "stylistic" | "contents" | "logical" | "requirements";
export type ConfigVariants = "" | "-typescript" | "-typescript-flavor";
export type ErrorLevelVariants = "" | "-error";
/**
 * @typedef {"recommended" | "stylistic" | "contents" | "logical" | "requirements"} ConfigGroups
 * @typedef {"" | "-typescript" | "-typescript-flavor"} ConfigVariants
 * @typedef {"" | "-error"} ErrorLevelVariants
 * @type {import('eslint').ESLint.Plugin & {
 *   configs: Record<`flat/${ConfigGroups}${ConfigVariants}${ErrorLevelVariants}`,
 *   import('eslint').Linter.Config>
 * }}
 */
declare const index: import("eslint").ESLint.Plugin & {
    configs: Record<`flat/${ConfigGroups}${ConfigVariants}${ErrorLevelVariants}`, import("eslint").Linter.Config>;
};
//# sourceMappingURL=index.d.ts.map