"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
Object.defineProperty(exports, "getJsdocProcessorPlugin", {
  enumerable: true,
  get: function () {
    return _getJsdocProcessorPlugin.getJsdocProcessorPlugin;
  }
});
exports.jsdoc = void 0;
var _objectDeepMerge = require("object-deep-merge");
var _indexCjs = _interopRequireDefault(require("./index-cjs.cjs"));
var _getJsdocProcessorPlugin = require("./getJsdocProcessorPlugin.cjs");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/* eslint-disable perfectionist/sort-imports -- For auto-generate; Do not remove */
// BEGIN REPLACE
// eslint-disable-next-line unicorn/prefer-export-from --- Reusing `index`
var _default = exports.default = _indexCjs.default; // END REPLACE
/* eslint-disable jsdoc/valid-types -- Bug */
/**
 * @type {((
 *   cfg?: import('eslint').Linter.Config & {
 *     mergeSettings?: boolean,
 *     config?: `flat/${import('./index-cjs.js').ConfigGroups}${import('./index-cjs.js').ConfigVariants}${import('./index-cjs.js').ErrorLevelVariants}`,
 *     settings?: Partial<import('./iterateJsdoc.js').Settings>,
 *     rules?: {[key in keyof import('./rules.d.ts').Rules]?: import('eslint').Linter.RuleEntry<import('./rules.d.ts').Rules[key]>}
 *   }
 * ) => import('eslint').Linter.Config)}
 */
/* eslint-enable jsdoc/valid-types -- Bug */
const jsdoc = function (cfg) {
  /** @type {import('eslint').Linter.Config} */
  let outputConfig = {
    plugins: {
      jsdoc: _indexCjs.default
    }
  };
  if (cfg) {
    if (cfg.config) {
      // @ts-expect-error Security check
      if (cfg.config === '__proto__') {
        throw new TypeError('Disallowed config value');
      }
      outputConfig = _indexCjs.default.configs[cfg.config];
    }
    if (cfg.rules) {
      outputConfig.rules = {
        ...outputConfig.rules,
        ...cfg.rules
      };
    }
    if (cfg.plugins) {
      outputConfig.plugins = {
        ...outputConfig.plugins,
        ...cfg.plugins
      };
    }
    if (cfg.name) {
      outputConfig.name = cfg.name;
    }
    if (cfg.basePath) {
      outputConfig.basePath = cfg.basePath;
    }
    if (cfg.files) {
      outputConfig.files = cfg.files;
    }
    if (cfg.ignores) {
      outputConfig.ignores = cfg.ignores;
    }
    if (cfg.language) {
      outputConfig.language = cfg.language;
    }
    if (cfg.languageOptions) {
      outputConfig.languageOptions = cfg.languageOptions;
    }
    if (cfg.linterOptions) {
      outputConfig.linterOptions = cfg.linterOptions;
    }
    if (cfg.processor) {
      outputConfig.processor = cfg.processor;
    }
  }
  outputConfig.settings = {
    jsdoc: cfg?.mergeSettings === false ? cfg.settings : (0, _objectDeepMerge.merge)({}, cfg?.settings ?? {}, cfg?.config?.includes('recommended') ? {
      // We may need to drop these for "typescript" (non-"flavor") configs,
      //   if support is later added: https://www.typescriptlang.org/docs/handbook/jsdoc-supported-types.html
      structuredTags: {
        next: {
          required: ['type']
        },
        throws: {
          required: ['type']
        },
        yields: {
          required: ['type']
        }
      }
    } : {})
  };
  return outputConfig;
};
exports.jsdoc = jsdoc;
//# sourceMappingURL=index-esm.cjs.map