/// <reference path="./CertID.d.ts" />
/// <reference path="./Request.d.ts" />
/// <reference path="./TBSRequest.d.ts" />
/// <reference path="./OCSPRequest.d.ts" />
/// <reference path="./OCSPUtil.d.ts" />

declare namespace jsrsasign.KJUR.asn1 {
    /**
     * ASN.1 classes for OCSP protocol
     *
     * This name space provides
     * <a href="https://tools.ietf.org/html/rfc6960">RFC 6960
     * Online Certificate Status Protocol (OCSP)</a> ASN.1 request and response generator.
     *
     * __FEATURES__
     *
     * - easily generate OCSP data
     *
     * __PROVIDED CLASSES__
     *
     * - `KJUR.asn1.ocsp.CertID for ASN.1 class as defined in
     * [RFC 6960 4.1.1](https://tools.ietf.org/html/rfc6960#section-4.1.1).
     * - `KJUR.asn1.ocsp.Request for ASN.1 class as defined in
     * [RFC 6960 4.1.1](https://tools.ietf.org/html/rfc6960#section-4.1.1).
     * - `KJUR.asn1.ocsp.TBSRequest for ASN.1 class as defined in
     * [RFC 6960 4.1.1](https://tools.ietf.org/html/rfc6960#section-4.1.1).
     * - `KJUR.asn1.ocsp.OCSPRequest for ASN.1 class as defined in
     * [RFC 6960 4.1.1](https://tools.ietf.org/html/rfc6960#section-4.1.1).
     * - `KJUR.asn1.ocsp.OCSPUtil for static utility methods.
     */
    namespace ocsp {
        //
    }
}
