
# Contribution Guidelines

Thank you for considering contributing to  **MRT Buddy** ! Your help is vital in making this project better and more useful for everyone. Please review these guidelines to ensure your contributions align with the project's needs and standards.

## General Rules

* **Discuss Before Implementing** : Before submitting a pull request or starting on changes, engage in a discussion within the [Issues](https://github.com/aniruddha-adhikary/mrt-buddy/issues) or [Discussions](https://github.com/aniruddha-adhikary/mrt-buddy/discussions) section. This step helps avoid duplicate efforts and confirms whether the proposed feature or fix is needed.
* **One or Two Changes per Pull Request** : Keep your pull requests focused. Each pull request should address a single or two feature(s) or bugs/issues. This practice helps in better review, testing, and integration.
* **Avoid Unnecessary Reformatting** : Refrain from reformatting untouched files with custom linters or making unrelated style changes in feature pull requests. This ensures the main focus of the pull request is clear and reviewable.

## How to Contribute

1. **Fork the Repository** : Create your fork of the project by visiting the [MRT Buddy repository](https://github.com/aniruddha-adhikary/mrt-buddy) and clicking on the **Fork** button.
2. **Clone the Repository** :

```shell
   git clone https://github.com/your-username/mrt-buddy.git
   cd mrt-buddy
```

1. **Make Your Changes** : Implement your code, ensuring you adhere to best practices and maintain clean, readable code.
2. **Commit Your Changes** :

```shell
   git add .
   git commit -m "Add: Brief description of your changes"
```

1. **Push to Your Fork** :

```shell
   git push origin your-forked-branch-name
```

1. **Submit a Pull Request** : Go to your forked repository on GitHub and create a pull request. Provide a concise, informative description, and link to relevant discussions or issues if applicable.

## Review Process

* **Code Review** : Once your pull request is submitted, maintainers will review your code. They may request changes or ask for clarifications. Please be responsive and participate actively.
* **Feedback and Collaboration** : All contributors are encouraged to review and comment on others' pull requests to foster community engagement and collective improvement.

## Reporting Issues

Found a bug? Want to request a feature? Create a new issue on the [Issues](https://github.com/aniruddha-adhikary/mrt-buddy/issues) page with clear details and steps to reproduce (if applicable).

## Best Practices

* **Code Style** : Maintain consistency with the project's code style.
* **Documentation** : If you're adding a new feature, make sure it includes appropriate documentation.
* **Stay Updated** : Regularly pull changes from the upstream repository to keep your fork in sync.

---

Thank you for helping make **MRT Buddy** better for everyone!
