/*
 * Copyright 2013 Dmitry Monakhov.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package monakhv.android.samlib.exception;

/**
 * Exception in error of Book parsing when we can not transform the next input line into 
 * Book Object potential wrong author URL or author is not  in samlib any more
 * 
 * Skiping Author update
 *
 * @author monakhv
 */
public class SamlibParseException extends SamLibException {

    /**
     * Creates a new instance of
     * <code>BookParseException</code> without detail message.
     */
    public SamlibParseException() {
    }

    /**
     * Constructs an instance of
     * <code>BookParseException</code> with the specified detail message.
     *
     * @param msg the detail message.
     */
    public SamlibParseException(String msg) {
        super(msg);
    }
}
