# timeto.me - Productivity Tools App

App Store https://apps.apple.com/us/app/id6448869727

Google Play https://play.google.com/store/apps/details?id=me.timeto.app

F-Droid https://f-droid.org/en/packages/me.timeto.app

Any questions [hi@timeto.me](mailto:hi@timeto.me?subject=[GitHub]%20Feedback)

<p float="left">
  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/1.jpg" width="200" />
  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/2.jpg" width="200" /> 
  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/3.jpg" width="200" />
  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/4.jpg" width="200" />
  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/5.jpg" width="200" />
  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/6.jpg" width="200" />
  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/7.jpg" width="200" />
  <img src="/fastlane/metadata/android/en-US/images/phoneScreenshots/8.jpg" width="200" />
</p>

---

# How to Use the App

Hi,

Developer is here.

I built this app to manage my productivity. Here I will show how I use it.

**This guide is not just a list of features, but my real day-to-day experience.**

Enjoy!

# Timer

You must set a timer for each activity, like eating, working, reading, etc.

**Timer is running all the time, even for sleep or breakfast.**

There is no stop option! To stop the current activity, you have to start the next one.

In other words, once you complete one activity, you must start the timer for the next one.

<!--

**Timer is running all the time, even for sleep or breakfast.**

There is NO stop option! To stop the current task, you have to start the next one.

In other words, once you complete one task, you must start the timer for the next one.
-->
<!--
**There is NO stop option! To finish the current activity, you have to start the next one.**

In other words, once you complete one activity, you must start the timer for the next one, even sleep or breakfast.
-->

This way I always remember what I have to do. Most of the time my screen looks like a typical pomodoro timer:

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_timer_1.jpg" width="200" />
</p>

This way also provides 24/7 data on how long everything takes:

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_chart_1.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_chart_2.jpg" width="200" /> 
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_chart_3.jpg" width="200" />
</p>

The app has some activities by default, but you can add your own. Here are mine:

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_activities_1.jpg" width="200" />
</p>

### Practice

Let's start a timer to work.

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_timer_practice_1.jpg" width="150" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_timer_practice_2.jpg" width="150" /> 
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_timer_practice_3.jpg" width="150" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_timer_practice_4.jpg" width="150" />
</p>

The timer starts. Then tap the timer again to see the "Summary" and "History".

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_timer_practice_5.jpg" width="150" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_chart_2.jpg" width="150" /> 
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_chart_3.jpg" width="150" />
</p>

# Repeating Tasks

You may think choosing activity and timer for each task is overwhelming. This is where repeating tasks come in.

How it works for me:

Most of my activities are repeated. I wake up at the same time, then 1 hour to get ready, 2 hours working, 1 hour
eating, etc. So I created a repeating task for each of these.

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_repeatings_1.jpg" width="200" />
</p>

Each day, these tasks move to the "Today" folder. Tasks are sorted by time of day and show how much time is left. It's
like a schedule:

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_repeatings_2.jpg" width="200" />
</p>

**The most important, when I press it, it automatically starts a timer with the right activity.**

You can create not only everyday tasks. For example, watering a cactus once a week or paying for internet
once a month, etc.

I believe this is the main feature of the app. I recommend using it to the max.

### Practice

Let's create a repeating task for a daily workout at 18:00.

On the home screen, tap at the bottom center to open tasks, tap the repeating icon, tap "New Repeating Task" and
fill the form:

- Task: Workout;
- Activity: Exercises / Health;
- Timer: 1h;
- Time of the Day: 18:00;
- Repetition Period: Every Day;
- Tap "Create".

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_repeating_practice_1.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_repeating_practice_2.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_repeating_practice_3.jpg" width="200" />
</p>

Every day, a "Workout" task will be added to the "Today" folder.

This task is already created for today. Open "Today" and tap the "Workout" task. The timer will automatically start with
the right activity.

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_repeating_practice_4.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_repeating_practice_5.jpg" width="200" />
</p>

# Checklists

Checklists are an addition to repeating tasks that are placed under the timer.

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_1.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_2.jpg" width="200" /> 
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_3.jpg" width="200" />
</p>

### Practice

Let's create a repeating task for a daily morning routine at 7:00 with a checklist.

On the home screen, tap at the bottom center to open tasks, tap the repeating icon, tap "New Repeating Task" and
fill the form:

- Task: Morning Routine;
- Activity: Getting Ready;
- Timer: 1h;
- Time of the Day: 7:00;
- Repetition Period: Every Day;
- Checklists: Tap "+ new checklist", type "Morning Routine", "Save", "+ new item". Create few items like Drink a glass
  of water, Warm up, Shower, Light breakfast, Medication, Yesterday's reflection, Day plan. Tap "Done", again "Done";
- Tap "Create".

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_1.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_2.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_3.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_4.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_5.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_6.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_7.jpg" width="200" />
</p>

Test it! Open "Today" and tap the "Morning Routine" task. You will see the checklist.

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_8.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_checklists_practice_9.jpg" width="200" />
</p>

# First Steps

We learned the timer, repeating tasks, and checklists. The most important points:

- Timer is running all the time;
- Using repeating tasks to the max;
- Timer, activity and checklist will be set automatically.

**You can already use the app!**

Right now, try playing with the app: start a new activity, create repeating tasks, checklists. You can rely on my
examples.

Then move on to advanced features.

Good luck! 🍀

# Goals

Look at the bottom of the screenshot. For me, I set a goal to work 8 hours a day and read for 30 minutes.

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_goals_1.jpg" width="200" />
</p>

To create goals, go to the activity edit form.

# Tasks List

A typical task list with folders. But there are 2 special folders: today and tmrw (tomorrow).

Today - tasks from repeating tasks and calendar go here on a set day, you can add your own.

Tmrw (tomorrow) - tasks that will be tomorrow including repeating tasks and calendar. In other words, the tasks that
will be moved to "Today" tomorrow.

Swipe left to delete and right to edit.

# Calendar

A typical calendar. Tasks from the calendar will be displayed not only in "Today" but also on the Home Screen. "Call
Ann" example:

<p float="left">
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_calendar_1.jpg" width="200" />
  <img src="https://raw.githubusercontent.com/medvedev91/timetome/main/android_app/src/main/res/drawable/readme_calendar_2.jpg" width="200" />
</p>

# Shortcuts

Real life example: I meditate every day, to start I open a special video on YouTube.

Shortcuts automate this. When I start the "Meditation" activity, the video will start automatically.

This works especially well with repeating tasks. "Meditation" is automatically created every day, I just tap on it, the
timer and video starts.

# Day Start Time

Especially for night owls. You can set the time when repeating tasks will be added for the next day. Default 00:00.

# Conclusion

I hope the app will improve your life like it improved mine. I would be very happy to get feedback and answer questions.

Any questions [hi@timeto.me](mailto:hi@timeto.me?subject=[GitHubReadme]%20Feedback)
