<h1 align="center">Easy Watermark</h1>

<p align="center">
  <img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/rosuh/easywatermark">
  &nbsp;
  &nbsp;
  <a href="https://hosted.weblate.org/engage/easywatermark/en/">
    <img src="https://hosted.weblate.org/widgets/easywatermark/en/svg-badge.svg" alt="translate status" />
  </a>
  &nbsp;
  &nbsp;
  <a href="https://app.fossa.com/projects/git%2Bgithub.com%2FrosuH%2FEasyWatermark?ref=badge_small" alt="FOSSA Status">
    <img src="https://app.fossa.com/api/projects/git%2Bgithub.com%2FrosuH%2FEasyWatermark.svg?type=small"/>
  </a>
</p>

<p align="center">  
  <a href="https://github.com/rosuH/EasyWatermark/blob/master/README_zh-CN.md">简体中文</a>
<p align="center">

<p align="center">  
Securely, easily add a watermark to your sensitive photos.</br>To prevent them from being leaked or exploited by the <b>BAD GUY</b>.
  </br>
</p>
<p align="center">
<img src="/static/preview.png"/>
</p>

> Of course, it is also suitable for making emojis. 
>
> After all, it supports image watermarking with very ghostly effects.
<a href="#" align="right"><img src="https://i.loli.net/2020/08/26/A53u6UbKZPYCv7t.jpg" width="5%"></a>

<p align="left">
<a href="https://play.google.com/store/apps/details?id=me.rosuh.easywatermark"><img src="/static/google-play-badge.png" width="auto" height="64px"/></a>
  <a href="https://www.coolapk.com/apk/272743"><img src="/static/logo_coolapk.png" width="auto" height="64px"/></a>
  <a href="https://f-droid.org/packages/me.rosuh.easywatermark/"><img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" width="auto" height="64px"/></a>
</p>

## Features
- **Security**.
  - The code is completely open source and feel free to FORK your won, ;)
  - Pure offline, no need to worry about your photos being leaked. Users with API >= 29 don't even
    need to request any permissions. (28 and below users need to approve for storage permissions to
    access and store photos)
  - There are no stats, tracking, Device IDs, or even crash reporting (so if you got a crash, please
    share the crash info with us >_<).
  - We've given up all third-party tracking SDK and various stats just so you can use it with
    confidence.
    **What's yours is yours**.
- **Layout**: support for horizontal and vertical intervals between the watermark, automatically
  repeat the full picture.
- **Style**: font color, font style, transparency, font size, and rotation angle are included.
- **Content**: Support text watermark and image watermark (or says stickers).

## Download

Developer-led download channels:
- [GitHub Release](https://github.com/rosuH/EasyWatermark/releases): Always stay up to date!
- [Google Play](https://play.google.com/store/apps/details?id=me.rosuh.easywatermark)
  - 🍺 Noted: the paid version, the same code. Try it if you want to buy me a cup of tea 🍵.
- [F-Droid](https://f-droid.org/packages/me.rosuh.easywatermark/)
- [Coolapk](https://www.coolapk.com/apk/272743)

All other channels are not developer-driven, so please screen them carefully before downloading and using them.

## Usage
You can use it however you want. It is more suitable for situations where you need to submit a photo ID, a hand-held photo ID or a sensitive photo. Example.
- Various real names in the country, uploading front and back photos of ID cards at every turn, even handheld ID photos.
- Pre-project previews, samples, copyrighted or simply spoofed images

Reference text.
> This photo is for xx for xxx purposes only, no other use.

You can turn down the transparency, just don't block the key information.

> (For now) we can't (temporarily) prevent information from being uploaded, or even (temporarily) prevent information from being leaked, but we can reduce the value of the information being leaked.
>
> Even if it's (probably) useless in the end, at least you can disgust the leaker a bit.

## UI

- Designed by [@tovi](https://www.figma.com/@tovi) with ❤️.

> This app was designed by [@tovi](https://www.figma.com/@tovi), so all rights to the UI and related design resources belong to him and may not be used without permission from any person or organization.

## Credit

- [daniel-stonuk/material-about-library](https://github.com/daniel-stoneuk/material-about-library)
- [skydoves/ColorPickerView](https://github.com/skydoves/ColorPickerView)
- [material-components/material-components-android](https://github.com/material-components/material-components-android)
- [Compressor](https://github.com/zetbaitsu/Compressor/)
- Sample Photo by Deepak Nautiyal
  on [Unsplash](https://unsplash.com/s/photos/animals?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText)
- Commit message generated by [AICommit](https://aicommit.app)

## Feedback and contribution

We welcome your comments and suggestions in the issues section, or you can contribute your code by
submitting a PR directly to us. Of course, you can also contact the developer directly via telegram
or email and we'll get back to you shortly.

## Localization

We welcome your localization assistance in any way, including but not limited to direct involvement in writing code, creating issues, emails, etc., or we also recommend using the [WebLate](https://hosted.weblate.org/engage/easywatermark/) platform for translation assistance, thank you.

<a href="https://hosted.weblate.org/engage/easywatermark/en/">
  <img src="https://hosted.weblate.org/widgets/easywatermark/en/88x31-grey.png" alt="翻译状态" />
</a>

## [Privacy policy](https://github.com/rosuH/EasyWatermark/blob/master/PrivacyPolicy.md)

If you really need it.
