package me.proton.android.lumo.navigation

import androidx.navigation.NavGraphBuilder
import androidx.navigation.compose.composable
import me.proton.android.lumo.ui.components.PaymentScreen

fun NavGraphBuilder.paymentRoutes(
    isReady: Boolean,
    onDismiss: () -> Unit,
) {
    composable<NavRoutes.Subscription> {
        PaymentScreen(
            isReady = isReady,
            onDismiss = onDismiss
        )
    }
}
