package me.proton.android.lumo.data.repository

import android.content.SharedPreferences
import androidx.core.content.edit
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import me.proton.android.lumo.ui.theme.AppStyle

interface ThemeRepository {

    suspend fun saveTheme(theme: AppStyle)

    suspend fun getTheme(): AppStyle
}

class ThemeRepositoryImpl(private val prefs: SharedPreferences) : ThemeRepository {

    override suspend fun saveTheme(theme: AppStyle) =
        withContext(Dispatchers.IO) {
            prefs.edit { putInt(KEY_THEME, theme.mode) }
        }

    override suspend fun getTheme(): AppStyle =
        withContext(Dispatchers.IO) {
            AppStyle.fromInt(
                prefs.getInt(KEY_THEME, AppStyle.Light.mode)
            )
        }


    companion object {
        private const val KEY_THEME = "key::lumo::theme"
    }
}