package me.lucky.silence

import android.app.ActivityManager
import android.app.role.RoleManager
import android.content.ComponentName
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.telephony.TelephonyManager
import me.lucky.silence.text.NotificationListenerService
import me.lucky.silence.text.SmsReceiver

class Utils {
    companion object {
        fun isNotificationListenerRunning(ctx: Context): Boolean {
            val manager = ctx.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
            @Suppress("deprecation")
            val services = manager.getRunningServices(Integer.MAX_VALUE)
            for (service in services) {
                if (NotificationListenerService::class.java.name == service.service.className) {
                    return true
                }
            }
            return false
        }

        fun updateMessagesEnabled(ctx: Context) {
            val prefs = Preferences(ctx)
            setComponentEnabled(
                ctx,
                SmsReceiver::class.java,
                prefs.messages.has(Message.SMS) && prefs.isEnabled,
            )
            setComponentEnabled(
                ctx,
                NotificationListenerService::class.java,
                prefs.messages.has(Message.NOTIFICATION) && prefs.isEnabled,
            )
        }

        fun setComponentEnabled(ctx: Context, cls: Class<*>, value: Boolean) =
            ctx.packageManager.setComponentEnabledSetting(
                ComponentName(ctx, cls),
                if (value) PackageManager.COMPONENT_ENABLED_STATE_ENABLED else
                    PackageManager.COMPONENT_ENABLED_STATE_DISABLED,
                PackageManager.DONT_KILL_APP,
            )

        fun isComponentEnabled(ctx: Context, cls: Class<*>) =
            ctx.packageManager.getComponentEnabledSetting(ComponentName(ctx, cls)) ==
                PackageManager.COMPONENT_ENABLED_STATE_ENABLED

        fun hasCallScreeningRole(ctx: Context) =
            ctx
                .getSystemService(RoleManager::class.java)
                ?.isRoleHeld(RoleManager.ROLE_CALL_SCREENING) ?: false

        private fun minSimCount() = if (BuildConfig.DEBUG) 1 else 2

        fun isSimFeatureEnabled(ctx: Context): Boolean =
            Build.VERSION.SDK_INT >= Build.VERSION_CODES.S &&
                getModemCount(ctx, Modem.SUPPORTED) >= minSimCount()

        fun hasActiveMultiSim(ctx: Context): Boolean =
            Build.VERSION.SDK_INT >= Build.VERSION_CODES.S &&
                getModemCount(ctx, Modem.ACTIVE) >= minSimCount()

        fun getModemCount(ctx: Context, modem: Modem): Int {
            val telephonyManager = ctx.getSystemService(TelephonyManager::class.java)
            return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
                when (modem) {
                    Modem.ACTIVE -> telephonyManager?.activeModemCount
                    Modem.SUPPORTED -> telephonyManager?.supportedModemCount
                }
            } else {
                @Suppress("deprecation")
                telephonyManager?.phoneCount
            } ?: 0
        }

        fun currentTimeSeconds() = System.currentTimeMillis() / 1000
    }
}

enum class Modem {
    ACTIVE,
    SUPPORTED,
}
