package me.knighthat.discord

import io.ktor.client.HttpClient
import io.ktor.client.engine.okhttp.OkHttp
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation
import io.ktor.client.plugins.websocket.WebSockets
import io.ktor.serialization.kotlinx.KotlinxWebsocketSerializationConverter
import io.ktor.serialization.kotlinx.json.json
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.runBlocking
import kotlinx.serialization.json.Json
import me.knighthat.discord.payload.Activity
import me.knighthat.discord.payload.Identify
import me.knighthat.discord.payload.Presence
import org.junit.jupiter.api.Test
import java.util.concurrent.TimeUnit
import kotlin.time.Duration.Companion.minutes
import kotlin.time.Duration.Companion.seconds


class DiscordImplTest {

    companion object {
        private const val APPLICATION_ID = "1370148610158759966"
    }

    @Test
    fun test() = runBlocking {
        Discord.setClient(
            HttpClient(OkHttp ) {
                install(WebSockets ) {
                    contentConverter = KotlinxWebsocketSerializationConverter(Json)
                }

                install(ContentNegotiation ) {
                    json()
                }

                engine {
                    config {
                        connectTimeout( 10, TimeUnit.SECONDS )
                    }
                }
            }
        )

        val activity = Activity(
            name = "Discord Kotlin",
            type = Type.PLAYING,
            url = "https://gitlab.com/tannguyen047/discord-kotlin.git",
            createdAt = System.currentTimeMillis(),
            applicationId = APPLICATION_ID,
            statusDisplayType = StatusDisplayType.NAME,
            buttons = listOf(
                Activity.Button(
                    label = "Get Kreate",
                    url = "https://github.com/knighthat/kreate/releases"
                ),
                Activity.Button(
                    label = "Get involved",
                    url = "https://gitlab.com/tannguyen047/discord-kotlin"
                )
            )
        )

        launch {
            delay( 30.seconds )

            val newActivity = activity.copy(
                details = "Developing Discord Kotlin",
                statusDisplayType = StatusDisplayType.DETAILS
            )
            Discord.updatePresence {
                Presence(null, listOf( newActivity ), Status.ONLINE, false)
            }

            delay( 1.minutes )

            Discord.logout()
        }

        Discord.login {
            token = System.getenv("DISCORD_TOKEN")
            intents = 0
            properties = Identify.Properties("linux", "discord-kotlin", "discord-kotlin")

            initPresence( activity )
        }
    }
}
