package me.knighthat.discord.payload

import kotlinx.serialization.Serializable
import me.knighthat.discord.Status
import org.intellij.lang.annotations.MagicConstant


/**
 * @param since Unix time (in milliseconds) of when the client went idle, or null if the client is not idle
 * @param activities User's activities
 * @param status User's new status
 * @param afk Whether or not the client is afk
 *
 * @see Status
 */
@Serializable
data class Presence(
    val since: Long?,
    val activities: List<Activity>,
    @param:MagicConstant(flagsFromClass = Status::class) val status: String,
    val afk: Boolean
)
