package me.knighthat.discord


/**
 * List of all intents and the Gateway events associated with them.
 * Any events not listed means it's not associated with an intent and will always be sent to your app.
 *
 * * [_Thread Members Update_](https://discord.com/developers/docs/events/gateway-events#thread-members-update)
 * contains different data depending on which intents are used.
 *
 * Events under the [GUILD_PRESENCES] and [GUILD_MEMBERS] intents are turned off by default on all API versions.
 * If you are using API v6, you will receive those events if you are authorized to receive them and have enabled
 * the intents in the Developer Portal. You do not need to use intents on API v6 to receive these events;
 * you just need to enable the flags. If you are using API v8 or above, intents are mandatory and must be
 * specified when identifying.
 *
 * @see <a href='https://discord.com/developers/docs/events/gateway#caveats'>Caveats</a>
 * @see <a href='https://discord.com/developers/docs/events/gateway#privileged-intents'>Privileged intents</a>
 */
object Intent {

    /**
     * GUILD_CREATE
     * GUILD_UPDATE
     * GUILD_DELETE
     * GUILD_ROLE_CREATE
     * GUILD_ROLE_UPDATE
     * GUILD_ROLE_DELETE
     * CHANNEL_CREATE
     * CHANNEL_UPDATE
     * CHANNEL_DELETE
     * CHANNEL_PINS_UPDATE
     * THREAD_CREATE
     * THREAD_UPDATE
     * THREAD_DELETE
     * THREAD_LIST_SYNC
     * THREAD_MEMBER_UPDATE
     * THREAD_MEMBERS_UPDATE *
     * STAGE_INSTANCE_CREATE
     * STAGE_INSTANCE_UPDATE
     * STAGE_INSTANCE_DELETE
     */
    const val GUILDS = 1 shl 0

    /**
     * GUILD_MEMBER_ADD
     * GUILD_MEMBER_UPDATE
     * GUILD_MEMBER_REMOVE
     * THREAD_MEMBERS_UPDATE *
     *
     * *Read [Intent]'s notes for details*
     */
    const val GUILD_MEMBERS = 1 shl 1

    /**
     * GUILD_AUDIT_LOG_ENTRY_CREATE
     * GUILD_BAN_ADD
     * GUILD_BAN_REMOVE
     */
    const val GUILD_MODERATION = 1 shl 2

    /**
     * GUILD_EMOJIS_UPDATE
     * GUILD_STICKERS_UPDATE
     * GUILD_SOUNDBOARD_SOUND_CREATE
     * GUILD_SOUNDBOARD_SOUND_UPDATE
     * GUILD_SOUNDBOARD_SOUND_DELETE
     * GUILD_SOUNDBOARD_SOUNDS_UPDATE
     */
    const val GUILD_EXPRESSIONS = 1 shl 3

    /**
     * GUILD_INTEGRATIONS_UPDATE
     * INTEGRATION_CREATE
     * INTEGRATION_UPDATE
     * INTEGRATION_DELETE
     */
    const val GUILD_INTEGRATIONS = 1 shl 4

    /**
     * WEBHOOKS_UPDATE
     */
    const val GUILD_WEBHOOKS = 1 shl 5

    /**
     * INVITE_CREATE
     * INVITE_DELETE
     */
    const val GUILD_INVITES = 1 shl 6

    /**
     * VOICE_CHANNEL_EFFECT_SEND
     * VOICE_STATE_UPDATE
     */
    const val GUILD_VOICE_STATES = 1 shl 7

    /**
     * PRESENCE_UPDATE
     *
     * *Read [Intent]'s notes for details*
     */
    const val GUILD_PRESENCES = 1 shl 8

    /**
     * MESSAGE_CREATE
     * MESSAGE_UPDATE
     * MESSAGE_DELETE
     * MESSAGE_DELETE_BULK
     */
    const val GUILD_MESSAGES = 1 shl 9

    /**
     * MESSAGE_REACTION_ADD
     * MESSAGE_REACTION_REMOVE
     * MESSAGE_REACTION_REMOVE_ALL
     * MESSAGE_REACTION_REMOVE_EMOJI
     */
    const val GUILD_MESSAGE_REACTIONS = 1 shl 10

    /**
     * TYPING_START
     */
    const val GUILD_MESSAGE_TYPING = 1 shl 11

    /**
     * MESSAGE_CREATE
     * MESSAGE_UPDATE
     * MESSAGE_DELETE
     * CHANNEL_PINS_UPDATE
     */
    const val DIRECT_MESSAGES = 1 shl 12

    /**
     * MESSAGE_REACTION_ADD
     * MESSAGE_REACTION_REMOVE
     * MESSAGE_REACTION_REMOVE_ALL
     * MESSAGE_REACTION_REMOVE_EMOJI
     */
    const val DIRECT_MESSAGE_REACTIONS = 1 shl 13

    /**
     * TYPING_START
     */
    const val DIRECT_MESSAGE_TYPING = 1 shl 14

    /**
     * Does not represent individual events, but rather affects what
     * data is present for events that could contain message content fields.
     *
     * More information is in the
     * [message content intent](https://discord.com/developers/docs/events/gateway#message-content-intent) section.
     */
    const val MESSAGE_CONTENT = 1 shl 15

    /**
     * GUILD_SCHEDULED_EVENT_CREATE
     * GUILD_SCHEDULED_EVENT_UPDATE
     * GUILD_SCHEDULED_EVENT_DELETE
     * GUILD_SCHEDULED_EVENT_USER_ADD
     * GUILD_SCHEDULED_EVENT_USER_REMOVE
     */
    const val GUILD_SCHEDULED_EVENTS = 1 shl 16

    /**
     * AUTO_MODERATION_RULE_CREATE
     * AUTO_MODERATION_RULE_UPDATE
     * AUTO_MODERATION_RULE_DELETE
     */
    const val AUTO_MODERATION_CONFIGURATION = 1 shl 20

    /**
     * AUTO_MODERATION_ACTION_EXECUTION
     */
    const val AUTO_MODERATION_EXECUTION = 1 shl 21

    /**
     * MESSAGE_POLL_VOTE_ADD
     * MESSAGE_POLL_VOTE_REMOVE
     */
    const val GUILD_MESSAGE_POLLS = 1 shl 24

    /**
     * MESSAGE_POLL_VOTE_ADD
     * MESSAGE_POLL_VOTE_REMOVE
     */
    const val DIRECT_MESSAGE_POLLS = 1 shl 25
}