package me.knighthat.discord

import io.ktor.client.HttpClient
import me.knighthat.discord.payload.Identify
import me.knighthat.discord.payload.Payload
import me.knighthat.discord.payload.Presence
import java.net.MalformedURLException

interface Discord {

    companion object: Discord by DiscordImpl()

    fun isReady(): Boolean

    /**
     * This client must be able to make normal HTTP calls
     * as well as websockets.
     */
    fun setClient( client: HttpClient )

    /**
     * Starts new session with credentials set in [Identify.Builder]
     *
     * This is a ""blocking"" process which holds the thread
     * as long as the connection is established
     */
    suspend fun login( builder: Identify.Builder.() -> Unit )

    /**
     * Non-blocking payload polling call.
     *
     * Payloads are not guaranteed to be sent
     * immediately upon call.
     *
     * @throws IllegalStateException if session isn't ready
     */
    fun send( payload: Payload )

    fun logout()

    fun updatePresence( presence: () -> Presence )

    /**
     * Convert a conventional URL into Discord-monitored url
     *
     * For example `https://example.com/my-image.png` will be converted
     * to `mp:mp:external/<image_id_by_discord>/https/example.com/my-image.png`
     *
     * > Please note: this example is not 100% correct, the final result maybe
     * a little bit different
     *
     * **Only supports `HTTP` and `HTTPS` schenes**
     *
     * @param imageUrl valid url points to an image. Must be a direct link
     * @param applicationId Discord bot's ID, must be a valid one or it won't be successful
     *
     * @throws MalformedURLException if [imageUrl] is not a valid url.
     * @throws IllegalArgumentException if scheme is neither `HTTP` nor `HTTPS`
     */
    suspend fun getExternalImageUrl( imageUrl: String, applicationId: String ): Result<String>
}