from babel.core import Locale

import xml.etree.ElementTree as ET
import logging
import os


def move(
    key: str, 
    from_files: dict[str, tuple[Locale, ET]], 
    to_files: dict[str, tuple[Locale, ET]]
) -> None:
    # Turns to_files to dict[Locale, ET]
    locale_mapping: dict[Locale, tuple[str, ET]] = {
        locale: (path, xml) 
        for path, (locale, xml) in to_files.items()
    }

    for file_path, v in from_files.items():
        dest_file: tuple[str, ET] = locale_mapping[v[0]]

        logging.debug(f'Moving "{key}" from {file_path} to {dest_file[0]}')

        f_root = v[1].getroot()
        t_root = dest_file[1].getroot()

        # Check if the string doesn't exists
        string: ET.Element = None
        for element in f_root.findall('plurals'):
            if element.get("name") == key:
                string = element.copy()
                f_root.remove(element)
                break
        if string is None:
            logging.warn(f'{key} doesn\'t exist in {file_path}' )
            continue
        # Check if the string exists in destination
        replaced = False
        for element in t_root.findall('plurals'):
            if element.get("name") == key:
                logging.info(f'{key} already exists in {dest_file[0]}')
                element.text = string.text
                break
        if not replaced:
            t_root.append(string)
        
        logging.debug(f'Moved {key} from {file_path} to {dest_file[0]}')
