from babel.core import Locale

import xml.etree.ElementTree as ET

from .rules import Rules
from .add import add
from .remove import remove
from .move import move as _move
from enums import Actions, FileType
from utils import get_action, request_string_id
from file_loader import load_files


FILE_TYPE = FileType.PLURALS

# Contains localized words (single and plural forms)
files: dict[str, tuple[Locale, ET]] = {}
from_files: dict[str, tuple[Locale, ET]] = {}
to_files: dict[str, tuple[Locale, ET]] = {}


def get_files() -> dict[str, tuple[Locale, ET]]:
    global files 

    return files


def process( path: str ) -> None:
    global files

    # Only load files when selected and files aren't loaded 
    # This is here to prevent subsequent run from overriding
    # previous changes
    if not files:
        files = load_files( path, FILE_TYPE.value )

    action: Actions = get_action( FILE_TYPE )
    match (action):
        case Actions.ADD:
            string_id: str = request_string_id('Specify string id: ')
            general_value: str = input(f'Enter default value of "{string_id}": ').strip()
            rules: Rules = Rules(general_value)

            add(string_id, rules, files)
        case Actions.REMOVE:
            string_id: str = request_string_id('Specify string id to remove: ')
            
            remove(string_id, files)

        case Actions.MODIFY:
            raise ValueError(f'Unsupported action {action}')
    # end match

def move( from_path: str, to_path: str ) -> None:
    global files
    global from_files
    global to_files

    if not from_files:
        from_files = load_files( from_path, FILE_TYPE.value )
        files |= from_files
    if not to_files:
        to_files = load_files( to_path, FILE_TYPE.value, from_files )
        files |= to_files

    string_id: str = request_string_id('Specify string id to move: ')
    _move(string_id, from_files, to_files)
    