package me.knighthat.internal.model

import me.knighthat.innertube.decode
import me.knighthat.internal.response.NextResponseImpl
import org.junit.jupiter.api.Assertions.assertEquals
import org.junit.jupiter.api.Assertions.assertNull
import org.junit.jupiter.api.Assertions.assertTrue
import org.junit.jupiter.api.Test
import org.junit.jupiter.api.assertNotNull

class InnertubeSongDetailsImplTest {

    @Test
    fun testFromPrimaryResultsResultsContent() {
        val fileName = "yt/next/endpoint_response.json"
        ClassLoader.getSystemResourceAsStream( fileName )
                   .also( ::assertNotNull )
                   ?.use { inStream ->
                       val response = inStream.decode<NextResponseImpl>()
                       assertNotNull( response )

                       val songDetails = response.contents
                           .twoColumnWatchNextResults
                           ?.results
                           ?.results
                           ?.contents
                           ?.let( InnertubeSongDetailsImpl::from )
                       assertNotNull( songDetails )

                       assertEquals( "PIECES OF LOVE", songDetails.title )

                       assertEquals( "1,689,524 views", songDetails.viewCount.long )
                       assertEquals( "1.6M views", songDetails.viewCount.short )

                       assertEquals( "Jul 27, 2021", songDetails.releaseDate )
                       assertEquals( "3 years ago", songDetails.relativeReleaseDate )

                       assertEquals(
                           """
                               Provided to YouTube by WM Japan
                               
                               PIECES OF LOVE · TWICE
                               
                               Perfect World
                               
                               ℗ 2021 WARNER MUSIC JAPAN INC.
                               
                               Masterer: Chris Gehringer
                               Recorded By: Eom Sehee
                               Background Vocals: Sayulee
                               Vocals: TWICE
                               Mixer: Tony Maserati
                               Instruments: UTA
                               Composer: Aaron Kim
                               Composer: Albin Nordqvist
                               Composer: EJAE
                               Composer: Isaac Han
                               Lyricist: Lauren Kaori
                               Composer: Walter Pok
                               
                               Auto-generated by YouTube.
                           """.trimIndent(),
                           songDetails.description
                       )

                       //<editor-fold desc="Artist">
                       assertEquals( "UCzgxx_DM2Dcb9Y1spb9mUJA", songDetails.artist.id )

                       assertEquals( "TWICE", songDetails.artist.name )

                       assertEquals( 3, songDetails.artist.thumbnails.size )

                       assertNull( songDetails.artist.description )

                       assertNull( songDetails.artist.shortNumSubscribers )
                       assertEquals( "18.2M subscribers", songDetails.artist.longNumSubscribers )

                       assertNull( songDetails.artist.shortNumMonthlyAudience )

                       assertTrue { songDetails.artist.sections.isEmpty() }
                       //</editor-fold>
                   }
    }
}