package me.knighthat.logging

object Logger {

    lateinit var handler: Handler

    private fun ensureHandlerInitialized() {
        if( !::handler.isInitialized )
            this.handler = DefaultHandler()
    }

    fun v( tag: String, message: String ) {
        ensureHandlerInitialized()
        this.handler.verbose( tag, message )
    }

    fun d( tag: String, message: String ) {
        ensureHandlerInitialized()
        this.handler.debug( tag, message )
    }

    fun i( tag: String, message: String ) {
        ensureHandlerInitialized()
        this.handler.info( tag, message )
    }

    fun w( tag: String, message: String ) {
        ensureHandlerInitialized()
        this.handler.warning( tag, message )
    }

    fun e( tag: String, error: Throwable, message: String ) {
        ensureHandlerInitialized()
        this.handler.error( tag, error, message )
    }

    interface Handler {

        fun verbose( tag: String, verbose: String )

        fun debug( tag: String, debug: String )

        fun info( tag: String, info: String )

        fun warning( tag: String, warning: String )

        fun error( tag: String, error: Throwable, message: String? )
    }

    internal class DefaultHandler: Handler {
        override fun verbose( tag: String, verbose: String ) = println( verbose )
        override fun debug( tag: String, debug: String ) = println( debug )
        override fun info( tag: String, info: String ) = println( info )
        override fun warning( tag: String, warning: String ) = println( warning )
        override fun error( tag: String, error: Throwable, message: String? ) {
            error.printStackTrace()
            error.message?.also( ::println )
            message?.also( ::println )
        }
    }
}