package me.knighthat.internal.response

import kotlinx.serialization.Serializable
import me.knighthat.innertube.response.Endpoint

@Serializable
data class EndpointImpl(
    override val browseEndpoint: BrowseImpl?,
    override val watchEndpoint: WatchImpl?,
    override val watchPlaylistEndpoint: WatchPlaylistImpl?,
    override val likeEndpoint: LikeImpl?,
    override val searchEndpoint: SearchImpl?,
    override val playlistEditEndpoint: PlaylistEditImpl?,
): Endpoint {

    @Serializable
    data class BrowseImpl(
        override val browseId: String,
        override val params: String?,
        override val browseEndpointContextSupportedConfigs: ContextImpl?
    ): Endpoint.Browse {

        @Serializable
        data class ContextImpl(
            override val browseEndpointContextMusicConfig: MusicConfigImpl
        ): Endpoint.Browse.Context {

            @Serializable
            data class MusicConfigImpl(
                override val pageType: String
            ): Endpoint.Browse.Context.MusicConfig
        }
    }

    @Serializable
    data class LikeImpl(
        override val status: String,
        override val target: TargetImpl
    ): Endpoint.Like {

        @Serializable
        data class TargetImpl(
            override val playlistId: String
        ): Endpoint.Like.Target
    }

    @Serializable
    data class PlaylistEditImpl(
        override val playlistId: String,
        override val actions: List<ActionImpl> = emptyList()
    ): Endpoint.PlaylistEdit {

        @Serializable
        data class ActionImpl(
            override val setVideoId: String,
            override val action: String,
            override val removedVideoId: String
        ): Endpoint.PlaylistEdit.Action
    }

    @Serializable
    data class SearchImpl(
        override val query: String,
        override val params: String?
    ): Endpoint.Search

    @Serializable
    data class WatchImpl(
        override val videoId: String,
        override val playlistId: String?,
        override val index: Int?,
        override val params: String?,
        override val playerParams: String?,
        override val ustreamerConfig: String?,
        override val playlistSetVideoId: String?,
        override val loggingContext: LoggingContextImpl?,
        override val watchEndpointMusicSupportedConfigs: WatchEndpointMusicSupportedConfigsImpl?
    ): Endpoint.Watch {

        @Serializable
        data class LoggingContextImpl(
            override val vssLoggingContext: VssLoggingContextImpl
        ): Endpoint.Watch.LoggingContext {

            @Serializable
            data class VssLoggingContextImpl(
                override val serializedContextData: String
            ): Endpoint.Watch.LoggingContext.VssLoggingContext
        }

        @Serializable
        data class WatchEndpointMusicSupportedConfigsImpl(
            override val watchEndpointMusicConfig: WatchEndpointMusicConfigImpl
        ): Endpoint.Watch.WatchEndpointMusicSupportedConfigs {

            @Serializable
            data class WatchEndpointMusicConfigImpl(
                override val hasPersistentPlaylistPanel: Boolean?,
                override val musicVideoType: String
            ): Endpoint.Watch.WatchEndpointMusicSupportedConfigs.WatchEndpointMusicConfig
        }
    }

    @Serializable
    data class WatchPlaylistImpl(
        override val playlistId: String?,
        override val params: String?
    ): Endpoint.WatchPlaylist
}
