plugins {
    alias( libs.plugins.kotlin.jvm )
    alias( libs.plugins.kotlin.serialization )

    `java-library`
}

repositories {
    mavenLocal()
    mavenCentral()
}

group = "me.knighthat"
version = "2025.09.09"

dependencies {
    implementation( libs.kotlinx.coroutines )
    implementation( libs.ktor.serialization.json )

    testImplementation( libs.bundles.junit5 )
    testRuntimeOnly( libs.junit.platform )

    testImplementation( libs.bundles.ktor )
    testImplementation( libs.okhttp3.logging.interceptor )

    compileOnly( libs.lombok )
    annotationProcessor( libs.lombok )
    testCompileOnly( libs.lombok )
    testAnnotationProcessor( libs.lombok )

    compileOnly( libs.jetbrains.annotations )
    annotationProcessor( libs.jetbrains.annotations )
    testCompileOnly( libs.jetbrains.annotations )
    testAnnotationProcessor( libs.jetbrains.annotations )
}

tasks.test {
    useJUnitPlatform()
}
