package me.knighthat.discord.payload

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.JsonPrimitive
import me.knighthat.discord.Code
import org.intellij.lang.annotations.MagicConstant


/**
 * Structure of an event to send and to be received from Discord.
 *
 * @param opCode Gateway opcode, which indicates the payload type
 * @param data  Event data
 * @param sequence Sequence number of event used for resuming sessions and heartbeating
 * @param name  Event name
 *
 * @see <a href='https://discord.com/developers/docs/events/gateway-events'>Gateway Events</a>
 */
@Serializable
data class Payload(
    @field:MagicConstant(flagsFromClass = Code::class)
    @SerialName("op") val opCode: Int,
    @SerialName("d") val data: JsonElement? = null,
    @SerialName("s") val sequence: Long? = null,
    @SerialName("t") val name: String? = null
)