package me.knighthat.discord


/**
 * A set of pre-defined flags to be sent with [me.knighthat.discord.payload.Activity]
 *
 * @see <a href='https://discord.com/developers/docs/events/gateway-events#activity-object-activity-flags'>Activity flags</a>
 */
object Flag {

    const val INSTANCE = 1 shl 0

    const val JOIN = 1 shl 1

    const val SPECTATE = 1 shl 2

    const val JOIN_REQUEST = 1 shl 3

    const val SYNC = 1 shl 4

    const val PLAY = 1 shl 5

    const val PARTY_PRIVACY_FRIENDS = 1 shl 6

    const val PARTY_PRIVACY_VOICE_CHANNEL = 1 shl 7

    const val EMBEDDED = 1 shl 8
}