package me.knighthat.discord


/**
 * A set of pre-defined opcodes from Discord.
 *
 * @see <a href='https://discord.com/developers/docs/topics/opcodes-and-status-codes'>Codes</a>
 */
internal object Code {

    //<editor-fold desc="Gateway opcodes">
    /**
     * An event was dispatched
     */
    @Receive
    const val DISPATCH = 0

    /**
     * Fired periodically by the client to keep the connection alive
     */
    @Send
    @Receive
    const val HEARTBEAT = 1

    /**
     * Starts a new session during the initial handshake
     */
    @Send
    const val IDENTIFY = 2

    /**
     * Update the client's presence
     */
    @Send
    const val PRESENCE_UPDATE = 3

    /**
     * Used to join/leave or move between voice channels
     */
    @Send
    const val VOICE_STATE_UPDATE = 4

    /**
     * Resume a previous session that was disconnected
     */
    @Send
    const val RESUME = 6

    /**
     * You should attempt to reconnect and resume immediately
     */
    @Receive
    const val RECONNECT = 7

    /**
     * Request information about offline guild members in a large guild
     */
    @Send
    const val REQUEST_GUILD_MEMBERS = 8

    /**
     * The session has been invalidated. You should reconnect and identify/resume accordingly
     */
    @Receive
    const val INVALID_SESSION = 9

    /**
     * Sent immediately after connecting, contains the `heartbeat_interval` to use
     */
    @Receive
    const val HELLO = 10

    /**
     * Sent in response to receiving a heartbeat to acknowledge that it has been received
     */
    @Receive
    const val ACK = 11

    /**
     * Request information about soundboard sounds in a set of guilds
     */
    @Send
    const val REQUEST_SOUNDBOARD_SOUNDS = 31
    //</editor-fold>

    //<editor-fold desc="Gateway close event codes">
    /**
     * We're not sure what went wrong. Try reconnecting?
     */
    const val UNKNOWN_ERROR = 4000

    /**
     * You sent an invalid Gateway opcode or an invalid payload for an opcode. Don't do that
     */
    const val UNKNOWN_OPCODE = 4002

    /**
     * You sent an invalid payload to Discord. Don't do that
     */
    const val DECODE_ERROR = 4003

    /**
     * You sent us a payload prior to identifying, or this session has been invalidated
     */
    const val NOT_AUTHORIZED = 4004

    /**
     * The account token sent with your identify payload is incorrect
     */
    const val AUTHENTICATION_FAILED = 4005

    /**
     * You sent more than one identify payload. Don't do that!
     */
    const val ALREADY_AUTHENTICATED = 4006

    /**
     * The sequence sent when resuming the session was invalid. Reconnect and start a new session
     */
    const val INVALID_SEQ = 4007

    /**
     * Woah nelly! You're sending payloads to us too quickly. Slow it down! You will be disconnected on receiving this
     */
    const val RATE_LIMITED = 4008

    /**
     * Your session timed out. Reconnect and start a new one
     */
    const val SESSION_TIMEOUT = 4009

    /**
     * You sent us an invalid shard when identifying
     */
    const val INVALID_SHARD = 4010

    /**
     * The session would have handled too many guilds - you are required to shard your connection in order to connect
     */
    const val SHARDING_REQUIRED = 4011

    /**
     * You sent an invalid version for the gateway
     */
    const val INVALID_API_VERSION = 4012

    /**
     * You sent an invalid intent for a Gateway Intent. You may have incorrectly calculated the bitwise value
     */
    const val INVALID_INTENT = 4013

    /**
     * You sent a disallowed intent for a Gateway Intent.
     * You may have tried to specify an intent that you have not enabled or are not approved for
     */
    const val DISALLOWED_INTENT = 4014
    //</editor-fold>

    //<editor-fold desc="RPC close event codes">
    /**
     * You connected to the RPC server with an invalid client ID
     */
    const val INVALID_CLIENT_ID = 4000

    /**
     * You connected to the RPC server with an invalid origin
     */
    const val INVALID_ORIGIN = 4001

    /**
     * You are being rate limited
     */
    const val RPC_RATE_LIMITED = 4002

    /**
     * The OAuth2 token associated with a connection was revoked, get a new one!
     */
    const val TOKEN_REVOKED = 4003

    /**
     * The RPC Server version specified in the connection string was not valid
     */
    const val INVALID_VERSION = 4004

    /**
     * The encoding specified in the connection string was not valid
     */
    const val INVALID_ENCODING = 4005
    //</editor-fold>
}
