package com.inputstick.api.layout;

public class RussianLayout extends KeyboardLayout {
	
	public static final String LOCALE_NAME = 			"ru-RU";
	public static final String LAYOUT_NAME_NATIVE = 	"Русский";
	public static final String LAYOUT_NAME_ENGLISH = 	"Russian";
	public static final String LAYOUT_VARIANT = 		"RU";
	
	//{char (16b unicode), modifier, key, deadkey_modifier, deadkey}
	//ru-RU
	private static final int[][] FAST_LUT = {
		{	 0,	    0,	    0,	    0,	    0	},	// empty	
		{	10,	    0,	   40,	    0,	    0	},	// enter
		{	 9,	    0,	   43,	    0,	    0	},	// tab			
		{   32,	    0,	   44,	    0,	    0	},	// space
		{   33,	    2,	   30,	    0,	    0	},	// !
		{   34,	    2,	   31,	    0,	    0	},	// "
		{   37,	    2,	   34,	    0,	    0	},	// %
		{   40,	    2,	   38,	    0,	    0	},	// (
		{   41,	    2,	   39,	    0,	    0	},	// )
		{   42,	    2,	   37,	    0,	    0	},	// *
		{   43,	    2,	   46,	    0,	    0	},	// +
		{   44,	    2,	   56,	    0,	    0	},	// ,
		{   45,	    0,	   45,	    0,	    0	},	// -
		{   46,	    0,	   56,	    0,	    0	},	// .
		{   47,	    2,	   49,	    0,	    0	},	// /
		{   48,	    0,	   39,	    0,	    0	},	// 0
		{   49,	    0,	   30,	    0,	    0	},	// 1
		{   50,	    0,	   31,	    0,	    0	},	// 2
		{   51,	    0,	   32,	    0,	    0	},	// 3
		{   52,	    0,	   33,	    0,	    0	},	// 4
		{   53,	    0,	   34,	    0,	    0	},	// 5
		{   54,	    0,	   35,	    0,	    0	},	// 6
		{   55,	    0,	   36,	    0,	    0	},	// 7
		{   56,	    0,	   37,	    0,	    0	},	// 8
		{   57,	    0,	   38,	    0,	    0	},	// 9
		{   58,	    2,	   35,	    0,	    0	},	// :
		{   59,	    2,	   33,	    0,	    0	},	// ;
		{   61,	    0,	   46,	    0,	    0	},	// =
		{   63,	    2,	   36,	    0,	    0	},	// ?
		{   92,	    0,	   49,	    0,	    0	},	// backslash
		{   95,	    2,	   45,	    0,	    0	},	// _
		{ 1025,	    2,	   53,	    0,	    0	},	// Ё
		{ 1040,	    2,	    9,	    0,	    0	},	// А
		{ 1041,	    2,	   54,	    0,	    0	},	// Б
		{ 1042,	    2,	    7,	    0,	    0	},	// В
		{ 1043,	    2,	   24,	    0,	    0	},	// Г
		{ 1044,	    2,	   15,	    0,	    0	},	// Д
		{ 1045,	    2,	   23,	    0,	    0	},	// Е
		{ 1046,	    2,	   51,	    0,	    0	},	// Ж
		{ 1047,	    2,	   19,	    0,	    0	},	// З
		{ 1048,	    2,	    5,	    0,	    0	},	// И
		{ 1049,	    2,	   20,	    0,	    0	},	// Й
		{ 1050,	    2,	   21,	    0,	    0	},	// К
		{ 1051,	    2,	   14,	    0,	    0	},	// Л
		{ 1052,	    2,	   25,	    0,	    0	},	// М
		{ 1053,	    2,	   28,	    0,	    0	},	// Н
		{ 1054,	    2,	   13,	    0,	    0	},	// О
		{ 1055,	    2,	   10,	    0,	    0	},	// П
		{ 1056,	    2,	   11,	    0,	    0	},	// Р
		{ 1057,	    2,	    6,	    0,	    0	},	// С
		{ 1058,	    2,	   17,	    0,	    0	},	// Т
		{ 1059,	    2,	    8,	    0,	    0	},	// У
		{ 1060,	    2,	    4,	    0,	    0	},	// Ф
		{ 1061,	    2,	   47,	    0,	    0	},	// Х
		{ 1062,	    2,	   26,	    0,	    0	},	// Ц
		{ 1063,	    2,	   27,	    0,	    0	},	// Ч
		{ 1064,	    2,	   12,	    0,	    0	},	// Ш
		{ 1065,	    2,	   18,	    0,	    0	},	// Щ
		{ 1066,	    2,	   48,	    0,	    0	},	// Ъ
		{ 1067,	    2,	   22,	    0,	    0	},	// Ы
		{ 1068,	    2,	   16,	    0,	    0	},	// Ь
		{ 1069,	    2,	   52,	    0,	    0	},	// Э
		{ 1070,	    2,	   55,	    0,	    0	},	// Ю
		{ 1071,	    2,	   29,	    0,	    0	},	// Я
		{ 1072,	    0,	    9,	    0,	    0	},	// а
		{ 1073,	    0,	   54,	    0,	    0	},	// б
		{ 1074,	    0,	    7,	    0,	    0	},	// в
		{ 1075,	    0,	   24,	    0,	    0	},	// г
		{ 1076,	    0,	   15,	    0,	    0	},	// д
		{ 1077,	    0,	   23,	    0,	    0	},	// е
		{ 1078,	    0,	   51,	    0,	    0	},	// ж
		{ 1079,	    0,	   19,	    0,	    0	},	// з
		{ 1080,	    0,	    5,	    0,	    0	},	// и
		{ 1081,	    0,	   20,	    0,	    0	},	// й
		{ 1082,	    0,	   21,	    0,	    0	},	// к
		{ 1083,	    0,	   14,	    0,	    0	},	// л
		{ 1084,	    0,	   25,	    0,	    0	},	// м
		{ 1085,	    0,	   28,	    0,	    0	},	// н
		{ 1086,	    0,	   13,	    0,	    0	},	// о
		{ 1087,	    0,	   10,	    0,	    0	},	// п
		{ 1088,	    0,	   11,	    0,	    0	},	// р
		{ 1089,	    0,	    6,	    0,	    0	},	// с
		{ 1090,	    0,	   17,	    0,	    0	},	// т
		{ 1091,	    0,	    8,	    0,	    0	},	// у
		{ 1092,	    0,	    4,	    0,	    0	},	// ф
		{ 1093,	    0,	   47,	    0,	    0	},	// х
		{ 1094,	    0,	   26,	    0,	    0	},	// ц
		{ 1095,	    0,	   27,	    0,	    0	},	// ч
		{ 1096,	    0,	   12,	    0,	    0	},	// ш
		{ 1097,	    0,	   18,	    0,	    0	},	// щ
		{ 1098,	    0,	   48,	    0,	    0	},	// ъ
		{ 1099,	    0,	   22,	    0,	    0	},	// ы
		{ 1100,	    0,	   16,	    0,	    0	},	// ь
		{ 1101,	    0,	   52,	    0,	    0	},	// э
		{ 1102,	    0,	   55,	    0,	    0	},	// ю
		{ 1103,	    0,	   29,	    0,	    0	},	// я
		{ 1105,	    0,	   53,	    0,	    0	},	// ё
		{ 8470,	    2,	   32,	    0,	    0	},	// №
	};	
	
	public static final int LUT[][] = {
	/*	0	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	1	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	2	*/	{	0	,	(int)'1'	,	0x21	,	-1	,	-1	,	-1	}	,
	/*	3	*/	{	0	,	(int)'2'	,	0x22	,	-1	,	-1	,	-1	}	,
	/*	4	*/	{	0	,	(int)'3'	,	0x2116	,	-1	,	-1	,	-1	}	,
	/*	5	*/	{	0	,	(int)'4'	,	0x003b	,	-1	,	-1	,	-1	}	,
	/*	6	*/	{	0	,	(int)'5'	,	0x25	,	-1	,	-1	,	-1	}	,
	/*	7	*/	{	0	,	(int)'6'	,	0x003a	,	-1	,	-1	,	-1	}	,
	/*	8	*/	{	0	,	(int)'7'	,	0x003f	,	-1	,	-1	,	-1	}	,
	/*	9	*/	{	0	,	(int)'8'	,	0x002a	,	-1	,	-1	,	-1	}	,
	/*	0a	*/	{	0	,	(int)'9'	,	0x28	,	-1	,	-1	,	-1	}	,
	/*	0b	*/	{	0	,	(int)'0'	,	0x29	,	-1	,	-1	,	-1	}	,
	/*	0c	*/	{	0	,	0x002d	,	0x005f	,	-1	,	-1	,	-1	}	,
	/*	0d	*/	{	0	,	0x003d	,	0x002b	,	-1	,	-1	,	-1	}	,
	/*	0e	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	0f	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	
	/*	10	*/	{	1	,	0x439	,	0x419	,	-1	,	-1	,	-1	}	,
	/*	11	*/	{	1	,	0x446	,	0x426	,	-1	,	-1	,	-1	}	,
	/*	12	*/	{	1	,	0x443	,	0x423	,	-1	,	-1	,	-1	}	,
	/*	13	*/	{	1	,	0x043a	,	0x041a	,	-1	,	-1	,	-1	}	,
	/*	14	*/	{	1	,	0x435	,	0x415	,	-1	,	-1	,	-1	}	,
	/*	15	*/	{	1	,	0x043d	,	0x041d	,	-1	,	-1	,	-1	}	,
	/*	16	*/	{	1	,	0x433	,	0x413	,	-1	,	-1	,	-1	}	,
	/*	17	*/	{	1	,	0x448	,	0x428	,	-1	,	-1	,	-1	}	,
	/*	18	*/	{	1	,	0x449	,	0x429	,	-1	,	-1	,	-1	}	,
	/*	19	*/	{	1	,	0x437	,	0x417	,	-1	,	-1	,	-1	}	,
	/*	1a	*/	{	1	,	0x445	,	0x425	,	-1	,	-1	,	-1	}	,
	/*	1b	*/	{	1	,	0x044a	,	0x042a	,	-1	,	-1	,	-1	}	,
	/*	1c	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	1d	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	1e	*/	{	1	,	0x444	,	0x424	,	-1	,	-1	,	-1	}	,
	/*	1f	*/	{	1	,	0x044b	,	0x042b	,	-1	,	-1	,	-1	}	,
	
	
	/*	20	*/	{	1	,	0x432	,	0x412	,	-1	,	-1	,	-1	}	,
	/*	21	*/	{	1	,	0x430	,	0x410	,	-1	,	-1	,	-1	}	,
	/*	22	*/	{	1	,	0x043f	,	0x041f	,	-1	,	-1	,	-1	}	,
	/*	23	*/	{	1	,	0x440	,	0x420	,	-1	,	-1	,	-1	}	,
	/*	24	*/	{	1	,	0x043e	,	0x041e	,	-1	,	-1	,	-1	}	,
	/*	25	*/	{	1	,	0x043b	,	0x041b	,	-1	,	-1	,	-1	}	,
	/*	26	*/	{	1	,	0x434	,	0x414	,	-1	,	-1	,	-1	}	,
	/*	27	*/	{	1	,	0x436	,	0x416	,	-1	,	-1	,	-1	}	,
	/*	28	*/	{	1	,	0x044d	,	0x042d	,	-1	,	-1	,	-1	}	,
	/*	29	*/	{	1	,	0x451	,	0x401	,	-1	,	-1	,	-1	}	,
	/*	2a	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	2b	*/	{	0	,	0x005c	,	0x002f	,	0x001c	,	-1	,	-1	}	,
	/*	2c	*/	{	1	,	0x044f	,	0x042f	,	-1	,	-1	,	-1	}	,
	/*	2d	*/	{	1	,	0x447	,	0x427	,	-1	,	-1	,	-1	}	,
	/*	2e	*/	{	1	,	0x441	,	0x421	,	-1	,	-1	,	-1	}	,
	/*	2f	*/	{	1	,	0x043c	,	0x041c	,	-1	,	-1	,	-1	}	,
	
	
	/*	30	*/	{	1	,	0x438	,	0x418	,	-1	,	-1	,	-1	}	,
	/*	31	*/	{	1	,	0x442	,	0x422	,	-1	,	-1	,	-1	}	,
	/*	32	*/	{	1	,	0x044c	,	0x042c	,	-1	,	-1	,	-1	}	,
	/*	33	*/	{	1	,	0x431	,	0x411	,	-1	,	-1	,	-1	}	,
	/*	34	*/	{	1	,	0x044e	,	0x042e	,	-1	,	-1	,	-1	}	,
	/*	35	*/	{	0	,	0x002e	,	0x002c	,	-1	,	-1	,	-1	}	,
	/*	36	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	37	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	38	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	39	*/	{	0	,	0x20	,	0x20	,	0x20	,	-1	,	-1	}	,
	/*	3a	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	3b	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	3c	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	3d	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	3e	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	3f	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	
	/*	40	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	41	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	42	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	43	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	44	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	45	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	46	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	47	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,	
	/*	48	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	49	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	4a	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	4b	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	4c	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	4d	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	4e	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	4f	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	
	
	/*	50	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	51	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,	
	/*	52	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	53	*/	{	0	,	0x002c	,	0x002c	,	-1	,	-1	,	-1	}	,
	/*	54	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	55	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	56	*/	{	0	,	0x005c	,	0x002f	,	0x001c	,	-1	,	-1	}	,
	/*	57	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,	
	/*	58	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	59	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	5a	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	5b	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	5c	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	5d	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	5e	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,
	/*	5f	*/	{	-1	,	0			,	0		,	0	,	0	,	0	}	,				
		
	};
	
	public static final int DEADKEYS[] = null;
	public static final int DEADKEY_LUT[][] = null;
	
	private static RussianLayout instance = new RussianLayout();
	
	private RussianLayout() {
	}
	
	public static RussianLayout getInstance() {
		return instance;
	}	
	
	@Override
	public int[][] getLUT() {
		return LUT;
	}

	@Override
	public int[][] getFastLUT() {
		return FAST_LUT;
	}

	@Override
	public void type(String text) {
		super.type(FAST_LUT, text, (byte)0);
	}	
	
	@Override
	public void type(String text, int typingSpeed) {
		super.type(FAST_LUT, text, (byte)0, typingSpeed);
	}
	
	@Override
	public void type(String text, byte modifiers) {
		super.type(FAST_LUT, text, modifiers);
	}
	
	@Override
	public void type(String text, byte modifiers, int typingSpeed) {
		super.type(FAST_LUT, text, modifiers, typingSpeed);
	}
	
	@Override
	public char getChar(int scanCode, boolean capsLock, boolean shift, boolean altGr) {
		return super.getChar(LUT, scanCode, capsLock, shift, altGr);
	}	
	
	@Override
	public String getLocaleName() {		
		return LOCALE_NAME;
	}	
	
	@Override
	public String getNativeName() {
		return LAYOUT_NAME_NATIVE; 
	}
	
	@Override
	public String getEnglishName() {
		return LAYOUT_NAME_ENGLISH;
	}
	
	@Override
	public String getVariant() {
		return LAYOUT_VARIANT;
	}
	
	@Override
	public int[][] getDeadkeyLUT() {		
		return DEADKEY_LUT;
	}

	@Override
	public int[] getDeadkeys() {
		return DEADKEYS;
	}

}
