package com.inputstick.api.layout;

public class GreekLayout extends KeyboardLayout {
	
	public static final String LOCALE_NAME = 			"el-GR";
	public static final String LAYOUT_NAME_NATIVE = 	"Ελληνικά";
	public static final String LAYOUT_NAME_ENGLISH = 	"Greek";
	public static final String LAYOUT_VARIANT = 		"GR";
	
	//{char (16b unicode), modifier, key, deadkey_modifier, deadkey}
	//de-DE
	private static final int[][] FAST_LUT = {
		{    0,	    0,	    0,	    0,	    0	},	// empty
		{    9,	    0,	   43,	    0,	    0	},	// tab
		{   10,	    0,	   40,	    0,	    0	},	// enter
		{   32,	    0,	   44,	    0,	    0	},	// space
		{   33,	    2,	   30,	    0,	    0	},	// !
		{   34,	    2,	   52,	    0,	    0	},	// "
		{   35,	    2,	   32,	    0,	    0	},	// #
		{   36,	    2,	   33,	    0,	    0	},	// $
		{   37,	    2,	   34,	    0,	    0	},	// %
		{   38,	    2,	   36,	    0,	    0	},	// &
		{   39,	    0,	   52,	    0,	    0	},	// '
		{   40,	    2,	   38,	    0,	    0	},	// (
		{   41,	    2,	   39,	    0,	    0	},	// )
		{   42,	    2,	   37,	    0,	    0	},	// *
		{   43,	    2,	   46,	    0,	    0	},	// +
		{   44,	    0,	   54,	    0,	    0	},	// ,
		{   45,	    0,	   45,	    0,	    0	},	// -
		{   46,	    0,	   55,	    0,	    0	},	// .
		{   47,	    0,	   56,	    0,	    0	},	// /
		{   48,	    0,	   39,	    0,	    0	},	// 0
		{   49,	    0,	   30,	    0,	    0	},	// 1
		{   50,	    0,	   31,	    0,	    0	},	// 2
		{   51,	    0,	   32,	    0,	    0	},	// 3
		{   52,	    0,	   33,	    0,	    0	},	// 4
		{   53,	    0,	   34,	    0,	    0	},	// 5
		{   54,	    0,	   35,	    0,	    0	},	// 6
		{   55,	    0,	   36,	    0,	    0	},	// 7
		{   56,	    0,	   37,	    0,	    0	},	// 8
		{   57,	    0,	   38,	    0,	    0	},	// 9
		{   58,	    2,	   20,	    0,	    0	},	// :
		{   59,	    0,	   20,	    0,	    0	},	// ;
		{   60,	    2,	   54,	    0,	    0	},	// <
		{   61,	    0,	   46,	    0,	    0	},	// =
		{   62,	    2,	   55,	    0,	    0	},	// >
		{   63,	    2,	   56,	    0,	    0	},	// ?
		{   64,	    2,	   31,	    0,	    0	},	// @
		{   91,	    0,	   47,	    0,	    0	},	// [
		{   92,	    0,	   49,	    0,	    0	},	// backslash
		{   93,	    0,	   48,	    0,	    0	},	// ]
		{   94,	    2,	   35,	    0,	    0	},	// ^
		{   95,	    2,	   45,	    0,	    0	},	// _
		{   96,	    0,	   53,	    0,	    0	},	// `
		{  123,	    2,	   47,	    0,	    0	},	// {
		{  124,	    2,	   49,	    0,	    0	},	// |
		{  125,	    2,	   48,	    0,	    0	},	// }
		{  126,	    2,	   53,	    0,	    0	},	// ~
		{  163,	   64,	   33,	    0,	    0	},	// £
		{  164,	   64,	   37,	    0,	    0	},	// ¤
		{  165,	   64,	   28,	    0,	    0	},	// ¥
		{  166,	   64,	   38,	    0,	    0	},	// ¦
		{  167,	   64,	   34,	    0,	    0	},	// §
		{  168,	    0,	   44,	    2,	   51	},	// ¨
		{  169,	   64,	    6,	    0,	    0	},	// ©
		{  171,	   64,	   47,	    0,	    0	},	// «
		{  172,	   64,	   49,	    0,	    0	},	// ¬
		{  174,	   64,	   21,	    0,	    0	},	// ®
		{  176,	   64,	   39,	    0,	    0	},	// °
		{  177,	   64,	   45,	    0,	    0	},	// ±
		{  178,	   64,	   31,	    0,	    0	},	// ²
		{  179,	   64,	   32,	    0,	    0	},	// ³
		{  182,	   64,	   35,	    0,	    0	},	// ¶
		{  187,	   64,	   48,	    0,	    0	},	// »
		{  189,	   64,	   46,	    0,	    0	},	// ½
		{  900,	    0,	   44,	    0,	   51	},	// ΄
		{  901,	    0,	   44,	    2,	   26	},	// ΅
		{  902,	    2,	    4,	    0,	   51	},	// Ά
		{  904,	    2,	    8,	    0,	   51	},	// Έ
		{  905,	    2,	   11,	    0,	   51	},	// Ή
		{  906,	    2,	   12,	    0,	   51	},	// Ί
		{  908,	    2,	   18,	    0,	   51	},	// Ό
		{  910,	    2,	   28,	    0,	   51	},	// Ύ
		{  911,	    2,	   25,	    0,	   51	},	// Ώ
		{  912,	    0,	   12,	    2,	   26	},	// ΐ
		{  913,	    2,	    4,	    0,	    0	},	// Α
		{  914,	    2,	    5,	    0,	    0	},	// Β
		{  915,	    2,	   10,	    0,	    0	},	// Γ
		{  916,	    2,	    7,	    0,	    0	},	// Δ
		{  917,	    2,	    8,	    0,	    0	},	// Ε
		{  918,	    2,	   29,	    0,	    0	},	// Ζ
		{  919,	    2,	   11,	    0,	    0	},	// Η
		{  920,	    2,	   24,	    0,	    0	},	// Θ
		{  921,	    2,	   12,	    0,	    0	},	// Ι
		{  922,	    2,	   14,	    0,	    0	},	// Κ
		{  923,	    2,	   15,	    0,	    0	},	// Λ
		{  924,	    2,	   16,	    0,	    0	},	// Μ
		{  925,	    2,	   17,	    0,	    0	},	// Ν
		{  926,	    2,	   13,	    0,	    0	},	// Ξ
		{  927,	    2,	   18,	    0,	    0	},	// Ο
		{  928,	    2,	   19,	    0,	    0	},	// Π
		{  929,	    2,	   21,	    0,	    0	},	// Ρ
		{  931,	    2,	   22,	    0,	    0	},	// Σ
		{  932,	    2,	   23,	    0,	    0	},	// Τ
		{  933,	    2,	   28,	    0,	    0	},	// Υ
		{  934,	    2,	    9,	    0,	    0	},	// Φ
		{  935,	    2,	   27,	    0,	    0	},	// Χ
		{  936,	    2,	    6,	    0,	    0	},	// Ψ
		{  937,	    2,	   25,	    0,	    0	},	// Ω
		{  938,	    2,	   12,	    2,	   51	},	// Ϊ
		{  939,	    2,	   28,	    2,	   51	},	// Ϋ
		{  940,	    0,	    4,	    0,	   51	},	// ά
		{  941,	    0,	    8,	    0,	   51	},	// έ
		{  942,	    0,	   11,	    0,	   51	},	// ή
		{  943,	    0,	   12,	    0,	   51	},	// ί
		{  944,	    0,	   28,	    2,	   26	},	// ΰ
		{  945,	    0,	    4,	    0,	    0	},	// α
		{  946,	    0,	    5,	    0,	    0	},	// β
		{  947,	    0,	   10,	    0,	    0	},	// γ
		{  948,	    0,	    7,	    0,	    0	},	// δ
		{  949,	    0,	    8,	    0,	    0	},	// ε
		{  950,	    0,	   29,	    0,	    0	},	// ζ
		{  951,	    0,	   11,	    0,	    0	},	// η
		{  952,	    0,	   24,	    0,	    0	},	// θ
		{  953,	    0,	   12,	    0,	    0	},	// ι
		{  954,	    0,	   14,	    0,	    0	},	// κ
		{  955,	    0,	   15,	    0,	    0	},	// λ
		{  956,	    0,	   16,	    0,	    0	},	// μ
		{  957,	    0,	   17,	    0,	    0	},	// ν
		{  958,	    0,	   13,	    0,	    0	},	// ξ
		{  959,	    0,	   18,	    0,	    0	},	// ο
		{  960,	    0,	   19,	    0,	    0	},	// π
		{  961,	    0,	   21,	    0,	    0	},	// ρ
		{  962,	    0,	   26,	    0,	    0	},	// ς
		{  963,	    0,	   22,	    0,	    0	},	// σ
		{  964,	    0,	   23,	    0,	    0	},	// τ
		{  965,	    0,	   28,	    0,	    0	},	// υ
		{  966,	    0,	    9,	    0,	    0	},	// φ
		{  967,	    0,	   27,	    0,	    0	},	// χ
		{  968,	    0,	    6,	    0,	    0	},	// ψ
		{  969,	    0,	   25,	    0,	    0	},	// ω
		{  970,	    0,	   12,	    2,	   51	},	// ϊ
		{  971,	    0,	   28,	    2,	   51	},	// ϋ
		{  972,	    0,	   18,	    0,	   51	},	// ό
		{  973,	    0,	   28,	    0,	   51	},	// ύ
		{  974,	    0,	   25,	    0,	   51	},	// ώ
		{ 8364,	   64,	    8,	    0,	    0	},	// €
	};	
	
	public static final int LUT[][] = {		
		/*	0	*/	{	-1	,	0			,	0		,	0		,	0		,	0		}	,
		/*	1	*/	{	-1	,	0			,	0		,	0		,	0		,	0		}	,		
		/*	02	*/	{	0	,	(int)'1'	,	0x0021	,	-1		,	-1		,	-1		}	,
		/*	03	*/	{	0	,	(int)'2'	,	0x0040	,	-1		,	0x00b2	,	-1		}	,
		/*	04	*/	{	0	,	(int)'3'	,	0x0023	,	-1		,	0x00b3	,	-1		}	,
		/*	05	*/	{	0	,	(int)'4'	,	0x0024	,	-1		,	0x00a3	,	-1		}	,
		/*	06	*/	{	0	,	(int)'5'	,	0x0025	,	-1		,	0x00a7	,	-1		}	,
		/*	07	*/	{	0	,	(int)'6'	,	0x005e	,	-1		,	0x00b6	,	-1		}	,
		/*	08	*/	{	0	,	(int)'7'	,	0x0026	,	-1		,	-1		,	-1		}	,
		/*	09	*/	{	0	,	(int)'8'	,	0x002a	,	-1		,	0x00a4	,	-1		}	,
		/*	0a	*/	{	0	,	(int)'9'	,	0x0028	,	-1		,	0x00a6	,	-1		}	,
		/*	0b	*/	{	0	,	(int)'0'	,	0x0029	,	-1		,	0x00b0	,	-1		}	,
		/*	0c	*/	{	0	,	0x002d		,	0x005f	,	-1		,	0x00b1	,	-1		}	,
		/*	0d	*/	{	0	,	0x003d		,	0x002b	,	-1		,	0x00bd	,	-1		}	,
		/*	0e	*/	{	-1	,	0			,	0		,	0		,	0		,	0		}	,
		/*	0f	*/	{	-1	,	0			,	0		,	0		,	0		,	0		}	,		
		
		/*	10	*/	{	0	,	0x003b	,	0x003a	,	-1			,	-1		,	-1		}	,
		/*	11	*/	{	0	,	0x03c2	,	0x0385	,	-1			,	-1		,	-1		}	,
		/*	12	*/	{	1	,	0x03b5	,	0x0395	,	-1			,	0x20ac	,	-1		}	,
		/*	13	*/	{	1	,	0x03c1	,	0x03a1	,	-1			,	0x00ae	,	-1		}	,
		/*	14	*/	{	1	,	0x03c4	,	0x03a4	,	-1			,	-1		,	-1		}	,
		/*	15	*/	{	1	,	0x03c5	,	0x03a5	,	-1			,	0x00a5	,	-1		}	,
		/*	16	*/	{	1	,	0x03b8	,	0x0398	,	-1			,	-1		,	-1		}	,
		/*	17	*/	{	1	,	0x03b9	,	0x0399	,	-1			,	-1		,	-1		}	,
		/*	18	*/	{	1	,	0x03bf	,	0x039f	,	-1			,	-1		,	-1		}	,
		/*	19	*/	{	1	,	0x03c0	,	0x03a0	,	-1			,	-1		,	-1		}	,
		/*	1a	*/	{	0	,	0x005b	,	0x007b	,	0x001b		,	0x00ab	,	-1		}	,
		/*	1b	*/	{	0	,	0x005d	,	0x007d	,	0x001d		,	0x00bb	,	-1		}	,		
		/*	1c	*/	{	-1	,	0		,	0		,	0			,	0		,	0		}	,
		/*	1d	*/	{	-1	,	0		,	0		,	0			,	0		,	0		}	,		
		/*	1e	*/	{	1	,	0x03b1	,	0x0391	,	-1			,	-1		,	-1		}	,
		/*	1f	*/	{	1	,	0x03c3	,	0x03a3	,	-1			,	-1		,	-1		}	,		
		
		/*	20	*/	{	1	,	0x03b4	,	0x0394	,	-1			,	-1		,	-1		}	,
		/*	21	*/	{	1	,	0x03c6	,	0x03a6	,	-1			,	-1		,	-1		}	,
		/*	22	*/	{	1	,	0x03b3	,	0x0393	,	-1			,	-1		,	-1		}	,
		/*	23	*/	{	1	,	0x03b7	,	0x0397	,	-1			,	-1		,	-1		}	,
		/*	24	*/	{	1	,	0x03be	,	0x039e	,	-1			,	-1		,	-1		}	,
		/*	25	*/	{	1	,	0x03ba	,	0x039a	,	-1			,	-1		,	-1		}	,
		/*	26	*/	{	1	,	0x03bb	,	0x039b	,	-1			,	-1		,	-1		}	,
		/*	27	*/	{	0	,	0x0384	,	0x00a8	,	-1			,	0x0385	,	-1		}	,
		/*	28	*/	{	0	,	0x0027	,	0x0022	,	0x001c		,	-1		,	-1		}	,
		/*	29	*/	{	0	,	0x0060	,	0x007e	,	-1			,	-1		,	-1		}	,
		/*	2a	*/	{	-1	,	0		,	0		,	0			,	0		,	0		}	,
		/*	2b	*/	{	0	,	0x005c	,	0x007c	,	0x001c		,	0x00ac	,	-1		}	,
		/*	2c	*/	{	1	,	0x03b6	,	0x0396	,	-1			,	-1		,	-1		}	,
		/*	2d	*/	{	1	,	0x03c7	,	0x03a7	,	-1			,	-1		,	-1		}	,
		/*	2e	*/	{	1	,	0x03c8	,	0x03a8	,	-1			,	0x00a9	,	-1		}	,
		/*	2f	*/	{	1	,	0x03c9	,	0x03a9	,	-1			,	-1		,	-1		}	,				
		
		/*	30	*/	{	1	,	0x03b2		,	0x0392		,	-1		,	-1		,	-1		}	,
		/*	31	*/	{	1	,	0x03bd		,	0x039d		,	-1		,	-1		,	-1		}	,
		/*	32	*/	{	1	,	0x03bc		,	0x039c		,	-1		,	-1		,	-1		}	,
		/*	33	*/	{	0	,	0x002c		,	0x003c		,	-1		,	-1		,	-1		}	,
		/*	34	*/	{	0	,	0x002e		,	0x003e		,	-1		,	-1		,	-1		}	,		
		/*	35	*/	{	0	,	0x002f		,	0x003f		,	-1		,	-1		,	-1		}	,
		/*	36	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	37	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	38	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	39	*/	{	0	,	0x0020		,	0x0020		,	0020	,	-1		,	-1		}	,
		/*	3a	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	3b	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	3c	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	3d	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	3e	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	3f	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		
		/*	40	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	41	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	42	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	43	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	44	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	45	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	46	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	47	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,	
		/*	48	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	49	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	4a	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	4b	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	4c	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	4d	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	4e	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	4f	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		
		/*	50	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	51	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,	
		/*	52	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	53	*/	{	0	,	0x002c		,	0x002c		,	-1		,	-1		,	-1		}	,
		/*	54	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	55	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	56	*/	{	0	,	0x003c		,	0x003e		,	0x001c	,	-1		,	-1		}	,
		/*	57	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,	
		/*	58	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	59	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	5a	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	5b	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	5c	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	5d	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	5e	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,
		/*	5f	*/	{	-1	,	0			,	0			,	0		,	0		,	0		}	,		
		
	};
	
	public static final int DEADKEYS[] = {
		0x0385, 0x0384, 0x00a8
	};
	
	public static final int DEADKEY_LUT[][] = {
		{	0x0385	,	0x03b9	,	0x0390	}	,
		{	0x0385	,	0x03c5	,	0x03b0	}	,
		{	0x0385	,	0x0020	,	0x0385	}	,
		{	0x0384	,	0x03c9	,	0x03ce	}	,
		{	0x0384	,	0x03b1	,	0x03ac	}	,
		{	0x0384	,	0x03b7	,	0x03ae	}	,
		{	0x0384	,	0x03b5	,	0x03ad	}	,
		{	0x0384	,	0x03b9	,	0x03af	}	,
		{	0x0384	,	0x03c5	,	0x03cd	}	,
		{	0x0384	,	0x03bf	,	0x03cc	}	,
		{	0x0384	,	0x03a9	,	0x038f	}	,
		{	0x0384	,	0x0391	,	0x0386	}	,
		{	0x0384	,	0x0397	,	0x0389	}	,
		{	0x0384	,	0x0395	,	0x0388	}	,
		{	0x0384	,	0x0399	,	0x038a	}	,
		{	0x0384	,	0x03a5	,	0x038e	}	,
		{	0x0384	,	0x039f	,	0x038c	}	,
		{	0x0384	,	0x0020	,	0x0384	}	,
		{	0x00a8	,	0x03b9	,	0x03ca	}	,
		{	0x00a8	,	0x03c5	,	0x03cb	}	,
		{	0x00a8	,	0x0399	,	0x03aa	}	,
		{	0x00a8	,	0x03a5	,	0x03ab	}	,
		{	0x00a8	,	0x0020	,	0x00a8	}	,				
	};
	
	private static GreekLayout instance = new GreekLayout();
	
	private GreekLayout() {
	}
	
	public static GreekLayout getInstance() {
		return instance;
	}	
	
	@Override
	public int[][] getLUT() {
		return LUT;
	}

	@Override
	public int[][] getFastLUT() {
		return FAST_LUT;
	}

	@Override
	public void type(String text) {
		super.type(FAST_LUT, text, (byte)0);
	}	
	
	@Override
	public void type(String text, int typingSpeed) {
		super.type(FAST_LUT, text, (byte)0, typingSpeed);
	}
	
	@Override
	public void type(String text, byte modifiers) {
		super.type(FAST_LUT, text, modifiers);
	}
	
	@Override
	public void type(String text, byte modifiers, int typingSpeed) {
		super.type(FAST_LUT, text, modifiers, typingSpeed);
	}
	
	@Override
	public char getChar(int scanCode, boolean capsLock, boolean shift, boolean altGr) {
		return super.getChar(LUT, scanCode, capsLock, shift, altGr);
	}	
	
	@Override
	public String getLocaleName() {		
		return LOCALE_NAME;
	}	
	
	@Override
	public String getNativeName() {
		return LAYOUT_NAME_NATIVE; 
	}
	
	@Override
	public String getEnglishName() {
		return LAYOUT_NAME_ENGLISH;
	}
	
	@Override
	public String getVariant() {
		return LAYOUT_VARIANT;
	}
	
	@Override
	public int[][] getDeadkeyLUT() {		
		return DEADKEY_LUT;
	}

	@Override
	public int[] getDeadkeys() {
		return DEADKEYS;
	}

}
