package me.danb.retherm;

public class ThermocoupleCalculator {

    public double MvToCelsius(String tcType, double mv) throws Exception {
        double[] tcParams;

        if (tcType.equals("b")) {
            tcParams = paramsForB(mv);
        } else if (tcType.equals("e")) {
            tcParams = paramsForE(mv);
        } else if (tcType.equals("j")) {
            tcParams = paramsForJ(mv);
        } else if (tcType.equals("k")) {
            tcParams = paramsForK(mv);
        } else if (tcType.equals("n")) {
            tcParams = paramsForN(mv);
        } else if (tcType.equals("r")) {
            tcParams = paramsForR(mv);
        } else if (tcType.equals("s")) {
            tcParams = paramsForS(mv);
        } else if (tcType.equals("t")) {
            tcParams = paramsForT(mv);
        } else {
            throw new Exception("Thermocouple type [" + tcType + "] not expected");
        }

        if (tcParams == null) {
            throw new Exception("mV value out of range");
        }

        return thermocoupleEquation(tcParams, mv);
    };

    private double[] paramsForB(double mv) {
        if (mv >= 0.29 && mv < 2.431) {
            return new double[]{5.0000000E+02, 1.2417900E+00, 1.9858097E+02, 2.4284248E+01, -9.7271640E+01, -1.5701178E+01, 3.1009445E-01, -5.0880251E-01, -1.6163342E-01};
        } else if (mv >= 2.431 && mv < 13.820) {
            return new double[] {1.2461474E+03, 7.2701221E+00, 9.4321033E+01, 7.3899296E+00, -1.5880987E-01, 1.2681877E-02, 1.0113834E-01, -1.6145962E-03, -4.1086314E-06};
        }
        return null;
    }

    private double[] paramsForE(double mv) {
        if (mv >= -9.835 && mv < -5.237) {
            return new double[]{-1.1721668E+02, -5.9901698E+00, 2.3647275E+01, 1.2807377E+01, 2.0665069E+00, 8.6513472E-02, 5.8995860E-01, 1.0960713E-01, 6.1769588E-03};
        } else if (mv >= -5.237 && mv < 0.591) {
            return new double[]{-5.0000000E+01, -2.7871777E+00, 1.9022736E+01, -1.7042725E+00, -3.5195189E-01, 4.7766102E-03, -6.5379760E-02, -2.1732833E-02, 0.0};
        } else if (mv >= 0.591 && mv < 24.964) {
            return new double[]{2.5014600E+02, 1.7191713E+01, 1.3115522E+01, 1.1780364E+00, 3.6422433E-02, 3.9584261E-04, 9.3112756E-02, 2.9804232E-03, 3.3263032E-05};
        } else if (mv >= 24.964 && mv < 53.112) {
            return new double[]{6.0139890E+02, 4.5206167E+01, 1.2399357E+01, 4.3399963E-01, 9.1967085E-03, 1.6901585E-04, 3.4424680E-02, 6.9741215E-04, 1.2946992E-05};
        } else if (mv >= 53.112 && mv < 76.373) {
            return new double[]{8.0435911E+02, 6.1359178E+01, 1.2759508E+01, -1.1116072E+00, 3.5332536E-02, 3.3080380E-05, -8.8196889E-02, 2.8497415E-03, 0.0};
        }
        return null;
    }

    private double[] paramsForJ(double mv) {
        if (mv >= -8.095 && mv < 0) {
            return new double[]{-6.4936529E+01, -3.1169773E+00, 2.2133797E+01, 2.0476437E+00, -4.6867532E-01, -3.6673992E-02, 1.1746348E-01, -2.0903413E-02, -2.1823704E-03};
        } else if (mv >= 0 && mv < 21.840) {
            return new double[]{2.5066947E+02, 1.3592329E+01, 1.8014787E+01, -6.5218881E-02, -1.2179108E-02, 2.0061707E-04, -3.9494552E-03, -7.3728206E-04, 1.6679731E-05};
        } else if (mv >= 21.840 && mv < 45.494) {
            return new double[]{6.4950262E+02, 3.6040848E+01, 1.6593395E+01, 7.3009590E-01, 2.4157343E-02, 1.2787077E-03, 4.9172861E-02, 1.6813810E-03, 7.6067922E-05};
        } else if (mv >= 45.494 && mv < 57.953) {
            return new double[]{9.2510550E+02, 5.3433832E+01, 1.6243326E+01, 9.2793267E-01, 6.4644193E-03, 2.0464414E-03, 5.2541788E-02, 1.3682959E-04, 1.3454746E-04};
        } else if (mv >= 57.953 && mv < 69.553) {
            return new double[]{1.0511294E+03, 6.0956091E+01, 1.7156001E+01, -2.5931041E+00, -5.8339803E-02, 1.9954137E-02, -1.5305581E-01, -2.9523967E-03, 1.1340164E-03};
        }
        return null;
    }

    private double[] paramsForK(double mv) {
        if (mv >= -6.5 && mv < -3.554) {
            return new double[]{-1.2147164E+02, -4.1790858E+00, 3.6069513E+01, 3.0722076E+01, 7.7913860E+00, 5.2593991E-01, 9.3939547E-01, 2.7791285E-01, 2.5163349E-02};
        } else if (mv >= -3.554 && mv < 4.096) {
            return new double[]{-8.7935962E+00, -3.4489914E-01, 2.5678719E+01, -4.9887904E-01, -4.4705222E-01, -4.4869203E-02, 2.3893439E-04, -2.0397750E-02, -1.8424107E-03};
        } else if (mv >= 4.096 && mv < 16.397) {
            return new double[]{3.1018976E+02, 1.2631386E+01, 2.4061949E+01, 4.0158622E+00, 2.6853917E-01, -9.7188544E-03, 1.6995872E-01, 1.1413069E-02, -3.9275155E-04};
        } else if (mv >= 16.397 && mv < 33.275) {
            return new double[]{6.0572562E+02, 2.5148718E+01, 2.3539401E+01, 4.6547228E-02, 1.3444400E-02, 5.9236853E-04, 8.3445513E-04, 4.6121445E-04, 2.5488122E-05};
        } else if (mv >= 33.275 && mv < 69.553) {
            return new double[]{1.0184705E+03, 4.1993851E+01, 2.5783239E+01, -1.8363403E+00, 5.6176662E-02, 1.8532400E-04, -7.4803355E-02, 2.3841860E-03, 0.0};
        }
        return null;
    }

    private double[] paramsForN(double mv) {
        if (mv >= -4.313 && mv < 0) {
            return new double[]{-5.9610511E+01, -1.5000000E+00, 4.2021322E+01, 4.7244037E+00, -6.1153213E+00, -9.9980337E-01, 1.6385664E-01, -1.4994026E-01, -3.0810372E-02};
        } else if (mv >= 0 && mv < 20.613) {
            return new double[]{3.1534505E+02, 9.8870997E+00, 2.7988676E+01, 1.5417343E+00, -1.4689457E-01, -6.8322712E-03, 6.2600036E-02, -5.1489572E-03, -2.8835863E-04};
        } else if (mv >= 20.613 && mv < 47.513) {
            return new double[]{1.0340172E+03, 3.7565475E+01, 2.6029492E+01, -6.0783095E-01, -9.7742562E-03, -3.3148813E-06, -2.5351881E-02, -3.8746827E-04, 1.7088177E-06};
        }
        return null;
    }

    private double[] paramsForR(double mv) {
        if (mv >= -0.226 && mv < 1.469) {
            return new double[]{1.3054315E+02, 8.8333090E-01, 1.2557377E+02, 1.3900275E+02, 3.3035469E+01, -8.5195924E-01, 1.2232896E+00, 3.5603023E-01, 0.0};
        } else if (mv >= 1.469 && mv < 7.461) {
            return new double[]{5.4188181E+02, 4.9312886E+00, 9.0208190E+01, 6.1762254E+00, -1.2279323E+00, 1.4873153E-02, 8.7670455E-02, -1.2906694E-02, 0.0};
        } else if (mv >= 7.461 && mv < 14.277) {
            return new double[]{1.0382132E+03, 1.1014763E+01, 7.4669343E+01, 3.4090711E+00, -1.4511205E-01, 6.3077387E-03, 5.6880253E-02, -2.0512736E-03, 0.0};
        } else if (mv >= 14.277 && mv < 21.101) {
            return new double[]{1.5676133E+03, 1.8397910E+01, 7.1646299E+01, -1.0866763E+00, -2.0968371E+00, -7.6741168E-01, -1.9712341E-02, -2.9903595E-02, -1.0766878E-02};
        }
        return null;
    }

    private double[] paramsForS(double mv) {
        if (mv >= -0.236 && mv < 1.441) {
            return new double[]{1.3792630E+02, 9.3395024E-01, 1.2761836E+02, 1.1089050E+02, 1.9898457E+01, 9.6152996E-02, 9.6545918E-01, 2.0813850E-01, 0.0};
        } else if (mv >= 1.441 && mv < 6.913) {
            return new double[]{4.7673468E+02, 4.0037367E+00, 1.0174512E+02, -8.9306371E+00, -4.2942435E+00, 2.0453847E-01, -7.1227776E-02, -4.4618306E-02, 1.6822887E-03};
        } else if (mv >= 6.913 && mv < 12.856) {
            return new double[]{9.7946589E+02, 9.3508283E+00, 8.7126730E+01, -2.3139202E+00, -3.2682118E-02, 4.6090022E-03, -1.4299790E-02, -1.2289882E-03, 0.0};
        } else if (mv >= 12.856 && mv < 18.693) {
            return new double[]{1.6010461E+03, 1.6789315E+01, 8.4315871E+01, -1.0185043E+01, -4.6283954E+00, -1.0158749E+00, -1.2877783E-01, -5.5802216E-02, -1.2146518E-02};
        }
        return null;
    }

    private double[] paramsForT(double mv) {
        if (mv >= -6.18 && mv < -4.648) {
            return new double[]{-1.9243000E+02, -5.4798963E+00, 5.9572141E+01, 1.9675733E+00, -7.8176011E+01, -1.0963280E+01, 2.7498092E-01, -1.3768944E+00, -4.5209805E-01};
        } else if (mv >= -4.648 && mv < 0) {
            return new double[]{-6.0000000E+01, -2.1528350E+00, 3.0449332E+01, -1.2946560E+00, -3.0500735E+00, -1.9226856E-01, 6.9877863E-03, -1.0596207E-01, -1.0774995E-02};
        } else if (mv >= 0 && mv < 9.288) {
            return new double[]{1.3500000E+02, 5.9588600E+00, 2.0325591E+01, 3.3013079E+00, 1.2638462E-01, -8.2883695E-04, 1.7595577E-01, 7.9740521E-03, 0.0};
        } else if (mv >= 9.288 && mv < 20.872) {
            return new double[]{3.0000000E+02, 1.4861780E+01, 1.7214707E+01, -9.3862713E-01, -7.3509066E-02, 2.9576140E-04, -4.8095795E-02, -4.7352054E-03, 0.00};
        }
        return null;
    }

    private double thermocoupleEquation(double[] ak, double mv) {
        double vvo = mv - ak[1];
        double ek1 = ak[5] * vvo;
        ek1 = ek1 + ak[4];
        ek1 = ek1 * vvo;
        ek1 = ek1 + ak[3];
        ek1 = ek1 * vvo;
        ek1 = ek1 + ak[2];
        ek1 = ek1 * vvo;
        double ek2 = vvo * ak[8];
        ek2 = ek2 + ak[7];
        ek2 = ek2 * vvo;
        ek2 = ek2 + ak[6];
        ek2 = ek2 * vvo;
        ek2 = ek2 + 1.0;
        double ek3 = ek1 / ek2;
        ek3 = ek3 + ak[0];
        return ek3;
    }
}
