package me.danb.retherm;

public class RtdCalculator {

    public Double RtdLinearFitToCelsius(double ohms, double ptRating, double alpha) throws Exception {
        double temp = (ohms / ptRating) - 1.0;
        temp = (temp / alpha) - 0.19;

        if (temp > -0.5 && temp < 101) {
            return temp;
        }

        throw new Exception("Out of range");
    }

    public Double EuropeOhmsToCelsius(double ohms, double factor) throws Exception {
        //Temp range -200 to 850c , Average error of �0.015�C
        ohms = ohms / factor;
        double c0 = -245.19;
        double c1 = 2.5293;
        double c2 = -0.066046;
        double c3 = 4.0422E-3;
        double c4 = -2.0697E-6;
        double c5 = -0.025422;
        double c6 = 1.6883E-3;
        double c7 = -1.3601E-6;
        double a = (ohms * c7) + c6;
        a = (a * ohms) + c5;
        a = (a * ohms) + 1;
        double b = (ohms * c4) + c3;
        b = (b * ohms) + c2;
        b = (b * ohms) + c1;
        b = b * ohms;
        double c = (b / a) + c0;

        if (c > (-200.00) && c < 850.00) {
            return c;
        }

        throw new Exception("Out of range");
    }
}
