# Easy Diary
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/unicodeveloper/awesome-opensource-apps)
[![Awesome Kotlin Badge](https://kotlin.link/awesome-kotlin.svg)](https://github.com/KotlinBy/awesome-kotlin)
[![License][licensesvg]][THIRDPARTY.md]

<img src="screenshots/ic_launcher.png" >

This is a diary application optimized for user experience.

## Download
Go to the Releases and download latest apk or click badges below.  

<a href='https://play.google.com/store/apps/details?id=me.blog.korn123.easydiary'><img alt='Get it on Google Play' src='https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png' width="258" height="98"/></a>
<a href='https://f-droid.org/en/packages/me.blog.korn123.easydiary'><img alt='Get it on F-Droid' src='screenshots/fdroid.png' height="98"/></a>     

## Privacy Policy 
* [Easy Diary Privacy Policy](https://hanjoongcho.github.io/aaf-easydiary/Privacy)
  
## Easy Diary User Manual  
Since 2023, we have been using notion and YouTube to create Easy Diary user manuals.  
* [Easy Diary Manual v0.1](https://spiced-skirt-15c.notion.site/User-Manual-v0-1-909b1fc94f5e40ccb8e8e560911c2e52)

## Star History
[![Star History Chart](https://api.star-history.com/svg?repos=hanjoongcho/aaf-easydiary,hanjoongcho/aaf-easyphotomap,hanjoongcho/aaf-easypassword&type=Date)](https://star-history.com/#hanjoongcho/aaf-easydiary&hanjoongcho/aaf-easyphotomap&hanjoongcho/aaf-easypassword&Date)

## Support Features
### ✍ Diary writing & editing
* You can create or edit content using the keypad and voice recognition function.
### 🔍 Diary search
* Saved content can be quickly retrieved. Words that match the searched keywords are highlighted and can be recognized at a glance.
### 📅 Calendar
* Saved content can be checked on a daily basis using the calendar.
### 🕒 Timeline
* Saved content can be checked in the form of a timeline according to the time it was created.
### 🃏 Diary Postcard
* You can create a diary postcard using saved content (including attached photos) and share it with your friends.
* Share anniversary or holiday greetings by making them pretty as postcards.
### 🔒 Lock
* The application can be locked or unlocked using a PIN (Personal Identification Number) or fingerprint recognition function.
### 🎨 Application Theme
* You can set 171 color themes and use the color picker to change text and text background colors to your liking.
### 🔤 Font
* If you have TTF fonts, you can use them by adding them to the Easy Diary font directory.
### 📊 Chart
* You can see at a glance the status of diary creation by time period in a bar chart.
###  💾 Backup & Restore
* All content, including attached photos, can be backed up and restored using Google Drive.

## Preview 2018 ~ Now
### Preview
[![Video Label](https://user-images.githubusercontent.com/7098851/236051294-2977764f-8878-4b3f-a1b2-e66e22daa99a.png)](https://youtu.be/7Lg8o-RHFhY)
### Custom Theme
[![Video Label](https://user-images.githubusercontent.com/7098851/236051470-ca8585ec-2552-4d89-8385-63f8b60a40a6.png)](https://youtu.be/hqdfXEfhvxQ)
### Markdown Syntax
[![Video Label](https://user-images.githubusercontent.com/7098851/236051854-5a71dec5-ef8d-4555-bbfd-fad54450c810.png)](https://youtu.be/dViTBSIHpwU)
### Welcom Dashboard popup
[![Video Label](https://user-images.githubusercontent.com/7098851/236052799-2d4fad30-30df-4698-8d53-96d0a19e3ca4.png)](https://youtu.be/wzSXtfg_JEs)
### Attached photo highlights
[![Video Label](https://user-images.githubusercontent.com/7098851/236053272-be8f0682-03c7-41b6-b490-8eae065b7236.png)](https://youtu.be/9AuGKZwZEB0)
### Location information display
[![Video Label](https://user-images.githubusercontent.com/7098851/236053735-f5ba6818-9ccd-439d-87ca-81cfbcde76f4.png)](https://youtu.be/DqJadC7YqKQ)
### Optimize card view design
[![Video Label](https://user-images.githubusercontent.com/7098851/236054115-895f0795-f50c-4553-b4ce-108ed14f270b.png)](https://youtu.be/T-9l0Q1GmF4)
### Calendar start day
[![Video Label](https://user-images.githubusercontent.com/7098851/236054537-e768d899-230b-43bd-9bb6-7cc98d9d95d0.png)](https://youtu.be/8JBuV5pHyXY)
### Font setting
[![Video Label](https://user-images.githubusercontent.com/7098851/236054817-c28de2ce-4ce9-477f-acac-ccaa91067e21.png)](https://youtu.be/o4RUw3lBEtc)
### Link Google Drive account
[![Video Label](https://user-images.githubusercontent.com/7098851/236055151-cbb8d709-9d90-4c26-85f1-dc945aaeb118.png)](https://youtu.be/vS9aszhEhwk)
### Easter egg (User defined symbol registration)
[![Video Label](https://user-images.githubusercontent.com/7098851/236055835-87247600-9b85-4a7e-9765-e3741b8c7c0e.png)](https://youtu.be/2vLxdrQTAio)

## Preview ~ 2018
### Write diary (voice or keypad)
<p align="left">
<img src="screenshots/01_1.jpg">
<img src="screenshots/01_2.jpg">
</p>

### Search diary
<p align="left">
<img src="screenshots/02.jpg">
</p>

### Read Diary
<p align="left">
<img src="screenshots/03_1.jpg">
<img src="screenshots/03_2.jpg">
</p>

### Edit Diary
<p align="left">
<img src="screenshots/04.jpg">
</p>

### Chart
<p align="left">
<img src="screenshots/05.jpg">
</p>

### Calendar
<p align="left">
<img src="screenshots/06.jpg">
</p>

### Diary Card
<p align="left">
<img src="screenshots/app_easydiary10_01_en.png" width="288" height="512">
<img src="screenshots/app_easydiary10_02_en.png" width="288" height="512">
<img src="screenshots/app_easydiary10_03.png" width="288" height="512">
<img src="screenshots/app_easydiary10_04.png" width="288" height="512">
<img src="screenshots/app_easydiary10_05_en.png" width="288" height="512">
<img src="screenshots/app_easydiary10_06_en.png" width="288" height="512">
<img src="screenshots/app_easydiary10_07_en.png" width="288" height="512">
</p>

### Time Line
<p align="left">
<img src="screenshots/08_1.jpg">
<img src="screenshots/08_2.jpg">
<img src="screenshots/08_3.jpg">
</p>

### Advanced Settings
<p align="left">
<img src="screenshots/app_easydiary09_01_en.png" width="288" height="512">
<img src="screenshots/app_easydiary09_03_en.png" width="288" height="512">
<img src="screenshots/app_easydiary09_02_en.png" width="288" height="512">
<img src="screenshots/app_easydiary06_en.png" width="288" height="512">
</p>

## How to build
### GMS Flavor
To build the gms flavor build, you need to add your Google Mobile Service settings and download the weather icons from Flaticon and import them directly.
```
Step1. Fork or download 'aaf-easydiary' project.
Step2. Import 'aaf-easydiary' project into android studio.
Step3. Setting storeFile and storePassword in local.properties file
       +++++++ local.properties +++++++++++++++++++++++++++++++++++
       storeFile=your signing key location
       storePassword=your password
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
       +++++++ example ++++++++++++++++++++++++++++++++++++++++++++
       storeFile=C:/dev/android/app-signing.jks
       storePassword=sjdiSDAss3!@#
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
       If you do not have the signing key, you can create it by referring to the link below:
       https://developer.android.com/studio/publish/app-signing#generate-key
Step4. Use below link download svg images from Flaticon.
Step5. Import 10 svg files for your project from your Android studio.
       Project rightclick > New > Vector Asset...(Res Directory is gms)
       You can import from the menu and the resource names are:
       clouds-and-sun.svg -> ic_clouds_and_sun.xml
       umbrella-1.svg     -> ic_umbrella_1.xml
       sunny.svg          -> ic_sunny.xml
       stars-2.svg        -> ic_stars_2.xml
       snowing.svg        -> ic_snowing.xml
       raindrops.svg      -> ic_raindrops.xml
       rainbow.svg        -> ic_rainbow.xml
       night-rain.svg     -> ic_night_rain.xml
       moon-9.svg         -> ic_moon_9.xml
       bolt.svg           -> ic_bolt.xml
Step6. Use the link below enable the drive API
       https://console.developers.google.com/
Step7. Use the link below create an OAuth 2.0 Client ID:
       https://console.developers.google.com/
Step8. Define OAuth 2.0 Client ID in the '/app/src/gms/res/values/keys.xml' file.
       <resources>
           <string name="oauth_requerst_id_token">523901516987-111111144k1ub4g2l286ipi06g3nm295.apps.googleusercontent.com</string>
       </resources>          
Step9. Build 'aaf-easydiary' project with android studio.
       a. Build > Select Build Variant
       b. Select 'gmsDevRelease' from the Build Variant setting and run
```
[Download 'weather-set-2' svg images from Flaticon](https://www.flaticon.com/packs/weather-set-2)

### FOSS Flavor
For the foss flavor build, no further action is required. However, because we do not use Google Mobile Service, we can not use the backup function with Google Drive, and we will use simpler weather icons than weather icons provided by gms flavor.  
※ Since we are developing the GMS Flavor package first, the merging of the latest features may be delayed in the FOSS Flavor package.
```
Step1. Fork or download 'aaf-easydiary' project.
Step2. Import 'aaf-easydiary' project into android studio.
Step3. Setting storeFile and storePassword in local.properties file
       +++++++ local.properties +++++++++++++++++++++++++++++++++++
       storeFile=your signing key location
       storePassword=your password
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
       +++++++ example ++++++++++++++++++++++++++++++++++++++++++++
       storeFile=C:/dev/android/app-signing.jks
       storePassword=sjdiSDAss3!@#
       ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
       If you do not have the signing key, you can create it by referring to the link below:
       https://developer.android.com/studio/publish/app-signing#generate-key
Step4. Build 'aaf-easydiary' project with android studio.
       a. Build > Select Build Variant
       b. Select 'fossRelease' from the Build Variant setting and run
```

## Translation
Thanks for someone help me to translate this app.   

Currently supported languages are listed below:   

### Korean Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-ko/strings.xml)     
* hanjoongcho (https://github.com/hanjoongcho)  

### English Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-en/strings.xml)  
* Google translation robot  

### Japanese Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-ja/strings.xml)   
* ScratchBuild (https://github.com/ScratchBuild)  

### German Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-de/strings.xml)  
* fulmeek (https://github.com/fulmeek)  

### Italian Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-it/strings.xml)  
* FrancescoFernicola (https://github.com/FrancescoFernicola)
* margherita-martinelli (https://github.com/margherita-martinelli)
* antcont (https://github.com/antcont)  

### French Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-fr/strings.xml)  
* Larnicone (https://github.com/Larnicone)  

### Hindi Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-hi/strings.xml)  
* Prasanta-Hembram (https://github.com/Prasanta-Hembram)  

### Santali Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-sat/strings.xml)  
* Prasanta-Hembram (https://github.com/Prasanta-Hembram)  

### Russian Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-ru/strings.xml)  
* stikice (https://github.com/stikice)  

### Chinese Translation contributor [(strings.xml)](https://github.com/hanjoongcho/aaf-easydiary/blob/master/app/src/main/res/values-zh-rCN/strings.xml)  
* liuteng-sy (https://github.com/liuteng-sy)  
* WAining (https://github.com/WAining)  

## Contributing
* [Contributing](Contributing.md)

## License
* [Easy Diary License][LICENSE]  
* [Third-Party License][THIRDPARTY.md]

[licensesvg]: https://img.shields.io/badge/License-GPL--3.0-brightgreen.svg
[LICENSE]: https://github.com/hanjoongcho/aaf-easydiary/blob/master/LICENSE
[README_ko.md]: https://github.com/hanjoongcho/aaf-easydiary/blob/master/README_ko.md
[THIRDPARTY.md]: https://github.com/hanjoongcho/aaf-easydiary/blob/master/THIRDPARTY.md
