# Contributor's guide

# Contributing Guide for Easy Diary

Welcome to the contributor's guide for Easy Diary open source software. If this document is open purposely by you, then you are interested in contributing to the Easy Diary project, and that's really amazing! 
The developer welcomes all contributions ranging from use-cases, documentation, code, patches, bug reports, feature requests, etc. Contributions are not restricted to programmers only, therefore, you do not need to be a programmer to share your views about the project.
Feel free to post suggestions, bugs & crashes, comments on a code in the project, or just anything that isn't as smooth as it should be as an issue on Github. 
If you're feeling adventurous, you're more than welcome to fork Easy Diary repository and submit pull requests either to implement a new feature, fix a bug, or clean up the code. 

---

### Submitting Feature Requests

If you wish to make contributions with respect to feature requests, please check the issue tracker to ascertain if the feature hasn't already been requested before by another user. If the feature has already been requested, but it is a closed issue that hasn't been marked as "won't fix", feel free to reopen the issue or create yours. 
To request a new feature you should [open an issue](https://github.com/hanjoongcho/aaf-easydiary/issues/new).

In order to help the developer understand the feature request;
- Title of the issue should be explicit, giving insight into the content of the issue.
- The area of the project where your feature would be applied or implemented should be properly stated. Add screenshots of mockup if possible.
- It would be great if a detailed use case is included in your request.

When submitting a feature request, please make a single issue for each feature request (i.e. don't submit an issue that contains a list of features). Such issues are hard to keep track of and often get lost.  

---

## Code Contribtuion

Do you have ideas of some new cool functionalities, a bug fix or other code you wish to contribute? This is the perfect section to guide you on that path.

### Code Quality

When submitting code it is preferred to ensure the code quality is up to par (or better) than the existing one and unit-test don't fail.

### Tests
Wherever possible please include tests, especially if your change implements or impacts a library routine. Even the slightest change can have a ripple effect of chaos.

For code contributions that will lead to huge operational changes, please first discuss the changes you wish to make via issue, email, or any other method before making a change. <hr>

## Bug & Crash Reports

Did you encounter an error which ultimately led to a crash while using Easy Diary? Let the developer know about it by creating a new issue. 

Filing a great bug report helps the developer pinpoint the cause of the bug and effectively work on a fix.

### Steps on how to file a great bug report.

Before filing a bug report,
- Ensure you're running the latest version of the software
- Confirm if it's actually a bug and not an error caused by a plugin on your system. Test with other systems to verify
- If the same issue persists after testing on other devices then it is indeed a bug. 

---

- Check the issue tracker if the bug hasn't been reported by other users. If it has been reported before it is likely to be in [opened issues](https://github.com/hanjoongcho/aaf-easydiary/issues). Also, check closed issues too.

The most important aspect of a bug report is the details. The more concise the details, the easier it'll be for the developer or someone else to tackle the bug.

- Title of the issue should give the developer insight about what the report is all about. 
- A brief explanation of the behaviour you expected the software to perform.
- The actual behaviour of the software when you experienced the bug.
- Steps to reproduce the bug coupled with screenshots and videos if possible.
- Test environment which is details of the Device, Operating system, Software version.

## Documentation

This is the creation of vital documents which a necessary for a software. Documentation also deals with written content creation. If you are copywriter this contribution category is for you. 
For better implementation, ensure to create the document with markdown text styling.
Rename the file with respect to content and add ```.md``` at the end so markdown is effective.
Send a pull request after the document is created.

## Creating a pull request

Here's a detailed content on how to [Create a pull request](https://help.github.com/articles/creating-a-pull-request)

Simply put, the way to create a Pull request is first to; 

1. Fork the repository of the project which in this case is [Easy Diary](https://github.com/hanjoongcho/aaf-easydiary)
2. Commit modifications and changes to your fork
3. Send a [pull request](https://help.github.com/articles/creating-a-pull-request) to the original repository you forked your repository from in step 1

## Contact

For further inquiries, you can contact the developer via email. Send an email to hanjoongcho@gmail.com. The developer can also be contacted by opening an issue on the repository.

You can also check out the developer's profile [here](https://github.com/hanjoongcho).
